/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xhttp2.utils;

import android.content.ContentUris;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.os.storage.StorageManager;
import android.provider.DocumentsContract;
import android.provider.MediaStore;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.xuexiang.xhttp2.XHttp;
import com.xuexiang.xhttp2.utils.Utils;
import java.lang.reflect.Array;
import java.lang.reflect.Method;

public final class PathUtils {
    private PathUtils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    public static String getFilePathByUri(Uri uri) {
        return PathUtils.getFilePathByUri(XHttp.getContext(), uri);
    }

    public static String getFilePathByUri(Context context, Uri uri) {
        if (context == null || uri == null) {
            return null;
        }
        String scheme = uri.getScheme();
        if ("file".equals(scheme)) {
            return uri.getPath();
        }
        if ("content".equals(scheme) && Build.VERSION.SDK_INT < 19) {
            String path = null;
            Cursor cursor = context.getContentResolver().query(uri, new String[]{"_data"}, null, null, null);
            if (cursor != null) {
                int columnIndex;
                if (cursor.moveToFirst() && (columnIndex = cursor.getColumnIndexOrThrow("_data")) > -1) {
                    path = cursor.getString(columnIndex);
                }
                cursor.close();
            }
            return path;
        }
        if ("content".equals(scheme) && Build.VERSION.SDK_INT >= 19 && DocumentsContract.isDocumentUri((Context)context, (Uri)uri)) {
            if (PathUtils.isExternalStorageDocument(uri)) {
                String docId = DocumentsContract.getDocumentId((Uri)uri);
                String[] split = docId.split(":");
                if (split.length == 2) {
                    String type = split[0];
                    if ("primary".equalsIgnoreCase(type)) {
                        return Environment.getExternalStorageDirectory() + "/" + split[1];
                    }
                    StorageManager storageManager = (StorageManager)context.getSystemService("storage");
                    try {
                        Class<?> storageVolumeClazz = Class.forName("android.os.storage.StorageVolume");
                        Method getVolumeList = storageManager.getClass().getMethod("getVolumeList", new Class[0]);
                        Method getUuid = storageVolumeClazz.getMethod("getUuid", new Class[0]);
                        Method getState = storageVolumeClazz.getMethod("getState", new Class[0]);
                        Method getPath = storageVolumeClazz.getMethod("getPath", new Class[0]);
                        Method isPrimary = storageVolumeClazz.getMethod("isPrimary", new Class[0]);
                        Method isEmulated = storageVolumeClazz.getMethod("isEmulated", new Class[0]);
                        Object result = getVolumeList.invoke((Object)storageManager, new Object[0]);
                        int length = Array.getLength(result);
                        for (int i = 0; i < length; ++i) {
                            String uuid;
                            boolean mounted;
                            Object storageVolumeElement = Array.get(result, i);
                            boolean bl = mounted = "mounted".equals(getState.invoke(storageVolumeElement, new Object[0])) || "mounted_ro".equals(getState.invoke(storageVolumeElement, new Object[0]));
                            if (!mounted || ((Boolean)isPrimary.invoke(storageVolumeElement, new Object[0])).booleanValue() && ((Boolean)isEmulated.invoke(storageVolumeElement, new Object[0])).booleanValue() || (uuid = (String)getUuid.invoke(storageVolumeElement, new Object[0])) == null || !uuid.equals(type)) continue;
                            return getPath.invoke(storageVolumeElement, new Object[0]) + "/" + split[1];
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            } else if (PathUtils.isDownloadsDocument(uri)) {
                String[] split;
                String documentId = DocumentsContract.getDocumentId((Uri)uri);
                if (TextUtils.isEmpty((CharSequence)documentId)) {
                    return null;
                }
                if (documentId.startsWith("raw:")) {
                    return documentId.substring("raw:".length());
                }
                if (documentId.startsWith("msf:") && Build.VERSION.SDK_INT >= 29 && (split = documentId.split(":")).length == 2) {
                    Uri contentUri = MediaStore.Downloads.EXTERNAL_CONTENT_URI;
                    String selection = "_id=?";
                    String[] selectionArgs = new String[]{split[1]};
                    return PathUtils.getDataColumn(context, contentUri, selection, selectionArgs);
                }
                long id = Utils.toLong(documentId, -1L);
                if (id != -1L) {
                    return PathUtils.getDownloadPathById(context, id);
                }
            } else if (PathUtils.isMediaDocument(uri)) {
                String docId = DocumentsContract.getDocumentId((Uri)uri);
                String[] split = docId.split(":");
                String type = split[0];
                Uri contentUri = null;
                if ("image".equals(type)) {
                    contentUri = MediaStore.Images.Media.EXTERNAL_CONTENT_URI;
                } else if ("video".equals(type)) {
                    contentUri = MediaStore.Video.Media.EXTERNAL_CONTENT_URI;
                } else if ("audio".equals(type)) {
                    contentUri = MediaStore.Audio.Media.EXTERNAL_CONTENT_URI;
                }
                String selection = "_id=?";
                String[] selectionArgs = new String[]{split[1]};
                return PathUtils.getDataColumn(context, contentUri, selection, selectionArgs);
            }
        } else {
            if ("content".equalsIgnoreCase(scheme)) {
                String uriPath;
                if (PathUtils.isGooglePhotosUri(uri)) {
                    return uri.getLastPathSegment();
                }
                if (PathUtils.isHuaWeiUri(uri)) {
                    String uriPath2 = uri.getPath();
                    if (!Utils.isEmpty(uriPath2) && uriPath2.startsWith("/root")) {
                        return uriPath2.replace("/root", "");
                    }
                } else if (PathUtils.isQQUri(uri) && !Utils.isEmpty(uriPath = uri.getPath())) {
                    return Environment.getExternalStorageDirectory() + uriPath.substring("/QQBrowser".length());
                }
                return PathUtils.getDataColumn(context, uri, null, null);
            }
            if ("file".equalsIgnoreCase(scheme)) {
                return uri.getPath();
            }
        }
        return null;
    }

    @Nullable
    private static String getDownloadPathById(Context context, long id) {
        Uri contentUri = ContentUris.withAppendedId((Uri)Uri.parse((String)"content://downloads/public_downloads"), (long)id);
        return PathUtils.getDataColumn(context, contentUri, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getDataColumn(Context context, Uri uri, String selection, String[] selectionArgs) {
        Cursor cursor = null;
        String column = "_data";
        String[] projection = new String[]{column};
        try {
            cursor = context.getContentResolver().query(uri, projection, selection, selectionArgs, null);
            if (cursor != null && cursor.moveToFirst()) {
                int index = cursor.getColumnIndexOrThrow(column);
                String string = cursor.getString(index);
                return string;
            }
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return null;
    }

    public static boolean isExternalStorageDocument(Uri uri) {
        return "com.android.externalstorage.documents".equals(uri.getAuthority());
    }

    public static boolean isDownloadsDocument(Uri uri) {
        return "com.android.providers.downloads.documents".equals(uri.getAuthority());
    }

    public static boolean isMediaDocument(Uri uri) {
        return "com.android.providers.media.documents".equals(uri.getAuthority());
    }

    public static boolean isGooglePhotosUri(Uri uri) {
        return "com.google.android.apps.photos.content".equals(uri.getAuthority());
    }

    public static boolean isHuaWeiUri(Uri uri) {
        return "com.huawei.hidisk.fileprovider".equals(uri.getAuthority());
    }

    public static boolean isQQUri(Uri uri) {
        return "com.tencent.mtt.fileprovider".equals(uri.getAuthority());
    }
}

