/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xhttp2;

import android.support.annotation.NonNull;
import android.text.TextUtils;
import com.google.gson.Gson;
import com.xuexiang.xhttp2.XHttp;
import com.xuexiang.xhttp2.annotation.NetMethod;
import com.xuexiang.xhttp2.cache.model.CacheMode;
import com.xuexiang.xhttp2.exception.ApiException;
import com.xuexiang.xhttp2.request.BaseBodyRequest;
import com.xuexiang.xhttp2.request.BaseRequest;
import com.xuexiang.xhttp2.request.PostRequest;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.TreeMap;

public class XHttpProxy
implements InvocationHandler {
    private String mThreadType;

    public static <T> T proxy(Class<T> cls) {
        return new XHttpProxy().create(cls);
    }

    public static <T> T proxy(Class<T> cls, String threadType) {
        return new XHttpProxy(threadType).create(cls);
    }

    public XHttpProxy() {
        this("executeToMain");
    }

    public XHttpProxy(String threadType) {
        this.mThreadType = threadType;
    }

    public <T> T create(Class<T> cls) {
        return (T)Proxy.newProxyInstance(cls.getClassLoader(), new Class[]{cls}, (InvocationHandler)this);
    }

    @Override
    public Object invoke(Object o, Method method, Object[] args) throws Throwable {
        NetMethod netMethod = method.getAnnotation(NetMethod.class);
        if (netMethod == null) {
            throw new ApiException(method.getName() + "\u65b9\u6cd5\u65e0NetMethod\u6ce8\u91ca", 5012);
        }
        if (netMethod.parameterNames().length != method.getGenericParameterTypes().length) {
            throw new ApiException(method.getName() + "\u65b9\u6cd5NetMethod\u6ce8\u91ca\u4e0e\u5b9e\u9645\u53c2\u6570\u4e2a\u6570\u4e0d\u5bf9\u5e94", 5012);
        }
        Map<String, Object> params = this.getParamsMap(method, args, netMethod);
        Type type = this.getReturnType(method);
        BaseRequest request = this.getHttpRequest(netMethod);
        if (request instanceof BaseBodyRequest) {
            if (netMethod.paramType() == 1) {
                ((BaseBodyRequest)request).upJson(new Gson().toJson(params));
            } else {
                request.params(params);
            }
            return request.execute(type);
        }
        if (netMethod.paramType() == 3) {
            if (args.length > 0) {
                request.url(netMethod.url() + "/" + args[0]);
                request.params(this.getParamsMap(method, args, netMethod, 1));
            }
        } else {
            request.params(params);
        }
        return request.execute(type);
    }

    private Type getReturnType(Method method) throws ApiException {
        Type type = method.getGenericReturnType();
        if (!(type instanceof ParameterizedType)) {
            throw new ApiException("\u63a5\u53e3\u65b9\u6cd5:" + method.getName() + "\u7684\u8fd4\u56de\u503c\u7c7b\u578b\u4e0d\u662f\u6cdb\u578b, \u5fc5\u987b\u8fd4\u56deObservable<T>\u7c7b\u578b", 5012);
        }
        type = ((ParameterizedType)type).getActualTypeArguments()[0];
        return type;
    }

    private BaseRequest getHttpRequest(NetMethod apiMethod) {
        BaseRequest request;
        String action = apiMethod.action();
        String baseUrl = apiMethod.baseUrl();
        String url = apiMethod.url();
        long timeout = apiMethod.timeout();
        boolean accessToken = apiMethod.accessToken();
        CacheMode cacheMode = apiMethod.cacheMode();
        switch (action) {
            case "post": {
                request = XHttp.post(url);
                break;
            }
            case "get": {
                request = XHttp.get(url);
                break;
            }
            case "put": {
                request = XHttp.put(url);
                break;
            }
            default: {
                request = XHttp.delete(url);
            }
        }
        if (!TextUtils.isEmpty((CharSequence)baseUrl)) {
            request.baseUrl(baseUrl);
        }
        if (!CacheMode.NO_CACHE.equals((Object)cacheMode)) {
            ((BaseRequest)request.cacheMode(cacheMode)).cacheKey(url);
        }
        if (timeout <= 0L) {
            timeout = 15000L;
        }
        return ((BaseRequest)((BaseRequest)((BaseRequest)request.threadType(this.mThreadType)).keepJson(apiMethod.keepJson())).accessToken(accessToken)).timeOut(timeout);
    }

    @NonNull
    private Map<String, Object> getParamsMap(Method method, Object[] args, NetMethod apiMethod) {
        TreeMap<String, Object> params = new TreeMap<String, Object>();
        Type[] parameters = method.getGenericParameterTypes();
        for (int i = 0; i < parameters.length; ++i) {
            params.put(apiMethod.parameterNames()[i], args[i]);
        }
        return params;
    }

    @NonNull
    private Map<String, Object> getParamsMap(Method method, Object[] args, NetMethod apiMethod, int index) {
        TreeMap<String, Object> params = new TreeMap<String, Object>();
        Type[] parameters = method.getGenericParameterTypes();
        for (int i = index; i < parameters.length; ++i) {
            params.put(apiMethod.parameterNames()[i], args[i]);
        }
        return params;
    }

    private PostRequest updateThreadType(PostRequest postRequest) {
        postRequest.threadType(this.mThreadType);
        return postRequest;
    }
}

