/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xhttp2;

import android.annotation.SuppressLint;
import android.app.Application;
import android.content.Context;
import android.text.TextUtils;
import com.google.gson.Gson;
import com.xuexiang.xhttp2.cache.RxCache;
import com.xuexiang.xhttp2.cache.converter.IDiskConverter;
import com.xuexiang.xhttp2.cache.converter.SerializableDiskConverter;
import com.xuexiang.xhttp2.cache.model.CacheMode;
import com.xuexiang.xhttp2.cookie.CookieManager;
import com.xuexiang.xhttp2.https.DefaultHostnameVerifier;
import com.xuexiang.xhttp2.https.HttpsUtils;
import com.xuexiang.xhttp2.interceptor.HttpLoggingInterceptor;
import com.xuexiang.xhttp2.logs.HttpLog;
import com.xuexiang.xhttp2.model.HttpHeaders;
import com.xuexiang.xhttp2.model.HttpParams;
import com.xuexiang.xhttp2.request.CustomRequest;
import com.xuexiang.xhttp2.request.DeleteRequest;
import com.xuexiang.xhttp2.request.DownloadRequest;
import com.xuexiang.xhttp2.request.GetRequest;
import com.xuexiang.xhttp2.request.PostRequest;
import com.xuexiang.xhttp2.request.PutRequest;
import com.xuexiang.xhttp2.utils.RxSchedulers;
import com.xuexiang.xhttp2.utils.Utils;
import io.reactivex.annotations.NonNull;
import io.reactivex.functions.Consumer;
import java.io.File;
import java.io.InputStream;
import java.net.Proxy;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import okhttp3.Cache;
import okhttp3.Call;
import okhttp3.ConnectionPool;
import okhttp3.CookieJar;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import retrofit2.CallAdapter;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;

public final class XHttp {
    private static volatile XHttp sInstance = null;
    private static Application sContext;
    public static final int DEFAULT_TIMEOUT_MILLISECONDS = 15000;
    public static final int DEFAULT_RETRY_COUNT = 0;
    public static final int DEFAULT_RETRY_INCREASE_DELAY = 0;
    public static final int DEFAULT_RETRY_DELAY = 500;
    public static final int DEFAULT_CACHE_NEVER_EXPIRE = -1;
    private String mBaseUrl;
    private String mSubUrl = "";
    private Cache mCache = null;
    private CacheMode mCacheMode = CacheMode.NO_CACHE;
    private long mCacheTime = -1L;
    private File mCacheDirectory;
    private long mCacheMaxSize;
    private int mRetryCount = 0;
    private int mRetryDelay = 500;
    private int mRetryIncreaseDelay = 0;
    private HttpHeaders mCommonHeaders;
    private HttpParams mCommonParams;
    private OkHttpClient.Builder mOkHttpClientBuilder = new OkHttpClient.Builder();
    private Retrofit.Builder mRetrofitBuilder;
    private RxCache.Builder mRxCacheBuilder;
    private CookieManager mCookieJar;

    private XHttp() {
        this.mOkHttpClientBuilder.hostnameVerifier((HostnameVerifier)new DefaultHostnameVerifier());
        this.mOkHttpClientBuilder.connectTimeout(15000L, TimeUnit.MILLISECONDS);
        this.mOkHttpClientBuilder.readTimeout(15000L, TimeUnit.MILLISECONDS);
        this.mOkHttpClientBuilder.writeTimeout(15000L, TimeUnit.MILLISECONDS);
        this.mRetrofitBuilder = new Retrofit.Builder();
        this.mRxCacheBuilder = new RxCache.Builder().init((Context)sContext).diskConverter(new SerializableDiskConverter());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static XHttp getInstance() {
        XHttp.testInitialize();
        if (sInstance != null) return sInstance;
        Class<XHttp> clazz = XHttp.class;
        synchronized (XHttp.class) {
            if (sInstance != null) return sInstance;
            sInstance = new XHttp();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sInstance;
        }
    }

    public static void init(Application app) {
        sContext = app;
    }

    public static Context getContext() {
        XHttp.testInitialize();
        return sContext;
    }

    private static void testInitialize() {
        if (sContext == null) {
            throw new ExceptionInInitializerError("\u8bf7\u5148\u5728\u5168\u5c40Application\u4e2d\u8c03\u7528 XHttp.init() \u521d\u59cb\u5316\uff01");
        }
    }

    public static OkHttpClient getOkHttpClient() {
        return XHttp.getInstance().mOkHttpClientBuilder.build();
    }

    public static RxCache getRxCache() {
        return XHttp.getInstance().mRxCacheBuilder.build();
    }

    public static OkHttpClient.Builder getOkHttpClientBuilder() {
        return XHttp.getInstance().mOkHttpClientBuilder;
    }

    public static Retrofit.Builder getRetrofitBuilder() {
        return XHttp.getInstance().mRetrofitBuilder;
    }

    public static RxCache.Builder getRxCacheBuilder() {
        return XHttp.getInstance().mRxCacheBuilder;
    }

    public XHttp debug(HttpLoggingInterceptor loggingInterceptor) {
        if (loggingInterceptor != null) {
            this.mOkHttpClientBuilder.addInterceptor((Interceptor)loggingInterceptor);
            HttpLog.debug(true);
        } else {
            HttpLog.debug(false);
        }
        return this;
    }

    public XHttp debug(boolean isDebug) {
        if (isDebug) {
            this.debug(new HttpLoggingInterceptor("[XHttp]", true).setLevel(HttpLoggingInterceptor.Level.BODY));
        }
        HttpLog.debug(isDebug);
        return this;
    }

    public XHttp debug(String tag) {
        if (!TextUtils.isEmpty((CharSequence)tag)) {
            this.debug(new HttpLoggingInterceptor(tag, true).setLevel(HttpLoggingInterceptor.Level.BODY));
            HttpLog.debug(tag);
        } else {
            HttpLog.debug(false);
        }
        return this;
    }

    public XHttp setBaseUrl(String baseUrl) {
        this.mBaseUrl = Utils.checkNotNull(baseUrl, "mBaseUrl == null");
        return this;
    }

    public XHttp setSubUrl(String subUrl) {
        this.mSubUrl = Utils.checkNotNull(subUrl, "mSubUrl == null");
        return this;
    }

    public static String getBaseUrl() {
        return XHttp.getInstance().mBaseUrl;
    }

    public static String getSubUrl() {
        return XHttp.getInstance().mSubUrl;
    }

    public XHttp setReadTimeOut(long readTimeOut) {
        this.mOkHttpClientBuilder.readTimeout(readTimeOut, TimeUnit.MILLISECONDS);
        return this;
    }

    public XHttp setWriteTimeOut(long writeTimeout) {
        this.mOkHttpClientBuilder.writeTimeout(writeTimeout, TimeUnit.MILLISECONDS);
        return this;
    }

    public XHttp setConnectTimeout(long connectTimeout) {
        this.mOkHttpClientBuilder.connectTimeout(connectTimeout, TimeUnit.MILLISECONDS);
        return this;
    }

    public XHttp setTimeout(long timeout) {
        this.mOkHttpClientBuilder.readTimeout(timeout, TimeUnit.MILLISECONDS);
        this.mOkHttpClientBuilder.writeTimeout(timeout, TimeUnit.MILLISECONDS);
        this.mOkHttpClientBuilder.connectTimeout(timeout, TimeUnit.MILLISECONDS);
        return this;
    }

    public XHttp setRetryCount(int retryCount) {
        if (retryCount < 0) {
            throw new IllegalArgumentException("mRetryCount must >= 0");
        }
        this.mRetryCount = retryCount;
        return this;
    }

    public static int getRetryCount() {
        return XHttp.getInstance().mRetryCount;
    }

    public XHttp setRetryDelay(int retryDelay) {
        if (retryDelay < 0) {
            throw new IllegalArgumentException("mRetryDelay must > 0");
        }
        this.mRetryDelay = retryDelay;
        return this;
    }

    public static int getRetryDelay() {
        return XHttp.getInstance().mRetryDelay;
    }

    public XHttp setRetryIncreaseDelay(int retryIncreaseDelay) {
        if (retryIncreaseDelay < 0) {
            throw new IllegalArgumentException("mRetryIncreaseDelay must >= 0");
        }
        this.mRetryIncreaseDelay = retryIncreaseDelay;
        return this;
    }

    public static int getRetryIncreaseDelay() {
        return XHttp.getInstance().mRetryIncreaseDelay;
    }

    public XHttp setCacheMode(CacheMode cacheMode) {
        this.mCacheMode = cacheMode;
        return this;
    }

    public static CacheMode getCacheMode() {
        return XHttp.getInstance().mCacheMode;
    }

    public XHttp setIsDiskCache(boolean isDiskCache) {
        this.mRxCacheBuilder.isDiskCache(isDiskCache);
        return this;
    }

    public XHttp setMemoryMaxSize(int memoryMaxSize) {
        this.mRxCacheBuilder.memoryMaxSize(memoryMaxSize);
        return this;
    }

    public XHttp setCacheTime(long cacheTime) {
        if (cacheTime <= -1L) {
            cacheTime = -1L;
        }
        this.mCacheTime = cacheTime;
        return this;
    }

    public static long getCacheTime() {
        return XHttp.getInstance().mCacheTime;
    }

    public XHttp setCacheMaxSize(long maxSize) {
        this.mCacheMaxSize = maxSize;
        return this;
    }

    public static long getCacheMaxSize() {
        return XHttp.getInstance().mCacheMaxSize;
    }

    public XHttp setCacheVersion(int cacheVersion) {
        if (cacheVersion < 0) {
            throw new IllegalArgumentException("cache version must > 0");
        }
        this.mRxCacheBuilder.appVersion(cacheVersion);
        return this;
    }

    public XHttp setCacheDirectory(File directory) {
        this.mCacheDirectory = Utils.checkNotNull(directory, "directory == null");
        this.mRxCacheBuilder.diskDir(directory);
        return this;
    }

    public static File getCacheDirectory() {
        return XHttp.getInstance().mCacheDirectory;
    }

    public XHttp setCacheDiskConverter(IDiskConverter converter) {
        this.mRxCacheBuilder.diskConverter(Utils.checkNotNull(converter, "converter == null"));
        return this;
    }

    public XHttp setHttpCache(Cache cache) {
        this.mCache = cache;
        return this;
    }

    public static Cache getHttpCache() {
        return XHttp.getInstance().mCache;
    }

    public XHttp addCommonParams(HttpParams commonParams) {
        if (this.mCommonParams == null) {
            this.mCommonParams = new HttpParams();
        }
        this.mCommonParams.put(commonParams);
        return this;
    }

    public XHttp addCommonHeaders(HttpHeaders commonHeaders) {
        if (this.mCommonHeaders == null) {
            this.mCommonHeaders = new HttpHeaders();
        }
        this.mCommonHeaders.put(commonHeaders);
        return this;
    }

    public static HttpParams getCommonParams() {
        return XHttp.getInstance().mCommonParams;
    }

    public static HttpHeaders getCommonHeaders() {
        return XHttp.getInstance().mCommonHeaders;
    }

    public XHttp addInterceptor(Interceptor interceptor) {
        this.mOkHttpClientBuilder.addInterceptor(Utils.checkNotNull(interceptor, "interceptor == null"));
        return this;
    }

    public XHttp addNetworkInterceptor(Interceptor interceptor) {
        this.mOkHttpClientBuilder.addNetworkInterceptor(Utils.checkNotNull(interceptor, "interceptor == null"));
        return this;
    }

    public XHttp setOkproxy(Proxy proxy) {
        this.mOkHttpClientBuilder.proxy(Utils.checkNotNull(proxy, "mProxy == null"));
        return this;
    }

    public XHttp setOkconnectionPool(ConnectionPool connectionPool) {
        this.mOkHttpClientBuilder.connectionPool(Utils.checkNotNull(connectionPool, "connectionPool == null"));
        return this;
    }

    public XHttp setOkclient(OkHttpClient client) {
        this.mRetrofitBuilder.client(Utils.checkNotNull(client, "client == null"));
        return this;
    }

    public XHttp addConverterFactory(Converter.Factory factory) {
        this.mRetrofitBuilder.addConverterFactory(Utils.checkNotNull(factory, "factory == null"));
        return this;
    }

    public XHttp addCallAdapterFactory(CallAdapter.Factory factory) {
        this.mRetrofitBuilder.addCallAdapterFactory(Utils.checkNotNull(factory, "factory == null"));
        return this;
    }

    public XHttp setCallbackExecutor(Executor executor) {
        this.mRetrofitBuilder.callbackExecutor(Utils.checkNotNull(executor, "executor == null"));
        return this;
    }

    public XHttp setCallFactory(Call.Factory factory) {
        this.mRetrofitBuilder.callFactory(Utils.checkNotNull(factory, "factory == null"));
        return this;
    }

    public XHttp setHostnameVerifier(HostnameVerifier hostnameVerifier) {
        this.mOkHttpClientBuilder.hostnameVerifier(hostnameVerifier);
        return this;
    }

    public XHttp setCertificates(InputStream ... certificates) {
        HttpsUtils.SSLParams sslParams = HttpsUtils.getSslSocketFactory(null, null, certificates);
        this.mOkHttpClientBuilder.sslSocketFactory(sslParams.sSLSocketFactory, sslParams.trustManager);
        return this;
    }

    public XHttp setCertificates(InputStream bksFile, String password, InputStream ... certificates) {
        HttpsUtils.SSLParams sslParams = HttpsUtils.getSslSocketFactory(bksFile, password, certificates);
        this.mOkHttpClientBuilder.sslSocketFactory(sslParams.sSLSocketFactory, sslParams.trustManager);
        return this;
    }

    public XHttp setCookieStore(CookieManager cookieManager) {
        this.mCookieJar = cookieManager;
        this.mOkHttpClientBuilder.cookieJar((CookieJar)this.mCookieJar);
        return this;
    }

    public static CookieManager getCookieJar() {
        return XHttp.getInstance().mCookieJar;
    }

    public static GetRequest get(String url) {
        return new GetRequest(url);
    }

    public static PostRequest post(String url) {
        return new PostRequest(url);
    }

    public static DeleteRequest delete(String url) {
        return new DeleteRequest(url);
    }

    public static PutRequest put(String url) {
        return new PutRequest(url);
    }

    public static CustomRequest custom() {
        return ((CustomRequest)new CustomRequest().addConverterFactory((Converter.Factory)GsonConverterFactory.create((Gson)new Gson()))).build();
    }

    public static <T> T custom(Class<T> service) {
        return ((CustomRequest)new CustomRequest().addConverterFactory((Converter.Factory)GsonConverterFactory.create((Gson)new Gson()))).build().create(service);
    }

    public static DownloadRequest downLoad(String url) {
        return new DownloadRequest(url);
    }

    @SuppressLint(value={"CheckResult"})
    public static void clearCache() {
        XHttp.getRxCache().clear().compose(RxSchedulers._io_main()).subscribe((Consumer)new Consumer<Boolean>(){

            public void accept(@NonNull Boolean aBoolean) throws Exception {
                HttpLog.i("clearCache success!!!");
            }
        }, (Consumer)new Consumer<Throwable>(){

            public void accept(@NonNull Throwable throwable) throws Exception {
                HttpLog.i("clearCache err!!!");
            }
        });
    }

    @SuppressLint(value={"CheckResult"})
    public static void removeCache(String key) {
        XHttp.getRxCache().remove(key).compose(RxSchedulers._io_main()).subscribe((Consumer)new Consumer<Boolean>(){

            public void accept(@NonNull Boolean aBoolean) throws Exception {
                HttpLog.i("removeCache success!!!");
            }
        }, (Consumer)new Consumer<Throwable>(){

            public void accept(@NonNull Throwable throwable) throws Exception {
                HttpLog.i("removeCache err!!!");
            }
        });
    }
}

