/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xhttp2.utils;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Environment;
import com.xuexiang.xhttp2.XHttp;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;

public final class Utils {
    private Utils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    public static <T> T checkNotNull(T t, String message) {
        if (t == null) {
            throw new NullPointerException(message);
        }
        return t;
    }

    public static boolean isNetworkAvailable(Context context) {
        ConnectivityManager manager = (ConnectivityManager)context.getApplicationContext().getSystemService("connectivity");
        if (null == manager) {
            return false;
        }
        NetworkInfo info = manager.getActiveNetworkInfo();
        return null != info && info.isAvailable();
    }

    public static void closeIO(Closeable ... closeables) {
        if (closeables == null) {
            return;
        }
        for (Closeable closeable : closeables) {
            if (closeable == null) continue;
            try {
                closeable.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static File getDiskCacheDir(Context context, String uniqueName) {
        String cachePath = Utils.isSDCardExist() && context.getExternalCacheDir() != null ? context.getExternalCacheDir().getPath() : context.getCacheDir().getPath();
        return new File(cachePath + File.separator + uniqueName);
    }

    private static boolean isSDCardExist() {
        return "mounted".equals(Environment.getExternalStorageState()) || !Environment.isExternalStorageRemovable();
    }

    private static String getDiskFilesDir() {
        return Utils.isSDCardExist() && XHttp.getContext().getExternalFilesDir(null) != null ? XHttp.getContext().getExternalFilesDir(null).getPath() : XHttp.getContext().getFilesDir().getPath();
    }

    public static String getDiskFilesDir(String fileDir) {
        return Utils.getDiskFilesDir() + File.separator + fileDir;
    }
}

