/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xhttp2.transform.func;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.xuexiang.xhttp2.model.ApiResult;
import com.xuexiang.xhttp2.utils.TypeUtils;
import io.reactivex.functions.Function;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import okhttp3.ResponseBody;
import org.json.JSONException;
import org.json.JSONObject;

public class ApiResultFunc<T>
implements Function<ResponseBody, ApiResult<T>> {
    private Type mType;
    private Gson mGson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{16, 128, 8}).serializeNulls().create();
    private boolean mKeepJson;

    public ApiResultFunc(Type type, boolean keepJson) {
        this.mType = type;
        this.mKeepJson = keepJson;
    }

    public ApiResult<T> apply(ResponseBody responseBody) throws Exception {
        ApiResult apiResult = new ApiResult();
        apiResult.setCode(-1);
        apiResult = this.mType instanceof ParameterizedType ? this.parseCustomApiResult(responseBody, apiResult) : this.parseApiResult(responseBody, apiResult);
        return apiResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private ApiResult<T> parseCustomApiResult(ResponseBody responseBody, ApiResult<T> apiResult) {
        Class cls = (Class)((ParameterizedType)this.mType).getRawType();
        if (ApiResult.class.isAssignableFrom(cls)) {
            Type[] params = ((ParameterizedType)this.mType).getActualTypeArguments();
            Class clazz = TypeUtils.getClass(params[0], 0);
            Class rawType = TypeUtils.getClass(this.mType, 0);
            try {
                String json = responseBody.string();
                if (this.mKeepJson && !List.class.isAssignableFrom(rawType) && clazz.equals(String.class)) {
                    apiResult.setData(json);
                    apiResult.setCode(0);
                }
                ApiResult result = (ApiResult)this.mGson.fromJson(json, this.mType);
                if (result != null) {
                    ApiResult apiResult2 = result;
                    return apiResult2;
                }
                apiResult.setMsg("json is null");
            }
            catch (Exception e) {
                e.printStackTrace();
                apiResult.setMsg(e.getMessage());
            }
            finally {
                responseBody.close();
            }
        } else {
            apiResult.setMsg("ApiResult.class.isAssignableFrom(cls) err!!");
        }
        return apiResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    private ApiResult<T> parseApiResult(ResponseBody responseBody, ApiResult<T> apiResult) {
        try {
            String json = responseBody.string();
            Class clazz = TypeUtils.getClass(this.mType, 0);
            if (this.mKeepJson && clazz.equals(String.class)) {
                apiResult.setData(json);
                apiResult.setCode(0);
            } else {
                ApiResult result = this.parseApiResult(json, apiResult);
                if (result != null) {
                    apiResult = result;
                    if (apiResult.getData() != null) {
                        Object data = this.mGson.fromJson(apiResult.getData().toString(), clazz);
                        apiResult.setData(data);
                    } else {
                        apiResult.setMsg("ApiResult's data is null");
                    }
                } else {
                    apiResult.setMsg("json is null");
                }
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
            apiResult.setMsg(e.getMessage());
        }
        catch (IOException e) {
            e.printStackTrace();
            apiResult.setMsg(e.getMessage());
        }
        finally {
            responseBody.close();
        }
        return apiResult;
    }

    private ApiResult parseApiResult(String json, ApiResult apiResult) throws JSONException {
        if (TextUtils.isEmpty((CharSequence)json)) {
            return null;
        }
        JSONObject jsonObject = new JSONObject(json);
        if (jsonObject.has("Code")) {
            apiResult.setCode(jsonObject.getInt("Code"));
        }
        if (jsonObject.has("Data")) {
            apiResult.setData(jsonObject.getString("Data"));
        }
        if (jsonObject.has("Msg")) {
            apiResult.setMsg(jsonObject.getString("Msg"));
        }
        return apiResult;
    }
}

