/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xhttp2.interceptor;

import com.xuexiang.xhttp2.utils.HttpUtils;
import java.io.IOException;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import okhttp3.Connection;
import okhttp3.Headers;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.internal.http.HttpHeaders;
import okio.Buffer;
import okio.BufferedSink;

public class HttpLoggingInterceptor
implements Interceptor {
    private volatile Level level = Level.NONE;
    protected Logger logger;
    protected String tag;
    private boolean isPrintStack = true;

    public void log(String message) {
        this.logger.log(java.util.logging.Level.INFO, message);
    }

    public HttpLoggingInterceptor(String tag) {
        this.setTag(tag);
    }

    public HttpLoggingInterceptor(String tag, boolean isPrintStack) {
        this.setTag(tag);
        this.isPrintStack = isPrintStack;
    }

    public HttpLoggingInterceptor setLevel(Level level) {
        if (level == null) {
            throw new NullPointerException("level == null. Use Level.NONE instead.");
        }
        this.level = level;
        return this;
    }

    public HttpLoggingInterceptor setTag(String tag) {
        this.tag = tag;
        this.logger = Logger.getLogger(tag);
        return this;
    }

    public String getTag() {
        return this.tag;
    }

    public Level getLevel() {
        return this.level;
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Response response;
        Request request = chain.request();
        if (Level.NONE.equals((Object)this.level)) {
            return chain.proceed(request);
        }
        this.logForRequest(request, chain.connection());
        long startNs = System.nanoTime();
        try {
            response = chain.proceed(request);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.log("<-- HTTP FAILED: " + e.getMessage());
            throw e;
        }
        long tookMs = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startNs);
        return this.logForResponse(response, tookMs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void logForRequest(Request request, Connection connection) throws IOException {
        if (this.level != Level.PARAM) {
            this.log("-------------------------------request-------------------------------");
        }
        boolean logBody = this.level == Level.BODY || this.level == Level.PARAM;
        boolean logHeaders = this.level == Level.BODY || this.level == Level.HEADERS;
        RequestBody requestBody = request.body();
        boolean hasRequestBody = requestBody != null;
        Protocol protocol = connection != null ? connection.protocol() : Protocol.HTTP_1_1;
        try {
            String requestStartMessage = "--> " + request.method() + ' ' + request.url() + ' ' + protocol;
            this.log(requestStartMessage);
            if (logHeaders) {
                Headers headers = request.headers();
                int count = headers.size();
                for (int i = 0; i < count; ++i) {
                    this.log("\t" + headers.name(i) + ": " + headers.value(i));
                }
            }
            if (logBody && hasRequestBody) {
                if (HttpUtils.isPlaintext(requestBody.contentType())) {
                    this.log("\tbody:" + this.bodyToString(request));
                } else {
                    this.log("\tbody: maybe [file part] , too large too print , ignored!");
                }
            }
        }
        catch (Exception e) {
            this.onError(e);
        }
        finally {
            if (this.level != Level.PARAM) {
                this.log("--> END " + request.method());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Response logForResponse(Response response, long tookMs) {
        if (this.level != Level.PARAM) {
            this.log("-------------------------------response-------------------------------");
        }
        Response.Builder builder = response.newBuilder();
        Response clone = builder.build();
        ResponseBody responseBody = clone.body();
        boolean logBody = this.level == Level.BODY || this.level == Level.PARAM;
        boolean logHeaders = this.level == Level.BODY || this.level == Level.HEADERS;
        try {
            this.log("<-- " + clone.code() + ' ' + clone.message() + ' ' + clone.request().url() + " (" + tookMs + "ms\uff09");
            if (logHeaders) {
                this.log(" ");
                Headers headers = clone.headers();
                int count = headers.size();
                for (int i = 0; i < count; ++i) {
                    this.log("\t" + headers.name(i) + ": " + headers.value(i));
                }
                this.log(" ");
            }
            if (logBody && HttpHeaders.hasBody((Response)clone)) {
                if (HttpUtils.isPlaintext(responseBody.contentType())) {
                    String body = responseBody.string();
                    this.log("\tbody:" + body);
                    responseBody = ResponseBody.create((MediaType)responseBody.contentType(), (String)body);
                    Response response2 = response.newBuilder().body(responseBody).build();
                    return response2;
                }
                this.log("\tbody: maybe [file part] , too large too print , ignored!");
                if (this.level != Level.PARAM) {
                    this.log(" ");
                }
            }
        }
        catch (Exception e) {
            this.onError(e);
        }
        finally {
            if (this.level != Level.PARAM) {
                this.log("<-- END HTTP");
            }
        }
        return response;
    }

    protected String bodyToString(Request request) {
        try {
            Request copy = request.newBuilder().build();
            Buffer buffer = new Buffer();
            copy.body().writeTo((BufferedSink)buffer);
            Charset charset = HttpUtils.UTF8;
            MediaType contentType = copy.body().contentType();
            if (contentType != null) {
                charset = contentType.charset(HttpUtils.UTF8);
            }
            return URLDecoder.decode(buffer.readString(charset), HttpUtils.UTF8.name());
        }
        catch (Exception e) {
            this.onError(e);
            return "";
        }
    }

    protected void onError(Throwable t) {
        if (this.isPrintStack) {
            t.printStackTrace();
        }
    }

    public static enum Level {
        NONE,
        BASIC,
        HEADERS,
        BODY,
        PARAM;

    }
}

