/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xhttp2.cache.stategy;

import com.xuexiang.xhttp2.cache.RxCache;
import com.xuexiang.xhttp2.cache.model.CacheResult;
import com.xuexiang.xhttp2.cache.stategy.IStrategy;
import com.xuexiang.xhttp2.logs.HttpLog;
import io.reactivex.Observable;
import io.reactivex.ObservableSource;
import io.reactivex.annotations.NonNull;
import io.reactivex.functions.Function;
import java.lang.reflect.Type;

public abstract class BaseStrategy
implements IStrategy {
    <T> Observable<CacheResult<T>> loadCache(RxCache rxCache, Type type, String key, long time, boolean needEmpty) {
        Observable observable = rxCache.load(type, key, time).flatMap(new Function<T, ObservableSource<CacheResult<T>>>(){

            public ObservableSource<CacheResult<T>> apply(@NonNull T t) throws Exception {
                if (t == null) {
                    return Observable.error((Throwable)new NullPointerException("Not find the cache!"));
                }
                return Observable.just(new CacheResult(true, t));
            }
        });
        if (needEmpty) {
            observable = observable.onErrorResumeNext(new Function<Throwable, ObservableSource<? extends CacheResult<T>>>(){

                public ObservableSource<? extends CacheResult<T>> apply(@NonNull Throwable throwable) throws Exception {
                    return Observable.empty();
                }
            });
        }
        return observable;
    }

    <T> Observable<CacheResult<T>> loadRemote(final RxCache rxCache, final String key, Observable<T> source, boolean needEmpty) {
        Observable observable = source.flatMap(new Function<T, ObservableSource<CacheResult<T>>>(){

            public ObservableSource<CacheResult<T>> apply(final @NonNull T t) throws Exception {
                return rxCache.save(key, t).map(new Function<Boolean, CacheResult<T>>(){

                    public CacheResult<T> apply(@NonNull Boolean aBoolean) throws Exception {
                        HttpLog.i("save status => " + aBoolean);
                        return new CacheResult<Object>(false, t);
                    }
                }).onErrorReturn(new Function<Throwable, CacheResult<T>>(){

                    public CacheResult<T> apply(@NonNull Throwable throwable) throws Exception {
                        HttpLog.i("save status => " + throwable);
                        return new CacheResult<Object>(false, t);
                    }
                });
            }
        });
        if (needEmpty) {
            observable = observable.onErrorResumeNext(new Function<Throwable, ObservableSource<? extends CacheResult<T>>>(){

                public ObservableSource<? extends CacheResult<T>> apply(@NonNull Throwable throwable) throws Exception {
                    return Observable.empty();
                }
            });
        }
        return observable;
    }
}

