/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xaop.util;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Bundle;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.core.content.ContextCompat;
import com.xuexiang.xaop.XAOP;
import com.xuexiang.xaop.consts.PermissionConsts;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public final class PermissionUtils {
    private static final List<String> PERMISSIONS = PermissionUtils.getPermissions();
    private static PermissionUtils sInstance;
    private OnRationaleListener mOnRationaleListener;
    private SimpleCallback mSimpleCallback;
    private FullCallback mFullCallback;
    private ThemeCallback mThemeCallback;
    private Set<String> mPermissions = new LinkedHashSet<String>();
    private List<String> mPermissionsRequest;
    private List<String> mPermissionsGranted;
    private List<String> mPermissionsDenied;
    private List<String> mPermissionsDeniedForever;

    public static List<String> getPermissions() {
        return PermissionUtils.getPermissions(XAOP.getContext().getPackageName());
    }

    public static List<String> getPermissions(String packageName) {
        PackageManager pm = XAOP.getContext().getPackageManager();
        try {
            return Arrays.asList(pm.getPackageInfo((String)packageName, (int)4096).requestedPermissions);
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return Collections.emptyList();
        }
    }

    public static boolean isGranted(String ... permissions) {
        for (String permission : permissions) {
            if (PermissionUtils.isGranted(permission)) continue;
            return false;
        }
        return true;
    }

    private static boolean isGranted(String permission) {
        return Build.VERSION.SDK_INT < 23 || 0 == ContextCompat.checkSelfPermission((Context)XAOP.getContext(), (String)permission);
    }

    public static PermissionUtils permission(String ... permissions) {
        return new PermissionUtils(permissions);
    }

    private PermissionUtils(String ... permissions) {
        for (String permission : permissions) {
            for (String aPermission : PermissionConsts.getPermissions((String)permission)) {
                if (!PERMISSIONS.contains(aPermission)) continue;
                this.mPermissions.add(aPermission);
            }
        }
        sInstance = this;
    }

    public PermissionUtils rationale(OnRationaleListener listener) {
        this.mOnRationaleListener = listener;
        return this;
    }

    public PermissionUtils callback(SimpleCallback callback) {
        this.mSimpleCallback = callback;
        return this;
    }

    public PermissionUtils callback(FullCallback callback) {
        this.mFullCallback = callback;
        return this;
    }

    public PermissionUtils theme(ThemeCallback callback) {
        this.mThemeCallback = callback;
        return this;
    }

    public void request() {
        this.mPermissionsGranted = new ArrayList<String>();
        this.mPermissionsRequest = new ArrayList<String>();
        if (Build.VERSION.SDK_INT < 23) {
            this.mPermissionsGranted.addAll(this.mPermissions);
            this.requestCallback();
        } else {
            for (String permission : this.mPermissions) {
                if (PermissionUtils.isGranted(permission)) {
                    this.mPermissionsGranted.add(permission);
                    continue;
                }
                this.mPermissionsRequest.add(permission);
            }
            if (this.mPermissionsRequest.isEmpty()) {
                this.requestCallback();
            } else {
                this.startPermissionActivity();
            }
        }
    }

    @RequiresApi(api=23)
    private void startPermissionActivity() {
        this.mPermissionsDenied = new ArrayList<String>();
        this.mPermissionsDeniedForever = new ArrayList<String>();
        PermissionActivity.start(XAOP.getContext());
    }

    @RequiresApi(api=23)
    private boolean rationale(Activity activity) {
        boolean isRationale = false;
        if (this.mOnRationaleListener != null) {
            for (String permission : this.mPermissionsRequest) {
                if (!activity.shouldShowRequestPermissionRationale(permission)) continue;
                this.getPermissionsStatus(activity);
                this.mOnRationaleListener.rationale(new OnRationaleListener.ShouldRequest(){

                    @Override
                    public void again(boolean again) {
                        if (again) {
                            PermissionUtils.this.startPermissionActivity();
                        } else {
                            PermissionUtils.this.requestCallback();
                        }
                    }
                });
                isRationale = true;
                break;
            }
            this.mOnRationaleListener = null;
        }
        return isRationale;
    }

    private void getPermissionsStatus(Activity activity) {
        for (String permission : this.mPermissionsRequest) {
            if (PermissionUtils.isGranted(permission)) {
                this.mPermissionsGranted.add(permission);
                continue;
            }
            this.mPermissionsDenied.add(permission);
            if (activity.shouldShowRequestPermissionRationale(permission)) continue;
            this.mPermissionsDeniedForever.add(permission);
        }
    }

    private void requestCallback() {
        if (this.mSimpleCallback != null) {
            if (this.mPermissionsRequest.size() == 0 || this.mPermissions.size() == this.mPermissionsGranted.size()) {
                this.mSimpleCallback.onGranted();
            } else if (!this.mPermissionsDenied.isEmpty()) {
                this.mSimpleCallback.onDenied();
            }
            this.mSimpleCallback = null;
        }
        if (this.mFullCallback != null) {
            if (this.mPermissionsRequest.size() == 0 || this.mPermissions.size() == this.mPermissionsGranted.size()) {
                this.mFullCallback.onGranted(this.mPermissionsGranted);
            } else if (!this.mPermissionsDenied.isEmpty()) {
                this.mFullCallback.onDenied(this.mPermissionsDeniedForever, this.mPermissionsDenied);
            }
            this.mFullCallback = null;
        }
        this.mOnRationaleListener = null;
        this.mThemeCallback = null;
    }

    private void onRequestPermissionsResult(Activity activity) {
        this.getPermissionsStatus(activity);
        this.requestCallback();
    }

    public static interface OnPermissionDeniedListener {
        public void onDenied(List<String> var1);
    }

    public static interface ThemeCallback {
        public void onActivityCreate(Activity var1);
    }

    public static interface FullCallback {
        public void onGranted(List<String> var1);

        public void onDenied(List<String> var1, List<String> var2);
    }

    public static interface SimpleCallback {
        public void onGranted();

        public void onDenied();
    }

    public static interface OnRationaleListener {
        public void rationale(ShouldRequest var1);

        public static interface ShouldRequest {
            public void again(boolean var1);
        }
    }

    @RequiresApi(api=23)
    public static class PermissionActivity
    extends Activity {
        public static void start(Context context) {
            Intent starter = new Intent(context, PermissionActivity.class);
            starter.addFlags(0x10000000);
            context.startActivity(starter);
        }

        protected void onCreate(@Nullable Bundle savedInstanceState) {
            if (sInstance != null && sInstance.mThemeCallback != null) {
                sInstance.mThemeCallback.onActivityCreate(this);
            }
            super.onCreate(savedInstanceState);
            if (sInstance != null && sInstance.rationale(this)) {
                this.finish();
                return;
            }
            if (sInstance != null && sInstance.mPermissionsRequest != null) {
                int size = sInstance.mPermissionsRequest.size();
                this.requestPermissions(sInstance.mPermissionsRequest.toArray(new String[size]), 1);
            }
        }

        public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
            if (sInstance != null) {
                sInstance.onRequestPermissionsResult(this);
            }
            this.finish();
        }
    }
}

