/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xaop.util;

import android.os.Handler;
import android.os.Looper;
import androidx.annotation.NonNull;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public final class AppExecutors {
    private static AppExecutors sInstance;
    private final ExecutorService mSingleIO;
    private ExecutorService mPoolIO;
    private final Executor mMainThread;

    private AppExecutors(ExecutorService singleIO, ExecutorService poolIO, Executor mainThread) {
        this.mSingleIO = singleIO;
        this.mPoolIO = poolIO;
        this.mMainThread = mainThread;
    }

    public AppExecutors updatePoolIO(int nThreads) {
        this.mPoolIO = Executors.newFixedThreadPool(nThreads);
        return this;
    }

    private AppExecutors() {
        this(Executors.newSingleThreadExecutor(), Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors()), new MainThreadExecutor());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AppExecutors get() {
        if (sInstance != null) return sInstance;
        Class<AppExecutors> clazz = AppExecutors.class;
        synchronized (AppExecutors.class) {
            if (sInstance != null) return sInstance;
            sInstance = new AppExecutors();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sInstance;
        }
    }

    public ExecutorService singleIO() {
        return this.mSingleIO;
    }

    public ExecutorService poolIO() {
        return this.mPoolIO;
    }

    public Executor mainThread() {
        return this.mMainThread;
    }

    private static class MainThreadExecutor
    implements Executor {
        private Handler mainThreadHandler = new Handler(Looper.getMainLooper());

        private MainThreadExecutor() {
        }

        @Override
        public void execute(@NonNull Runnable command) {
            this.mainThreadHandler.post(command);
        }
    }
}

