/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xaop.cache.core;

import android.util.LruCache;
import com.xuexiang.xaop.cache.core.ICache;
import java.lang.reflect.Type;

public class LruMemoryCache
implements ICache {
    private LruCache<String, Object> mMemoryCache;

    public LruMemoryCache(int cacheSize) {
        this.mMemoryCache = new LruCache(cacheSize);
    }

    @Override
    public <T> T load(Type type, String key, long time) {
        if (this.mMemoryCache == null) {
            return null;
        }
        return (T)this.mMemoryCache.get((Object)key);
    }

    @Override
    public <T> boolean save(String key, T value) {
        return this.mMemoryCache != null && this.mMemoryCache.put((Object)key, value) != null;
    }

    @Override
    public boolean containsKey(String key) {
        return this.mMemoryCache != null && this.mMemoryCache.get((Object)key) != null;
    }

    @Override
    public boolean remove(String key) {
        return this.mMemoryCache != null && this.mMemoryCache.remove((Object)key) != null;
    }

    @Override
    public boolean clear() {
        if (this.mMemoryCache != null) {
            this.mMemoryCache.evictAll();
            return true;
        }
        return false;
    }
}

