/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xaop.cache.core;

import com.xuexiang.xaop.cache.core.ICache;
import com.xuexiang.xaop.logger.XLogger;
import com.xuexiang.xaop.util.MD5Utils;
import com.xuexiang.xaop.util.Utils;
import java.lang.reflect.Type;

public class CacheCore
implements ICache {
    private ICache mCache;

    public CacheCore(ICache cache) {
        this.mCache = Utils.checkNotNull(cache, "ICache == null");
    }

    public CacheCore setICache(ICache icache) {
        this.mCache = icache;
        return this;
    }

    @Override
    public <T> T load(Type type, String key, long time) {
        if (this.mCache != null) {
            String cacheKey = MD5Utils.encode(key);
            XLogger.d("loadCache  key=" + cacheKey);
            return this.mCache.load(type, cacheKey, time);
        }
        return null;
    }

    @Override
    public <T> boolean save(String key, T value) {
        if (this.mCache != null) {
            String cacheKey = MD5Utils.encode(key);
            XLogger.d("saveCache  key=" + cacheKey);
            return this.mCache.save(cacheKey, value);
        }
        return false;
    }

    @Override
    public boolean containsKey(String key) {
        if (this.mCache != null) {
            String cacheKey = MD5Utils.encode(key);
            XLogger.d("containsCache  key=" + cacheKey);
            return this.mCache.containsKey(cacheKey);
        }
        return false;
    }

    @Override
    public boolean remove(String key) {
        String cacheKey = MD5Utils.encode(key);
        XLogger.d("removeCache  key=" + cacheKey);
        return this.mCache == null || this.mCache.remove(cacheKey);
    }

    @Override
    public boolean clear() {
        return this.mCache != null && this.mCache.clear();
    }
}

