/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xaop.logger;

import android.support.annotation.NonNull;
import android.text.TextUtils;
import com.xuexiang.xaop.logger.ILogger;
import com.xuexiang.xaop.logger.LogcatLogger;
import com.xuexiang.xaop.util.Strings;

public final class XLogger {
    public static final String DEFAULT_LOG_TAG = "[XLogger]";
    private static final int MAX_LOG_PRIORITY = 10;
    private static final int MIN_LOG_PRIORITY = 0;
    private static ILogger sILogger = new LogcatLogger();
    private static Strings.ISerializer sISerializer;
    private static String sTag;
    private static boolean sIsDebug;
    private static int sLogPriority;

    private XLogger() {
        throw new UnsupportedOperationException("Do not need instantiate!");
    }

    public static void setLogger(@NonNull ILogger logger) {
        sILogger = logger;
    }

    public static void setTag(String tag) {
        sTag = tag;
    }

    public static void setDebug(boolean isDebug) {
        sIsDebug = isDebug;
    }

    public static void setPriority(int priority) {
        sLogPriority = priority;
    }

    public static void setISerializer(Strings.ISerializer sISerializer) {
        XLogger.sISerializer = sISerializer;
    }

    public static Strings.ISerializer getISerializer() {
        return sISerializer;
    }

    public static void debug(boolean isDebug) {
        if (isDebug) {
            XLogger.debug(DEFAULT_LOG_TAG);
        } else {
            XLogger.debug("");
        }
    }

    public static void debug(String tag) {
        if (!TextUtils.isEmpty((CharSequence)tag)) {
            XLogger.setDebug(true);
            XLogger.setPriority(0);
            XLogger.setTag(tag);
        } else {
            XLogger.setDebug(false);
            XLogger.setPriority(10);
            XLogger.setTag("");
        }
    }

    public static void v(String msg) {
        if (XLogger.enableLog(2)) {
            sILogger.log(2, sTag, msg, null);
        }
    }

    public static void vTag(String tag, String msg) {
        if (XLogger.enableLog(2)) {
            sILogger.log(2, tag, msg, null);
        }
    }

    public static void d(String msg) {
        if (XLogger.enableLog(3)) {
            sILogger.log(3, sTag, msg, null);
        }
    }

    public static void dTag(String tag, String msg) {
        if (XLogger.enableLog(3)) {
            sILogger.log(3, tag, msg, null);
        }
    }

    public static void i(String msg) {
        if (XLogger.enableLog(4)) {
            sILogger.log(4, sTag, msg, null);
        }
    }

    public static void iTag(String tag, String msg) {
        if (XLogger.enableLog(4)) {
            sILogger.log(4, tag, msg, null);
        }
    }

    public static void w(String msg) {
        if (XLogger.enableLog(5)) {
            sILogger.log(5, sTag, msg, null);
        }
    }

    public static void wTag(String tag, String msg) {
        if (XLogger.enableLog(5)) {
            sILogger.log(5, tag, msg, null);
        }
    }

    public static void e(String msg) {
        if (XLogger.enableLog(6)) {
            sILogger.log(6, sTag, msg, null);
        }
    }

    public static void eTag(String tag, String msg) {
        if (XLogger.enableLog(6)) {
            sILogger.log(6, tag, msg, null);
        }
    }

    public static void e(Throwable t) {
        if (XLogger.enableLog(6)) {
            sILogger.log(6, sTag, null, t);
        }
    }

    public static void eTag(String tag, Throwable t) {
        if (XLogger.enableLog(6)) {
            sILogger.log(6, tag, null, t);
        }
    }

    public static void e(String msg, Throwable t) {
        if (XLogger.enableLog(6)) {
            sILogger.log(6, sTag, msg, t);
        }
    }

    public static void eTag(String tag, String msg, Throwable t) {
        if (XLogger.enableLog(6)) {
            sILogger.log(6, tag, msg, t);
        }
    }

    public static void wtf(String msg) {
        if (XLogger.enableLog(7)) {
            sILogger.log(7, sTag, msg, null);
        }
    }

    public static void wtfTag(String tag, String msg) {
        if (XLogger.enableLog(7)) {
            sILogger.log(7, tag, msg, null);
        }
    }

    public static void log(int priority, String tag, String msg) {
        if (XLogger.enableLog(priority)) {
            sILogger.log(priority, tag, msg, null);
        }
    }

    private static boolean enableLog(int logPriority) {
        return XLogger.isDebug() && logPriority >= sLogPriority;
    }

    public static boolean isDebug() {
        return sILogger != null && sIsDebug;
    }

    static {
        sTag = DEFAULT_LOG_TAG;
        sIsDebug = false;
        sLogPriority = 10;
    }
}

