/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xaop.cache;

import android.content.Context;
import android.os.StatFs;
import com.xuexiang.xaop.XAOP;
import com.xuexiang.xaop.cache.converter.IDiskConverter;
import com.xuexiang.xaop.cache.core.CacheCore;
import com.xuexiang.xaop.cache.core.LruDiskCache;
import com.xuexiang.xaop.cache.core.LruMemoryCache;
import com.xuexiang.xaop.util.Utils;
import java.io.File;
import java.lang.reflect.Type;

public class XCache {
    private CacheCore mCacheCore;
    private long mCacheTime;

    public static XCache newInstance() {
        return new XCache();
    }

    public XCache() {
        this(new Builder().builder());
    }

    public XCache(Builder builder) {
        this.init(builder);
    }

    public XCache init(Builder builder) {
        if (builder.isDiskCache) {
            this.mCacheTime = builder.cacheTime;
            this.mCacheCore = new CacheCore(new LruDiskCache(builder.diskConverter, builder.diskDir, builder.appVersion, builder.diskMaxSize));
        } else {
            this.mCacheCore = new CacheCore(new LruMemoryCache(builder.memoryMaxSize));
        }
        return this;
    }

    public <T> T load(String key) {
        return this.mCacheCore.load(null, key, this.mCacheTime);
    }

    public <T> T load(String key, long time) {
        return this.mCacheCore.load(null, key, time);
    }

    public <T> T load(Type type, String key, long time) {
        return this.mCacheCore.load(type, key, time);
    }

    public <T> boolean save(String key, T value) {
        return this.mCacheCore.save(key, value);
    }

    public boolean containsKey(String key) {
        return this.mCacheCore.containsKey(key);
    }

    public boolean remove(String key) {
        return this.mCacheCore.remove(key);
    }

    public boolean clear() {
        return this.mCacheCore.clear();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private static final int MIN_DISK_CACHE_SIZE = 0x500000;
        private static final int MAX_DISK_CACHE_SIZE = 0x3200000;
        private boolean isDiskCache = false;
        private int memoryMaxSize;
        private Context context;
        private long cacheTime;
        private IDiskConverter diskConverter;
        private File diskDir;
        private int appVersion;
        private long diskMaxSize;

        public Builder() {
            this(XAOP.getContext());
        }

        public Builder(Context context) {
            this.context = context;
            this.diskConverter = XAOP.getIDiskConverter();
            this.cacheTime = -1L;
            this.appVersion = Utils.getAppVersionCode(context);
        }

        public Builder isDiskCache(boolean isDiskCache) {
            this.isDiskCache = isDiskCache;
            return this;
        }

        public Builder memoryMaxSize(int memoryMaxSize) {
            this.memoryMaxSize = memoryMaxSize;
            return this;
        }

        public Builder cacheTime(long cacheTime) {
            this.cacheTime = cacheTime;
            return this;
        }

        public Builder appVersion(int appVersion) {
            this.appVersion = appVersion;
            return this;
        }

        public Builder diskDir(File directory) {
            this.diskDir = directory;
            return this;
        }

        public Builder diskConverter(IDiskConverter converter) {
            this.diskConverter = converter;
            return this;
        }

        public Builder diskMax(long maxSize) {
            this.diskMaxSize = maxSize;
            return this;
        }

        public Builder builder() {
            if (this.isDiskCache) {
                if (this.diskConverter == null) {
                    this.diskConverter = XAOP.getIDiskConverter();
                }
                if (this.diskDir == null) {
                    this.diskDir = Utils.getDiskCacheDir(this.context, "data-cache");
                }
                Utils.checkNotNull(this.diskDir, "diskDir==null");
                if (!this.diskDir.exists()) {
                    this.diskDir.mkdirs();
                }
                if (this.diskMaxSize <= 0L) {
                    this.diskMaxSize = Builder.calculateDiskCacheSize(this.diskDir);
                }
                this.cacheTime = Math.max(-1L, this.cacheTime);
                this.appVersion = Math.max(Utils.getAppVersionCode(this.context), this.appVersion);
            } else if (this.memoryMaxSize <= 0) {
                this.memoryMaxSize = (int)(Runtime.getRuntime().maxMemory() / 1024L) / 8;
            }
            return this;
        }

        public XCache build() {
            return new XCache(this.builder());
        }

        private static long calculateDiskCacheSize(File dir) {
            long size = 0L;
            try {
                StatFs statFs = new StatFs(dir.getAbsolutePath());
                long available = (long)statFs.getBlockCount() * (long)statFs.getBlockSize();
                size = available / 50L;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            return Math.max(Math.min(size, 0x3200000L), 0x500000L);
        }
    }
}

