package com.ark.net.urlconn;

import android.content.Context;
import com.yanzhenjie.kalle.download.SimpleCallback;
import com.yanzhenjie.kalle.exception.*;

public abstract class DownloadCallback extends SimpleCallback {

    private Context mContext;

    public DownloadCallback(Context context) {
        mContext = context;
    }

    @Override
    public final void onException(Exception e) {
        String message;
        if (e instanceof NetworkError) {
            message = mContext.getString(R.string.http_exception_network);
        } else if (e instanceof URLError) {
            message = mContext.getString(R.string.http_exception_url);
        } else if (e instanceof HostError) {
            message = mContext.getString(R.string.http_exception_host);
        } else if (e instanceof ConnectTimeoutError) {
            message = mContext.getString(R.string.http_exception_connect_timeout);
        } else if (e instanceof WriteException) {
            message = mContext.getString(R.string.http_exception_write);
        } else if (e instanceof ReadTimeoutError) {
            message = mContext.getString(R.string.http_exception_read_timeout);
        } else {
            message = mContext.getString(R.string.http_exception_unknow_error);
        }
        onException(message);
    }

    public abstract void onException(String message);

}
