/*
 * Decompiled with CFR 0.152.
 */
package com.ark.uikit.loading;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.v7.widget.AppCompatImageView;
import android.util.AttributeSet;
import android.view.View;
import com.ark.uikit.loading.LevelLoadingRenderer;
import com.ark.uikit.loading.LoadingDrawable;

public class LoadingView
extends AppCompatImageView {
    private LoadingDrawable mLoadingDrawable;
    private LevelLoadingRenderer mLoadingRenderer;

    public LoadingView(Context context) {
        super(context);
    }

    public LoadingView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mLoadingRenderer = new LevelLoadingRenderer(context);
        this.mLoadingDrawable = new LoadingDrawable(this.mLoadingRenderer);
        this.setImageDrawable(this.mLoadingDrawable);
    }

    public void setCircleColors(int r1, int r2, int r3) {
        this.mLoadingRenderer.setCircleColors(r1, r2, r3);
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.startAnimation();
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.stopAnimation();
    }

    protected void onVisibilityChanged(@NonNull View changedView, int visibility) {
        super.onVisibilityChanged(changedView, visibility);
        if (visibility == 0) {
            this.startAnimation();
        } else {
            this.stopAnimation();
        }
    }

    private void startAnimation() {
        if (this.mLoadingDrawable != null) {
            this.mLoadingDrawable.start();
        }
    }

    private void stopAnimation() {
        if (this.mLoadingDrawable != null) {
            this.mLoadingDrawable.stop();
        }
    }
}

