/*
 * Decompiled with CFR 0.152.
 */
package com.ark.dict;

import android.text.TextUtils;
import com.ark.dict.Utils;
import com.tencent.mmkv.MMKV;
import java.util.Set;

public final class ArkKv {
    private static final String ID_CONFIG = "key_val_id";

    private ArkKv() {
    }

    public static void saveString(String key, String value) {
        if (TextUtils.isEmpty((CharSequence)key)) {
            return;
        }
        try {
            Class.forName("com.tencent.mmkv.MMKV");
            MMKV mmkv = MMKV.mmkvWithID((String)ID_CONFIG, (int)2);
            mmkv.encode(key, value);
        }
        catch (ClassNotFoundException e) {
            Utils.getContext().getSharedPreferences(ID_CONFIG, 0).edit().putString(key, value).apply();
        }
    }

    public static void saveSet(String key, Set<String> value) {
        if (TextUtils.isEmpty((CharSequence)key)) {
            return;
        }
        try {
            Class.forName("com.tencent.mmkv.MMKV");
            MMKV mmkv = MMKV.mmkvWithID((String)ID_CONFIG, (int)2);
            mmkv.encode(key, value);
        }
        catch (ClassNotFoundException e) {
            Utils.getContext().getSharedPreferences(ID_CONFIG, 0).edit().putStringSet(key, value).apply();
        }
    }

    public static void saveBool(String key, boolean value) {
        if (TextUtils.isEmpty((CharSequence)key)) {
            return;
        }
        try {
            Class.forName("com.tencent.mmkv.MMKV");
            MMKV mmkv = MMKV.mmkvWithID((String)ID_CONFIG, (int)2);
            mmkv.encode(key, value);
        }
        catch (ClassNotFoundException e) {
            Utils.getContext().getSharedPreferences(ID_CONFIG, 0).edit().putBoolean(key, value).apply();
        }
    }

    public static void saveInt(String key, int value) {
        if (TextUtils.isEmpty((CharSequence)key)) {
            return;
        }
        try {
            Class.forName("com.tencent.mmkv.MMKV");
            MMKV mmkv = MMKV.mmkvWithID((String)ID_CONFIG, (int)2);
            mmkv.encode(key, value);
        }
        catch (ClassNotFoundException e) {
            Utils.getContext().getSharedPreferences(ID_CONFIG, 0).edit().putInt(key, value).apply();
        }
    }

    public static void saveLong(String key, long value) {
        if (TextUtils.isEmpty((CharSequence)key)) {
            return;
        }
        try {
            Class.forName("com.tencent.mmkv.MMKV");
            MMKV mmkv = MMKV.mmkvWithID((String)ID_CONFIG, (int)2);
            mmkv.encode(key, value);
        }
        catch (ClassNotFoundException e) {
            Utils.getContext().getSharedPreferences(ID_CONFIG, 0).edit().putLong(key, value).apply();
        }
    }

    public static void saveFloat(String key, float value) {
        if (TextUtils.isEmpty((CharSequence)key)) {
            return;
        }
        try {
            Class.forName("com.tencent.mmkv.MMKV");
            MMKV mmkv = MMKV.mmkvWithID((String)ID_CONFIG, (int)2);
            mmkv.encode(key, value);
        }
        catch (ClassNotFoundException e) {
            Utils.getContext().getSharedPreferences(ID_CONFIG, 0).edit().putFloat(key, value).apply();
        }
    }

    public static String getString(String key, String defValue) {
        String value;
        if (TextUtils.isEmpty((CharSequence)key)) {
            return defValue;
        }
        try {
            Class.forName("com.tencent.mmkv.MMKV");
            MMKV mmkv = MMKV.mmkvWithID((String)ID_CONFIG, (int)2);
            value = mmkv.decodeString(key, defValue);
        }
        catch (ClassNotFoundException e) {
            value = Utils.getContext().getSharedPreferences(ID_CONFIG, 0).getString(key, defValue);
        }
        return value;
    }

    public static boolean getBool(String key, boolean defValue) {
        boolean value;
        if (TextUtils.isEmpty((CharSequence)key)) {
            return defValue;
        }
        try {
            Class.forName("com.tencent.mmkv.MMKV");
            MMKV mmkv = MMKV.mmkvWithID((String)ID_CONFIG, (int)2);
            value = mmkv.decodeBool(key, defValue);
        }
        catch (ClassNotFoundException e) {
            value = Utils.getContext().getSharedPreferences(ID_CONFIG, 0).getBoolean(key, defValue);
        }
        return value;
    }

    public static int getInt(String key, int defValue) {
        int value;
        if (TextUtils.isEmpty((CharSequence)key)) {
            return defValue;
        }
        try {
            Class.forName("com.tencent.mmkv.MMKV");
            MMKV mmkv = MMKV.mmkvWithID((String)ID_CONFIG, (int)2);
            value = mmkv.decodeInt(key, defValue);
        }
        catch (ClassNotFoundException e) {
            value = Utils.getContext().getSharedPreferences(ID_CONFIG, 0).getInt(key, defValue);
        }
        return value;
    }

    public static long getLong(String key, long defValue) {
        long value;
        if (TextUtils.isEmpty((CharSequence)key)) {
            return defValue;
        }
        try {
            Class.forName("com.tencent.mmkv.MMKV");
            MMKV mmkv = MMKV.mmkvWithID((String)ID_CONFIG, (int)2);
            value = mmkv.decodeLong(key, defValue);
        }
        catch (ClassNotFoundException e) {
            value = Utils.getContext().getSharedPreferences(ID_CONFIG, 0).getLong(key, defValue);
        }
        return value;
    }

    public static float getFloat(String key, float defValue) {
        float value;
        if (TextUtils.isEmpty((CharSequence)key)) {
            return defValue;
        }
        try {
            Class.forName("com.tencent.mmkv.MMKV");
            MMKV mmkv = MMKV.mmkvWithID((String)ID_CONFIG, (int)2);
            value = mmkv.decodeFloat(key, defValue);
        }
        catch (ClassNotFoundException e) {
            value = Utils.getContext().getSharedPreferences(ID_CONFIG, 0).getFloat(key, defValue);
        }
        return value;
    }

    public static Set<String> getStringSet(String key, Set<String> defValue) {
        Set value;
        if (TextUtils.isEmpty((CharSequence)key)) {
            return defValue;
        }
        try {
            Class.forName("com.tencent.mmkv.MMKV");
            MMKV mmkv = MMKV.mmkvWithID((String)ID_CONFIG, (int)2);
            value = mmkv.decodeStringSet(key, defValue);
        }
        catch (ClassNotFoundException e) {
            value = Utils.getContext().getSharedPreferences(ID_CONFIG, 0).getStringSet(key, defValue);
        }
        return value;
    }

    public static boolean contains(String key) {
        boolean value;
        try {
            Class.forName("com.tencent.mmkv.MMKV");
            MMKV mmkv = MMKV.mmkvWithID((String)ID_CONFIG, (int)2);
            value = mmkv.contains(key);
        }
        catch (ClassNotFoundException e) {
            value = Utils.getContext().getSharedPreferences(ID_CONFIG, 0).contains(key);
        }
        return value;
    }

    public static void remove(String key) {
        try {
            Class.forName("com.tencent.mmkv.MMKV");
            MMKV mmkv = MMKV.mmkvWithID((String)ID_CONFIG, (int)2);
            mmkv.remove(key);
        }
        catch (ClassNotFoundException e) {
            Utils.getContext().getSharedPreferences(ID_CONFIG, 0).edit().remove(key).apply();
        }
    }
}

