package com.ark.dict;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.support.annotation.Nullable;

public class ConfigBroadcastReceiver extends BroadcastReceiver {

    private OnConfigRespListener mListener = null;

    @Override
    public void onReceive(Context context, Intent intent) {
        boolean byUser = false;
        if (intent != null) {
            byUser = intent.getBooleanExtra("byUser", false);
        }
        if (mListener != null) {
            mListener.onLoaded(byUser, ConfigMapLoader.getInstance());
        }
    }

    /**
     * 添加设置响应监听
     *
     * @param listener OnConfigRespListener
     */
    public void addOnConfigRespListener(@Nullable OnConfigRespListener listener) {
        mListener = listener;
    }

    /**
     * 移除所有设置响应监听
     */
    public void removeAllOnConfigRespListener() {
        mListener = null;
    }
}
