package com.ark.dict;

import android.content.Context;
import android.text.TextUtils;

import java.util.Set;

public final class ArkKv {
    private static final String ID_CONFIG = "key_val_id";

    private ArkKv() {
    }

    public static void saveString(String key, String value) {
        if (TextUtils.isEmpty(key)) {
            return;
        }
        try {
            Class.forName("com.tencent.mmkv.MMKV");
            com.tencent.mmkv.MMKV mmkv = com.tencent.mmkv.MMKV.mmkvWithID(ID_CONFIG,
                    com.tencent.mmkv.MMKV.MULTI_PROCESS_MODE);
            mmkv.encode(key, value);
        } catch (ClassNotFoundException e) {
            Utils.getContext()
                    .getSharedPreferences(ID_CONFIG, Context.MODE_PRIVATE)
                    .edit()
                    .putString(key, value)
                    .apply();
        }
    }

    public static void saveSet(String key, Set<String> value) {
        if (TextUtils.isEmpty(key)) {
            return;
        }
        try {
            Class.forName("com.tencent.mmkv.MMKV");
            com.tencent.mmkv.MMKV mmkv = com.tencent.mmkv.MMKV.mmkvWithID(ID_CONFIG,
                    com.tencent.mmkv.MMKV.MULTI_PROCESS_MODE);
            mmkv.encode(key, value);
        } catch (ClassNotFoundException e) {
            Utils.getContext()
                    .getSharedPreferences(ID_CONFIG, Context.MODE_PRIVATE)
                    .edit()
                    .putStringSet(key, value)
                    .apply();
        }
    }

    public static void saveBool(String key, boolean value) {
        if (TextUtils.isEmpty(key)) {
            return;
        }
        try {
            Class.forName("com.tencent.mmkv.MMKV");
            com.tencent.mmkv.MMKV mmkv = com.tencent.mmkv.MMKV.mmkvWithID(ID_CONFIG,
                    com.tencent.mmkv.MMKV.MULTI_PROCESS_MODE);
            mmkv.encode(key, value);
        } catch (ClassNotFoundException e) {
            Utils.getContext()
                    .getSharedPreferences(ID_CONFIG, Context.MODE_PRIVATE)
                    .edit()
                    .putBoolean(key, value)
                    .apply();
        }
    }


    public static void saveInt(String key, int value) {
        if (TextUtils.isEmpty(key)) {
            return;
        }
        try {
            Class.forName("com.tencent.mmkv.MMKV");
            com.tencent.mmkv.MMKV mmkv = com.tencent.mmkv.MMKV.mmkvWithID(ID_CONFIG,
                    com.tencent.mmkv.MMKV.MULTI_PROCESS_MODE);
            mmkv.encode(key, value);
        } catch (ClassNotFoundException e) {
            Utils.getContext()
                    .getSharedPreferences(ID_CONFIG, Context.MODE_PRIVATE)
                    .edit()
                    .putInt(key, value)
                    .apply();
        }
    }

    public static void saveLong(String key, long value) {
        if (TextUtils.isEmpty(key)) {
            return;
        }
        try {
            Class.forName("com.tencent.mmkv.MMKV");
            com.tencent.mmkv.MMKV mmkv = com.tencent.mmkv.MMKV.mmkvWithID(ID_CONFIG,
                    com.tencent.mmkv.MMKV.MULTI_PROCESS_MODE);
            mmkv.encode(key, value);
        } catch (ClassNotFoundException e) {
            Utils.getContext()
                    .getSharedPreferences(ID_CONFIG, Context.MODE_PRIVATE)
                    .edit()
                    .putLong(key, value)
                    .apply();
        }
    }

    public static void saveFloat(String key, float value) {
        if (TextUtils.isEmpty(key)) {
            return;
        }
        try {
            Class.forName("com.tencent.mmkv.MMKV");
            com.tencent.mmkv.MMKV mmkv = com.tencent.mmkv.MMKV.mmkvWithID(ID_CONFIG,
                    com.tencent.mmkv.MMKV.MULTI_PROCESS_MODE);
            mmkv.encode(key, value);
        } catch (ClassNotFoundException e) {
            Utils.getContext()
                    .getSharedPreferences(ID_CONFIG, Context.MODE_PRIVATE)
                    .edit()
                    .putFloat(key, value)
                    .apply();
        }
    }

    public static String getString(String key, String defValue) {
        if (TextUtils.isEmpty(key)) {
            return defValue;
        }
        String value;
        try {
            Class.forName("com.tencent.mmkv.MMKV");
            com.tencent.mmkv.MMKV mmkv = com.tencent.mmkv.MMKV.mmkvWithID(ID_CONFIG,
                    com.tencent.mmkv.MMKV.MULTI_PROCESS_MODE);
            value = mmkv.decodeString(key, defValue);
        } catch (ClassNotFoundException e) {
            value = Utils.getContext()
                    .getSharedPreferences(ID_CONFIG, Context.MODE_PRIVATE)
                    .getString(key, defValue);
        }
        return value;
    }

    public static boolean getBool(String key, boolean defValue) {
        if (TextUtils.isEmpty(key)) {
            return defValue;
        }
        boolean value;
        try {
            Class.forName("com.tencent.mmkv.MMKV");
            com.tencent.mmkv.MMKV mmkv = com.tencent.mmkv.MMKV.mmkvWithID(ID_CONFIG,
                    com.tencent.mmkv.MMKV.MULTI_PROCESS_MODE);
            value = mmkv.decodeBool(key, defValue);
        } catch (ClassNotFoundException e) {
            value = Utils.getContext()
                    .getSharedPreferences(ID_CONFIG, Context.MODE_PRIVATE)
                    .getBoolean(key, defValue);
        }
        return value;
    }

    public static int getInt(String key, int defValue) {
        if (TextUtils.isEmpty(key)) {
            return defValue;
        }
        int value;
        try {
            Class.forName("com.tencent.mmkv.MMKV");
            com.tencent.mmkv.MMKV mmkv = com.tencent.mmkv.MMKV.mmkvWithID(ID_CONFIG,
                    com.tencent.mmkv.MMKV.MULTI_PROCESS_MODE);
            value = mmkv.decodeInt(key, defValue);
        } catch (ClassNotFoundException e) {
            value = Utils.getContext()
                    .getSharedPreferences(ID_CONFIG, Context.MODE_PRIVATE)
                    .getInt(key, defValue);
        }
        return value;
    }

    public static long getLong(String key, long defValue) {
        if (TextUtils.isEmpty(key)) {
            return defValue;
        }
        long value;
        try {
            Class.forName("com.tencent.mmkv.MMKV");
            com.tencent.mmkv.MMKV mmkv = com.tencent.mmkv.MMKV.mmkvWithID(ID_CONFIG,
                    com.tencent.mmkv.MMKV.MULTI_PROCESS_MODE);
            value = mmkv.decodeLong(key, defValue);
        } catch (ClassNotFoundException e) {
            value = Utils.getContext()
                    .getSharedPreferences(ID_CONFIG, Context.MODE_PRIVATE)
                    .getLong(key, defValue);
        }
        return value;
    }

    public static float getFloat(String key, float defValue) {
        if (TextUtils.isEmpty(key)) {
            return defValue;
        }
        float value;
        try {
            Class.forName("com.tencent.mmkv.MMKV");
            com.tencent.mmkv.MMKV mmkv = com.tencent.mmkv.MMKV.mmkvWithID(ID_CONFIG,
                    com.tencent.mmkv.MMKV.MULTI_PROCESS_MODE);
            value = mmkv.decodeFloat(key, defValue);
        } catch (ClassNotFoundException e) {
            value = Utils.getContext()
                    .getSharedPreferences(ID_CONFIG, Context.MODE_PRIVATE)
                    .getFloat(key, defValue);
        }
        return value;
    }

    public static Set<String> getStringSet(String key, Set<String> defValue) {
        if (TextUtils.isEmpty(key)) {
            return defValue;
        }
        Set<String> value;
        try {
            Class.forName("com.tencent.mmkv.MMKV");
            com.tencent.mmkv.MMKV mmkv = com.tencent.mmkv.MMKV.mmkvWithID(ID_CONFIG,
                    com.tencent.mmkv.MMKV.MULTI_PROCESS_MODE);
            value = mmkv.decodeStringSet(key, defValue);
        } catch (ClassNotFoundException e) {
            value = Utils.getContext()
                    .getSharedPreferences(ID_CONFIG, Context.MODE_PRIVATE)
                    .getStringSet(key, defValue);
        }
        return value;
    }

    public static boolean contains(String key) {
        boolean value;
        try {
            Class.forName("com.tencent.mmkv.MMKV");
            com.tencent.mmkv.MMKV mmkv = com.tencent.mmkv.MMKV.mmkvWithID(ID_CONFIG,
                    com.tencent.mmkv.MMKV.MULTI_PROCESS_MODE);
            value = mmkv.contains(key);
        } catch (ClassNotFoundException e) {
            value = Utils.getContext()
                    .getSharedPreferences(ID_CONFIG, Context.MODE_PRIVATE)
                    .contains(key);
        }
        return value;
    }

    public static void remove(String key) {
        try {
            Class.forName("com.tencent.mmkv.MMKV");
            com.tencent.mmkv.MMKV mmkv = com.tencent.mmkv.MMKV.mmkvWithID(ID_CONFIG,
                    com.tencent.mmkv.MMKV.MULTI_PROCESS_MODE);
            mmkv.remove(key);
        } catch (ClassNotFoundException e) {
            Utils.getContext()
                    .getSharedPreferences(ID_CONFIG, Context.MODE_PRIVATE)
                    .edit().remove(key).apply();
        }
    }
}
