/*
 * Decompiled with CFR 0.152.
 */
package com.ark.dict;

import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Locale;

final class InnerUtils {
    InnerUtils() {
    }

    @NonNull
    static String getLanguage(@NonNull Context context) {
        try {
            Locale locale = Build.VERSION.SDK_INT >= 24 ? context.getResources().getConfiguration().getLocales().get(0) : context.getResources().getConfiguration().locale;
            String language = locale.getLanguage() + "-" + locale.getCountry();
            if (language.startsWith("zh-")) {
                if (language.startsWith("zh-CN")) {
                    return "CN";
                }
                return "CT";
            }
            if (language.startsWith("fr-")) {
                return "FR";
            }
            if (language.startsWith("de-")) {
                return "GE";
            }
            if (language.startsWith("it-")) {
                return "IT";
            }
            if (language.startsWith("ja-")) {
                return "JP";
            }
            if (language.startsWith("ko-")) {
                return "KR";
            }
            if (language.startsWith("ru-")) {
                return "RU";
            }
            if (language.startsWith("es-")) {
                return "SP";
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "EN";
    }

    @Nullable
    private static PackageInfo getPackageInfo(Context context) {
        PackageManager packageManager = context.getPackageManager();
        try {
            return packageManager.getPackageInfo(context.getPackageName(), 0);
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    @NonNull
    static String getVersionName(@NonNull Context context) {
        PackageInfo packageInfo = InnerUtils.getPackageInfo(context);
        if (packageInfo != null) {
            return packageInfo.versionName;
        }
        return "1.0";
    }

    @NonNull
    static String getChannel(@Nullable Context context) {
        String str = InnerUtils.getUMChannel(context);
        if (str == null || TextUtils.isEmpty((CharSequence)str) || TextUtils.equals((CharSequence)"null", (CharSequence)str)) {
            str = "default";
        }
        return str;
    }

    @Nullable
    private static String getUMChannel(@Nullable Context ctx) {
        if (ctx == null) {
            return null;
        }
        String channelName = null;
        try {
            ApplicationInfo applicationInfo;
            PackageManager packageManager = ctx.getPackageManager();
            if (packageManager != null && (applicationInfo = packageManager.getApplicationInfo(ctx.getPackageName(), 128)) != null && applicationInfo.metaData != null) {
                channelName = applicationInfo.metaData.get("UMENG_CHANNEL") + "";
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        return channelName;
    }

    static void sendConfigResp(Context context, boolean byUser) {
        Intent intent = new Intent(context.getPackageName() + ".dict.config.ACTION");
        intent.setPackage(context.getPackageName());
        intent.putExtra("byUser", byUser);
        context.sendBroadcast(intent);
    }

    static String encode32MD5(String s) {
        try {
            MessageDigest digest = MessageDigest.getInstance("MD5");
            digest.update(s.getBytes());
            byte[] messageDigest = digest.digest();
            return InnerUtils.toHexString32(messageDigest);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return "";
        }
    }

    private static String toHexString32(byte[] keyData) {
        if (keyData == null) {
            return null;
        }
        int expectedStringLen = keyData.length * 2;
        StringBuilder sb = new StringBuilder(expectedStringLen);
        for (byte aKeyData : keyData) {
            String hexStr = Integer.toString(aKeyData & 0xFF, 16);
            if (hexStr.length() == 1) {
                hexStr = "0" + hexStr;
            }
            sb.append(hexStr);
        }
        return sb.toString();
    }
}

