/*
 * Decompiled with CFR 0.152.
 */
package com.ark.dict;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.IntentFilter;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.util.Log;
import com.ark.dict.ConfigBroadcastReceiver;
import com.ark.dict.InnerUtils;
import com.ark.dict.OnConfigRespListener;
import com.ark.dict.Utils;
import com.ark.net.urlconn.StringCallback;
import com.tencent.mmkv.MMKV;
import com.yanzhenjie.kalle.Kalle;
import com.yanzhenjie.kalle.simple.Callback;
import com.yanzhenjie.kalle.simple.SimpleResponse;
import com.yanzhenjie.kalle.simple.cache.CacheMode;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.json.JSONObject;

public final class ConfigMapLoader {
    private static final String KEY_CONFIG = "key_val_config";
    private static final String ID_CONFIG = "key_val_id";
    private static Map<String, String> mResponseMap = new HashMap<String, String>();
    private static ConfigBroadcastReceiver sReceive = new ConfigBroadcastReceiver();
    private Map<String, String> mParamMap = new HashMap<String, String>();
    private ConfigBroadcastReceiver receiver;

    private ConfigMapLoader() {
        Context context = Utils.getContext();
        this.mParamMap.put("appid", InnerUtils.encode32MD5(context.getPackageName()));
        this.mParamMap.put("package_name", context.getPackageName());
        this.mParamMap.put("sys", "android");
        this.mParamMap.put("os", "android");
        this.mParamMap.put("channel", InnerUtils.getChannel(context));
        this.mParamMap.put("appver", InnerUtils.getVersionName(context));
        this.mParamMap.put("lan", InnerUtils.getLanguage(context));
    }

    public static ConfigMapLoader getInstance() {
        return Holder.configMapLoader;
    }

    @NonNull
    public ConfigMapLoader addOnConfigRespListener(@NonNull Context context, @NonNull OnConfigRespListener listener) {
        if (!mResponseMap.isEmpty()) {
            listener.onLoaded(false, this);
        } else {
            this.receiver = new ConfigBroadcastReceiver();
            IntentFilter intentFilter = new IntentFilter();
            intentFilter.addAction(context.getPackageName() + ".dict.config.ACTION");
            context.registerReceiver((BroadcastReceiver)this.receiver, intentFilter);
            sReceive.addOnConfigRespListener(listener);
        }
        return this;
    }

    public void removeAllOnConfigRespListener(@NonNull Context context) {
        if (this.receiver != null) {
            try {
                context.unregisterReceiver((BroadcastReceiver)this.receiver);
            }
            catch (Exception e) {
                Log.e((String)"logger", (String)e.getLocalizedMessage());
            }
            this.receiver = null;
        }
        sReceive.removeAllOnConfigRespListener();
    }

    @NonNull
    public Map<String, String> getResponseMap() {
        if (mResponseMap.isEmpty()) {
            String json = this.loadFromCache();
            try {
                Log.w((String)"logger", (String)"\u4f7f\u7528\u79bb\u7ebf\u914d\u7f6e");
                mResponseMap = this.loadJsonToMap(json);
            }
            catch (Exception e) {
                Log.e((String)"logger", (String)e.getLocalizedMessage());
            }
        }
        return mResponseMap;
    }

    @NonNull
    private Map<String, String> loadJsonToMap(String json) throws Exception {
        HashMap<String, String> mResponseMap = new HashMap<String, String>();
        if (!TextUtils.isEmpty((CharSequence)json)) {
            JSONObject responseObject = new JSONObject(json);
            JSONObject resObject = responseObject.optJSONObject("res");
            JSONObject params = resObject.optJSONObject("params");
            JSONObject kvObj = params == null ? resObject : params;
            Iterator iterator = kvObj.keys();
            while (iterator.hasNext()) {
                String key = (String)iterator.next();
                String value = kvObj.optString(key);
                mResponseMap.put(key, value);
            }
        }
        return mResponseMap;
    }

    @NonNull
    private String loadFromCache() {
        MMKV kv = MMKV.mmkvWithID((String)ID_CONFIG, (int)2);
        String local = kv.decodeString(KEY_CONFIG, "");
        Log.i((String)"logger", (String)("local-->" + local));
        return local;
    }

    void request(final boolean byUser) {
        Kalle.get((String)this.getRequestUrl()).cacheKey(KEY_CONFIG).cacheMode(CacheMode.NETWORK_NO_THEN_READ_CACHE).perform((Callback)new StringCallback<String>(Utils.getContext()){

            public void onResponse(SimpleResponse<String, String> response) {
                String json = null;
                if (response.isSucceed()) {
                    json = (String)response.succeed();
                    Log.w((String)"logger", (String)("\u5728\u7ebf\u914d\u7f6e\u8bf7\u6c42\u6210\u529f:" + json));
                    MMKV kv = MMKV.mmkvWithID((String)ConfigMapLoader.ID_CONFIG, (int)2);
                    kv.encode(ConfigMapLoader.KEY_CONFIG, json);
                } else {
                    Log.w((String)"logger", (String)("\u5728\u7ebf\u914d\u7f6e\u8bf7\u6c42\u5931\u8d25:" + (String)response.failed()));
                }
                if (TextUtils.isEmpty((CharSequence)json)) {
                    json = ConfigMapLoader.this.loadFromCache();
                }
                try {
                    mResponseMap = ConfigMapLoader.this.loadJsonToMap(json);
                }
                catch (Exception e) {
                    Log.e((String)"logger", (String)e.getLocalizedMessage());
                }
                InnerUtils.sendConfigResp(Utils.getContext(), byUser);
            }
        });
    }

    public void request() {
        this.request(true);
    }

    @NonNull
    public ConfigMapLoader enableRefresh(boolean enabled) {
        if (enabled) {
            this.mParamMap.put("currenttime", String.valueOf(System.currentTimeMillis()));
        }
        return this;
    }

    public boolean isOldServer() {
        String pkName = Utils.getContext().getPackageName();
        return TextUtils.equals((CharSequence)pkName, (CharSequence)"com.emojifair.emoji") || TextUtils.equals((CharSequence)pkName, (CharSequence)"com.emojifair.emoji") || TextUtils.equals((CharSequence)pkName, (CharSequence)"com.novv.resshare") || TextUtils.equals((CharSequence)pkName, (CharSequence)"com.androidesk") || TextUtils.equals((CharSequence)pkName, (CharSequence)"com.lovebizhi.wallpaper") || TextUtils.equals((CharSequence)pkName, (CharSequence)"com.androidesk.livewallpaper");
    }

    @NonNull
    public String getRequestUrl() {
        StringBuilder builderUrl = new StringBuilder();
        if (this.isOldServer()) {
            builderUrl.append("http://service.kv.dandanjiang.tv/online/params");
        } else {
            builderUrl.append("http://service.kv.dandanjiang.tv/remote");
        }
        if (this.mParamMap.size() != 0) {
            builderUrl.append("?");
            Iterator<Map.Entry<String, String>> iterator = this.mParamMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, String> object;
                Map.Entry<String, String> entry = object = iterator.next();
                String key = entry.getKey();
                String val = entry.getValue();
                builderUrl.append(key);
                builderUrl.append("=");
                builderUrl.append(val);
                builderUrl.append("&");
            }
            builderUrl.deleteCharAt(builderUrl.length() - 1);
        }
        return builderUrl.toString();
    }

    private static class Holder {
        private static ConfigMapLoader configMapLoader = new ConfigMapLoader();

        private Holder() {
        }
    }
}

