/*
 * Decompiled with CFR 0.152.
 */
package com.xkzhangsan.time.utils;

import com.xkzhangsan.time.utils.BaseCache;
import java.util.function.Supplier;
import java.util.regex.Pattern;

public class RegexCache {
    private static volatile BaseCache<Regex, Pattern> cache;

    private RegexCache() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static BaseCache<Regex, Pattern> getCache() {
        if (cache != null) return cache;
        Class<RegexCache> clazz = RegexCache.class;
        synchronized (RegexCache.class) {
            if (cache != null) return cache;
            cache = new BaseCache();
            // ** MonitorExit[var0] (shouldn't be in output)
            return cache;
        }
    }

    public static Pattern get(String rule) {
        return RegexCache.get(rule, 0);
    }

    public static Pattern get(final String rule, final int flags) {
        Regex regex = new Regex(rule, flags);
        Supplier<Pattern> supplier = new Supplier<Pattern>(){

            @Override
            public Pattern get() {
                return Pattern.compile(rule, flags);
            }
        };
        return RegexCache.getCache().get(regex, supplier);
    }

    public static Pattern remove(String rule) {
        return RegexCache.remove(rule, 0);
    }

    public static Pattern remove(String rule, int flags) {
        Regex regex = new Regex(rule, flags);
        return RegexCache.getCache().remove(regex);
    }

    public static void clear() {
        RegexCache.getCache().clear();
    }

    private static class Regex {
        private String name;
        private String rule;
        private int flags;
        private String desc;

        public Regex(String rule, int flags) {
            this(null, rule, flags);
        }

        public Regex(String name, String rule, int flags) {
            this(name, rule, flags, null);
        }

        public Regex(String name, String rule, int flags, String desc) {
            this.name = name;
            this.rule = rule;
            this.flags = flags;
            this.desc = desc;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.flags;
            result = 31 * result + (this.rule == null ? 0 : this.rule.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Regex other = (Regex)obj;
            if (this.flags != other.flags) {
                return false;
            }
            return !(this.rule == null ? other.rule != null : !this.rule.equals(other.rule));
        }

        public String toString() {
            return "Regex [name=" + this.name + ", rule=" + this.rule + ", flags=" + this.flags + ", desc=" + this.desc + "]";
        }
    }
}

