/*
 * Decompiled with CFR 0.152.
 */
package com.xkzhangsan.time.calculator;

import com.xkzhangsan.time.TemporalAdjusterExtension;
import com.xkzhangsan.time.calculator.TimePair;
import com.xkzhangsan.time.converter.DateTimeConverterUtil;
import com.xkzhangsan.time.enums.ConstellationNameEnum;
import com.xkzhangsan.time.enums.MonthNameEnum;
import com.xkzhangsan.time.enums.TwelveTwoEnum;
import com.xkzhangsan.time.enums.WeekNameEnum;
import com.xkzhangsan.time.enums.ZoneIdEnum;
import com.xkzhangsan.time.formatter.DateTimeFormatterUtil;
import com.xkzhangsan.time.utils.ArrayUtil;
import com.xkzhangsan.time.utils.CollectionUtil;
import com.xkzhangsan.time.utils.StringUtil;
import java.time.DateTimeException;
import java.time.DayOfWeek;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.MonthDay;
import java.time.Period;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAdjusters;
import java.time.temporal.TemporalField;
import java.time.temporal.TemporalUnit;
import java.time.temporal.WeekFields;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class DateTimeCalculatorUtil {
    private DateTimeCalculatorUtil() {
    }

    public static int getYear(Date date) {
        return DateTimeConverterUtil.toLocalDateTime(date).getYear();
    }

    public static int getYear(Instant instant) {
        return DateTimeConverterUtil.toLocalDateTime(instant).getYear();
    }

    public static int getYear(LocalDateTime localDateTime) {
        Objects.requireNonNull(localDateTime, "localDateTime");
        return localDateTime.getYear();
    }

    public static int getYear(LocalDate localDate) {
        Objects.requireNonNull(localDate, "localDate");
        return localDate.getYear();
    }

    public static int getMonth(Date date) {
        return DateTimeConverterUtil.toLocalDateTime(date).getMonthValue();
    }

    public static int getMonth(Instant instant) {
        return DateTimeConverterUtil.toLocalDateTime(instant).getMonthValue();
    }

    public static int getMonth(LocalDateTime localDateTime) {
        Objects.requireNonNull(localDateTime, "localDateTime");
        return localDateTime.getMonthValue();
    }

    public static int getMonth(LocalDate localDate) {
        Objects.requireNonNull(localDate, "localDate");
        return localDate.getMonthValue();
    }

    public static String getMonthEnLong(Date date) {
        return MonthNameEnum.getFullNameEnByCode(DateTimeCalculatorUtil.getMonth(date));
    }

    public static String getMonthEnLong(Instant instant) {
        return MonthNameEnum.getFullNameEnByCode(DateTimeCalculatorUtil.getMonth(instant));
    }

    public static String getMonthEnLong(LocalDateTime localDateTime) {
        Objects.requireNonNull(localDateTime, "localDateTime");
        return MonthNameEnum.getFullNameEnByCode(DateTimeCalculatorUtil.getMonth(localDateTime));
    }

    public static String getMonthEnLong(LocalDate localDate) {
        Objects.requireNonNull(localDate, "localDate");
        return MonthNameEnum.getFullNameEnByCode(DateTimeCalculatorUtil.getMonth(localDate));
    }

    public static String getMonthEnShort(Date date) {
        return MonthNameEnum.getShortNameEnByCode(DateTimeCalculatorUtil.getMonth(date));
    }

    public static String getMonthEnShort(Instant instant) {
        return MonthNameEnum.getShortNameEnByCode(DateTimeCalculatorUtil.getMonth(instant));
    }

    public static String getMonthEnShort(LocalDateTime localDateTime) {
        Objects.requireNonNull(localDateTime, "localDateTime");
        return MonthNameEnum.getShortNameEnByCode(DateTimeCalculatorUtil.getMonth(localDateTime));
    }

    public static String getMonthEnShort(LocalDate localDate) {
        Objects.requireNonNull(localDate, "localDate");
        return MonthNameEnum.getShortNameEnByCode(localDate.getMonthValue());
    }

    public static String getMonthEnShortUpper(Date date) {
        return MonthNameEnum.getShortNameEnByCode(DateTimeCalculatorUtil.getMonth(date)).toUpperCase();
    }

    public static String getMonthEnShortUpper(Instant instant) {
        return MonthNameEnum.getShortNameEnByCode(DateTimeCalculatorUtil.getMonth(instant)).toUpperCase();
    }

    public static String getMonthEnShortUpper(LocalDateTime localDateTime) {
        Objects.requireNonNull(localDateTime, "localDateTime");
        return MonthNameEnum.getShortNameEnByCode(DateTimeCalculatorUtil.getMonth(localDateTime)).toUpperCase();
    }

    public static String getMonthEnShortUpper(LocalDate localDate) {
        Objects.requireNonNull(localDate, "localDate");
        return MonthNameEnum.getShortNameEnByCode(localDate.getMonthValue()).toUpperCase();
    }

    public static String getMonthCnLong(Date date) {
        return MonthNameEnum.getFullNameCnByCode(DateTimeCalculatorUtil.getMonth(date));
    }

    public static String getMonthCnLong(Instant instant) {
        return MonthNameEnum.getFullNameCnByCode(DateTimeCalculatorUtil.getMonth(instant));
    }

    public static String getMonthCnLong(LocalDateTime localDateTime) {
        Objects.requireNonNull(localDateTime, "localDateTime");
        return MonthNameEnum.getFullNameCnByCode(DateTimeCalculatorUtil.getMonth(localDateTime));
    }

    public static String getMonthCnLong(LocalDate localDate) {
        Objects.requireNonNull(localDate, "localDate");
        return MonthNameEnum.getFullNameCnByCode(localDate.getMonthValue());
    }

    public static String getMonthCnShort(Date date) {
        return MonthNameEnum.getShortNameCnByCode(DateTimeCalculatorUtil.getMonth(date));
    }

    public static String getMonthCnShort(Instant instant) {
        return MonthNameEnum.getShortNameCnByCode(DateTimeCalculatorUtil.getMonth(instant));
    }

    public static String getMonthCnShort(LocalDateTime localDateTime) {
        Objects.requireNonNull(localDateTime, "localDateTime");
        return MonthNameEnum.getShortNameCnByCode(DateTimeCalculatorUtil.getMonth(localDateTime));
    }

    public static String getMonthCnShort(LocalDate localDate) {
        Objects.requireNonNull(localDate, "localDate");
        return MonthNameEnum.getShortNameCnByCode(localDate.getMonthValue());
    }

    public static int getDayOfMonth(Date date) {
        return DateTimeConverterUtil.toLocalDateTime(date).getDayOfMonth();
    }

    public static int getDayOfMonth(Instant instant) {
        return DateTimeConverterUtil.toLocalDateTime(instant).getDayOfMonth();
    }

    public static int getDayOfMonth(LocalDateTime localDateTime) {
        Objects.requireNonNull(localDateTime, "localDateTime");
        return localDateTime.getDayOfMonth();
    }

    public static int getDayOfMonth(LocalDate localDate) {
        Objects.requireNonNull(localDate, "localDate");
        return localDate.getDayOfMonth();
    }

    public static int getDayOfYear(Date date) {
        return DateTimeConverterUtil.toLocalDateTime(date).getDayOfYear();
    }

    public static int getDayOfYear(Instant instant) {
        return DateTimeConverterUtil.toLocalDateTime(instant).getDayOfYear();
    }

    public static int getDayOfYear(LocalDateTime localDateTime) {
        Objects.requireNonNull(localDateTime, "localDateTime");
        return localDateTime.getDayOfYear();
    }

    public static int getDayOfYear(LocalDate localDate) {
        Objects.requireNonNull(localDate, "localDate");
        return localDate.getDayOfYear();
    }

    public static int getLengthOfYear(int year) {
        return Year.of(year).length();
    }

    public static int getDayOfYear() {
        return DateTimeCalculatorUtil.getDayOfYear(new Date());
    }

    public static int getHour(Date date) {
        return DateTimeConverterUtil.toLocalDateTime(date).getHour();
    }

    public static int getHour(Instant instant) {
        return DateTimeConverterUtil.toLocalDateTime(instant).getHour();
    }

    public static int getHour(LocalDateTime localDateTime) {
        Objects.requireNonNull(localDateTime, "localDateTime");
        return localDateTime.getHour();
    }

    public static int getHour(LocalTime localTime) {
        Objects.requireNonNull(localTime, "localTime");
        return localTime.getHour();
    }

    public static int getMinute(Date date) {
        return DateTimeConverterUtil.toLocalDateTime(date).getMinute();
    }

    public static int getMinute(Instant instant) {
        return DateTimeConverterUtil.toLocalDateTime(instant).getMinute();
    }

    public static int getMinute(LocalDateTime localDateTime) {
        Objects.requireNonNull(localDateTime, "localDateTime");
        return localDateTime.getMinute();
    }

    public static int getMinute(LocalTime localTime) {
        Objects.requireNonNull(localTime, "localTime");
        return localTime.getMinute();
    }

    public static int getSecond(Date date) {
        return DateTimeConverterUtil.toLocalDateTime(date).getSecond();
    }

    public static int getSecond(Instant instant) {
        return DateTimeConverterUtil.toLocalDateTime(instant).getSecond();
    }

    public static int getSecond(LocalDateTime localDateTime) {
        Objects.requireNonNull(localDateTime, "localDateTime");
        return localDateTime.getSecond();
    }

    public static int getSecond(LocalTime localTime) {
        Objects.requireNonNull(localTime, "localTime");
        return localTime.getSecond();
    }

    public static int getMillisecond(Date date) {
        return DateTimeConverterUtil.toLocalDateTime(date).getNano() / 1000000;
    }

    public static int getMillisecond(Instant instant) {
        return DateTimeConverterUtil.toLocalDateTime(instant).getNano() / 1000000;
    }

    public static int getMillisecond(LocalDateTime localDateTime) {
        Objects.requireNonNull(localDateTime, "localDateTime");
        return localDateTime.getNano() / 1000000;
    }

    public static int getMillisecond(LocalTime localTime) {
        Objects.requireNonNull(localTime, "localTime");
        return localTime.getNano() / 1000000;
    }

    public static int getMillisecond(ZonedDateTime zonedDateTime) {
        Objects.requireNonNull(zonedDateTime, "zonedDateTime");
        return zonedDateTime.getNano() / 1000000;
    }

    public static long getEpochMilli() {
        return System.currentTimeMillis();
    }

    public static long getEpochSecond() {
        return System.currentTimeMillis() / 1000L;
    }

    public static String getEpochMilliFormat() {
        return DateTimeFormatterUtil.formatToDateTimeStr(new Date());
    }

    public static String getEpochMilliFormatFull() {
        return DateTimeFormatterUtil.format(new Date(), DateTimeFormatterUtil.YYYY_MM_DD_HH_MM_SS_SSS_FMT);
    }

    public static String getEpochMilliIsoFormat() {
        return DateTimeFormatterUtil.format(new Date(), DateTimeFormatterUtil.YYYY_MM_DD_T_HH_MM_SS_XXX_FMT);
    }

    public static String getEpochMilliIsoFormatFull() {
        return DateTimeFormatterUtil.format(new Date(), DateTimeFormatterUtil.YYYY_MM_DD_T_HH_MM_SS_SSS_XXX_FMT);
    }

    public static String getEpochMilliIsoNotFormatNoColon() {
        return DateTimeFormatterUtil.format(new Date(), DateTimeFormatterUtil.YYYY_MM_DD_T_HH_MM_SS_Z_FMT);
    }

    public static String getEpochMilliIsoFormatFullNoColon() {
        return DateTimeFormatterUtil.format(new Date(), DateTimeFormatterUtil.YYYY_MM_DD_T_HH_MM_SS_SSS_Z_FMT);
    }

    public static Date getDate(int year, int month, int dayOfMonth) {
        return DateTimeConverterUtil.toDate(LocalDate.of(year, month, dayOfMonth));
    }

    public static Date getDate(int year, int month, int dayOfMonth, int hour, int minute, int second) {
        return DateTimeConverterUtil.toDate(LocalDateTime.of(year, month, dayOfMonth, hour, minute, second));
    }

    public static Date getDate(int year, int month, int dayOfMonth, int hour, int minute, int second, int milliOfSecond) {
        return DateTimeConverterUtil.toDate(LocalDateTime.of(year, month, dayOfMonth, hour, minute, second, milliOfSecond * 1000000));
    }

    public static Date getDateStartOfMonth(int year, int month) {
        return DateTimeConverterUtil.toDateStartOfMonth(YearMonth.of(year, month));
    }

    public static Date getDateEndOfMonth(int year, int month) {
        return DateTimeConverterUtil.toDateEndOfMonth(YearMonth.of(year, month));
    }

    public static int getAge(LocalDate birthDay) {
        Objects.requireNonNull(birthDay, "birthDay");
        Period period = DateTimeCalculatorUtil.periodBetween(birthDay, LocalDate.now());
        if (period.getYears() < 0) {
            throw new DateTimeException("birthDay is after now!");
        }
        return period.getYears();
    }

    public static int getAge(Date birthDay) {
        return DateTimeCalculatorUtil.getAge(DateTimeConverterUtil.toLocalDate(birthDay));
    }

    public static int getAge(LocalDateTime birthDay) {
        return DateTimeCalculatorUtil.getAge(DateTimeConverterUtil.toLocalDate(birthDay));
    }

    public static int getQuarter(LocalDateTime localDateTime) {
        Objects.requireNonNull(localDateTime, "localDateTime");
        return (localDateTime.getMonthValue() + 2) / 3;
    }

    public static int getQuarter(LocalDate localDate) {
        Objects.requireNonNull(localDate, "localDate");
        return (localDate.getMonthValue() + 2) / 3;
    }

    public static int getQuarter(Date date) {
        Objects.requireNonNull(date, "date");
        return (DateTimeCalculatorUtil.getMonth(date) + 2) / 3;
    }

    public static int getQuarterOfNow() {
        return (LocalDate.now().getMonthValue() + 2) / 3;
    }

    public static Date plusYears(Date date, long amountToAdd) {
        return DateTimeCalculatorUtil.plus(date, (TemporalUnit)ChronoUnit.YEARS, amountToAdd);
    }

    public static LocalDateTime plusYears(LocalDateTime localDateTime, long amountToAdd) {
        Objects.requireNonNull(localDateTime, "localDateTime");
        return localDateTime.plusYears(amountToAdd);
    }

    public static LocalDate plusYears(LocalDate localDate, long amountToAdd) {
        Objects.requireNonNull(localDate, "localDate");
        return localDate.plusYears(amountToAdd);
    }

    public static Date plusMonths(Date date, long amountToAdd) {
        return DateTimeCalculatorUtil.plus(date, (TemporalUnit)ChronoUnit.MONTHS, amountToAdd);
    }

    public static LocalDateTime plusMonths(LocalDateTime localDateTime, long amountToAdd) {
        Objects.requireNonNull(localDateTime, "localDateTime");
        return localDateTime.plusMonths(amountToAdd);
    }

    public static LocalDate plusMonths(LocalDate localDate, long amountToAdd) {
        Objects.requireNonNull(localDate, "localDate");
        return localDate.plusMonths(amountToAdd);
    }

    public static Date plusWeeks(Date date, long amountToAdd) {
        return DateTimeCalculatorUtil.plus(date, (TemporalUnit)ChronoUnit.WEEKS, amountToAdd);
    }

    public static LocalDateTime plusWeeks(LocalDateTime localDateTime, long amountToAdd) {
        Objects.requireNonNull(localDateTime, "localDateTime");
        return localDateTime.plusWeeks(amountToAdd);
    }

    public static LocalDate plusWeeks(LocalDate localDate, long amountToAdd) {
        Objects.requireNonNull(localDate, "localDate");
        return localDate.plusWeeks(amountToAdd);
    }

    public static Date plusDays(Date date, long amountToAdd) {
        return DateTimeCalculatorUtil.plus(date, (TemporalUnit)ChronoUnit.DAYS, amountToAdd);
    }

    public static LocalDateTime plusDays(LocalDateTime localDateTime, long amountToAdd) {
        Objects.requireNonNull(localDateTime, "localDateTime");
        return localDateTime.plusDays(amountToAdd);
    }

    public static LocalDate plusDays(LocalDate localDate, long amountToAdd) {
        Objects.requireNonNull(localDate, "localDate");
        return localDate.plusDays(amountToAdd);
    }

    public static Date plusHours(Date date, long amountToAdd) {
        return DateTimeCalculatorUtil.plus(date, (TemporalUnit)ChronoUnit.HOURS, amountToAdd);
    }

    public static LocalDateTime plusHours(LocalDateTime localDateTime, long amountToAdd) {
        Objects.requireNonNull(localDateTime, "localDateTime");
        return localDateTime.plusHours(amountToAdd);
    }

    public static LocalTime plusHours(LocalTime localTime, long amountToAdd) {
        Objects.requireNonNull(localTime, "localTime");
        return localTime.plusHours(amountToAdd);
    }

    public static Date plusMinutes(Date date, long amountToAdd) {
        return DateTimeCalculatorUtil.plus(date, (TemporalUnit)ChronoUnit.MINUTES, amountToAdd);
    }

    public static LocalDateTime plusMinutes(LocalDateTime localDateTime, long amountToAdd) {
        Objects.requireNonNull(localDateTime, "localDateTime");
        return localDateTime.plusMinutes(amountToAdd);
    }

    public static LocalTime plusMinutes(LocalTime localTime, long amountToAdd) {
        Objects.requireNonNull(localTime, "localTime");
        return localTime.plusMinutes(amountToAdd);
    }

    public static Date plusSeconds(Date date, long amountToAdd) {
        return DateTimeCalculatorUtil.plus(date, (TemporalUnit)ChronoUnit.SECONDS, amountToAdd);
    }

    public static LocalDateTime plusSeconds(LocalDateTime localDateTime, long amountToAdd) {
        Objects.requireNonNull(localDateTime, "localDateTime");
        return localDateTime.plusSeconds(amountToAdd);
    }

    public static LocalTime plusSeconds(LocalTime localTime, long amountToAdd) {
        Objects.requireNonNull(localTime, "localTime");
        return localTime.plusSeconds(amountToAdd);
    }

    public static Date plusMillis(Date date, long amountToAdd) {
        return DateTimeCalculatorUtil.plus(date, (TemporalUnit)ChronoUnit.MILLIS, amountToAdd);
    }

    public static LocalDateTime plusMillis(LocalDateTime localDateTime, long amountToAdd) {
        return (LocalDateTime)DateTimeCalculatorUtil.plus(localDateTime, (TemporalUnit)ChronoUnit.MILLIS, amountToAdd);
    }

    public static LocalTime plusMillis(LocalTime localTime, long amountToAdd) {
        return (LocalTime)DateTimeCalculatorUtil.plus(localTime, (TemporalUnit)ChronoUnit.MILLIS, amountToAdd);
    }

    public static Date minusYears(Date date, long amountToSubtract) {
        return DateTimeCalculatorUtil.minus(date, (TemporalUnit)ChronoUnit.YEARS, amountToSubtract);
    }

    public static LocalDateTime minusYears(LocalDateTime localDateTime, long amountToSubtract) {
        Objects.requireNonNull(localDateTime, "localDateTime");
        return localDateTime.minusYears(amountToSubtract);
    }

    public static LocalDate minusYears(LocalDate localDate, long amountToSubtract) {
        Objects.requireNonNull(localDate, "localDate");
        return localDate.minusYears(amountToSubtract);
    }

    public static Date minusMonths(Date date, long amountToSubtract) {
        return DateTimeCalculatorUtil.minus(date, (TemporalUnit)ChronoUnit.MONTHS, amountToSubtract);
    }

    public static LocalDateTime minusMonths(LocalDateTime localDateTime, long amountToSubtract) {
        Objects.requireNonNull(localDateTime, "localDateTime");
        return localDateTime.minusMonths(amountToSubtract);
    }

    public static LocalDate minusMonths(LocalDate localDate, long amountToSubtract) {
        Objects.requireNonNull(localDate, "localDate");
        return localDate.minusMonths(amountToSubtract);
    }

    public static Date minusWeeks(Date date, long amountToSubtract) {
        return DateTimeCalculatorUtil.minus(date, (TemporalUnit)ChronoUnit.WEEKS, amountToSubtract);
    }

    public static LocalDateTime minusWeeks(LocalDateTime localDateTime, long amountToSubtract) {
        Objects.requireNonNull(localDateTime, "localDateTime");
        return localDateTime.minusWeeks(amountToSubtract);
    }

    public static LocalDate minusWeeks(LocalDate localDate, long amountToSubtract) {
        Objects.requireNonNull(localDate, "localDate");
        return localDate.minusWeeks(amountToSubtract);
    }

    public static Date minusDays(Date date, long amountToSubtract) {
        return DateTimeCalculatorUtil.minus(date, (TemporalUnit)ChronoUnit.DAYS, amountToSubtract);
    }

    public static LocalDateTime minusDays(LocalDateTime localDateTime, long amountToSubtract) {
        Objects.requireNonNull(localDateTime, "localDateTime");
        return localDateTime.minusDays(amountToSubtract);
    }

    public static LocalDate minusDays(LocalDate localDate, long amountToSubtract) {
        Objects.requireNonNull(localDate, "localDate");
        return localDate.minusDays(amountToSubtract);
    }

    public static Date minusHours(Date date, long amountToSubtract) {
        return DateTimeCalculatorUtil.minus(date, (TemporalUnit)ChronoUnit.HOURS, amountToSubtract);
    }

    public static LocalDateTime minusHours(LocalDateTime localDateTime, long amountToSubtract) {
        Objects.requireNonNull(localDateTime, "localDateTime");
        return localDateTime.minusHours(amountToSubtract);
    }

    public static LocalTime minusHours(LocalTime localTime, long amountToSubtract) {
        Objects.requireNonNull(localTime, "localTime");
        return localTime.minusHours(amountToSubtract);
    }

    public static Date minusMinutes(Date date, long amountToSubtract) {
        return DateTimeCalculatorUtil.minus(date, (TemporalUnit)ChronoUnit.MINUTES, amountToSubtract);
    }

    public static LocalDateTime minusMinutes(LocalDateTime localDateTime, long amountToSubtract) {
        Objects.requireNonNull(localDateTime, "localDateTime");
        return localDateTime.minusMinutes(amountToSubtract);
    }

    public static LocalTime minusMinutes(LocalTime localTime, long amountToSubtract) {
        Objects.requireNonNull(localTime, "localTime");
        return localTime.minusMinutes(amountToSubtract);
    }

    public static Date minusSeconds(Date date, long amountToSubtract) {
        return DateTimeCalculatorUtil.minus(date, (TemporalUnit)ChronoUnit.SECONDS, amountToSubtract);
    }

    public static LocalDateTime minusSeconds(LocalDateTime localDateTime, long amountToSubtract) {
        Objects.requireNonNull(localDateTime, "localDateTime");
        return localDateTime.minusSeconds(amountToSubtract);
    }

    public static LocalTime minusSeconds(LocalTime localTime, long amountToSubtract) {
        Objects.requireNonNull(localTime, "localTime");
        return localTime.minusSeconds(amountToSubtract);
    }

    public static Date minusMillis(Date date, long amountToSubtract) {
        return DateTimeCalculatorUtil.minus(date, (TemporalUnit)ChronoUnit.MILLIS, amountToSubtract);
    }

    public static LocalDateTime minusMillis(LocalDateTime localDateTime, long amountToSubtract) {
        return (LocalDateTime)DateTimeCalculatorUtil.minus(localDateTime, (TemporalUnit)ChronoUnit.MILLIS, amountToSubtract);
    }

    public static LocalTime minusMillis(LocalTime localTime, long amountToSubtract) {
        return (LocalTime)DateTimeCalculatorUtil.minus(localTime, (TemporalUnit)ChronoUnit.MILLIS, amountToSubtract);
    }

    public static Date withYear(Date date, long newValue) {
        return DateTimeCalculatorUtil.with(date, (TemporalField)ChronoField.YEAR, newValue);
    }

    public static LocalDateTime withYear(LocalDateTime localDateTime, long newValue) {
        Objects.requireNonNull(localDateTime, "localDateTime");
        return localDateTime.withYear((int)newValue);
    }

    public static LocalDate withYear(LocalDate localDate, long newValue) {
        Objects.requireNonNull(localDate, "localDate");
        return localDate.withYear((int)newValue);
    }

    public static Date withMonth(Date date, long newValue) {
        return DateTimeCalculatorUtil.with(date, (TemporalField)ChronoField.MONTH_OF_YEAR, newValue);
    }

    public static LocalDateTime withMonth(LocalDateTime localDateTime, long newValue) {
        Objects.requireNonNull(localDateTime, "localDateTime");
        return localDateTime.withMonth((int)newValue);
    }

    public static LocalDate withMonth(LocalDate localDate, long newValue) {
        Objects.requireNonNull(localDate, "localDate");
        return localDate.withMonth((int)newValue);
    }

    public static Date withDayOfMonth(Date date, long newValue) {
        return DateTimeCalculatorUtil.with(date, (TemporalField)ChronoField.DAY_OF_MONTH, newValue);
    }

    public static LocalDateTime withDayOfMonth(LocalDateTime localDateTime, long newValue) {
        Objects.requireNonNull(localDateTime, "localDateTime");
        return localDateTime.withDayOfMonth((int)newValue);
    }

    public static LocalDate withDayOfMonth(LocalDate localDate, long newValue) {
        Objects.requireNonNull(localDate, "localDate");
        return localDate.withDayOfMonth((int)newValue);
    }

    public static Date withDayOfYear(Date date, long newValue) {
        return DateTimeCalculatorUtil.with(date, (TemporalField)ChronoField.DAY_OF_YEAR, newValue);
    }

    public static LocalDateTime withDayOfYear(LocalDateTime localDateTime, long newValue) {
        Objects.requireNonNull(localDateTime, "localDateTime");
        return localDateTime.withDayOfYear((int)newValue);
    }

    public static LocalDate withDayOfYear(LocalDate localDate, long newValue) {
        Objects.requireNonNull(localDate, "localDate");
        return localDate.withDayOfYear((int)newValue);
    }

    public static Date withHour(Date date, long newValue) {
        return DateTimeCalculatorUtil.with(date, (TemporalField)ChronoField.HOUR_OF_DAY, newValue);
    }

    public static LocalDateTime withHour(LocalDateTime localDateTime, long newValue) {
        Objects.requireNonNull(localDateTime, "localDateTime");
        return localDateTime.withHour((int)newValue);
    }

    public static LocalTime withHour(LocalTime localTime, long newValue) {
        Objects.requireNonNull(localTime, "localTime");
        return localTime.withHour((int)newValue);
    }

    public static Date withMinute(Date date, long newValue) {
        return DateTimeCalculatorUtil.with(date, (TemporalField)ChronoField.MINUTE_OF_HOUR, newValue);
    }

    public static LocalDateTime withMinute(LocalDateTime localDateTime, long newValue) {
        Objects.requireNonNull(localDateTime, "localDateTime");
        return localDateTime.withMinute((int)newValue);
    }

    public static LocalTime withMinute(LocalTime localTime, long newValue) {
        Objects.requireNonNull(localTime, "localTime");
        return localTime.withMinute((int)newValue);
    }

    public static Date withSecond(Date date, long newValue) {
        return DateTimeCalculatorUtil.with(date, (TemporalField)ChronoField.SECOND_OF_MINUTE, newValue);
    }

    public static LocalDateTime withSecond(LocalDateTime localDateTime, long newValue) {
        Objects.requireNonNull(localDateTime, "localDateTime");
        return localDateTime.withSecond((int)newValue);
    }

    public static LocalTime withSecond(LocalTime localTime, long newValue) {
        Objects.requireNonNull(localTime, "localTime");
        return localTime.withSecond((int)newValue);
    }

    public static Date withMilli(Date date, long newValue) {
        return DateTimeCalculatorUtil.with(date, (TemporalField)ChronoField.MILLI_OF_SECOND, newValue);
    }

    public static LocalDateTime withMilli(LocalDateTime localDateTime, long newValue) {
        return (LocalDateTime)DateTimeCalculatorUtil.with(localDateTime, (TemporalField)ChronoField.MILLI_OF_SECOND, newValue);
    }

    public static LocalTime withMilli(LocalTime localTime, long newValue) {
        return (LocalTime)DateTimeCalculatorUtil.with(localTime, (TemporalField)ChronoField.MILLI_OF_SECOND, newValue);
    }

    public static Date withDayOfWeek(Date date, long newValue) {
        return DateTimeCalculatorUtil.with(date, (TemporalField)ChronoField.DAY_OF_WEEK, newValue);
    }

    public static LocalDateTime withDayOfWeek(LocalDateTime localDateTime, long newValue) {
        return (LocalDateTime)DateTimeCalculatorUtil.with(localDateTime, (TemporalField)ChronoField.DAY_OF_WEEK, newValue);
    }

    public static LocalDate withDayOfWeek(LocalDate localDate, long newValue) {
        return (LocalDate)DateTimeCalculatorUtil.with(localDate, (TemporalField)ChronoField.DAY_OF_WEEK, newValue);
    }

    @Deprecated
    public static long betweenYears(LocalDateTime startInclusive, LocalDateTime endExclusive) {
        Objects.requireNonNull(startInclusive, "startInclusive");
        Objects.requireNonNull(endExclusive, "endExclusive");
        return Period.between(DateTimeConverterUtil.toLocalDate(startInclusive), DateTimeConverterUtil.toLocalDate(endExclusive)).getYears();
    }

    @Deprecated
    public static long betweenYears(Date startInclusive, Date endExclusive) {
        Objects.requireNonNull(startInclusive, "startInclusive");
        Objects.requireNonNull(endExclusive, "endExclusive");
        return Period.between(DateTimeConverterUtil.toLocalDate(startInclusive), DateTimeConverterUtil.toLocalDate(endExclusive)).getYears();
    }

    @Deprecated
    public static long betweenYears(LocalDate startInclusive, LocalDate endExclusive) {
        return Period.between(startInclusive, endExclusive).getYears();
    }

    public static long betweenPeriodYears(LocalDateTime startInclusive, LocalDateTime endExclusive) {
        Objects.requireNonNull(startInclusive, "startInclusive");
        Objects.requireNonNull(endExclusive, "endExclusive");
        return Period.between(DateTimeConverterUtil.toLocalDate(startInclusive), DateTimeConverterUtil.toLocalDate(endExclusive)).getYears();
    }

    public static long betweenPeriodYears(Date startInclusive, Date endExclusive) {
        Objects.requireNonNull(startInclusive, "startInclusive");
        Objects.requireNonNull(endExclusive, "endExclusive");
        return Period.between(DateTimeConverterUtil.toLocalDate(startInclusive), DateTimeConverterUtil.toLocalDate(endExclusive)).getYears();
    }

    public static long betweenPeriodYears(LocalDate startInclusive, LocalDate endExclusive) {
        return Period.between(startInclusive, endExclusive).getYears();
    }

    @Deprecated
    public static long betweenMonths(LocalDateTime startInclusive, LocalDateTime endExclusive) {
        Objects.requireNonNull(startInclusive, "startInclusive");
        Objects.requireNonNull(endExclusive, "endExclusive");
        return Period.between(DateTimeConverterUtil.toLocalDate(startInclusive), DateTimeConverterUtil.toLocalDate(endExclusive)).getMonths();
    }

    @Deprecated
    public static long betweenMonths(Date startInclusive, Date endExclusive) {
        Objects.requireNonNull(startInclusive, "startInclusive");
        Objects.requireNonNull(endExclusive, "endExclusive");
        return Period.between(DateTimeConverterUtil.toLocalDate(startInclusive), DateTimeConverterUtil.toLocalDate(endExclusive)).getMonths();
    }

    @Deprecated
    public static long betweenMonths(LocalDate startInclusive, LocalDate endExclusive) {
        return Period.between(startInclusive, endExclusive).getMonths();
    }

    public static long betweenPeriodMonths(LocalDateTime startInclusive, LocalDateTime endExclusive) {
        Objects.requireNonNull(startInclusive, "startInclusive");
        Objects.requireNonNull(endExclusive, "endExclusive");
        return Period.between(DateTimeConverterUtil.toLocalDate(startInclusive), DateTimeConverterUtil.toLocalDate(endExclusive)).getMonths();
    }

    public static long betweenPeriodMonths(Date startInclusive, Date endExclusive) {
        Objects.requireNonNull(startInclusive, "startInclusive");
        Objects.requireNonNull(endExclusive, "endExclusive");
        return Period.between(DateTimeConverterUtil.toLocalDate(startInclusive), DateTimeConverterUtil.toLocalDate(endExclusive)).getMonths();
    }

    public static long betweenPeriodMonths(LocalDate startInclusive, LocalDate endExclusive) {
        return Period.between(startInclusive, endExclusive).getMonths();
    }

    @Deprecated
    public static long betweenDays(LocalDateTime startInclusive, LocalDateTime endExclusive) {
        Objects.requireNonNull(startInclusive, "startInclusive");
        Objects.requireNonNull(endExclusive, "endExclusive");
        return Period.between(DateTimeConverterUtil.toLocalDate(startInclusive), DateTimeConverterUtil.toLocalDate(endExclusive)).getDays();
    }

    @Deprecated
    public static long betweenDays(Date startInclusive, Date endExclusive) {
        Objects.requireNonNull(startInclusive, "startInclusive");
        Objects.requireNonNull(endExclusive, "endExclusive");
        return Period.between(DateTimeConverterUtil.toLocalDate(startInclusive), DateTimeConverterUtil.toLocalDate(endExclusive)).getDays();
    }

    @Deprecated
    public static long betweenDays(LocalDate startInclusive, LocalDate endExclusive) {
        return Period.between(startInclusive, endExclusive).getDays();
    }

    public static long betweenPeriodDays(LocalDateTime startInclusive, LocalDateTime endExclusive) {
        Objects.requireNonNull(startInclusive, "startInclusive");
        Objects.requireNonNull(endExclusive, "endExclusive");
        return Period.between(DateTimeConverterUtil.toLocalDate(startInclusive), DateTimeConverterUtil.toLocalDate(endExclusive)).getDays();
    }

    public static long betweenPeriodDays(Date startInclusive, Date endExclusive) {
        Objects.requireNonNull(startInclusive, "startInclusive");
        Objects.requireNonNull(endExclusive, "endExclusive");
        return Period.between(DateTimeConverterUtil.toLocalDate(startInclusive), DateTimeConverterUtil.toLocalDate(endExclusive)).getDays();
    }

    public static long betweenPeriodDays(LocalDate startInclusive, LocalDate endExclusive) {
        return Period.between(startInclusive, endExclusive).getDays();
    }

    public static long betweenTotalDays(LocalDateTime startInclusive, LocalDateTime endExclusive) {
        return Duration.between(startInclusive, endExclusive).toDays();
    }

    public static long betweenTotalDays(LocalDate startInclusive, LocalDate endExclusive) {
        return Duration.between(DateTimeConverterUtil.toLocalDateTime(startInclusive), DateTimeConverterUtil.toLocalDateTime(endExclusive)).toDays();
    }

    public static long betweenTotalDays(Date startInclusive, Date endExclusive) {
        Objects.requireNonNull(startInclusive, "startInclusive");
        Objects.requireNonNull(endExclusive, "endExclusive");
        return DateTimeCalculatorUtil.durationBetween(DateTimeConverterUtil.toLocalDateTime(startInclusive), DateTimeConverterUtil.toLocalDateTime(endExclusive)).toDays();
    }

    public static long betweenTotalHours(LocalDateTime startInclusive, LocalDateTime endExclusive) {
        return Duration.between(startInclusive, endExclusive).toHours();
    }

    public static long betweenTotalHours(LocalDate startInclusive, LocalDate endExclusive) {
        return Duration.between(DateTimeConverterUtil.toLocalDateTime(startInclusive), DateTimeConverterUtil.toLocalDateTime(endExclusive)).toHours();
    }

    public static long betweenTotalHours(LocalTime startInclusive, LocalTime endExclusive) {
        return Duration.between(startInclusive, endExclusive).toHours();
    }

    public static long betweenTotalHours(Date startInclusive, Date endExclusive) {
        Objects.requireNonNull(startInclusive, "startInclusive");
        Objects.requireNonNull(endExclusive, "endExclusive");
        return DateTimeCalculatorUtil.durationBetween(DateTimeConverterUtil.toLocalDateTime(startInclusive), DateTimeConverterUtil.toLocalDateTime(endExclusive)).toHours();
    }

    public static long betweenTotalMinutes(LocalDateTime startInclusive, LocalDateTime endExclusive) {
        return Duration.between(startInclusive, endExclusive).toMinutes();
    }

    public static long betweenTotalMinutes(LocalDate startInclusive, LocalDate endExclusive) {
        return Duration.between(DateTimeConverterUtil.toLocalDateTime(startInclusive), DateTimeConverterUtil.toLocalDateTime(endExclusive)).toMinutes();
    }

    public static long betweenTotalMinutes(LocalTime startInclusive, LocalTime endExclusive) {
        return Duration.between(startInclusive, endExclusive).toMinutes();
    }

    public static long betweenTotalMinutes(Date startInclusive, Date endExclusive) {
        Objects.requireNonNull(startInclusive, "startInclusive");
        Objects.requireNonNull(endExclusive, "endExclusive");
        return DateTimeCalculatorUtil.durationBetween(DateTimeConverterUtil.toLocalDateTime(startInclusive), DateTimeConverterUtil.toLocalDateTime(endExclusive)).toMinutes();
    }

    public static long betweenTotalSeconds(LocalDateTime startInclusive, LocalDateTime endExclusive) {
        return Duration.between(startInclusive, endExclusive).getSeconds();
    }

    public static long betweenTotalSeconds(LocalDate startInclusive, LocalDate endExclusive) {
        return Duration.between(DateTimeConverterUtil.toLocalDateTime(startInclusive), DateTimeConverterUtil.toLocalDateTime(endExclusive)).getSeconds();
    }

    public static long betweenTotalSeconds(LocalTime startInclusive, LocalTime endExclusive) {
        return Duration.between(startInclusive, endExclusive).getSeconds();
    }

    public static long betweenTotalSeconds(Date startInclusive, Date endExclusive) {
        Objects.requireNonNull(startInclusive, "startInclusive");
        Objects.requireNonNull(endExclusive, "endExclusive");
        return DateTimeCalculatorUtil.durationBetween(DateTimeConverterUtil.toLocalDateTime(startInclusive), DateTimeConverterUtil.toLocalDateTime(endExclusive)).getSeconds();
    }

    public static long betweenTotalMillis(LocalDateTime startInclusive, LocalDateTime endExclusive) {
        return Duration.between(startInclusive, endExclusive).toMillis();
    }

    public static long betweenTotalMillis(LocalDate startInclusive, LocalDate endExclusive) {
        return Duration.between(DateTimeConverterUtil.toLocalDateTime(startInclusive), DateTimeConverterUtil.toLocalDateTime(endExclusive)).toMillis();
    }

    public static long betweenTotalMillis(LocalTime startInclusive, LocalTime endExclusive) {
        return Duration.between(startInclusive, endExclusive).toMillis();
    }

    public static long betweenTotalMillis(Date startInclusive, Date endExclusive) {
        Objects.requireNonNull(startInclusive, "startInclusive");
        Objects.requireNonNull(endExclusive, "endExclusive");
        return DateTimeCalculatorUtil.durationBetween(DateTimeConverterUtil.toLocalDateTime(startInclusive), DateTimeConverterUtil.toLocalDateTime(endExclusive)).toMillis();
    }

    public static long betweenTotalNanos(LocalDateTime startInclusive, LocalDateTime endExclusive) {
        return Duration.between(startInclusive, endExclusive).toNanos();
    }

    public static long betweenTotalNanos(LocalDate startInclusive, LocalDate endExclusive) {
        return Duration.between(DateTimeConverterUtil.toLocalDateTime(startInclusive), DateTimeConverterUtil.toLocalDateTime(endExclusive)).toNanos();
    }

    public static long betweenTotalNanos(LocalTime startInclusive, LocalTime endExclusive) {
        return Duration.between(startInclusive, endExclusive).toNanos();
    }

    public static long betweenTotalNanos(Date startInclusive, Date endExclusive) {
        Objects.requireNonNull(startInclusive, "startInclusive");
        Objects.requireNonNull(endExclusive, "endExclusive");
        return DateTimeCalculatorUtil.durationBetween(DateTimeConverterUtil.toLocalDateTime(startInclusive), DateTimeConverterUtil.toLocalDateTime(endExclusive)).toNanos();
    }

    public static int getDayOfWeek(Date date) {
        return DateTimeConverterUtil.toLocalDateTime(date).getDayOfWeek().getValue();
    }

    public static int getDayOfWeek(LocalDateTime localDateTime) {
        Objects.requireNonNull(localDateTime, "localDateTime");
        return localDateTime.getDayOfWeek().getValue();
    }

    public static int getDayOfWeek(LocalDate localDate) {
        Objects.requireNonNull(localDate, "localDate");
        return localDate.getDayOfWeek().getValue();
    }

    public static int getDayOfWeek(Instant instant) {
        return DateTimeConverterUtil.toLocalDateTime(instant).getDayOfWeek().getValue();
    }

    public static String getDayOfWeekEnLong(Date date) {
        return WeekNameEnum.getFullNameEnByCode(DateTimeCalculatorUtil.getDayOfWeek(date));
    }

    public static String getDayOfWeekEnLong(LocalDateTime localDateTime) {
        Objects.requireNonNull(localDateTime, "localDateTime");
        return WeekNameEnum.getFullNameEnByCode(DateTimeCalculatorUtil.getDayOfWeek(localDateTime));
    }

    public static String getDayOfWeekEnLong(LocalDate localDate) {
        Objects.requireNonNull(localDate, "localDate");
        return WeekNameEnum.getFullNameEnByCode(DateTimeCalculatorUtil.getDayOfWeek(localDate));
    }

    public static String getDayOfWeekEnLong(Instant instant) {
        return WeekNameEnum.getFullNameEnByCode(DateTimeCalculatorUtil.getDayOfWeek(instant));
    }

    public static String getDayOfWeekEnShort(Date date) {
        return WeekNameEnum.getShortNameEnByCode(DateTimeCalculatorUtil.getDayOfWeek(date));
    }

    public static String getDayOfWeekEnShort(LocalDateTime localDateTime) {
        Objects.requireNonNull(localDateTime, "localDateTime");
        return WeekNameEnum.getShortNameEnByCode(DateTimeCalculatorUtil.getDayOfWeek(localDateTime));
    }

    public static String getDayOfWeekEnShort(LocalDate localDate) {
        Objects.requireNonNull(localDate, "localDate");
        return WeekNameEnum.getShortNameEnByCode(DateTimeCalculatorUtil.getDayOfWeek(localDate));
    }

    public static String getDayOfWeekEnShort(Instant instant) {
        return WeekNameEnum.getShortNameEnByCode(DateTimeCalculatorUtil.getDayOfWeek(instant));
    }

    public static String getDayOfWeekEnShortUpper(Date date) {
        return WeekNameEnum.getShortNameEnByCode(DateTimeCalculatorUtil.getDayOfWeek(date)).toUpperCase();
    }

    public static String getDayOfWeekEnShortUpper(LocalDateTime localDateTime) {
        Objects.requireNonNull(localDateTime, "localDateTime");
        return WeekNameEnum.getShortNameEnByCode(DateTimeCalculatorUtil.getDayOfWeek(localDateTime)).toUpperCase();
    }

    public static String getDayOfWeekEnShortUpper(LocalDate localDate) {
        Objects.requireNonNull(localDate, "localDate");
        return WeekNameEnum.getShortNameEnByCode(DateTimeCalculatorUtil.getDayOfWeek(localDate)).toUpperCase();
    }

    public static String getDayOfWeekEnShortUpper(Instant instant) {
        return WeekNameEnum.getShortNameEnByCode(DateTimeCalculatorUtil.getDayOfWeek(instant)).toUpperCase();
    }

    public static String getDayOfWeekCn(Date date) {
        return WeekNameEnum.getNameCnByCode(DateTimeCalculatorUtil.getDayOfWeek(date));
    }

    public static String getDayOfWeekCn(LocalDateTime localDateTime) {
        Objects.requireNonNull(localDateTime, "localDateTime");
        return WeekNameEnum.getNameCnByCode(DateTimeCalculatorUtil.getDayOfWeek(localDateTime));
    }

    public static String getDayOfWeekCn(LocalDate localDate) {
        Objects.requireNonNull(localDate, "localDate");
        return WeekNameEnum.getNameCnByCode(DateTimeCalculatorUtil.getDayOfWeek(localDate));
    }

    public static String getDayOfWeekCn(Instant instant) {
        return WeekNameEnum.getNameCnByCode(DateTimeCalculatorUtil.getDayOfWeek(instant));
    }

    public static String getDayOfWeekCnShort(Date date) {
        return WeekNameEnum.getNameCnByCode(DateTimeCalculatorUtil.getDayOfWeek(date)).substring(2);
    }

    public static String getDayOfWeekCnShort(LocalDateTime localDateTime) {
        Objects.requireNonNull(localDateTime, "localDateTime");
        return WeekNameEnum.getNameCnByCode(DateTimeCalculatorUtil.getDayOfWeek(localDateTime)).substring(2);
    }

    public static String getDayOfWeekCnShort(LocalDate localDate) {
        Objects.requireNonNull(localDate, "localDate");
        return WeekNameEnum.getNameCnByCode(DateTimeCalculatorUtil.getDayOfWeek(localDate)).substring(2);
    }

    public static String getDayOfWeekCnShort(Instant instant) {
        return WeekNameEnum.getNameCnByCode(DateTimeCalculatorUtil.getDayOfWeek(instant)).substring(2);
    }

    public static LocalDate firstDayOfMonth(LocalDate localDate) {
        Objects.requireNonNull(localDate, "localDate");
        return localDate.with(TemporalAdjusters.firstDayOfMonth());
    }

    public static LocalDateTime firstDayOfMonth(LocalDateTime localDateTime) {
        Objects.requireNonNull(localDateTime, "localDateTime");
        return localDateTime.with(TemporalAdjusters.firstDayOfMonth());
    }

    public static Date firstDayOfMonth(Date date) {
        return DateTimeConverterUtil.toDate(DateTimeConverterUtil.toLocalDateTime(date).with(TemporalAdjusters.firstDayOfMonth()));
    }

    public static LocalDate lastDayOfMonth(LocalDate localDate) {
        Objects.requireNonNull(localDate, "localDate");
        return localDate.with(TemporalAdjusters.lastDayOfMonth());
    }

    public static LocalDateTime lastDayOfMonth(LocalDateTime localDateTime) {
        Objects.requireNonNull(localDateTime, "localDateTime");
        return localDateTime.with(TemporalAdjusters.lastDayOfMonth());
    }

    public static Date lastDayOfMonth(Date date) {
        return DateTimeConverterUtil.toDate(DateTimeConverterUtil.toLocalDateTime(date).with(TemporalAdjusters.lastDayOfMonth()));
    }

    public static boolean isLeapYear(LocalDate localDate) {
        Objects.requireNonNull(localDate, "localDate");
        return localDate.isLeapYear();
    }

    public static boolean isLeapYear(LocalDateTime localDateTime) {
        Objects.requireNonNull(localDateTime, "localDateTime");
        return localDateTime.toLocalDate().isLeapYear();
    }

    public static boolean isLeapYear(Date date) {
        return DateTimeConverterUtil.toLocalDateTime(date).toLocalDate().isLeapYear();
    }

    public static boolean isLeapYear(int year) {
        return year % 4 == 0 && (year % 100 != 0 || year % 400 == 0);
    }

    public static int nextLeapYear(int year) {
        for (int i = 0; i < 8; ++i) {
            if (!DateTimeCalculatorUtil.isLeapYear(++year)) continue;
            return year;
        }
        return -1;
    }

    public static LocalDateTime nextLeapYear(LocalDateTime localDateTime) {
        return localDateTime.withYear(DateTimeCalculatorUtil.nextLeapYear(localDateTime.getYear()));
    }

    public static LocalDate nextLeapYear(LocalDate localDate) {
        return localDate.withYear(DateTimeCalculatorUtil.nextLeapYear(localDate.getYear()));
    }

    public static Date nextLeapYear(Date date) {
        return DateTimeConverterUtil.toDate(DateTimeCalculatorUtil.nextLeapYear(DateTimeConverterUtil.toLocalDateTime(date)));
    }

    public static boolean isWorkDay(Date date) {
        int dayOfWeek = DateTimeCalculatorUtil.getDayOfWeek(date);
        return dayOfWeek != 6 && dayOfWeek != 7;
    }

    public static boolean isWorkDay(LocalDateTime localDateTime) {
        int dayOfWeek = DateTimeCalculatorUtil.getDayOfWeek(localDateTime);
        return dayOfWeek != 6 && dayOfWeek != 7;
    }

    public static boolean isWorkDay(LocalDate localDate) {
        int dayOfWeek = DateTimeCalculatorUtil.getDayOfWeek(localDate);
        return dayOfWeek != 6 && dayOfWeek != 7;
    }

    public static boolean isWeekend(Date date) {
        return !DateTimeCalculatorUtil.isWorkDay(date);
    }

    public static boolean isWeekend(LocalDateTime localDateTime) {
        return !DateTimeCalculatorUtil.isWorkDay(localDateTime);
    }

    public static boolean isWeekend(LocalDate localDate) {
        return !DateTimeCalculatorUtil.isWorkDay(localDate);
    }

    public static boolean isChineseWorkDay(Date date, String holidayData) {
        return DateTimeCalculatorUtil.isChineseWorkDay(DateTimeConverterUtil.toLocalDateTime(date), holidayData);
    }

    public static boolean isChineseWorkDay(LocalDateTime localDateTime, String holidayData) {
        Objects.requireNonNull(holidayData, "holidayData");
        Map<String, Integer> dateTypeMap = StringUtil.convertHolidayDataToMapUseCache(holidayData);
        Integer dateType = dateTypeMap.get(DateTimeFormatterUtil.formatToDateStr(localDateTime));
        if (dateType != null) {
            return dateType == 1;
        }
        return DateTimeCalculatorUtil.isWorkDay(localDateTime);
    }

    public static boolean hasChineseWorkDay(long start, long end, String holidayData) {
        Objects.requireNonNull(holidayData, "holidayData");
        LocalDateTime startDate = DateTimeConverterUtil.toLocalDateTime(start);
        LocalDateTime endDate = DateTimeConverterUtil.toLocalDateTime(end);
        List<LocalDateTime> dateList = DateTimeCalculatorUtil.getLocalDateTimeList(startDate, endDate, ChronoUnit.DAYS);
        Map<String, Integer> dateTypeMap = StringUtil.convertHolidayDataToMapUseCache(holidayData);
        for (LocalDateTime date : dateList) {
            String dateStr = DateTimeFormatterUtil.formatToDateStr(date);
            Integer dateType = dateTypeMap.get(dateStr);
            if (!(dateType != null ? dateType == 1 : DateTimeCalculatorUtil.isWorkDay(date))) continue;
            return true;
        }
        return false;
    }

    public static boolean hasChineseWorkDay(String start, String end, String holidayData) {
        Objects.requireNonNull(start, "start");
        Objects.requireNonNull(end, "end");
        Objects.requireNonNull(holidayData, "holidayData");
        return DateTimeCalculatorUtil.hasChineseWorkDay(Long.parseLong(start), Long.parseLong(end), holidayData);
    }

    public static boolean hasChineseWorkDay(Date start, Date end, String holidayData) {
        Objects.requireNonNull(start, "start");
        Objects.requireNonNull(end, "end");
        Objects.requireNonNull(holidayData, "holidayData");
        return DateTimeCalculatorUtil.hasChineseWorkDay(DateTimeConverterUtil.toEpochMilli(start), DateTimeConverterUtil.toEpochMilli(end), holidayData);
    }

    public static boolean hasChineseWorkDay(LocalDate start, LocalDate end, String holidayData) {
        Objects.requireNonNull(start, "start");
        Objects.requireNonNull(end, "end");
        Objects.requireNonNull(holidayData, "holidayData");
        return DateTimeCalculatorUtil.hasChineseWorkDay(DateTimeConverterUtil.toEpochMilli(start), DateTimeConverterUtil.toEpochMilli(end), holidayData);
    }

    public static List<String> chineseWorkDay(long start, long end, String holidayData) {
        Objects.requireNonNull(holidayData, "holidayData");
        ArrayList<String> result = new ArrayList<String>();
        LocalDate startDate = DateTimeConverterUtil.toLocalDate(start);
        LocalDate endDate = DateTimeConverterUtil.toLocalDate(end);
        List<LocalDate> dateList = DateTimeCalculatorUtil.getLocalDateList(startDate, endDate, ChronoUnit.DAYS);
        Map<String, Integer> dateTypeMap = StringUtil.convertHolidayDataToMapUseCache(holidayData);
        dateList.stream().forEach(date -> {
            String dateStr = date.toString();
            Integer dateType = (Integer)dateTypeMap.get(dateStr);
            if (dateType != null) {
                if (dateType == 1) {
                    result.add(dateStr);
                }
            } else if (DateTimeCalculatorUtil.isWorkDay(date)) {
                result.add(dateStr);
            }
        });
        return result;
    }

    public static List<String> chineseWorkDay(LocalDate start, LocalDate end, String holidayData) {
        return DateTimeCalculatorUtil.chineseWorkDay(DateTimeConverterUtil.toEpochMilli(start), DateTimeConverterUtil.toEpochMilli(end), holidayData);
    }

    public static int chineseWorkDayCount(long start, long end, String holidayData) {
        return DateTimeCalculatorUtil.chineseWorkDay(start, end, holidayData).size();
    }

    public static boolean isChineseWorkDay(LocalDate localDate, String holidayData) {
        return DateTimeCalculatorUtil.isChineseWorkDay(DateTimeConverterUtil.toLocalDateTime(localDate), holidayData);
    }

    public static Date nextChineseWorkDay(Date date, String holidayData) {
        while (date != null) {
            if (!DateTimeCalculatorUtil.isChineseWorkDay(DateTimeConverterUtil.toLocalDate(date = DateTimeCalculatorUtil.plusDays(date, 1L)), holidayData)) continue;
            return date;
        }
        return null;
    }

    public static LocalDateTime nextChineseWorkDay(LocalDateTime localDateTime, String holidayData) {
        while (localDateTime != null) {
            if (!DateTimeCalculatorUtil.isChineseWorkDay(localDateTime = DateTimeCalculatorUtil.plusDays(localDateTime, 1L), holidayData)) continue;
            return localDateTime;
        }
        return null;
    }

    public static LocalDate nextChineseWorkDay(LocalDate localDate, String holidayData) {
        while (localDate != null) {
            if (!DateTimeCalculatorUtil.isChineseWorkDay(localDate = DateTimeCalculatorUtil.plusDays(localDate, 1L), holidayData)) continue;
            return localDate;
        }
        return null;
    }

    public static int lengthOfMonth(LocalDate localDate) {
        Objects.requireNonNull(localDate, "localDate");
        return localDate.lengthOfMonth();
    }

    public static int lengthOfMonth(LocalDateTime localDateTime) {
        Objects.requireNonNull(localDateTime, "localDateTime");
        return localDateTime.toLocalDate().lengthOfMonth();
    }

    public static int lengthOfMonth(Date date) {
        return DateTimeConverterUtil.toLocalDateTime(date).toLocalDate().lengthOfMonth();
    }

    public static int lengthOfYear(LocalDate localDate) {
        Objects.requireNonNull(localDate, "localDate");
        return localDate.lengthOfYear();
    }

    public static int lengthOfYear(LocalDateTime localDateTime) {
        Objects.requireNonNull(localDateTime, "localDateTime");
        return localDateTime.toLocalDate().lengthOfYear();
    }

    public static int lengthOfYear(Date date) {
        return DateTimeConverterUtil.toLocalDateTime(date).toLocalDate().lengthOfYear();
    }

    public static LocalDate next(LocalDate localDate, DayOfWeek dayOfWeek) {
        Objects.requireNonNull(localDate, "localDate");
        return localDate.with(TemporalAdjusters.next(dayOfWeek));
    }

    public static LocalDateTime next(LocalDateTime localDateTime, DayOfWeek dayOfWeek) {
        return localDateTime.with(TemporalAdjusters.next(dayOfWeek));
    }

    public static Date next(Date date, DayOfWeek dayOfWeek) {
        return DateTimeConverterUtil.toDate(DateTimeConverterUtil.toLocalDateTime(date).with(TemporalAdjusters.next(dayOfWeek)));
    }

    public static LocalDate previous(LocalDate localDate, DayOfWeek dayOfWeek) {
        Objects.requireNonNull(localDate, "localDate");
        return localDate.with(TemporalAdjusters.previous(dayOfWeek));
    }

    public static LocalDateTime previous(LocalDateTime localDateTime, DayOfWeek dayOfWeek) {
        return localDateTime.with(TemporalAdjusters.previous(dayOfWeek));
    }

    public static Date previous(Date date, DayOfWeek dayOfWeek) {
        return DateTimeConverterUtil.toDate(DateTimeConverterUtil.toLocalDateTime(date).with(TemporalAdjusters.previous(dayOfWeek)));
    }

    public static LocalDate nextWorkDay(LocalDate localDate) {
        Objects.requireNonNull(localDate, "localDate");
        return localDate.with(TemporalAdjusterExtension.nextWorkDay());
    }

    public static LocalDateTime nextWorkDay(LocalDateTime localDateTime) {
        Objects.requireNonNull(localDateTime, "localDateTime");
        return localDateTime.with(TemporalAdjusterExtension.nextWorkDay());
    }

    public static Date nextWorkDay(Date date) {
        return DateTimeConverterUtil.toDate(DateTimeConverterUtil.toLocalDateTime(date).with(TemporalAdjusterExtension.nextWorkDay()));
    }

    public static ZonedDateTime getZonedDateTimeNowOfDefault() {
        return ZonedDateTime.now(ZoneId.systemDefault());
    }

    public static ZonedDateTime getZonedDateTimeNowOfShanghai() {
        return ZonedDateTime.now(ZoneId.of(ZoneIdEnum.CTT.getZoneIdName()));
    }

    public static ZonedDateTime getZonedDateTimeNowOfParis() {
        return ZonedDateTime.now(ZoneId.of(ZoneIdEnum.ECT.getZoneIdName()));
    }

    public static ZonedDateTime getZonedDateTimeNowOfEST() {
        return ZonedDateTime.now(ZoneId.of(ZoneIdEnum.EST.getZoneIdName()));
    }

    public static ZonedDateTime getZonedDateTimeNowOfTokyo() {
        return ZonedDateTime.now(ZoneId.of(ZoneIdEnum.JST.getZoneIdName()));
    }

    public static Temporal plus(Temporal temporal, TemporalUnit unit, long amountToAdd) {
        Objects.requireNonNull(temporal, "temporal");
        return temporal.plus(amountToAdd, unit);
    }

    public static Date plus(Date date, TemporalUnit unit, long amountToAdd) {
        return DateTimeConverterUtil.toDate(DateTimeConverterUtil.toLocalDateTime(date).plus(amountToAdd, unit));
    }

    public static Temporal minus(Temporal temporal, TemporalUnit unit, long amountToSubtract) {
        Objects.requireNonNull(temporal, "temporal");
        return temporal.minus(amountToSubtract, unit);
    }

    public static Date minus(Date date, TemporalUnit unit, long amountToSubtract) {
        return DateTimeConverterUtil.toDate(DateTimeConverterUtil.toLocalDateTime(date).minus(amountToSubtract, unit));
    }

    public static Temporal with(Temporal temporal, TemporalField field, long newValue) {
        Objects.requireNonNull(temporal, "temporal");
        return temporal.with(field, newValue);
    }

    public static Date with(Date date, TemporalField field, long newValue) {
        return DateTimeConverterUtil.toDate(DateTimeConverterUtil.toLocalDateTime(date).with(field, newValue));
    }

    public static Duration durationBetween(Temporal startInclusive, Temporal endExclusive) {
        return Duration.between(startInclusive, endExclusive);
    }

    public static Period periodBetween(LocalDate startDateInclusive, LocalDate endDateExclusive) {
        return Period.between(startDateInclusive, endDateExclusive);
    }

    public static ZonedDateTime getZonedDateTimeNow(String zoneId) {
        Objects.requireNonNull(zoneId, "zoneId");
        return ZonedDateTime.now(ZoneId.of(zoneId));
    }

    public static ZonedDateTime transform(ZonedDateTime zonedDateTime, String zoneId) {
        Objects.requireNonNull(zoneId, "zoneId");
        return DateTimeCalculatorUtil.transform(zonedDateTime, ZoneId.of(zoneId));
    }

    public static ZonedDateTime transform(ZonedDateTime zonedDateTime, ZoneId zone) {
        Objects.requireNonNull(zonedDateTime, "zonedDateTime");
        Objects.requireNonNull(zone, "zone");
        return zonedDateTime.withZoneSameInstant(zone);
    }

    public static String transform(Date date, String zoneId) {
        Objects.requireNonNull(zoneId, "zoneId");
        return DateTimeCalculatorUtil.transform(date, ZoneId.of(zoneId));
    }

    public static String transform(Date date, ZoneId zone) {
        Objects.requireNonNull(zone, "zone");
        return DateTimeFormatterUtil.formatToDateTimeStr(date, zone.toString());
    }

    public static int compare(Date date1, Date date2) {
        return DateTimeCalculatorUtil.compare(DateTimeConverterUtil.toLocalDateTime(date1), DateTimeConverterUtil.toLocalDateTime(date2));
    }

    public static int compare(Temporal temporal1, Temporal temporal2) {
        Objects.requireNonNull(temporal1, "temporal1");
        Objects.requireNonNull(temporal2, "temporal2");
        if (temporal1 instanceof LocalDateTime && temporal2 instanceof LocalDateTime) {
            LocalDateTime localDateTimeA = (LocalDateTime)temporal1;
            LocalDateTime localDateTimeB = (LocalDateTime)temporal2;
            return localDateTimeA.compareTo(localDateTimeB);
        }
        if (temporal1 instanceof LocalDate && temporal2 instanceof LocalDate) {
            LocalDate localDateA = (LocalDate)temporal1;
            LocalDate localDateB = (LocalDate)temporal2;
            return localDateA.compareTo(localDateB);
        }
        if (temporal1 instanceof LocalTime && temporal2 instanceof LocalTime) {
            LocalTime localTimeA = (LocalTime)temporal1;
            LocalTime localTimeB = (LocalTime)temporal2;
            return localTimeA.compareTo(localTimeB);
        }
        if (temporal1 instanceof Instant && temporal2 instanceof Instant) {
            Instant instantA = (Instant)temporal1;
            Instant instantB = (Instant)temporal2;
            return instantA.compareTo(instantB);
        }
        throw new DateTimeException("Unsupported Temporal, must be LocalDateTime,LocalDate,LocalTime,Instant");
    }

    public static LocalTime startTimeOfDay() {
        return LocalTime.MIN;
    }

    public static LocalTime endTimeOfDay() {
        return LocalTime.of(23, 59, 59);
    }

    public static LocalTime endAccuracyTimeOfDay() {
        return LocalTime.MAX;
    }

    public static Date startTimeOfYesterday() {
        return DateTimeConverterUtil.toDate(LocalDate.now().minusDays(1L).atTime(DateTimeCalculatorUtil.startTimeOfDay()));
    }

    public static Date endTimeOfYesterday() {
        return DateTimeConverterUtil.toDate(LocalDate.now().minusDays(1L).atTime(DateTimeCalculatorUtil.endTimeOfDay()));
    }

    public static Date startTimeOfTomorrow() {
        return DateTimeConverterUtil.toDate(LocalDate.now().plusDays(1L).atTime(DateTimeCalculatorUtil.startTimeOfDay()));
    }

    public static Date endTimeOfTomorrow() {
        return DateTimeConverterUtil.toDate(LocalDate.now().plusDays(1L).atTime(DateTimeCalculatorUtil.endTimeOfDay()));
    }

    public static Date startTimeOfToday() {
        return DateTimeConverterUtil.toDate(LocalDate.now().atTime(DateTimeCalculatorUtil.startTimeOfDay()));
    }

    public static Date endTimeOfToday() {
        return DateTimeConverterUtil.toDate(LocalDate.now().atTime(DateTimeCalculatorUtil.endTimeOfDay()));
    }

    public static Date startTimeOfLastMonth() {
        return DateTimeConverterUtil.toDate(DateTimeCalculatorUtil.firstDayOfMonth(LocalDate.now().minusMonths(1L)).atTime(DateTimeCalculatorUtil.startTimeOfDay()));
    }

    public static Date endTimeOfLastMonth() {
        return DateTimeConverterUtil.toDate(DateTimeCalculatorUtil.lastDayOfMonth(LocalDate.now().minusMonths(1L)).atTime(DateTimeCalculatorUtil.endTimeOfDay()));
    }

    public static Date startTimeOfMonth() {
        return DateTimeConverterUtil.toDate(DateTimeCalculatorUtil.firstDayOfMonth(LocalDate.now()).atTime(DateTimeCalculatorUtil.startTimeOfDay()));
    }

    public static Date endTimeOfMonth() {
        return DateTimeConverterUtil.toDate(DateTimeCalculatorUtil.lastDayOfMonth(LocalDate.now()).atTime(DateTimeCalculatorUtil.endTimeOfDay()));
    }

    public static Date startTimeOfDate(Date date) {
        return DateTimeConverterUtil.toDate(DateTimeConverterUtil.toLocalDate(date).atTime(DateTimeCalculatorUtil.startTimeOfDay()));
    }

    public static Date endTimeOfDate(Date date) {
        return DateTimeConverterUtil.toDate(DateTimeConverterUtil.toLocalDate(date).atTime(DateTimeCalculatorUtil.endTimeOfDay()));
    }

    public static Date endAccuracyTimeOfDate(Date date) {
        return DateTimeConverterUtil.toDate(DateTimeConverterUtil.toLocalDate(date).atTime(DateTimeCalculatorUtil.endAccuracyTimeOfDay()));
    }

    public static LocalDateTime startTimeOfLocalDateTime(LocalDateTime localDateTime) {
        Objects.requireNonNull(localDateTime, "localDateTime");
        return localDateTime.with(DateTimeCalculatorUtil.startTimeOfDay());
    }

    public static LocalDateTime endAccuracyTimeOfLocalDateTime(LocalDateTime localDateTime) {
        Objects.requireNonNull(localDateTime, "localDateTime");
        return localDateTime.with(DateTimeCalculatorUtil.endAccuracyTimeOfDay());
    }

    public static Date startTimeOfSpecialMonth(int year, int month) {
        return DateTimeConverterUtil.toDate(LocalDate.of(year, month, 1).atTime(DateTimeCalculatorUtil.startTimeOfDay()));
    }

    public static Date endTimeOfSpecialMonth(int year, int month) {
        return DateTimeConverterUtil.toDate(DateTimeCalculatorUtil.lastDayOfMonth(LocalDate.of(year, month, 1)).atTime(DateTimeCalculatorUtil.endTimeOfDay()));
    }

    public static Date startTimeOfDate(int year, int month, int dayOfMonth) {
        return DateTimeConverterUtil.toDate(LocalDate.of(year, month, dayOfMonth).atTime(DateTimeCalculatorUtil.startTimeOfDay()));
    }

    public static Date endTimeOfDate(int year, int month, int dayOfMonth) {
        return DateTimeConverterUtil.toDate(LocalDate.of(year, month, dayOfMonth).atTime(DateTimeCalculatorUtil.endTimeOfDay()));
    }

    public static Date startTimeOfFirstQuarter(int year) {
        return DateTimeCalculatorUtil.startTimeOfSpecialMonth(year, 1);
    }

    public static Date startTimeOfSecondQuarter(int year) {
        return DateTimeCalculatorUtil.startTimeOfSpecialMonth(year, 4);
    }

    public static Date startTimeOfThirdQuarter(int year) {
        return DateTimeCalculatorUtil.startTimeOfSpecialMonth(year, 7);
    }

    public static Date startTimeOfFourthQuarter(int year) {
        return DateTimeCalculatorUtil.startTimeOfSpecialMonth(year, 10);
    }

    public static Date endTimeOfFirstQuarter(int year) {
        return DateTimeCalculatorUtil.endTimeOfSpecialMonth(year, 3);
    }

    public static Date endTimeOfSecondQuarter(int year) {
        return DateTimeCalculatorUtil.endTimeOfSpecialMonth(year, 6);
    }

    public static Date endTimeOfThirdQuarter(int year) {
        return DateTimeCalculatorUtil.endTimeOfSpecialMonth(year, 9);
    }

    public static Date endTimeOfFourthQuarter(int year) {
        return DateTimeCalculatorUtil.endTimeOfSpecialMonth(year, 12);
    }

    public static Date startTimeOfCurrentQuarter() {
        LocalDate now = LocalDate.now();
        int year = now.getYear();
        int firstMonthOfQuarter = now.getMonth().firstMonthOfQuarter().getValue();
        return DateTimeCalculatorUtil.startTimeOfSpecialMonth(year, firstMonthOfQuarter);
    }

    public static Date endTimeOfCurrentQuarter() {
        LocalDate now = LocalDate.now();
        int year = now.getYear();
        int endMonthOfQuarter = now.getMonth().firstMonthOfQuarter().getValue() + 2;
        return DateTimeCalculatorUtil.endTimeOfSpecialMonth(year, endMonthOfQuarter);
    }

    public static Date startTimeOfYear(int year) {
        return DateTimeCalculatorUtil.startTimeOfSpecialMonth(year, 1);
    }

    public static Date endTimeOfYear(int year) {
        return DateTimeCalculatorUtil.endTimeOfSpecialMonth(year, 12);
    }

    public static Date startTimeOfCurrentYear() {
        return DateTimeCalculatorUtil.startTimeOfYear(LocalDate.now().getYear());
    }

    public static Date endTimeOfCurrentYear() {
        return DateTimeCalculatorUtil.endTimeOfYear(LocalDate.now().getYear());
    }

    public static boolean isSameMonthDay(LocalDate localDate1, MonthDay monthDay) {
        Objects.requireNonNull(localDate1, "localDate1");
        Objects.requireNonNull(monthDay, "monthDay");
        return MonthDay.of(localDate1.getMonthValue(), localDate1.getDayOfMonth()).equals(monthDay);
    }

    public static boolean isSameMonthDay(LocalDate localDate1, String monthDayStr) {
        Objects.requireNonNull(monthDayStr, "monthDayStr");
        return DateTimeCalculatorUtil.isSameMonthDay(localDate1, MonthDay.parse("--" + monthDayStr));
    }

    public static boolean isSameMonthDay(LocalDate localDate1, LocalDate localDate2) {
        Objects.requireNonNull(localDate2, "localDate2");
        return DateTimeCalculatorUtil.isSameMonthDay(localDate1, MonthDay.of(localDate2.getMonthValue(), localDate2.getDayOfMonth()));
    }

    public static boolean isSameMonthDay(Date date, String monthDayStr) {
        return DateTimeCalculatorUtil.isSameMonthDay(DateTimeConverterUtil.toLocalDate(date), monthDayStr);
    }

    public static boolean isSameMonthDay(Date date1, Date date2) {
        Objects.requireNonNull(date1, "date1");
        Objects.requireNonNull(date2, "date2");
        return DateTimeCalculatorUtil.isSameMonthDay(DateTimeConverterUtil.toLocalDate(date1), DateTimeConverterUtil.toLocalDate(date2));
    }

    public static boolean isSameMonthDayOfNow(String monthDayStr) {
        return DateTimeCalculatorUtil.isSameMonthDay(LocalDate.now(), monthDayStr);
    }

    public static long betweenNextSameMonthDay(LocalDate localDate1, int month, int dayOfMonth) {
        Objects.requireNonNull(localDate1, "localDate1");
        MonthDay monthDay1 = MonthDay.of(localDate1.getMonthValue(), localDate1.getDayOfMonth());
        MonthDay monthDay2 = MonthDay.of(month, dayOfMonth);
        MonthDay leapMonthDay = MonthDay.of(2, 29);
        if (leapMonthDay.equals(monthDay2)) {
            LocalDate nextLeapYear = DateTimeCalculatorUtil.nextLeapYear(localDate1);
            return DateTimeCalculatorUtil.betweenTotalDays(localDate1.atStartOfDay(), nextLeapYear.withMonth(month).withDayOfMonth(dayOfMonth).atStartOfDay());
        }
        if (monthDay1.compareTo(monthDay2) == -1) {
            return DateTimeCalculatorUtil.betweenTotalDays(localDate1.atStartOfDay(), localDate1.withMonth(month).withDayOfMonth(dayOfMonth).atStartOfDay());
        }
        LocalDate next = localDate1.plusYears(1L);
        return DateTimeCalculatorUtil.betweenTotalDays(localDate1.atStartOfDay(), next.withMonth(month).withDayOfMonth(dayOfMonth).atStartOfDay());
    }

    public static long betweenNextSameMonthDay(LocalDate localDate, String monthDayStr) {
        Objects.requireNonNull(monthDayStr, "monthDayStr");
        MonthDay monthDay2 = MonthDay.parse("--" + monthDayStr);
        return DateTimeCalculatorUtil.betweenNextSameMonthDay(localDate, monthDay2.getMonthValue(), monthDay2.getDayOfMonth());
    }

    public static long betweenNextSameMonthDay(Date date, String monthDayStr) {
        Objects.requireNonNull(monthDayStr, "monthDayStr");
        MonthDay monthDay2 = MonthDay.parse("--" + monthDayStr);
        return DateTimeCalculatorUtil.betweenNextSameMonthDay(DateTimeConverterUtil.toLocalDate(date), monthDay2.getMonthValue(), monthDay2.getDayOfMonth());
    }

    public static long betweenNextSameMonthDayOfNow(String monthDayStr) {
        Objects.requireNonNull(monthDayStr, "monthDayStr");
        MonthDay monthDay2 = MonthDay.parse("--" + monthDayStr);
        return DateTimeCalculatorUtil.betweenNextSameMonthDay(LocalDate.now(), monthDay2.getMonthValue(), monthDay2.getDayOfMonth());
    }

    public static LocalDate nextSameMonthDay(LocalDate localDate, String monthDayStr) {
        return localDate.plusDays(DateTimeCalculatorUtil.betweenNextSameMonthDay(localDate, monthDayStr));
    }

    public static Date nextSameMonthDay(Date date, String monthDayStr) {
        return DateTimeConverterUtil.toDate(DateTimeCalculatorUtil.nextSameMonthDay(DateTimeConverterUtil.toLocalDate(date), monthDayStr));
    }

    public static Date nextSameMonthDayOfNow(String monthDayStr) {
        return DateTimeCalculatorUtil.nextSameMonthDay(new Date(), monthDayStr);
    }

    public static String getConstellationNameCn(String monthDayStr) {
        return ConstellationNameEnum.getNameCnByMonthDay(monthDayStr);
    }

    public static String getConstellationNameCn(Date date) {
        String monthDayStr = DateTimeFormatterUtil.format(date, DateTimeFormatterUtil.MM_DD_FMT);
        return ConstellationNameEnum.getNameCnByMonthDay(monthDayStr);
    }

    public static String getConstellationNameEn(String monthDayStr) {
        return ConstellationNameEnum.getNameEnByMonthDay(monthDayStr);
    }

    public static List<LocalDateTime> getLocalDateTimeList(LocalDateTime start, LocalDateTime end) {
        Objects.requireNonNull(start, "start");
        Objects.requireNonNull(end, "end");
        if (start.isAfter(end)) {
            throw new DateTimeException("start must before or equal end!");
        }
        ArrayList<LocalDateTime> localDateTimeList = new ArrayList<LocalDateTime>();
        long days = DateTimeCalculatorUtil.betweenTotalDays(start, end) + 1L;
        for (long i = 0L; i < days; ++i) {
            localDateTimeList.add(start.plusDays(i));
        }
        return localDateTimeList;
    }

    public static List<LocalDateTime> getLocalDateTimeList(LocalDateTime start, LocalDateTime end, ChronoUnit unit) {
        Objects.requireNonNull(start, "start");
        Objects.requireNonNull(end, "end");
        Objects.requireNonNull(unit, "unit");
        if (start.isAfter(end)) {
            throw new DateTimeException("start must before or equal end!");
        }
        ArrayList<LocalDateTime> localDateTimeList = new ArrayList<LocalDateTime>();
        if (start.equals(end)) {
            localDateTimeList.add(start);
            return localDateTimeList;
        }
        int i = 1;
        LocalDateTime localDateTime = start;
        localDateTimeList.add(localDateTime);
        while (localDateTime.isBefore(end) && !(localDateTime = (LocalDateTime)DateTimeCalculatorUtil.plus(start, (TemporalUnit)unit, (long)i)).isAfter(end) && !localDateTime.equals(end)) {
            localDateTimeList.add(localDateTime);
            ++i;
        }
        localDateTimeList.add(end);
        return localDateTimeList;
    }

    public static List<String> getLocalDateTimeFormatList(LocalDateTime start, LocalDateTime end, String dateFormatPattern) {
        DateTimeFormatter formatter = DateTimeFormatterUtil.getDateTimeFormatter(dateFormatPattern);
        return DateTimeCalculatorUtil.getLocalDateTimeList(start, end).stream().map(localDateTime -> DateTimeFormatterUtil.format(localDateTime, formatter)).collect(Collectors.toList());
    }

    public static List<LocalDate> getLocalDateList(LocalDate start, LocalDate end) {
        return DateTimeCalculatorUtil.getLocalDateTimeList(DateTimeConverterUtil.toLocalDateTime(start), DateTimeConverterUtil.toLocalDateTime(end)).stream().map(localDateTime -> localDateTime.toLocalDate()).collect(Collectors.toList());
    }

    public static List<LocalDate> getLocalDateList(LocalDate start, LocalDate end, ChronoUnit unit) {
        Objects.requireNonNull(start, "start");
        Objects.requireNonNull(end, "end");
        Objects.requireNonNull(unit, "unit");
        if (start.isAfter(end)) {
            throw new DateTimeException("start must before or equal end!");
        }
        ArrayList<LocalDate> localDateList = new ArrayList<LocalDate>();
        if (start.equals(end)) {
            localDateList.add(start);
            return localDateList;
        }
        int i = 1;
        LocalDate localDate = start;
        localDateList.add(localDate);
        while (localDate.isBefore(end) && !(localDate = (LocalDate)DateTimeCalculatorUtil.plus(start, (TemporalUnit)unit, (long)i)).isAfter(end) && !localDate.equals(end)) {
            localDateList.add(localDate);
            ++i;
        }
        localDateList.add(end);
        return localDateList;
    }

    public static List<Date> getDateList(Date start, Date end) {
        return DateTimeCalculatorUtil.getLocalDateTimeList(DateTimeConverterUtil.toLocalDateTime(start), DateTimeConverterUtil.toLocalDateTime(end)).stream().map(localDateTime -> DateTimeConverterUtil.toDate(localDateTime)).collect(Collectors.toList());
    }

    public static List<String> getDateFormatList(Date start, Date end, String dateFormatPattern) {
        DateTimeFormatter formatter = DateTimeFormatterUtil.getDateTimeFormatter(dateFormatPattern);
        return DateTimeCalculatorUtil.getDateList(start, end).stream().map(date -> DateTimeFormatterUtil.format(date, formatter)).collect(Collectors.toList());
    }

    public static List<Date> getDateList(Date startInclusive, Date endInclusive, ChronoUnit unit) {
        return DateTimeCalculatorUtil.getLocalDateTimeList(DateTimeConverterUtil.toLocalDateTime(startInclusive), DateTimeConverterUtil.toLocalDateTime(endInclusive), unit).stream().map(localDateTime -> DateTimeConverterUtil.toDate(localDateTime)).collect(Collectors.toList());
    }

    public static List<LocalDate> getLocalDateList(YearMonth yearMonth) {
        Objects.requireNonNull(yearMonth, "yearMonth");
        ArrayList<LocalDate> localDateList = new ArrayList<LocalDate>();
        long days = yearMonth.lengthOfMonth();
        LocalDate localDate = DateTimeConverterUtil.toLocalDateStartOfMonth(yearMonth);
        for (long i = 0L; i < days; ++i) {
            localDateList.add(DateTimeCalculatorUtil.plusDays(localDate, i));
        }
        return localDateList;
    }

    public static List<LocalDate> getLocalDateList(String yearMonthStr) {
        Objects.requireNonNull(yearMonthStr, "yearMonthStr");
        YearMonth yearMonth = YearMonth.parse(yearMonthStr);
        return DateTimeCalculatorUtil.getLocalDateList(yearMonth);
    }

    public static List<LocalDate> getLocalDateList(int year, int month) {
        YearMonth yearMonth = YearMonth.of(year, month);
        return DateTimeCalculatorUtil.getLocalDateList(yearMonth);
    }

    public static List<LocalDateTime> getLocalDateTimeList(YearMonth yearMonth) {
        return DateTimeCalculatorUtil.getLocalDateList(yearMonth).stream().map(localDate -> DateTimeConverterUtil.toLocalDateTime(localDate)).collect(Collectors.toList());
    }

    public static List<LocalDateTime> getLocalDateTimeList(String yearMonthStr) {
        return DateTimeCalculatorUtil.getLocalDateList(yearMonthStr).stream().map(localDate -> DateTimeConverterUtil.toLocalDateTime(localDate)).collect(Collectors.toList());
    }

    public static List<LocalDateTime> getLocalDateTimeList(int year, int month) {
        return DateTimeCalculatorUtil.getLocalDateList(YearMonth.of(year, month)).stream().map(localDate -> DateTimeConverterUtil.toLocalDateTime(localDate)).collect(Collectors.toList());
    }

    public static List<Date> getDateList(String yearMonthStr) {
        return DateTimeCalculatorUtil.getLocalDateList(yearMonthStr).stream().map(localDate -> DateTimeConverterUtil.toDate(localDate)).collect(Collectors.toList());
    }

    public static List<Date> getDateList(int year, int month) {
        return DateTimeCalculatorUtil.getLocalDateList(YearMonth.of(year, month)).stream().map(localDate -> DateTimeConverterUtil.toDate(localDate)).collect(Collectors.toList());
    }

    public static boolean isExpiry(YearMonth yearMonth) {
        Objects.requireNonNull(yearMonth, "yearMonth");
        return yearMonth.isBefore(YearMonth.now());
    }

    public static boolean isExpiry(String yearMonthStr) {
        Objects.requireNonNull(yearMonthStr, "yearMonthStr");
        YearMonth yearMonth = YearMonth.parse(yearMonthStr);
        return DateTimeCalculatorUtil.isExpiry(yearMonth);
    }

    public static boolean isBirthDay(LocalDate birthDay) {
        Objects.requireNonNull(birthDay, "birthDay");
        return DateTimeCalculatorUtil.isSameMonthDay(birthDay, LocalDate.now());
    }

    public static boolean isBirthDay(Date birthDay) {
        Objects.requireNonNull(birthDay, "birthDay");
        return DateTimeCalculatorUtil.isBirthDay(DateTimeConverterUtil.toLocalDate(birthDay));
    }

    public static boolean isBirthDay(LocalDateTime birthDay) {
        Objects.requireNonNull(birthDay, "birthDay");
        return DateTimeCalculatorUtil.isBirthDay(DateTimeConverterUtil.toLocalDate(birthDay));
    }

    public static LocalDateTime reduceAccuracyToSecond(LocalDateTime localDateTime) {
        Objects.requireNonNull(localDateTime, "localDateTime");
        return LocalDateTime.of(localDateTime.getYear(), localDateTime.getMonthValue(), localDateTime.getDayOfMonth(), localDateTime.getHour(), localDateTime.getMinute(), localDateTime.getSecond());
    }

    public static Date reduceAccuracyToSecond(Date date) {
        Objects.requireNonNull(date, "date");
        return DateTimeConverterUtil.toDate(DateTimeCalculatorUtil.reduceAccuracyToSecond(DateTimeConverterUtil.toLocalDateTime(date)));
    }

    public static LocalDateTime reduceAccuracyToMinute(LocalDateTime localDateTime) {
        Objects.requireNonNull(localDateTime, "localDateTime");
        return LocalDateTime.of(localDateTime.getYear(), localDateTime.getMonthValue(), localDateTime.getDayOfMonth(), localDateTime.getHour(), localDateTime.getMinute(), 0);
    }

    public static Date reduceAccuracyToMinute(Date date) {
        Objects.requireNonNull(date, "date");
        return DateTimeConverterUtil.toDate(DateTimeCalculatorUtil.reduceAccuracyToMinute(DateTimeConverterUtil.toLocalDateTime(date)));
    }

    public static LocalDateTime reduceAccuracyToHour(LocalDateTime localDateTime) {
        Objects.requireNonNull(localDateTime, "localDateTime");
        return LocalDateTime.of(localDateTime.getYear(), localDateTime.getMonthValue(), localDateTime.getDayOfMonth(), localDateTime.getHour(), 0, 0);
    }

    public static Date reduceAccuracyToHour(Date date) {
        Objects.requireNonNull(date, "date");
        return DateTimeConverterUtil.toDate(DateTimeCalculatorUtil.reduceAccuracyToHour(DateTimeConverterUtil.toLocalDateTime(date)));
    }

    public static LocalDateTime reduceAccuracyToDay(LocalDateTime localDateTime) {
        Objects.requireNonNull(localDateTime, "localDateTime");
        return LocalDateTime.of(localDateTime.getYear(), localDateTime.getMonthValue(), localDateTime.getDayOfMonth(), 0, 0, 0);
    }

    public static Date reduceAccuracyToDay(Date date) {
        Objects.requireNonNull(date, "date");
        return DateTimeConverterUtil.toDate(DateTimeCalculatorUtil.reduceAccuracyToDay(DateTimeConverterUtil.toLocalDateTime(date)));
    }

    public static int weekOfMonth(LocalDate localDate, Locale locale) {
        Objects.requireNonNull(localDate, "localDate");
        WeekFields weekFields = locale == null ? WeekFields.of(Locale.getDefault()) : WeekFields.of(locale);
        return (int)weekFields.weekOfMonth().getFrom(localDate);
    }

    public static int weekOfMonth(LocalDate localDate) {
        return DateTimeCalculatorUtil.weekOfMonth(localDate, null);
    }

    public static int weekOfMonth(LocalDateTime localDateTime) {
        return DateTimeCalculatorUtil.weekOfMonth(DateTimeConverterUtil.toLocalDate(localDateTime), null);
    }

    public static int weekOfMonth(Date date) {
        return DateTimeCalculatorUtil.weekOfMonth(DateTimeConverterUtil.toLocalDate(date), null);
    }

    public static int weekOfMonth() {
        return DateTimeCalculatorUtil.weekOfMonth(LocalDate.now());
    }

    public static int weekOfYear(LocalDate localDate, Locale locale) {
        Objects.requireNonNull(localDate, "localDate");
        WeekFields weekFields = locale == null ? WeekFields.of(Locale.getDefault()) : WeekFields.of(locale);
        return (int)weekFields.weekOfYear().getFrom(localDate);
    }

    public static int weekOfYear(LocalDate localDate) {
        return DateTimeCalculatorUtil.weekOfYear(localDate, null);
    }

    public static int weekOfYear(LocalDateTime localDateTime) {
        return DateTimeCalculatorUtil.weekOfYear(DateTimeConverterUtil.toLocalDate(localDateTime), null);
    }

    public static int weekOfYear(Date date) {
        return DateTimeCalculatorUtil.weekOfYear(DateTimeConverterUtil.toLocalDate(date), null);
    }

    public static int weekOfYear() {
        return DateTimeCalculatorUtil.weekOfYear(LocalDate.now());
    }

    public static boolean isMonday(LocalDate localDate) {
        Objects.requireNonNull(localDate, "localDate");
        return WeekNameEnum.Mon.getCode() == localDate.getDayOfWeek().getValue();
    }

    public static boolean isMonday(Date date) {
        return DateTimeCalculatorUtil.isMonday(DateTimeConverterUtil.toLocalDate(date));
    }

    public static boolean isZhouYi(LocalDate localDate) {
        return DateTimeCalculatorUtil.isMonday(localDate);
    }

    public static boolean isZhouYi(Date date) {
        return DateTimeCalculatorUtil.isMonday(DateTimeConverterUtil.toLocalDate(date));
    }

    public static boolean isFriday(LocalDate localDate) {
        Objects.requireNonNull(localDate, "localDate");
        return WeekNameEnum.Fri.getCode() == localDate.getDayOfWeek().getValue();
    }

    public static boolean isFriday(Date date) {
        return DateTimeCalculatorUtil.isFriday(DateTimeConverterUtil.toLocalDate(date));
    }

    public static boolean isZhouWu(LocalDate localDate) {
        return DateTimeCalculatorUtil.isFriday(localDate);
    }

    public static boolean isZhouWu(Date date) {
        return DateTimeCalculatorUtil.isFriday(DateTimeConverterUtil.toLocalDate(date));
    }

    public static String getTwelveTwo(LocalTime localTime) {
        return TwelveTwoEnum.getNameCn(localTime);
    }

    public static String getTwelveTwo(LocalDateTime localDateTime) {
        return TwelveTwoEnum.getNameCn(DateTimeConverterUtil.toLocalTime(localDateTime));
    }

    public static String getTwelveTwo(Date date) {
        return TwelveTwoEnum.getNameCn(date);
    }

    public static String getTwelveTwo() {
        return TwelveTwoEnum.getNameCn(LocalTime.now());
    }

    public static Date today() {
        return new Date();
    }

    public static Date tomorrow() {
        return DateTimeCalculatorUtil.plusDays(DateTimeCalculatorUtil.today(), 1L);
    }

    public static Date nextWeek() {
        return DateTimeCalculatorUtil.plusWeeks(DateTimeCalculatorUtil.today(), 1L);
    }

    public static Date nextMonth() {
        return DateTimeCalculatorUtil.plusMonths(DateTimeCalculatorUtil.today(), 1L);
    }

    public static Date nextYear() {
        return DateTimeCalculatorUtil.plusYears(DateTimeCalculatorUtil.today(), 1L);
    }

    public static Date yesterday() {
        return DateTimeCalculatorUtil.minusDays(DateTimeCalculatorUtil.today(), 1L);
    }

    public static Date lastWeek() {
        return DateTimeCalculatorUtil.minusWeeks(DateTimeCalculatorUtil.today(), 1L);
    }

    public static Date lastMonth() {
        return DateTimeCalculatorUtil.minusMonths(DateTimeCalculatorUtil.today(), 1L);
    }

    public static Date lastYear() {
        return DateTimeCalculatorUtil.minusYears(DateTimeCalculatorUtil.today(), 1L);
    }

    public static boolean isOverlap(long startDate1, long endDate1, long startDate2, long endDate2, boolean isStrict) {
        if (endDate1 < startDate1) {
            throw new DateTimeException("endDate1\u4e0d\u80fd\u5c0f\u4e8estartDate1");
        }
        if (endDate2 < startDate2) {
            throw new DateTimeException("endDate2\u4e0d\u80fd\u5c0f\u4e8estartDate2");
        }
        return isStrict ? endDate1 >= startDate2 && startDate1 <= endDate2 : endDate1 > startDate2 && startDate1 < endDate2;
    }

    public static boolean isOverlap(Date startDate1, Date endDate1, Date startDate2, Date endDate2, boolean isStrict) {
        Objects.requireNonNull(startDate1, "startDate1");
        Objects.requireNonNull(endDate1, "endDate1");
        Objects.requireNonNull(startDate2, "startDate2");
        Objects.requireNonNull(endDate2, "endDate2");
        return DateTimeCalculatorUtil.isOverlap(startDate1.getTime(), endDate1.getTime(), startDate2.getTime(), endDate2.getTime(), isStrict);
    }

    public static boolean isOverlap(Date startDate1, Date endDate1, Date startDate2, Date endDate2) {
        return DateTimeCalculatorUtil.isOverlap(startDate1, endDate1, startDate2, endDate2, false);
    }

    public static boolean isOverlap(LocalDateTime startDate1, LocalDateTime endDate1, LocalDateTime startDate2, LocalDateTime endDate2, boolean isStrict) {
        Objects.requireNonNull(startDate1, "startDate1");
        Objects.requireNonNull(endDate1, "endDate1");
        Objects.requireNonNull(startDate2, "startDate2");
        Objects.requireNonNull(endDate2, "endDate2");
        return DateTimeCalculatorUtil.isOverlap(DateTimeConverterUtil.toEpochMilli(startDate1), DateTimeConverterUtil.toEpochMilli(endDate1), DateTimeConverterUtil.toEpochMilli(startDate2), DateTimeConverterUtil.toEpochMilli(endDate2), isStrict);
    }

    public static boolean isOverlap(LocalDate startDate1, LocalDate endDate1, LocalDate startDate2, LocalDate endDate2, boolean isStrict) {
        Objects.requireNonNull(startDate1, "startDate1");
        Objects.requireNonNull(endDate1, "endDate1");
        Objects.requireNonNull(startDate2, "startDate2");
        Objects.requireNonNull(endDate2, "endDate2");
        return DateTimeCalculatorUtil.isOverlap(DateTimeConverterUtil.toEpochMilli(startDate1), DateTimeConverterUtil.toEpochMilli(endDate1), DateTimeConverterUtil.toEpochMilli(startDate2), DateTimeConverterUtil.toEpochMilli(endDate2), isStrict);
    }

    public static boolean isOverlap(TimePair[] timePairs, boolean isStrict) {
        if (ArrayUtil.isEmpty(timePairs)) {
            throw new DateTimeException("timePairs\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Arrays.sort(timePairs, Comparator.comparingLong(TimePair::getStart));
        for (int i = 1; i < timePairs.length; ++i) {
            if (!(isStrict ? timePairs[i - 1].getEnd() >= timePairs[i].getStart() : timePairs[i - 1].getEnd() > timePairs[i].getStart())) continue;
            return true;
        }
        return false;
    }

    public static boolean isOverlap(List<TimePair> timePairList, boolean isStrict) {
        if (CollectionUtil.isEmpty(timePairList)) {
            throw new DateTimeException("timePairList\u4e0d\u80fd\u4e3a\u7a7a");
        }
        TimePair[] timePairs = new TimePair[timePairList.size()];
        timePairList.toArray(timePairs);
        return DateTimeCalculatorUtil.isOverlap(timePairs, isStrict);
    }

    public static long overlapTime(long startDate1, long endDate1, long startDate2, long endDate2) {
        if (!DateTimeCalculatorUtil.isOverlap(startDate1, endDate1, startDate2, endDate2, false)) {
            return 0L;
        }
        long overlapTime = 0L;
        if (startDate1 <= startDate2 && endDate2 <= endDate1) {
            overlapTime = endDate2 - startDate2;
        } else if (startDate2 <= startDate1 && endDate1 <= endDate2) {
            overlapTime = endDate1 - startDate1;
        } else if (startDate1 < startDate2) {
            overlapTime = endDate1 - startDate2;
        } else if (endDate1 > endDate2) {
            overlapTime = endDate2 - startDate1;
        }
        return overlapTime;
    }

    public static long overlapTime(Date startDate1, Date endDate1, Date startDate2, Date endDate2) {
        return DateTimeCalculatorUtil.overlapTime(startDate1.getTime(), endDate1.getTime(), startDate2.getTime(), endDate2.getTime());
    }

    public static LocalTime averageTime(List<Date> dateList) {
        if (CollectionUtil.isEmpty(dateList)) {
            throw new DateTimeException("dateList\u4e0d\u80fd\u4e3a\u7a7a");
        }
        double average = dateList.stream().mapToDouble(date -> DateTimeConverterUtil.toLocalTime(date).toNanoOfDay()).average().getAsDouble();
        return LocalTime.ofNanoOfDay(new Double(average).longValue());
    }

    public static String countdown(long millis) {
        if (millis <= 0L) {
            return "0\u5c0f\u65f60\u5206\u949f0\u79d2";
        }
        Duration duration = Duration.ofMillis(millis);
        long hours = duration.getSeconds() / 3600L;
        int minutes = (int)(duration.getSeconds() % 3600L / 60L);
        int seconds = (int)(duration.getSeconds() % 60L);
        StringBuilder buf = new StringBuilder(24);
        buf.append(hours).append("\u5c0f\u65f6");
        buf.append(minutes).append("\u5206\u949f");
        buf.append(seconds).append("\u79d2");
        return buf.toString();
    }

    public static String countdown(Date start, String unitNames) {
        Objects.requireNonNull(start, "start");
        Date end = new Date();
        return DateTimeCalculatorUtil.countdown(end.getTime() - start.getTime(), unitNames);
    }

    public static String countdown(Date start, Date end, String unitNames) {
        Objects.requireNonNull(start, "start");
        Objects.requireNonNull(end, "end");
        return DateTimeCalculatorUtil.countdown(end.getTime() - start.getTime(), unitNames);
    }

    public static String countdown(long millis, String unitNames) {
        long hours;
        StringBuilder buf = new StringBuilder(24);
        long[] valueArr = new long[]{0L, 0L, 0L};
        if (StringUtil.isEmpty(unitNames)) {
            unitNames = "\u5c0f\u65f6,\u5206\u949f,\u79d2";
        }
        if (millis <= 0L) {
            return DateTimeCalculatorUtil.getCountDownResult(unitNames, buf, valueArr);
        }
        Duration duration = Duration.ofMillis(millis);
        valueArr[0] = hours = duration.getSeconds() / 3600L;
        int minutes = (int)(duration.getSeconds() % 3600L / 60L);
        valueArr[1] = minutes;
        int seconds = (int)(duration.getSeconds() % 60L);
        valueArr[2] = seconds;
        return DateTimeCalculatorUtil.getCountDownResult(unitNames, buf, valueArr);
    }

    public static String countdownWithDay(long millis) {
        if (millis <= 0L) {
            return "0\u59290\u5c0f\u65f60\u5206\u949f0\u79d2";
        }
        Duration duration = Duration.ofMillis(millis);
        long days = duration.getSeconds() / 86400L;
        int hours = (int)(duration.getSeconds() % 86400L / 3600L);
        int minutes = (int)(duration.getSeconds() % 3600L / 60L);
        int seconds = (int)(duration.getSeconds() % 60L);
        StringBuilder buf = new StringBuilder(24);
        buf.append(days).append("\u5929");
        buf.append(hours).append("\u5c0f\u65f6");
        buf.append(minutes).append("\u5206\u949f");
        buf.append(seconds).append("\u79d2");
        return buf.toString();
    }

    public static String countdownWithDay(long millis, String unitNames) {
        long days;
        StringBuilder buf = new StringBuilder(24);
        long[] valueArr = new long[]{0L, 0L, 0L, 0L};
        if (StringUtil.isEmpty(unitNames)) {
            unitNames = "\u5929,\u5c0f\u65f6,\u5206\u949f,\u79d2";
        }
        if (millis <= 0L) {
            return DateTimeCalculatorUtil.getCountDownResult(unitNames, buf, valueArr);
        }
        Duration duration = Duration.ofMillis(millis);
        valueArr[0] = days = duration.getSeconds() / 86400L;
        int hours = (int)(duration.getSeconds() % 86400L / 3600L);
        valueArr[1] = hours;
        int minutes = (int)(duration.getSeconds() % 3600L / 60L);
        valueArr[2] = minutes;
        int seconds = (int)(duration.getSeconds() % 60L);
        valueArr[3] = seconds;
        return DateTimeCalculatorUtil.getCountDownResult(unitNames, buf, valueArr);
    }

    public static String countdownWithDay(Date start, String unitNames) {
        Objects.requireNonNull(start, "start");
        Date end = new Date();
        return DateTimeCalculatorUtil.countdownWithDay(end.getTime() - start.getTime(), unitNames);
    }

    public static String countdownWithDay(Date start, Date end, String unitNames) {
        Objects.requireNonNull(start, "start");
        Objects.requireNonNull(end, "end");
        return DateTimeCalculatorUtil.countdownWithDay(end.getTime() - start.getTime(), unitNames);
    }

    private static String getCountDownResult(String unitNames, StringBuilder buf, long[] valueArr) {
        String[] unitNameArr = unitNames.split(",");
        for (int i = 0; i < unitNameArr.length; ++i) {
            buf.append(valueArr[i] + unitNameArr[i]);
        }
        return buf.toString();
    }
}

