/*
 * Decompiled with CFR 0.152.
 */
package com.xkzhangsan.time.nlp;

import com.xkzhangsan.time.calculator.DateTimeCalculatorUtil;
import com.xkzhangsan.time.converter.DateTimeConverterUtil;
import com.xkzhangsan.time.enums.MomentEnum;
import com.xkzhangsan.time.enums.RegexEnum;
import com.xkzhangsan.time.formatter.DateTimeFormatterUtil;
import com.xkzhangsan.time.nlp.TextAnalysis;
import com.xkzhangsan.time.nlp.TimeContext;
import com.xkzhangsan.time.utils.CollectionUtil;
import java.time.LocalDateTime;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalField;
import java.time.temporal.TemporalUnit;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TimeNLP {
    private static Map<Integer, Object> TUNIT_MAP = new HashMap<Integer, Object>();
    private String timeExpression = null;
    private String timeNorm = "";
    private String timeNormFormat = "";
    private Date time;
    private Boolean isAllDayTime = true;
    private boolean isFirstTimeSolveContext = true;
    private TextAnalysis textAnalysis = null;
    private TimeContext timeContext = new TimeContext();
    private TimeContext timeContextOrigin = new TimeContext();

    public TimeNLP(String timeExpression, TextAnalysis textAnalysis) {
        this.timeExpression = timeExpression;
        this.textAnalysis = textAnalysis;
        this.timeNormalization();
    }

    public TimeNLP(String timeExpression, TextAnalysis textAnalysis, TimeContext timePoint) {
        this.timeExpression = timeExpression;
        this.textAnalysis = textAnalysis;
        this.timeContextOrigin = timePoint;
        this.timeNormalization();
    }

    public Date getTime() {
        return this.time;
    }

    private LocalDateTime normStandardTime() {
        LocalDateTime localDateTime = null;
        Pattern pattern = RegexEnum.NormStandard.getPattern();
        Matcher match = pattern.matcher(this.timeExpression);
        if (match.find()) {
            try {
                localDateTime = DateTimeFormatterUtil.smartParseToLocalDateTime(this.timeExpression);
                int[] tunit = this.timeContext.getTunit();
                tunit[0] = localDateTime.getYear();
                tunit[1] = localDateTime.getMonthValue();
                tunit[2] = localDateTime.getDayOfMonth();
                if (localDateTime.getHour() > 0) {
                    tunit[3] = localDateTime.getHour();
                }
                if (localDateTime.getMinute() > 0) {
                    tunit[4] = localDateTime.getMinute();
                }
                if (localDateTime.getSecond() > 0) {
                    tunit[5] = localDateTime.getSecond();
                }
            }
            catch (Exception e) {
                System.out.println("normStandardTime error:" + e.getMessage());
            }
        }
        return localDateTime;
    }

    private void normYear() {
        Pattern pattern = RegexEnum.NormYearTwo.getPattern();
        Matcher match = pattern.matcher(this.timeExpression);
        if (match.find()) {
            this.timeContext.getTunit()[0] = Integer.parseInt(match.group());
            if (this.timeContext.getTunit()[0] >= 0 && this.timeContext.getTunit()[0] < 100) {
                if (this.timeContext.getTunit()[0] < 30) {
                    int[] nArray = this.timeContext.getTunit();
                    nArray[0] = nArray[0] + 2000;
                } else {
                    int[] nArray = this.timeContext.getTunit();
                    nArray[0] = nArray[0] + 1900;
                }
            }
        }
        if ((match = (pattern = RegexEnum.NormYearFour.getPattern()).matcher(this.timeExpression)).find()) {
            this.timeContext.getTunit()[0] = Integer.parseInt(match.group());
        }
    }

    private void normMonth() {
        Pattern pattern = RegexEnum.NormMonth.getPattern();
        Matcher match = pattern.matcher(this.timeExpression);
        if (match.find()) {
            this.timeContext.getTunit()[1] = Integer.parseInt(match.group());
            this.preferFuture(1);
        }
    }

    private void normMonthFuzzyDay() {
        Pattern pattern = RegexEnum.NormMonthFuzzyDay.getPattern();
        Matcher match = pattern.matcher(this.timeExpression);
        if (match.find()) {
            String matchStr = match.group();
            Pattern p = Pattern.compile("(\u6708|\\.|\\-)");
            Matcher m = p.matcher(matchStr);
            if (m.find()) {
                int splitIndex = m.start();
                String month = matchStr.substring(0, splitIndex);
                String date = matchStr.substring(splitIndex + 1);
                this.timeContext.getTunit()[1] = Integer.parseInt(month);
                this.timeContext.getTunit()[2] = Integer.parseInt(date);
                this.preferFuture(1);
            }
        }
    }

    private void normDay() {
        Pattern pattern = RegexEnum.NormDay.getPattern();
        Matcher match = pattern.matcher(this.timeExpression);
        if (match.find()) {
            this.timeContext.getTunit()[2] = Integer.parseInt(match.group());
            this.preferFuture(2);
        }
    }

    private void normHour() {
        Pattern pattern = RegexEnum.NormHour.getPattern();
        Matcher match = pattern.matcher(this.timeExpression);
        if (match.find()) {
            this.timeContext.getTunit()[3] = Integer.parseInt(match.group());
            this.preferFuture(3);
            this.isAllDayTime = false;
        }
        if ((match = (pattern = RegexEnum.NormHourDayBreak.getPattern()).matcher(this.timeExpression)).find()) {
            if (this.timeContext.getTunit()[3] == -1) {
                this.timeContext.getTunit()[3] = MomentEnum.day_break.getHourTime();
            }
            this.preferFuture(3);
            this.isAllDayTime = false;
        }
        if ((match = (pattern = RegexEnum.NormHourEarlyMorning.getPattern()).matcher(this.timeExpression)).find()) {
            if (this.timeContext.getTunit()[3] == -1) {
                this.timeContext.getTunit()[3] = MomentEnum.early_morning.getHourTime();
            }
            this.preferFuture(3);
            this.isAllDayTime = false;
        }
        if ((match = (pattern = RegexEnum.NormHourMorning.getPattern()).matcher(this.timeExpression)).find()) {
            if (this.timeContext.getTunit()[3] == -1) {
                this.timeContext.getTunit()[3] = MomentEnum.morning.getHourTime();
            }
            this.preferFuture(3);
            this.isAllDayTime = false;
        }
        if ((match = (pattern = RegexEnum.NormHourNoon.getPattern()).matcher(this.timeExpression)).find()) {
            if (this.timeContext.getTunit()[3] >= 0 && this.timeContext.getTunit()[3] <= 10) {
                int[] nArray = this.timeContext.getTunit();
                nArray[3] = nArray[3] + 12;
            }
            if (this.timeContext.getTunit()[3] == -1) {
                this.timeContext.getTunit()[3] = MomentEnum.noon.getHourTime();
            }
            this.preferFuture(3);
            this.isAllDayTime = false;
        }
        if ((match = (pattern = RegexEnum.NormHourAfternoon.getPattern()).matcher(this.timeExpression)).find()) {
            if (this.timeContext.getTunit()[3] >= 0 && this.timeContext.getTunit()[3] <= 11) {
                int[] nArray = this.timeContext.getTunit();
                nArray[3] = nArray[3] + 12;
            }
            if (this.timeContext.getTunit()[3] == -1) {
                this.timeContext.getTunit()[3] = MomentEnum.afternoon.getHourTime();
            }
            this.preferFuture(3);
            this.isAllDayTime = false;
        }
        if ((match = (pattern = RegexEnum.NormHourNight.getPattern()).matcher(this.timeExpression)).find()) {
            if (this.timeContext.getTunit()[3] >= 1 && this.timeContext.getTunit()[3] <= 11) {
                int[] nArray = this.timeContext.getTunit();
                nArray[3] = nArray[3] + 12;
            } else if (this.timeContext.getTunit()[3] == 12) {
                this.timeContext.getTunit()[3] = 0;
            } else if (this.timeContext.getTunit()[3] == -1) {
                this.timeContext.getTunit()[3] = MomentEnum.night.getHourTime();
            }
            this.preferFuture(3);
            this.isAllDayTime = false;
        }
    }

    private void normMinute() {
        Pattern pattern = RegexEnum.NormMinuteSpec.getPattern();
        Matcher match = pattern.matcher(this.timeExpression);
        if (match.find()) {
            return;
        }
        pattern = RegexEnum.NormMinute.getPattern();
        match = pattern.matcher(this.timeExpression);
        if (match.find() && !match.group().equals("")) {
            this.timeContext.getTunit()[4] = Integer.parseInt(match.group());
            this.preferFuture(4);
            this.isAllDayTime = false;
        }
        if ((match = (pattern = RegexEnum.NormMinuteOneQuarter.getPattern()).matcher(this.timeExpression)).find()) {
            this.timeContext.getTunit()[4] = 15;
            this.preferFuture(4);
            this.isAllDayTime = false;
        }
        if ((match = (pattern = RegexEnum.NormMinuteHalf.getPattern()).matcher(this.timeExpression)).find()) {
            this.timeContext.getTunit()[4] = 30;
            this.preferFuture(4);
            this.isAllDayTime = false;
        }
        if ((match = (pattern = RegexEnum.NormMinuteThreeQuarter.getPattern()).matcher(this.timeExpression)).find()) {
            this.timeContext.getTunit()[4] = 45;
            this.preferFuture(4);
            this.isAllDayTime = false;
        }
    }

    private void normSecond() {
        Pattern pattern = RegexEnum.NormSecondSpec.getPattern();
        Matcher match = pattern.matcher(this.timeExpression);
        if (match.find()) {
            return;
        }
        pattern = RegexEnum.NormSecond.getPattern();
        match = pattern.matcher(this.timeExpression);
        if (match.find()) {
            this.timeContext.getTunit()[5] = Integer.parseInt(match.group());
            this.isAllDayTime = false;
        }
    }

    private void normTotal() {
        String tmpTarget;
        String[] tmpParser;
        Pattern pattern = RegexEnum.NormTotalTime.getPattern();
        Matcher match = pattern.matcher(this.timeExpression);
        if (match.find()) {
            tmpParser = new String[3];
            tmpTarget = match.group();
            tmpParser = tmpTarget.split(":");
            this.timeContext.getTunit()[3] = Integer.parseInt(tmpParser[0]);
            this.timeContext.getTunit()[4] = Integer.parseInt(tmpParser[1]);
            this.timeContext.getTunit()[5] = Integer.parseInt(tmpParser[2]);
            this.preferFuture(3);
            this.isAllDayTime = false;
        } else {
            pattern = RegexEnum.NormTotalTimeShort.getPattern();
            match = pattern.matcher(this.timeExpression);
            if (match.find()) {
                tmpParser = new String[2];
                tmpTarget = match.group();
                tmpParser = tmpTarget.split(":");
                this.timeContext.getTunit()[3] = Integer.parseInt(tmpParser[0]);
                this.timeContext.getTunit()[4] = Integer.parseInt(tmpParser[1]);
                this.preferFuture(3);
                this.isAllDayTime = false;
            }
        }
        pattern = RegexEnum.NormHourNoon.getPattern();
        match = pattern.matcher(this.timeExpression);
        if (match.find()) {
            if (this.timeContext.getTunit()[3] >= 0 && this.timeContext.getTunit()[3] <= 10) {
                int[] nArray = this.timeContext.getTunit();
                nArray[3] = nArray[3] + 12;
            }
            if (this.timeContext.getTunit()[3] == -1) {
                this.timeContext.getTunit()[3] = MomentEnum.noon.getHourTime();
            }
            this.preferFuture(3);
            this.isAllDayTime = false;
        }
        if ((match = (pattern = RegexEnum.NormHourAfternoon.getPattern()).matcher(this.timeExpression)).find()) {
            if (this.timeContext.getTunit()[3] >= 0 && this.timeContext.getTunit()[3] <= 11) {
                int[] nArray = this.timeContext.getTunit();
                nArray[3] = nArray[3] + 12;
            }
            if (this.timeContext.getTunit()[3] == -1) {
                this.timeContext.getTunit()[3] = MomentEnum.afternoon.getHourTime();
            }
            this.preferFuture(3);
            this.isAllDayTime = false;
        }
        if ((match = (pattern = RegexEnum.NormTotalNight.getPattern()).matcher(this.timeExpression)).find()) {
            if (this.timeContext.getTunit()[3] >= 1 && this.timeContext.getTunit()[3] <= 11) {
                int[] nArray = this.timeContext.getTunit();
                nArray[3] = nArray[3] + 12;
            } else if (this.timeContext.getTunit()[3] == 12) {
                this.timeContext.getTunit()[3] = 0;
            }
            if (this.timeContext.getTunit()[3] == -1) {
                this.timeContext.getTunit()[3] = MomentEnum.night.getHourTime();
            }
            this.preferFuture(3);
            this.isAllDayTime = false;
        }
        if ((match = (pattern = RegexEnum.NormTotalDateOne.getPattern()).matcher(this.timeExpression)).find()) {
            tmpParser = new String[3];
            tmpTarget = match.group();
            tmpParser = tmpTarget.split("-");
            this.timeContext.getTunit()[0] = Integer.parseInt(tmpParser[0]);
            this.timeContext.getTunit()[1] = Integer.parseInt(tmpParser[1]);
            this.timeContext.getTunit()[2] = Integer.parseInt(tmpParser[2]);
        }
        if ((match = (pattern = RegexEnum.NormTotalDateTwo.getPattern()).matcher(this.timeExpression)).find()) {
            tmpParser = new String[3];
            tmpTarget = match.group();
            tmpParser = tmpTarget.split("/");
            this.timeContext.getTunit()[1] = Integer.parseInt(tmpParser[0]);
            this.timeContext.getTunit()[2] = Integer.parseInt(tmpParser[1]);
            this.timeContext.getTunit()[0] = Integer.parseInt(tmpParser[2]);
        }
        if ((match = (pattern = RegexEnum.NormTotalDateThree.getPattern()).matcher(this.timeExpression)).find()) {
            tmpParser = new String[3];
            tmpTarget = match.group();
            tmpParser = tmpTarget.split("\\.");
            this.timeContext.getTunit()[0] = Integer.parseInt(tmpParser[0]);
            this.timeContext.getTunit()[1] = Integer.parseInt(tmpParser[1]);
            this.timeContext.getTunit()[2] = Integer.parseInt(tmpParser[2]);
        }
    }

    private void normBaseRelated() {
        int year;
        int month;
        int day;
        String[] timeGrid = new String[6];
        timeGrid = this.timeContextOrigin.getTimeBase().split("-");
        int[] ini = new int[6];
        for (int i = 0; i < 6; ++i) {
            ini[i] = Integer.parseInt(timeGrid[i]);
        }
        LocalDateTime localDateTime = LocalDateTime.of(ini[0], ini[1], ini[2], ini[3], ini[4], ini[5]);
        boolean flag = false;
        Pattern pattern = RegexEnum.NormBaseRelatedDayBefore.getPattern();
        Matcher match = pattern.matcher(this.timeExpression);
        if (match.find()) {
            flag = true;
            day = Integer.parseInt(match.group());
            localDateTime = localDateTime.minusDays(day);
        }
        if ((match = (pattern = RegexEnum.NormBaseRelatedDayAfter.getPattern()).matcher(this.timeExpression)).find()) {
            flag = true;
            day = Integer.parseInt(match.group());
            localDateTime = localDateTime.plusDays(day);
        }
        if ((match = (pattern = RegexEnum.NormBaseRelatedMonthBefore.getPattern()).matcher(this.timeExpression)).find()) {
            flag = true;
            month = Integer.parseInt(match.group());
            localDateTime = localDateTime.minusMonths(month);
        }
        if ((match = (pattern = RegexEnum.NormBaseRelatedMonthAfter.getPattern()).matcher(this.timeExpression)).find()) {
            flag = true;
            month = Integer.parseInt(match.group());
            localDateTime = localDateTime.plusMonths(month);
        }
        if ((match = (pattern = RegexEnum.NormBaseRelatedYearBefore.getPattern()).matcher(this.timeExpression)).find()) {
            flag = true;
            year = Integer.parseInt(match.group());
            localDateTime = localDateTime.minusYears(year);
        }
        if ((match = (pattern = RegexEnum.NormBaseRelatedYearAfter.getPattern()).matcher(this.timeExpression)).find()) {
            flag = true;
            year = Integer.parseInt(match.group());
            localDateTime = localDateTime.plusYears(year);
        }
        if (flag) {
            this.setUnitValues(localDateTime);
        }
    }

    private void normBaseTimeRelated() {
        int minute;
        Matcher matchSecondAfter;
        Matcher matchSecondBefore;
        int hour;
        Matcher matchMinuteAfter;
        Matcher matchMinuteBefore;
        int hour2;
        String[] timeGrid = new String[6];
        timeGrid = this.timeContextOrigin.getTimeBase().split("-");
        int[] ini = new int[6];
        for (int i = 0; i < 6; ++i) {
            ini[i] = Integer.parseInt(timeGrid[i]);
        }
        LocalDateTime localDateTime = LocalDateTime.of(ini[0], ini[1], ini[2], ini[3], ini[4], ini[5]);
        boolean flag = false;
        Pattern pattern = RegexEnum.NormBaseTimeRelatedHourBefore.getPattern();
        Matcher match = pattern.matcher(this.timeExpression);
        if (match.find()) {
            flag = true;
            hour2 = Integer.parseInt(match.group());
            localDateTime = localDateTime.minusHours(hour2);
        }
        if ((match = (pattern = RegexEnum.NormBaseTimeRelatedHourAfter.getPattern()).matcher(this.timeExpression)).find()) {
            flag = true;
            hour2 = Integer.parseInt(match.group());
            localDateTime = localDateTime.plusHours(hour2);
        }
        if ((match = (pattern = RegexEnum.NormBaseTimeRelatedHalfHourBefore.getPattern()).matcher(this.timeExpression)).find()) {
            flag = true;
            localDateTime = localDateTime.minusMinutes(30L);
        }
        if ((match = (pattern = RegexEnum.NormBaseTimeRelatedHalfHourAfter.getPattern()).matcher(this.timeExpression)).find()) {
            flag = true;
            localDateTime = localDateTime.plusMinutes(30L);
        }
        if ((matchMinuteBefore = (pattern = RegexEnum.NormBaseTimeRelatedMinuteBefore.getPattern()).matcher(this.timeExpression)).find()) {
            flag = true;
            int minute2 = Integer.parseInt(matchMinuteBefore.group());
            localDateTime = localDateTime.minusMinutes(minute2);
        }
        if ((matchMinuteAfter = (pattern = RegexEnum.NormBaseTimeRelatedMinuteAfter.getPattern()).matcher(this.timeExpression)).find()) {
            flag = true;
            int minute3 = Integer.parseInt(matchMinuteAfter.group());
            localDateTime = localDateTime.plusMinutes(minute3);
        }
        if (matchMinuteBefore.find() && (match = (pattern = RegexEnum.NormBaseTimeRelatedHour.getPattern()).matcher(this.timeExpression)).find()) {
            flag = true;
            hour = Integer.parseInt(match.group());
            localDateTime = localDateTime.minusHours(hour);
        }
        if (matchMinuteAfter.find() && (match = (pattern = RegexEnum.NormBaseTimeRelatedHour.getPattern()).matcher(this.timeExpression)).find()) {
            flag = true;
            hour = Integer.parseInt(match.group());
            localDateTime = localDateTime.plusHours(hour);
        }
        if ((matchSecondBefore = (pattern = RegexEnum.NormBaseTimeRelatedSecondBefore.getPattern()).matcher(this.timeExpression)).find()) {
            flag = true;
            int second = Integer.parseInt(matchSecondBefore.group());
            localDateTime = localDateTime.minusSeconds(second);
        }
        if ((matchSecondAfter = (pattern = RegexEnum.NormBaseTimeRelatedSecondAfter.getPattern()).matcher(this.timeExpression)).find()) {
            flag = true;
            int second = Integer.parseInt(matchSecondAfter.group());
            localDateTime = localDateTime.plusSeconds(second);
        }
        if (matchSecondBefore.find() && (match = (pattern = RegexEnum.NormBaseTimeRelatedMinute.getPattern()).matcher(this.timeExpression)).find()) {
            flag = true;
            minute = Integer.parseInt(match.group());
            localDateTime = localDateTime.minusMinutes(minute);
        }
        if (matchSecondAfter.find() && (match = (pattern = RegexEnum.NormBaseTimeRelatedMinute.getPattern()).matcher(this.timeExpression)).find()) {
            flag = true;
            minute = Integer.parseInt(match.group());
            localDateTime = localDateTime.plusMinutes(minute);
        }
        if (flag) {
            this.setUnitValues(localDateTime);
        }
    }

    private void normCurRelated() {
        int week;
        String[] timeGrid = new String[6];
        timeGrid = this.timeContextOrigin.getOldTimeBase().split("-");
        int[] ini = new int[6];
        for (int i = 0; i < 6; ++i) {
            ini[i] = Integer.parseInt(timeGrid[i]);
        }
        LocalDateTime localDateTime = LocalDateTime.of(ini[0], ini[1], ini[2], ini[3], ini[4], ini[5]);
        boolean[] flag = new boolean[]{false, false, false};
        Pattern pattern = RegexEnum.NormCurRelatedYearBeforeLast.getPattern();
        Matcher match = pattern.matcher(this.timeExpression);
        if (match.find()) {
            flag[0] = true;
            localDateTime = localDateTime.minusYears(2L);
        }
        if ((match = (pattern = RegexEnum.NormCurRelatedYearBefore.getPattern()).matcher(this.timeExpression)).find()) {
            flag[0] = true;
            localDateTime = localDateTime.minusYears(1L);
        }
        if ((match = (pattern = RegexEnum.NormCurRelatedYear.getPattern()).matcher(this.timeExpression)).find()) {
            flag[0] = true;
            localDateTime = localDateTime.plusYears(0L);
        }
        if ((match = (pattern = RegexEnum.NormCurRelatedYearAfter.getPattern()).matcher(this.timeExpression)).find()) {
            flag[0] = true;
            localDateTime = localDateTime.plusYears(1L);
        }
        if ((match = (pattern = RegexEnum.NormCurRelatedYearAfterNext.getPattern()).matcher(this.timeExpression)).find()) {
            flag[0] = true;
            localDateTime = localDateTime.plusYears(2L);
        }
        if ((match = (pattern = RegexEnum.NormCurRelatedMonthBefore.getPattern()).matcher(this.timeExpression)).find()) {
            flag[1] = true;
            localDateTime = localDateTime.minusMonths(1L);
        }
        if ((match = (pattern = RegexEnum.NormCurRelatedMonth.getPattern()).matcher(this.timeExpression)).find()) {
            flag[1] = true;
            localDateTime = localDateTime.plusMonths(0L);
        }
        if ((match = (pattern = RegexEnum.NormCurRelatedMonthAfter.getPattern()).matcher(this.timeExpression)).find()) {
            flag[1] = true;
            localDateTime = localDateTime.plusMonths(1L);
        }
        if ((match = (pattern = RegexEnum.NormCurRelatedDayBeforeThree.getPattern()).matcher(this.timeExpression)).find()) {
            flag[2] = true;
            localDateTime = localDateTime.minusDays(3L);
        }
        if ((match = (pattern = RegexEnum.NormCurRelatedDayBeforeLast.getPattern()).matcher(this.timeExpression)).find()) {
            flag[2] = true;
            localDateTime = localDateTime.minusDays(2L);
        }
        if ((match = (pattern = RegexEnum.NormCurRelatedDayYesterday.getPattern()).matcher(this.timeExpression)).find()) {
            flag[2] = true;
            localDateTime = localDateTime.minusDays(1L);
        }
        if ((match = (pattern = RegexEnum.NormCurRelatedDayToday.getPattern()).matcher(this.timeExpression)).find()) {
            flag[2] = true;
            localDateTime = localDateTime.plusDays(0L);
        }
        if ((match = (pattern = RegexEnum.NormCurRelatedDayTomorrow.getPattern()).matcher(this.timeExpression)).find()) {
            flag[2] = true;
            localDateTime = localDateTime.plusDays(1L);
        }
        if ((match = (pattern = RegexEnum.NormCurRelatedDayAfterNext.getPattern()).matcher(this.timeExpression)).find()) {
            flag[2] = true;
            localDateTime = localDateTime.plusDays(2L);
        }
        if ((match = (pattern = RegexEnum.NormCurRelatedDayAfterThree.getPattern()).matcher(this.timeExpression)).find()) {
            flag[2] = true;
            localDateTime = localDateTime.plusDays(3L);
        }
        if ((match = (pattern = RegexEnum.NormCurRelatedWeekBeforeLast.getPattern()).matcher(this.timeExpression)).find()) {
            flag[2] = true;
            try {
                week = Integer.parseInt(match.group());
            }
            catch (NumberFormatException e) {
                week = 1;
            }
            localDateTime = localDateTime.minusWeeks(2L);
            localDateTime = DateTimeCalculatorUtil.withDayOfWeek(localDateTime, (long)week);
        }
        if ((match = (pattern = RegexEnum.NormCurRelatedWeekBefore.getPattern()).matcher(this.timeExpression)).find()) {
            flag[2] = true;
            try {
                week = Integer.parseInt(match.group());
            }
            catch (NumberFormatException e) {
                week = 1;
            }
            localDateTime = localDateTime.minusWeeks(1L);
            localDateTime = DateTimeCalculatorUtil.withDayOfWeek(localDateTime, (long)week);
        }
        if ((match = (pattern = RegexEnum.NormCurRelatedWeekAfter.getPattern()).matcher(this.timeExpression)).find()) {
            flag[2] = true;
            try {
                week = Integer.parseInt(match.group());
            }
            catch (NumberFormatException e) {
                week = 1;
            }
            localDateTime = localDateTime.plusWeeks(1L);
            localDateTime = DateTimeCalculatorUtil.withDayOfWeek(localDateTime, (long)week);
        }
        if ((match = (pattern = RegexEnum.NormCurRelatedWeekAfterNext.getPattern()).matcher(this.timeExpression)).find()) {
            flag[2] = true;
            try {
                week = Integer.parseInt(match.group());
            }
            catch (NumberFormatException e) {
                week = 1;
            }
            localDateTime = localDateTime.plusWeeks(2L);
            localDateTime = DateTimeCalculatorUtil.withDayOfWeek(localDateTime, (long)week);
        }
        if ((match = (pattern = RegexEnum.NormCurRelatedWeek.getPattern()).matcher(this.timeExpression)).find()) {
            flag[2] = true;
            try {
                week = Integer.parseInt(match.group());
            }
            catch (NumberFormatException e) {
                week = 1;
            }
            localDateTime = localDateTime.plusWeeks(0L);
            localDateTime = DateTimeCalculatorUtil.withDayOfWeek(localDateTime, (long)week);
            localDateTime = this.preferFutureWeek(week, localDateTime);
        }
        String s = DateTimeFormatterUtil.format(localDateTime, "yyyy-MM-dd-HH-mm-ss");
        String[] timeFin = s.split("-");
        if (flag[0] || flag[1] || flag[2]) {
            this.timeContext.getTunit()[0] = Integer.parseInt(timeFin[0]);
        }
        if (flag[1] || flag[2]) {
            this.timeContext.getTunit()[1] = Integer.parseInt(timeFin[1]);
        }
        if (flag[2]) {
            this.timeContext.getTunit()[2] = Integer.parseInt(timeFin[2]);
        }
    }

    private LocalDateTime preferFutureWeek(int weekday, LocalDateTime localDateTime) {
        int curWeekday;
        if (!this.textAnalysis.isPreferFuture()) {
            return localDateTime;
        }
        int checkTimeIndex = 2;
        for (int i = 0; i < checkTimeIndex; ++i) {
            if (this.timeContext.getTunit()[i] == -1) continue;
            return localDateTime;
        }
        LocalDateTime curDateTime = LocalDateTime.now();
        if (this.timeContextOrigin.getTimeBase() != null) {
            String[] ini = this.timeContextOrigin.getTimeBase().split("-");
            curDateTime = LocalDateTime.of((int)Integer.valueOf(ini[0]), Integer.valueOf(ini[1]), (int)Integer.valueOf(ini[2]), (int)Integer.valueOf(ini[3]), (int)Integer.valueOf(ini[4]), (int)Integer.valueOf(ini[5]));
        }
        if ((curWeekday = curDateTime.get(ChronoField.DAY_OF_WEEK)) < weekday) {
            return localDateTime;
        }
        return localDateTime.plusWeeks(1L);
    }

    private void modifyTimeBase() {
        String[] timeGrid = new String[6];
        timeGrid = this.timeContextOrigin.getTimeBase().split("-");
        String s = "";
        s = this.timeContext.getTunit()[0] != -1 ? s + Integer.toString(this.timeContext.getTunit()[0]) : s + timeGrid[0];
        for (int i = 1; i < 6; ++i) {
            s = s + "-";
            s = this.timeContext.getTunit()[i] != -1 ? s + Integer.toString(this.timeContext.getTunit()[i]) : s + timeGrid[i];
        }
        this.timeContextOrigin.setTimeBase(s);
    }

    private void timeNormalization() {
        int tunitpointer;
        LocalDateTime localDateTime = this.normStandardTime();
        if (localDateTime == null) {
            this.normYear();
            this.normMonth();
            this.normDay();
            this.normMonthFuzzyDay();
            this.normBaseRelated();
            this.normBaseTimeRelated();
            this.normCurRelated();
            this.normHour();
            this.normMinute();
            this.normSecond();
            this.normTotal();
            this.modifyTimeBase();
            localDateTime = LocalDateTime.of(1970, 1, 1, 0, 0);
        }
        String[] timeGrid = new String[6];
        timeGrid = this.timeContextOrigin.getTimeBase().split("-");
        for (tunitpointer = 5; tunitpointer >= 0 && this.timeContext.getTunit()[tunitpointer] < 0; --tunitpointer) {
        }
        for (int i = 0; i < tunitpointer; ++i) {
            if (this.timeContext.getTunit()[i] >= 0) continue;
            this.timeContext.getTunit()[i] = Integer.parseInt(timeGrid[i]);
        }
        String[] resultTmp = new String[6];
        resultTmp[0] = String.valueOf(this.timeContext.getTunit()[0]);
        if (this.timeContext.getTunit()[0] >= 10 && this.timeContext.getTunit()[0] < 100) {
            resultTmp[0] = "19" + String.valueOf(this.timeContext.getTunit()[0]);
        }
        if (this.timeContext.getTunit()[0] > 0 && this.timeContext.getTunit()[0] < 10) {
            resultTmp[0] = "200" + String.valueOf(this.timeContext.getTunit()[0]);
        }
        for (int i = 1; i < 6; ++i) {
            resultTmp[i] = String.valueOf(this.timeContext.getTunit()[i]);
        }
        if (Integer.parseInt(resultTmp[0]) != -1) {
            this.timeNorm = this.timeNorm + resultTmp[0] + "\u5e74";
            localDateTime = localDateTime.withYear(Integer.valueOf(resultTmp[0]));
            if (Integer.parseInt(resultTmp[1]) != -1) {
                this.timeNorm = this.timeNorm + resultTmp[1] + "\u6708";
                localDateTime = localDateTime.withMonth(Integer.valueOf(resultTmp[1]));
                if (Integer.parseInt(resultTmp[2]) != -1) {
                    this.timeNorm = this.timeNorm + resultTmp[2] + "\u65e5";
                    localDateTime = localDateTime.withDayOfMonth(Integer.valueOf(resultTmp[2]));
                    if (Integer.parseInt(resultTmp[3]) != -1) {
                        this.timeNorm = this.timeNorm + resultTmp[3] + "\u65f6";
                        localDateTime = localDateTime.withHour(Integer.valueOf(resultTmp[3]));
                        if (Integer.parseInt(resultTmp[4]) != -1) {
                            this.timeNorm = this.timeNorm + resultTmp[4] + "\u5206";
                            localDateTime = localDateTime.withMinute(Integer.valueOf(resultTmp[4]));
                            if (Integer.parseInt(resultTmp[5]) != -1) {
                                this.timeNorm = this.timeNorm + resultTmp[5] + "\u79d2";
                                localDateTime = localDateTime.withSecond(Integer.valueOf(resultTmp[5]));
                            }
                        }
                    }
                }
            }
        }
        this.timeContextOrigin.setTunit((int[])this.timeContext.getTunit().clone());
        this.timeContext.setTimeBase(this.timeContextOrigin.getTimeBase());
        this.timeContext.setOldTimeBase(this.timeContextOrigin.getOldTimeBase());
        this.time = DateTimeConverterUtil.toDate(localDateTime);
        this.timeNormFormat = DateTimeFormatterUtil.format(localDateTime, DateTimeFormatterUtil.YYYY_MM_DD_HH_MM_SS_FMT);
    }

    public Boolean getIsAllDayTime() {
        return this.isAllDayTime;
    }

    public void setIsAllDayTime(Boolean isAllDayTime) {
        this.isAllDayTime = isAllDayTime;
    }

    public String toString() {
        return this.timeExpression + " ---> " + this.timeNormFormat;
    }

    private void preferFuture(int checkTimeIndex) {
        Pattern pattern;
        Matcher match;
        int i;
        for (i = 0; i < checkTimeIndex; ++i) {
            if (this.timeContext.getTunit()[i] == -1) continue;
            return;
        }
        this.checkContextTime(checkTimeIndex);
        for (i = 0; i < checkTimeIndex; ++i) {
            if (this.timeContext.getTunit()[i] == -1) continue;
            return;
        }
        if (!this.textAnalysis.isPreferFuture()) {
            return;
        }
        LocalDateTime localDateTime = LocalDateTime.now();
        if (this.timeContextOrigin.getTimeBase() != null) {
            String[] ini = this.timeContextOrigin.getTimeBase().split("-");
            localDateTime = LocalDateTime.of((int)Integer.valueOf(ini[0]), Integer.valueOf(ini[1]), (int)Integer.valueOf(ini[2]), (int)Integer.valueOf(ini[3]), (int)Integer.valueOf(ini[4]), (int)Integer.valueOf(ini[5]));
        }
        int curTime = localDateTime.get((TemporalField)TUNIT_MAP.get(checkTimeIndex));
        if (checkTimeIndex == 3 && this.timeContext.getTunit()[3] >= 0 && this.timeContext.getTunit()[3] <= 11 ? (match = (pattern = RegexEnum.NormHourAfternoon.getPattern()).matcher(this.timeExpression)).find() && curTime < this.timeContext.getTunit()[3] + 12 : curTime < this.timeContext.getTunit()[checkTimeIndex]) {
            return;
        }
        localDateTime = localDateTime.plus(1L, (TemporalUnit)TUNIT_MAP.get(checkTimeIndex - 1 + 10));
        for (int i2 = 0; i2 < checkTimeIndex; ++i2) {
            this.timeContext.getTunit()[i2] = localDateTime.get((TemporalField)TUNIT_MAP.get(i2));
        }
    }

    private void checkContextTime(int checkTimeIndex) {
        for (int i = 0; i < checkTimeIndex; ++i) {
            if (this.timeContext.getTunit()[i] != -1 || this.timeContextOrigin.getTunit()[i] == -1) continue;
            this.timeContext.getTunit()[i] = this.timeContextOrigin.getTunit()[i];
        }
        if (this.isFirstTimeSolveContext && checkTimeIndex == 3 && this.timeContextOrigin.getTunit()[checkTimeIndex] >= 12 && this.timeContext.getTunit()[checkTimeIndex] < 12) {
            int[] nArray = this.timeContext.getTunit();
            int n = checkTimeIndex;
            nArray[n] = nArray[n] + 12;
        }
        this.isFirstTimeSolveContext = false;
    }

    public static List<TimeNLP> filterTimeUnit(List<TimeNLP> timeNLPList) {
        if (CollectionUtil.isEmpty(timeNLPList)) {
            return timeNLPList;
        }
        ArrayList<TimeNLP> list = new ArrayList<TimeNLP>();
        for (TimeNLP t : timeNLPList) {
            if (t == null || t.getTime().getTime() == -28800000L) continue;
            list.add(t);
        }
        return list;
    }

    private void setUnitValues(LocalDateTime localDateTime) {
        String s = DateTimeFormatterUtil.format(localDateTime, "yyyy-MM-dd-HH-mm-ss");
        String[] timeFin = s.split("-");
        this.timeContext.getTunit()[0] = Integer.parseInt(timeFin[0]);
        this.timeContext.getTunit()[1] = Integer.parseInt(timeFin[1]);
        this.timeContext.getTunit()[2] = Integer.parseInt(timeFin[2]);
        this.timeContext.getTunit()[3] = Integer.parseInt(timeFin[3]);
        this.timeContext.getTunit()[4] = Integer.parseInt(timeFin[4]);
        this.timeContext.getTunit()[5] = Integer.parseInt(timeFin[5]);
    }

    public String getTimeExpression() {
        return this.timeExpression;
    }

    public void setTimeExpression(String timeExpression) {
        this.timeExpression = timeExpression;
    }

    public String getTimeNorm() {
        return this.timeNorm;
    }

    public void setTimeNorm(String timeNorm) {
        this.timeNorm = timeNorm;
    }

    public String getTimeNormFormat() {
        return this.timeNormFormat;
    }

    public void setTimeNormFormat(String timeNormFormat) {
        this.timeNormFormat = timeNormFormat;
    }

    public TimeContext getTimeContext() {
        return this.timeContext;
    }

    public void setTimeContext(TimeContext timeContext) {
        this.timeContext = timeContext;
    }

    public void setTime(Date time) {
        this.time = time;
    }

    static {
        TUNIT_MAP.put(0, ChronoField.YEAR);
        TUNIT_MAP.put(1, ChronoField.MONTH_OF_YEAR);
        TUNIT_MAP.put(2, ChronoField.DAY_OF_MONTH);
        TUNIT_MAP.put(3, ChronoField.HOUR_OF_DAY);
        TUNIT_MAP.put(4, ChronoField.MINUTE_OF_HOUR);
        TUNIT_MAP.put(5, ChronoField.SECOND_OF_MINUTE);
        TUNIT_MAP.put(10, ChronoUnit.YEARS);
        TUNIT_MAP.put(11, ChronoUnit.MONTHS);
        TUNIT_MAP.put(12, ChronoUnit.DAYS);
        TUNIT_MAP.put(13, ChronoUnit.HOURS);
        TUNIT_MAP.put(14, ChronoUnit.MINUTES);
        TUNIT_MAP.put(15, ChronoUnit.SECONDS);
    }
}

