/*
 * Decompiled with CFR 0.152.
 */
package com.hbzhou.open.flowcamera;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Matrix;
import android.graphics.SurfaceTexture;
import android.media.MediaPlayer;
import android.media.MediaScannerConnection;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.Surface;
import android.view.TextureView;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.MimeTypeMap;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.Toast;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.camera.core.ImageCapture;
import androidx.camera.core.ImageCaptureException;
import androidx.camera.core.VideoCapture;
import androidx.camera.view.CameraView;
import androidx.core.app.ActivityCompat;
import androidx.core.content.ContextCompat;
import androidx.lifecycle.LifecycleEventObserver;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.LifecycleOwner;
import com.bumptech.glide.Glide;
import com.hbzhou.open.flowcamera.CaptureLayout;
import com.hbzhou.open.flowcamera.CaptureListener;
import com.hbzhou.open.flowcamera.R;
import com.hbzhou.open.flowcamera.listener.ClickListener;
import com.hbzhou.open.flowcamera.listener.FlowCameraListener;
import com.hbzhou.open.flowcamera.listener.OnVideoPlayPrepareListener;
import com.hbzhou.open.flowcamera.listener.TypeListener;
import com.hbzhou.open.flowcamera.util.LogUtil;
import com.hbzhou.open.flowcamera.util.ScreenUtils;
import java.io.File;
import java.io.IOException;
import java.util.Objects;

public class FlowCameraView
extends FrameLayout {
    private static final int TYPE_FLASH_AUTO = 33;
    private static final int TYPE_FLASH_ON = 34;
    private static final int TYPE_FLASH_OFF = 35;
    private int type_flash = 35;
    public static final int BUTTON_STATE_ONLY_CAPTURE = 257;
    public static final int BUTTON_STATE_ONLY_RECORDER = 258;
    public static final int BUTTON_STATE_BOTH = 259;
    private FlowCameraListener flowCameraListener;
    private ClickListener leftClickListener;
    private Context mContext;
    private CameraView mVideoView;
    private ImageView mPhoto;
    private ImageView mSwitchCamera;
    private ImageView mFlashLamp;
    private CaptureLayout mCaptureLayout;
    private MediaPlayer mMediaPlayer;
    private TextureView mTextureView;
    private File videoFile;
    private File photoFile;
    private int iconSrc;
    private int iconLeft;
    private int iconRight;
    private int duration;
    private long recordTime = 0L;

    public FlowCameraView(Context context) {
        this(context, null);
    }

    public FlowCameraView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public FlowCameraView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mContext = context;
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.FlowCameraView, defStyleAttr, 0);
        this.iconSrc = a.getResourceId(R.styleable.FlowCameraView_iconSrc, R.drawable.ic_camera);
        this.iconLeft = a.getResourceId(R.styleable.FlowCameraView_iconLeft, 0);
        this.iconRight = a.getResourceId(R.styleable.FlowCameraView_iconRight, 0);
        this.duration = a.getInteger(R.styleable.FlowCameraView_duration_max, 10000);
        a.recycle();
        this.initView();
    }

    public void initView() {
        this.setWillNotDraw(false);
        View view = LayoutInflater.from((Context)this.mContext).inflate(R.layout.flow_camera_view, (ViewGroup)this);
        this.mVideoView = (CameraView)view.findViewById(R.id.video_preview);
        this.mTextureView = (TextureView)view.findViewById(R.id.mVideo);
        this.mPhoto = (ImageView)view.findViewById(R.id.image_photo);
        this.mSwitchCamera = (ImageView)view.findViewById(R.id.image_switch);
        this.mSwitchCamera.setImageResource(this.iconSrc);
        this.mFlashLamp = (ImageView)view.findViewById(R.id.image_flash);
        this.setFlashRes();
        this.mFlashLamp.setOnClickListener(v -> {
            ++this.type_flash;
            if (this.type_flash > 35) {
                this.type_flash = 33;
            }
            this.setFlashRes();
        });
        this.mVideoView.enableTorch(true);
        this.mVideoView.setCaptureMode(CameraView.CaptureMode.MIXED);
        this.mCaptureLayout = (CaptureLayout)view.findViewById(R.id.capture_layout);
        this.mCaptureLayout.setDuration(this.duration);
        this.mCaptureLayout.setIconSrc(this.iconLeft, this.iconRight);
        this.mSwitchCamera.setOnClickListener(v -> this.mVideoView.toggleCamera());
        this.mCaptureLayout.setCaptureLisenter(new CaptureListener(){

            @Override
            public void takePictures() {
                FlowCameraView.this.mSwitchCamera.setVisibility(4);
                FlowCameraView.this.mFlashLamp.setVisibility(4);
                Integer lensFacing = FlowCameraView.this.mVideoView.getCameraLensFacing();
                if (lensFacing == null) {
                    lensFacing = 1;
                }
                ImageCapture.OutputFileOptions.Builder outputFileOptions = new ImageCapture.OutputFileOptions.Builder(FlowCameraView.this.photoFile = FlowCameraView.this.initTakePicPath(FlowCameraView.this.mContext));
                ImageCapture.Metadata metadata = new ImageCapture.Metadata();
                metadata.setReversedHorizontal(0 == lensFacing);
                outputFileOptions.setMetadata(metadata);
                FlowCameraView.this.mVideoView.takePicture(outputFileOptions.build(), ContextCompat.getMainExecutor((Context)FlowCameraView.this.mContext), new ImageCapture.OnImageSavedCallback(){

                    public void onImageSaved(@NonNull ImageCapture.OutputFileResults outputFileResults) {
                        if (!FlowCameraView.this.photoFile.exists()) {
                            Toast.makeText((Context)FlowCameraView.this.mContext, (CharSequence)"\u56fe\u7247\u4fdd\u5b58\u51fa\u9519!", (int)1).show();
                            return;
                        }
                        Glide.with((Context)FlowCameraView.this.mContext).load(FlowCameraView.this.photoFile).into(FlowCameraView.this.mPhoto);
                        FlowCameraView.this.mPhoto.setVisibility(0);
                        FlowCameraView.this.mCaptureLayout.startTypeBtnAnimator();
                    }

                    public void onError(@NonNull ImageCaptureException exception) {
                        if (FlowCameraView.this.flowCameraListener != null) {
                            FlowCameraView.this.flowCameraListener.onError(exception.getImageCaptureError(), Objects.requireNonNull(exception.getMessage()), exception.getCause());
                        }
                    }
                });
            }

            @Override
            public void recordStart() {
                FlowCameraView.this.mSwitchCamera.setVisibility(4);
                FlowCameraView.this.mFlashLamp.setVisibility(4);
                FlowCameraView.this.mVideoView.startRecording(FlowCameraView.this.initStartRecordingPath(FlowCameraView.this.mContext), ContextCompat.getMainExecutor((Context)FlowCameraView.this.mContext), new VideoCapture.OnVideoSavedCallback(){

                    public void onVideoSaved(@NonNull File file) {
                        FlowCameraView.this.videoFile = file;
                        if (FlowCameraView.this.recordTime < 1500L && FlowCameraView.this.videoFile.exists() && FlowCameraView.this.videoFile.delete()) {
                            return;
                        }
                        FlowCameraView.this.mTextureView.setVisibility(0);
                        FlowCameraView.this.mCaptureLayout.startTypeBtnAnimator();
                        FlowCameraView.this.transformsTextureView(FlowCameraView.this.mTextureView);
                        if (FlowCameraView.this.mTextureView.isAvailable()) {
                            FlowCameraView.this.startVideoPlay(FlowCameraView.this.videoFile, () -> FlowCameraView.this.mVideoView.setVisibility(8));
                        } else {
                            FlowCameraView.this.mTextureView.setSurfaceTextureListener(new TextureView.SurfaceTextureListener(){

                                public void onSurfaceTextureAvailable(SurfaceTexture surface, int width, int height) {
                                    FlowCameraView.this.startVideoPlay(FlowCameraView.this.videoFile, () -> FlowCameraView.this.mVideoView.setVisibility(8));
                                }

                                public void onSurfaceTextureSizeChanged(SurfaceTexture surface, int width, int height) {
                                }

                                public boolean onSurfaceTextureDestroyed(SurfaceTexture surface) {
                                    return false;
                                }

                                public void onSurfaceTextureUpdated(SurfaceTexture surface) {
                                }
                            });
                        }
                    }

                    public void onError(int videoCaptureError, @NonNull String message, @Nullable Throwable cause) {
                        if (FlowCameraView.this.flowCameraListener != null) {
                            FlowCameraView.this.flowCameraListener.onError(videoCaptureError, message, cause);
                        }
                    }
                });
            }

            @Override
            public void recordShort(long time) {
                FlowCameraView.this.recordTime = time;
                FlowCameraView.this.mSwitchCamera.setVisibility(0);
                FlowCameraView.this.mFlashLamp.setVisibility(0);
                FlowCameraView.this.mCaptureLayout.resetCaptureLayout();
                FlowCameraView.this.mCaptureLayout.setTextWithAnimation("\u5f55\u5236\u65f6\u95f4\u8fc7\u77ed");
                FlowCameraView.this.mVideoView.stopRecording();
            }

            @Override
            public void recordEnd(long time) {
                FlowCameraView.this.recordTime = time;
                FlowCameraView.this.mVideoView.stopRecording();
            }

            @Override
            public void recordZoom(float zoom) {
            }

            @Override
            public void recordError() {
                if (FlowCameraView.this.flowCameraListener != null) {
                    FlowCameraView.this.flowCameraListener.onError(0, "\u672a\u77e5\u539f\u56e0!", null);
                }
            }
        });
        this.mCaptureLayout.setTypeLisenter(new TypeListener(){

            @Override
            public void cancel() {
                FlowCameraView.this.stopVideoPlay();
                FlowCameraView.this.resetState();
            }

            @Override
            public void confirm() {
                if (FlowCameraView.this.videoFile != null && FlowCameraView.this.videoFile.exists()) {
                    FlowCameraView.this.stopVideoPlay();
                    if (FlowCameraView.this.flowCameraListener != null) {
                        FlowCameraView.this.flowCameraListener.recordSuccess(FlowCameraView.this.videoFile);
                    }
                    FlowCameraView.this.scanPhotoAlbum(FlowCameraView.this.videoFile);
                } else if (FlowCameraView.this.photoFile != null && FlowCameraView.this.photoFile.exists()) {
                    FlowCameraView.this.mPhoto.setVisibility(4);
                    if (FlowCameraView.this.flowCameraListener != null) {
                        FlowCameraView.this.flowCameraListener.captureSuccess(FlowCameraView.this.photoFile);
                    }
                    FlowCameraView.this.scanPhotoAlbum(FlowCameraView.this.photoFile);
                }
            }
        });
        this.mCaptureLayout.setLeftClickListener(() -> {
            if (this.leftClickListener != null) {
                this.leftClickListener.onClick();
            }
        });
    }

    private void transformsTextureView(TextureView textureView) {
        Matrix matrix = new Matrix();
        int screenHeight = ScreenUtils.getScreenHeight(this.mContext);
        int screenWidth = ScreenUtils.getScreenWidth(this.mContext);
        int lensFacing = 1;
        if (this.mVideoView.getCameraLensFacing() != null) {
            lensFacing = this.mVideoView.getCameraLensFacing();
        }
        if (lensFacing == 0) {
            matrix.postScale(-1.0f, 1.0f, 1.0f * (float)screenWidth / 2.0f, 1.0f * (float)screenHeight / 2.0f);
        } else {
            matrix.postScale(1.0f, 1.0f, 1.0f * (float)screenWidth / 2.0f, 1.0f * (float)screenHeight / 2.0f);
        }
        textureView.setTransform(matrix);
    }

    private void scanPhotoAlbum(File dataFile) {
        if (dataFile == null) {
            return;
        }
        String mimeType = MimeTypeMap.getSingleton().getMimeTypeFromExtension(dataFile.getAbsolutePath().substring(dataFile.getAbsolutePath().lastIndexOf(".") + 1));
        MediaScannerConnection.scanFile((Context)this.mContext, (String[])new String[]{dataFile.getAbsolutePath()}, (String[])new String[]{mimeType}, null);
    }

    public File initTakePicPath(Context context) {
        return new File(context.getExternalMediaDirs()[0], System.currentTimeMillis() + ".jpeg");
    }

    public File initStartRecordingPath(Context context) {
        return new File(context.getExternalMediaDirs()[0], System.currentTimeMillis() + ".mp4");
    }

    public void setFlowCameraListener(FlowCameraListener flowCameraListener) {
        this.flowCameraListener = flowCameraListener;
    }

    public void setBindToLifecycle(LifecycleOwner lifecycleOwner) {
        if (ActivityCompat.checkSelfPermission((Context)((Context)lifecycleOwner), (String)"android.permission.CAMERA") != 0) {
            return;
        }
        this.mVideoView.bindToLifecycle(lifecycleOwner);
        lifecycleOwner.getLifecycle().addObserver((LifecycleObserver)((LifecycleEventObserver)(source, event) -> LogUtil.i("event---", event.toString())));
    }

    public void setRecordVideoMaxTime(int maxDurationTime) {
        this.mCaptureLayout.setDuration(maxDurationTime * 1000);
    }

    public void setCaptureMode(int state) {
        if (this.mCaptureLayout != null) {
            this.mCaptureLayout.setButtonFeatures(state);
        }
    }

    public void setLeftClickListener(ClickListener clickListener) {
        this.leftClickListener = clickListener;
    }

    private void setFlashRes() {
        switch (this.type_flash) {
            case 33: {
                this.mFlashLamp.setImageResource(R.drawable.ic_flash_auto);
                this.mVideoView.setFlash(0);
                break;
            }
            case 34: {
                this.mFlashLamp.setImageResource(R.drawable.ic_flash_on);
                this.mVideoView.setFlash(1);
                break;
            }
            case 35: {
                this.mFlashLamp.setImageResource(R.drawable.ic_flash_off);
                this.mVideoView.setFlash(2);
            }
        }
    }

    private void resetState() {
        if (this.mVideoView.isRecording()) {
            this.mVideoView.stopRecording();
        }
        if (this.videoFile != null && this.videoFile.exists() && this.videoFile.delete()) {
            LogUtil.i("videoFile is clear");
        }
        if (this.photoFile != null && this.photoFile.exists() && this.photoFile.delete()) {
            LogUtil.i("photoFile is clear");
        }
        this.mPhoto.setVisibility(4);
        this.mSwitchCamera.setVisibility(0);
        this.mFlashLamp.setVisibility(0);
        this.mVideoView.setVisibility(0);
        this.mCaptureLayout.resetCaptureLayout();
    }

    private void startVideoPlay(File videoFile, OnVideoPlayPrepareListener onVideoPlayPrepareListener) {
        try {
            if (this.mMediaPlayer == null) {
                this.mMediaPlayer = new MediaPlayer();
            }
            this.mMediaPlayer.setDataSource(videoFile.getAbsolutePath());
            this.mMediaPlayer.setSurface(new Surface(this.mTextureView.getSurfaceTexture()));
            this.mMediaPlayer.setLooping(true);
            this.mMediaPlayer.setOnPreparedListener(mp -> {
                mp.start();
                float ratio = (float)mp.getVideoWidth() * 1.0f / (float)mp.getVideoHeight();
                int width1 = this.mTextureView.getWidth();
                ViewGroup.LayoutParams layoutParams = this.mTextureView.getLayoutParams();
                layoutParams.height = (int)((float)width1 / ratio);
                this.mTextureView.setLayoutParams(layoutParams);
                if (onVideoPlayPrepareListener != null) {
                    onVideoPlayPrepareListener.onPrepared();
                }
            });
            this.mMediaPlayer.prepareAsync();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void stopVideoPlay() {
        if (this.mMediaPlayer != null) {
            this.mMediaPlayer.stop();
            this.mMediaPlayer.release();
            this.mMediaPlayer = null;
        }
        this.mTextureView.setVisibility(8);
    }
}

