/*
 * Decompiled with CFR 0.152.
 */
package pub.devrel.easypermissions.helper;

import android.app.Activity;
import android.app.Fragment;
import android.app.FragmentManager;
import android.content.Context;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.StyleRes;
import androidx.core.app.ActivityCompat;
import pub.devrel.easypermissions.RationaleDialogFragment;
import pub.devrel.easypermissions.helper.PermissionHelper;

class ActivityPermissionHelper
extends PermissionHelper<Activity> {
    private static final String TAG = "ActPermissionHelper";

    ActivityPermissionHelper(Activity host) {
        super(host);
    }

    @Override
    public void directRequestPermissions(int requestCode, String ... perms) {
        ActivityCompat.requestPermissions((Activity)((Activity)this.getHost()), (String[])perms, (int)requestCode);
    }

    @Override
    public boolean shouldShowRequestPermissionRationale(@NonNull String perm) {
        return ActivityCompat.shouldShowRequestPermissionRationale((Activity)((Activity)this.getHost()), (String)perm);
    }

    @Override
    public Context getContext() {
        return (Context)this.getHost();
    }

    @Override
    public void showRequestPermissionRationale(@NonNull String rationale, @NonNull String positiveButton, @NonNull String negativeButton, @StyleRes int theme, int requestCode, String ... perms) {
        FragmentManager fm = ((Activity)this.getHost()).getFragmentManager();
        Fragment fragment = fm.findFragmentByTag("RationaleDialogFragment");
        if (fragment instanceof RationaleDialogFragment) {
            Log.d((String)TAG, (String)"Found existing fragment, not showing rationale.");
            return;
        }
        RationaleDialogFragment.newInstance(positiveButton, negativeButton, rationale, theme, requestCode, perms).showAllowingStateLoss(fm, "RationaleDialogFragment");
    }
}

