/*
 * Decompiled with CFR 0.152.
 */
package com.bilibili.boxing_impl.ui;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentStatePagerAdapter;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.support.v7.widget.Toolbar;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.widget.Button;
import android.widget.ProgressBar;
import android.widget.Toast;
import com.bilibili.boxing.AbsBoxingViewActivity;
import com.bilibili.boxing.model.BoxingManager;
import com.bilibili.boxing.model.entity.BaseMedia;
import com.bilibili.boxing.model.entity.impl.ImageMedia;
import com.bilibili.boxing_impl.BoxingResHelper;
import com.bilibili.boxing_impl.R;
import com.bilibili.boxing_impl.ui.BoxingRawImageFragment;
import com.bilibili.boxing_impl.view.HackyViewPager;
import java.util.ArrayList;
import java.util.List;

public class BoxingViewActivity
extends AbsBoxingViewActivity {
    public static final String EXTRA_TYPE_BACK = "com.bilibili.boxing_impl.ui.BoxingViewActivity.type_back";
    HackyViewPager mGallery;
    ProgressBar mProgressBar;
    private boolean mNeedEdit;
    private boolean mNeedLoading;
    private boolean mFinishLoading;
    private boolean mNeedAllCount = true;
    private int mCurrentPage;
    private int mTotalCount;
    private int mStartPos;
    private int mPos;
    private int mMaxCount;
    private String mAlbumId;
    private Toolbar mToolbar;
    private ImagesAdapter mAdapter;
    private ImageMedia mCurrentImageItem;
    private Button mOkBtn;
    private ArrayList<BaseMedia> mImages;
    private ArrayList<BaseMedia> mSelectedImages;
    private MenuItem mSelectedMenuItem;

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_boxing_view);
        this.createToolbar();
        this.initData();
        this.initView();
        this.startLoading();
    }

    private void createToolbar() {
        this.mToolbar = (Toolbar)this.findViewById(R.id.nav_top_bar);
        this.setSupportActionBar(this.mToolbar);
        this.getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        this.mToolbar.setNavigationOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                BoxingViewActivity.this.onBackPressed();
            }
        });
        this.getSupportActionBar().setDisplayShowTitleEnabled(false);
    }

    private void initData() {
        this.mSelectedImages = this.getSelectedImages();
        this.mAlbumId = this.getAlbumId();
        this.mStartPos = this.getStartPos();
        this.mNeedLoading = BoxingManager.getInstance().getBoxingConfig().isNeedLoading();
        this.mNeedEdit = BoxingManager.getInstance().getBoxingConfig().isNeedEdit();
        this.mMaxCount = this.getMaxCount();
        this.mImages = new ArrayList();
        if (!this.mNeedLoading && this.mSelectedImages != null) {
            this.mImages.addAll(this.mSelectedImages);
        }
    }

    private void initView() {
        this.mAdapter = new ImagesAdapter(this.getSupportFragmentManager());
        this.mOkBtn = (Button)this.findViewById(R.id.image_items_ok);
        this.mGallery = (HackyViewPager)this.findViewById(R.id.pager);
        this.mProgressBar = (ProgressBar)this.findViewById(R.id.loading);
        this.mGallery.setAdapter((PagerAdapter)this.mAdapter);
        this.mGallery.addOnPageChangeListener((ViewPager.OnPageChangeListener)new OnPagerChangeListener());
        if (!this.mNeedEdit) {
            View chooseLayout = this.findViewById(R.id.item_choose_layout);
            chooseLayout.setVisibility(8);
        } else {
            this.setOkTextNumber();
            this.mOkBtn.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    BoxingViewActivity.this.finishByBackPressed(false);
                }
            });
        }
    }

    private void setOkTextNumber() {
        if (this.mNeedEdit) {
            int selectedSize = this.mSelectedImages.size();
            int size = Math.max(this.mSelectedImages.size(), this.mMaxCount);
            this.mOkBtn.setText((CharSequence)this.getString(R.string.boxing_image_preview_ok_fmt, new Object[]{String.valueOf(selectedSize), String.valueOf(size)}));
            this.mOkBtn.setEnabled(selectedSize > 0);
        }
    }

    private void finishByBackPressed(boolean value) {
        Intent intent = new Intent();
        intent.putParcelableArrayListExtra("com.bilibili.boxing.Boxing.selected_media", this.mSelectedImages);
        intent.putExtra(EXTRA_TYPE_BACK, value);
        this.setResult(-1, intent);
        this.finish();
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        super.onCreateOptionsMenu(menu2);
        if (this.mNeedEdit) {
            this.getMenuInflater().inflate(R.menu.activity_boxing_image_viewer, menu2);
            this.mSelectedMenuItem = menu2.findItem(R.id.menu_image_item_selected);
            if (this.mCurrentImageItem != null) {
                this.setMenuIcon(this.mCurrentImageItem.isSelected());
            } else {
                this.setMenuIcon(false);
            }
            return true;
        }
        return false;
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        int id2 = item.getItemId();
        if (id2 == R.id.menu_image_item_selected) {
            if (this.mCurrentImageItem == null) {
                return false;
            }
            if (this.mSelectedImages.size() >= this.mMaxCount && !this.mCurrentImageItem.isSelected()) {
                String warning = this.getString(R.string.boxing_max_image_over_fmt, new Object[]{this.mMaxCount});
                Toast.makeText((Context)this, (CharSequence)warning, (int)0).show();
                return true;
            }
            if (this.mCurrentImageItem.isSelected()) {
                this.cancelImage();
            } else if (!this.mSelectedImages.contains(this.mCurrentImageItem)) {
                if (this.mCurrentImageItem.isGifOverSize()) {
                    Toast.makeText((Context)this.getApplicationContext(), (int)R.string.boxing_gif_too_big, (int)0).show();
                    return true;
                }
                this.mCurrentImageItem.setSelected(true);
                this.mSelectedImages.add((BaseMedia)this.mCurrentImageItem);
            }
            this.setOkTextNumber();
            this.setMenuIcon(this.mCurrentImageItem.isSelected());
            return true;
        }
        return super.onOptionsItemSelected(item);
    }

    private void cancelImage() {
        if (this.mSelectedImages.contains(this.mCurrentImageItem)) {
            this.mSelectedImages.remove(this.mCurrentImageItem);
        }
        this.mCurrentImageItem.setSelected(false);
    }

    private void setMenuIcon(boolean isSelected) {
        if (this.mNeedEdit) {
            this.mSelectedMenuItem.setIcon(isSelected ? BoxingResHelper.getMediaCheckedRes() : BoxingResHelper.getMediaUncheckedRes());
        }
    }

    public void startLoading() {
        if (!this.mNeedLoading) {
            this.mCurrentImageItem = (ImageMedia)this.mSelectedImages.get(this.mStartPos);
            this.mToolbar.setTitle((CharSequence)this.getString(R.string.boxing_image_preview_title_fmt, new Object[]{String.valueOf(this.mStartPos + 1), String.valueOf(this.mSelectedImages.size())}));
            this.mProgressBar.setVisibility(8);
            this.mGallery.setVisibility(0);
            this.mAdapter.setMedias(this.mImages);
            if (this.mStartPos > 0 && this.mStartPos < this.mSelectedImages.size()) {
                this.mGallery.setCurrentItem(this.mStartPos, false);
            }
        } else {
            this.loadMedia(this.mAlbumId, this.mStartPos, this.mCurrentPage);
            this.mAdapter.setMedias(this.mImages);
        }
    }

    private void loadMedia(String albumId, int startPos, int page) {
        this.mPos = startPos;
        this.loadMedias(page, albumId);
    }

    public void showMedia(@Nullable List<BaseMedia> medias, int totalCount) {
        if (medias == null || totalCount <= 0) {
            return;
        }
        this.mImages.addAll(medias);
        this.mAdapter.notifyDataSetChanged();
        this.checkSelectedMedia(this.mImages, this.mSelectedImages);
        this.setupGallery();
        if (this.mToolbar != null && this.mNeedAllCount) {
            this.mToolbar.setTitle((CharSequence)this.getString(R.string.boxing_image_preview_title_fmt, new Object[]{String.valueOf(++this.mPos), String.valueOf(totalCount)}));
            this.mNeedAllCount = false;
        }
        this.loadOtherPagesInAlbum(totalCount);
    }

    private void setupGallery() {
        int startPos = this.mStartPos;
        if (this.mGallery == null || startPos < 0) {
            return;
        }
        if (startPos < this.mImages.size() && !this.mFinishLoading) {
            this.mGallery.setCurrentItem(this.mStartPos, false);
            this.mCurrentImageItem = (ImageMedia)this.mImages.get(startPos);
            this.mProgressBar.setVisibility(8);
            this.mGallery.setVisibility(0);
            this.mFinishLoading = true;
            this.invalidateOptionsMenu();
        } else if (startPos >= this.mImages.size()) {
            this.mProgressBar.setVisibility(0);
            this.mGallery.setVisibility(8);
        }
    }

    private void loadOtherPagesInAlbum(int totalCount) {
        this.mTotalCount = totalCount;
        if (this.mCurrentPage <= this.mTotalCount / 1000) {
            ++this.mCurrentPage;
            this.loadMedia(this.mAlbumId, this.mStartPos, this.mCurrentPage);
        }
    }

    protected void onSaveInstanceState(Bundle outState) {
        if (this.mSelectedImages != null) {
            outState.putParcelableArrayList("com.bilibili.boxing.Boxing.selected_media", this.mSelectedImages);
        }
        outState.putString("com.bilibili.boxing.Boxing.album_id", this.mAlbumId);
        super.onSaveInstanceState(outState);
    }

    public void onBackPressed() {
        this.finishByBackPressed(true);
    }

    private class OnPagerChangeListener
    extends ViewPager.SimpleOnPageChangeListener {
        private OnPagerChangeListener() {
        }

        public void onPageSelected(int position) {
            if (BoxingViewActivity.this.mToolbar != null && position < BoxingViewActivity.this.mImages.size()) {
                BoxingViewActivity.this.mToolbar.setTitle((CharSequence)BoxingViewActivity.this.getString(R.string.boxing_image_preview_title_fmt, new Object[]{String.valueOf(position + 1), BoxingViewActivity.this.mNeedLoading ? String.valueOf(BoxingViewActivity.this.mTotalCount) : String.valueOf(BoxingViewActivity.this.mImages.size())}));
                BoxingViewActivity.this.mCurrentImageItem = (ImageMedia)BoxingViewActivity.this.mImages.get(position);
                BoxingViewActivity.this.invalidateOptionsMenu();
            }
        }
    }

    private class ImagesAdapter
    extends FragmentStatePagerAdapter {
        private ArrayList<BaseMedia> mMedias;

        ImagesAdapter(FragmentManager fm) {
            super(fm);
        }

        public Fragment getItem(int i) {
            return BoxingRawImageFragment.newInstance((ImageMedia)this.mMedias.get(i));
        }

        public int getCount() {
            return this.mMedias == null ? 0 : this.mMedias.size();
        }

        public void setMedias(ArrayList<BaseMedia> medias) {
            this.mMedias = medias;
            this.notifyDataSetChanged();
        }
    }
}

