/*
 * Decompiled with CFR 0.152.
 */
package com.bilibili.boxing_impl.ui;

import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.design.widget.BottomSheetBehavior;
import android.support.v4.app.Fragment;
import android.support.v7.widget.Toolbar;
import android.view.View;
import android.widget.FrameLayout;
import android.widget.ImageView;
import com.bilibili.boxing.AbsBoxingActivity;
import com.bilibili.boxing.AbsBoxingViewFragment;
import com.bilibili.boxing.BoxingMediaLoader;
import com.bilibili.boxing.model.entity.BaseMedia;
import com.bilibili.boxing.model.entity.impl.ImageMedia;
import com.bilibili.boxing_impl.R;
import com.bilibili.boxing_impl.ui.BoxingBottomSheetFragment;
import java.util.ArrayList;
import java.util.List;

public class BoxingBottomSheetActivity
extends AbsBoxingActivity
implements View.OnClickListener {
    private BottomSheetBehavior<FrameLayout> mBehavior;
    private ImageView mImage;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_boxing_bottom_sheet);
        this.createToolbar();
        FrameLayout bottomSheet = (FrameLayout)this.findViewById(R.id.content_layout);
        this.mBehavior = BottomSheetBehavior.from((View)bottomSheet);
        this.mBehavior.setState(4);
        this.mImage = (ImageView)this.findViewById(R.id.media_result);
        this.mImage.setOnClickListener((View.OnClickListener)this);
    }

    @NonNull
    public AbsBoxingViewFragment onCreateBoxingView(ArrayList<BaseMedia> medias) {
        BoxingBottomSheetFragment fragment = (BoxingBottomSheetFragment)this.getSupportFragmentManager().findFragmentByTag("com.bilibili.boxing_impl.ui.BoxingBottomSheetFragment");
        if (fragment == null) {
            fragment = BoxingBottomSheetFragment.newInstance();
            this.getSupportFragmentManager().beginTransaction().add(R.id.content_layout, (Fragment)fragment, "com.bilibili.boxing_impl.ui.BoxingBottomSheetFragment").commit();
        }
        return fragment;
    }

    private void createToolbar() {
        Toolbar bar = (Toolbar)this.findViewById(R.id.nav_top_bar);
        this.setSupportActionBar(bar);
        this.getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        this.getSupportActionBar().setTitle(R.string.boxing_default_album);
        bar.setNavigationOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                BoxingBottomSheetActivity.this.onBackPressed();
            }
        });
    }

    private boolean hideBottomSheet() {
        if (this.mBehavior != null && this.mBehavior.getState() != 5) {
            this.mBehavior.setState(5);
            return true;
        }
        return false;
    }

    private boolean collapseBottomSheet() {
        if (this.mBehavior != null && this.mBehavior.getState() != 4) {
            this.mBehavior.setState(4);
            return true;
        }
        return false;
    }

    private void toggleBottomSheet() {
        if (this.mBehavior == null) {
            return;
        }
        if (this.mBehavior.getState() == 5) {
            this.mBehavior.setState(4);
        } else {
            this.mBehavior.setState(5);
        }
    }

    public void onBackPressed() {
        if (this.hideBottomSheet()) {
            return;
        }
        super.onBackPressed();
    }

    public void onClick(View v) {
        int id2 = v.getId();
        if (id2 == R.id.media_result) {
            this.toggleBottomSheet();
        }
    }

    public void onBoxingFinish(Intent intent, @Nullable List<BaseMedia> medias) {
        if (this.mImage != null && medias != null && !medias.isEmpty()) {
            ImageMedia imageMedia = (ImageMedia)medias.get(0);
            BoxingMediaLoader.getInstance().displayRaw(this.mImage, imageMedia.getPath(), 1080, 720, null);
        }
        this.hideBottomSheet();
    }
}

