/*
 * Decompiled with CFR 0.152.
 */
package com.github.xiaoymin.knife4j.spring.extension;

import com.github.xiaoymin.knife4j.core.extend.OpenApiExtendMarkdownChildren;
import com.github.xiaoymin.knife4j.core.extend.OpenApiExtendMarkdownFile;
import com.github.xiaoymin.knife4j.core.extend.OpenApiExtendSetting;
import com.github.xiaoymin.knife4j.core.model.MarkdownProperty;
import com.github.xiaoymin.knife4j.core.util.CollectionUtils;
import com.github.xiaoymin.knife4j.core.util.CommonUtils;
import com.github.xiaoymin.knife4j.core.util.StrUtil;
import com.github.xiaoymin.knife4j.spring.extension.OpenApiExtension;
import com.github.xiaoymin.knife4j.spring.extension.OpenApiMarkdownExtension;
import com.github.xiaoymin.knife4j.spring.extension.OpenApiSettingExtension;
import com.github.xiaoymin.knife4j.spring.util.MarkdownUtils;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;
import springfox.documentation.service.VendorExtension;

public class OpenApiExtensionResolver {
    Logger logger = LoggerFactory.getLogger(OpenApiExtensionResolver.class);
    private final ResourcePatternResolver resourceResolver = new PathMatchingResourcePatternResolver();
    private final Map<String, List<OpenApiExtendMarkdownFile>> markdownFileMaps = new HashMap<String, List<OpenApiExtendMarkdownFile>>();
    private final OpenApiExtendSetting setting;
    private final List<MarkdownProperty> markdownProperties;

    private void start() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Resolver method start...");
        }
        if (CollectionUtils.isNotEmpty(this.markdownProperties)) {
            for (MarkdownProperty markdownProperty : this.markdownProperties) {
                if (!StrUtil.isNotBlank((CharSequence)markdownProperty.getName()) || !StrUtil.isNotBlank((CharSequence)markdownProperty.getLocations())) continue;
                String swaggerGroupName = StrUtil.isNotBlank((CharSequence)markdownProperty.getGroup()) ? markdownProperty.getGroup() : "default";
                OpenApiExtendMarkdownFile openApiExtendMarkdownFile = new OpenApiExtendMarkdownFile();
                openApiExtendMarkdownFile.setName(markdownProperty.getName());
                openApiExtendMarkdownFile.setGroup(swaggerGroupName);
                ArrayList<OpenApiExtendMarkdownChildren> allChildrenLists = new ArrayList<OpenApiExtendMarkdownChildren>();
                Object[] locations = markdownProperty.getLocations().split(";");
                if (!CollectionUtils.isEmpty((Object[])locations)) {
                    for (Object location : locations) {
                        List<OpenApiExtendMarkdownChildren> childrenList;
                        if (!StrUtil.isNotBlank((CharSequence)location) || !CollectionUtils.isNotEmpty(childrenList = this.readLocations((String)location))) continue;
                        allChildrenLists.addAll(childrenList);
                    }
                }
                if (CollectionUtils.isNotEmpty(allChildrenLists)) {
                    openApiExtendMarkdownFile.setChildren(allChildrenLists);
                }
                if (this.markdownFileMaps.containsKey(swaggerGroupName)) {
                    this.markdownFileMaps.get(swaggerGroupName).add(openApiExtendMarkdownFile);
                    continue;
                }
                this.markdownFileMaps.put(swaggerGroupName, CollectionUtils.newArrayList((Object[])new OpenApiExtendMarkdownFile[]{openApiExtendMarkdownFile}));
            }
        }
        if (this.setting != null && this.setting.isEnableHomeCustom() && StrUtil.isNotBlank((CharSequence)this.setting.getHomeCustomLocation())) {
            String content = this.readCustomHome(this.setting.getHomeCustomLocation());
            this.setting.setHomeCustomLocation(content);
        }
    }

    private String readCustomHome(String customHomeLocation) {
        String customHomeContent = "";
        try {
            Resource[] resources = this.resourceResolver.getResources(customHomeLocation);
            if (resources != null && resources.length > 0) {
                Resource resource = resources[0];
                customHomeContent = new String(CommonUtils.readBytes((InputStream)resource.getInputStream()), "UTF-8");
            }
        }
        catch (Exception e) {
            this.logger.warn("(Ignores) Failed to read CustomeHomeLocation Markdown files,Error Message:{} ", (Object)e.getMessage());
        }
        return customHomeContent;
    }

    private List<OpenApiExtendMarkdownChildren> readLocations(String locations) {
        try {
            ArrayList<OpenApiExtendMarkdownChildren> openApiExtendMarkdownChildrenList = new ArrayList<OpenApiExtendMarkdownChildren>();
            Resource[] resources = this.resourceResolver.getResources(locations);
            if (resources != null && resources.length > 0) {
                for (Resource resource : resources) {
                    OpenApiExtendMarkdownChildren markdownFile = this.readMarkdownChildren(resource);
                    if (markdownFile == null) continue;
                    openApiExtendMarkdownChildrenList.add(markdownFile);
                }
                return openApiExtendMarkdownChildrenList;
            }
        }
        catch (Exception e) {
            this.logger.warn("(Ignores) Failed to read Markdown files,Error Message:{} ", (Object)e.getMessage());
        }
        return null;
    }

    private OpenApiExtendMarkdownChildren readMarkdownChildren(Resource resource) {
        return MarkdownUtils.resolveMarkdownResource(resource);
    }

    public List<VendorExtension> buildExtensions(String groupName) {
        String swaggerGroupName = StrUtil.isNotBlank((CharSequence)groupName) ? groupName : "default";
        OpenApiExtension openApiExtension = new OpenApiExtension("x-openapi");
        openApiExtension.addProperty(new OpenApiSettingExtension(this.setting));
        openApiExtension.addProperty(new OpenApiMarkdownExtension(this.markdownFileMaps.get(swaggerGroupName)));
        ArrayList<VendorExtension> vendorExtensions = new ArrayList<VendorExtension>();
        vendorExtensions.add((VendorExtension)openApiExtension);
        return vendorExtensions;
    }

    public List<VendorExtension> buildSettingExtensions() {
        OpenApiExtension openApiExtension = new OpenApiExtension("x-openapi");
        openApiExtension.addProperty(new OpenApiSettingExtension(this.setting));
        ArrayList<VendorExtension> vendorExtensions = new ArrayList<VendorExtension>();
        vendorExtensions.add((VendorExtension)openApiExtension);
        return vendorExtensions;
    }

    public OpenApiExtensionResolver(OpenApiExtendSetting setting, List<MarkdownProperty> markdownProperties) {
        this.setting = setting;
        this.markdownProperties = markdownProperties;
    }
}

