/*
 * Decompiled with CFR 0.152.
 */
package com.github.xiaoymin.knife4j.spring.util;

import com.github.xiaoymin.knife4j.core.enums.BasicAuthTypeEnums;
import com.github.xiaoymin.knife4j.core.enums.OAuth2TypeEnums;
import com.github.xiaoymin.knife4j.core.oauth2.OAuth2Properties;
import com.github.xiaoymin.knife4j.core.oauth2.OAuth2Scope;
import com.github.xiaoymin.knife4j.core.util.Assert;
import com.github.xiaoymin.knife4j.core.util.CollectionUtils;
import com.github.xiaoymin.knife4j.core.util.StrUtil;
import com.github.xiaoymin.knife4j.spring.model.docket.Knife4jAuthInfoProperties;
import com.github.xiaoymin.knife4j.spring.util.RequestHandlerSelectorUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import springfox.documentation.builders.OAuthBuilder;
import springfox.documentation.service.ApiKey;
import springfox.documentation.service.AuthorizationCodeGrant;
import springfox.documentation.service.AuthorizationScope;
import springfox.documentation.service.BasicAuth;
import springfox.documentation.service.ClientCredentialsGrant;
import springfox.documentation.service.GrantType;
import springfox.documentation.service.ImplicitGrant;
import springfox.documentation.service.LoginEndpoint;
import springfox.documentation.service.OAuth;
import springfox.documentation.service.ResourceOwnerPasswordCredentialsGrant;
import springfox.documentation.service.SecurityReference;
import springfox.documentation.service.SecurityScheme;
import springfox.documentation.service.TokenEndpoint;
import springfox.documentation.service.TokenRequestEndpoint;
import springfox.documentation.spi.service.contexts.SecurityContext;
import springfox.documentation.spring.web.plugins.Docket;

public class SecurityDocketUtils {
    public static final String OAUTH2_TOKEN_NAME = "access_token";
    public static final String OAUTH2_NAME = "oauth2";
    public static final String BASIC_AUTH_NAME = "Authorization";
    public static final String API_KEY_DEFAULT_PASS = "header";

    public static void configCustomAuth(Docket docket, List<Knife4jAuthInfoProperties> authInfoProperties) {
        if (CollectionUtils.isNotEmpty(authInfoProperties)) {
            ArrayList<SecurityContext> securityContexts = new ArrayList<SecurityContext>();
            ArrayList<Object> securitySchemes = new ArrayList<Object>();
            for (Knife4jAuthInfoProperties authInfo : authInfoProperties) {
                if (authInfo.getAuthType() == BasicAuthTypeEnums.BASIC) {
                    securitySchemes.add(new BasicAuth(BASIC_AUTH_NAME));
                } else if (authInfo.getAuthType() == BasicAuthTypeEnums.API_KEY) {
                    securitySchemes.add(new ApiKey(authInfo.getKeyName(), authInfo.getName(), API_KEY_DEFAULT_PASS));
                }
                SecurityContext securityContext = SecurityContext.builder().securityReferences(Arrays.asList(new SecurityReference(authInfo.getName(), SecurityDocketUtils.createAuthScope(authInfo.getScopes(), true).toArray(new AuthorizationScope[0])))).forPaths(RequestHandlerSelectorUtils.multiplePathSelector(authInfo.getPaths())).build();
                securityContexts.add(securityContext);
            }
            docket.securityContexts(securityContexts).securitySchemes(securitySchemes);
        }
    }

    public static void configOAuth2(Docket docket, OAuth2Properties oAuth2Properties) {
        if (oAuth2Properties != null) {
            Assert.notNull((Object)oAuth2Properties.getConfig(), (String)"OAuth2 Config can't be Empty!");
            Assert.notBlank((String)oAuth2Properties.getConfig().getUrl(), (String)"OAuth2 URL can't be empty!");
            List<GrantType> grantTypes = null;
            if (oAuth2Properties.getGrantType() == OAuth2TypeEnums.IMPLICIT) {
                grantTypes = SecurityDocketUtils.implicit(docket, oAuth2Properties);
            } else if (oAuth2Properties.getGrantType() == OAuth2TypeEnums.AUTHORIZATION_CODE) {
                grantTypes = SecurityDocketUtils.authorizationCode(docket, oAuth2Properties);
            } else if (oAuth2Properties.getGrantType() == OAuth2TypeEnums.CLIENT_CREDENTIALS) {
                grantTypes = SecurityDocketUtils.clientCredentials(docket, oAuth2Properties);
            } else if (oAuth2Properties.getGrantType() == OAuth2TypeEnums.PASSWORD) {
                grantTypes = SecurityDocketUtils.password(docket, oAuth2Properties);
            }
            OAuth oAuth = SecurityDocketUtils.createOAuth2(grantTypes);
            List<AuthorizationScope> scopes = SecurityDocketUtils.createAuthScope(oAuth2Properties.getScopes(), false);
            SecurityReference securityReference = new SecurityReference(OAUTH2_NAME, scopes.toArray(new AuthorizationScope[0]));
            SecurityContext securityContext = new SecurityContext(Arrays.asList(securityReference), RequestHandlerSelectorUtils.multiplePathSelector(oAuth2Properties.getPaths()));
            List<SecurityScheme> securitySchemes = Arrays.asList(oAuth);
            List<SecurityContext> securityContexts = Arrays.asList(securityContext);
            docket.securityContexts(securityContexts).securitySchemes(securitySchemes);
        }
    }

    private static List<GrantType> password(Docket docket, OAuth2Properties oAuth2Properties) {
        ArrayList<GrantType> grantTypes = new ArrayList<GrantType>();
        String passwordTokenUrl = oAuth2Properties.getConfig().getUrl();
        ResourceOwnerPasswordCredentialsGrant resourceOwnerPasswordCredentialsGrant = new ResourceOwnerPasswordCredentialsGrant(passwordTokenUrl);
        grantTypes.add((GrantType)resourceOwnerPasswordCredentialsGrant);
        return grantTypes;
    }

    private static List<GrantType> clientCredentials(Docket docket, OAuth2Properties oAuth2Properties) {
        ArrayList<GrantType> grantTypes = new ArrayList<GrantType>();
        String clientTokenUrl = oAuth2Properties.getConfig().getUrl();
        ClientCredentialsGrant clientCredentialsGrant = new ClientCredentialsGrant(clientTokenUrl);
        grantTypes.add((GrantType)clientCredentialsGrant);
        return grantTypes;
    }

    public static List<GrantType> implicit(Docket docket, OAuth2Properties oAuth2Properties) {
        ArrayList<GrantType> grantTypes = new ArrayList<GrantType>();
        String tokenName = StrUtil.isNotBlank((CharSequence)oAuth2Properties.getConfig().getTokenName()) ? oAuth2Properties.getConfig().getTokenName() : OAUTH2_TOKEN_NAME;
        ImplicitGrant implicitGrant = new ImplicitGrant(new LoginEndpoint(oAuth2Properties.getConfig().getUrl()), tokenName);
        grantTypes.add((GrantType)implicitGrant);
        return grantTypes;
    }

    public static List<GrantType> authorizationCode(Docket docket, OAuth2Properties oAuth2Properties) {
        ArrayList<GrantType> grantTypes = new ArrayList<GrantType>();
        String tokenName = StrUtil.isNotBlank((CharSequence)oAuth2Properties.getConfig().getTokenName()) ? oAuth2Properties.getConfig().getTokenName() : OAUTH2_TOKEN_NAME;
        TokenRequestEndpoint tokenRequestEndpoint = new TokenRequestEndpoint(oAuth2Properties.getConfig().getUrl(), oAuth2Properties.getConfig().getClientId(), oAuth2Properties.getConfig().getClientSecret());
        TokenEndpoint tokenEndpoint = new TokenEndpoint(oAuth2Properties.getConfig().getAuthorize(), tokenName);
        AuthorizationCodeGrant authorizationCodeGrant = new AuthorizationCodeGrant(tokenRequestEndpoint, tokenEndpoint);
        grantTypes.add((GrantType)authorizationCodeGrant);
        return grantTypes;
    }

    public static OAuth createOAuth2(List<GrantType> grantTypes) {
        OAuth oAuth = new OAuthBuilder().name(OAUTH2_NAME).grantTypes(grantTypes).build();
        return oAuth;
    }

    public static List<AuthorizationScope> createAuthScope(List<OAuth2Scope> auth2Scopes, boolean createDefault) {
        ArrayList<AuthorizationScope> scopes = new ArrayList<AuthorizationScope>();
        if (CollectionUtils.isNotEmpty(auth2Scopes)) {
            for (OAuth2Scope scope : auth2Scopes) {
                scopes.add(new AuthorizationScope(scope.getName(), scope.getDescription()));
            }
        } else if (createDefault) {
            AuthorizationScope authorizationScope = new AuthorizationScope("global", "accessEverything");
            scopes.add(authorizationScope);
        }
        return scopes;
    }
}

