/*
 * Decompiled with CFR 0.152.
 */
package com.github.xiaoymin.knife4j.spring.model;

import com.github.xiaoymin.knife4j.core.extend.OpenApiExtendMarkdownChildren;
import com.github.xiaoymin.knife4j.spring.util.MarkdownUtils;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;

public class MarkdownFiles {
    private static final ResourcePatternResolver resourceResolver = new PathMatchingResourcePatternResolver();
    Logger logger = LoggerFactory.getLogger(MarkdownFiles.class);
    private String basePath;
    private List<OpenApiExtendMarkdownChildren> markdownFiles = new ArrayList<OpenApiExtendMarkdownChildren>();

    public List<OpenApiExtendMarkdownChildren> getMarkdownFiles() {
        return this.markdownFiles;
    }

    public void setMarkdownFiles(List<OpenApiExtendMarkdownChildren> markdownFiles) {
        this.markdownFiles = markdownFiles;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    public MarkdownFiles() {
    }

    public MarkdownFiles(String basePath) {
        this.basePath = basePath;
    }

    public void init() {
        if (this.basePath != null && this.basePath != "" && !"".equals(this.basePath)) {
            try {
                Resource[] resources = resourceResolver.getResources(this.basePath);
                if (resources != null && resources.length > 0) {
                    for (Resource resource : resources) {
                        OpenApiExtendMarkdownChildren markdownFile = this.createMarkdownFile(resource);
                        if (markdownFile == null) continue;
                        this.getMarkdownFiles().add(markdownFile);
                    }
                }
            }
            catch (Exception e) {
                this.logger.warn("(Ignores) Failed to read Markdown files,Error Message:{} ", (Object)e.getMessage());
            }
        }
    }

    private OpenApiExtendMarkdownChildren createMarkdownFile(Resource resource) {
        return MarkdownUtils.resolveMarkdownResource(resource);
    }
}

