/*
 * Decompiled with CFR 0.152.
 */
package com.github.xiaoymin.knife4j.spring.gateway.discover;

import com.github.xiaoymin.knife4j.spring.gateway.Knife4jGatewayProperties;
import com.github.xiaoymin.knife4j.spring.gateway.discover.ServiceDiscoverHandler;
import com.github.xiaoymin.knife4j.spring.gateway.enums.GatewayStrategy;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.cloud.client.discovery.event.HeartbeatEvent;
import org.springframework.cloud.gateway.event.RefreshRoutesEvent;
import org.springframework.context.event.EventListener;

public class ServiceChangeListener {
    private static final Logger log = LoggerFactory.getLogger(ServiceChangeListener.class);
    final DiscoveryClient discoveryClient;
    final ServiceDiscoverHandler serviceDiscoverHandler;
    final Knife4jGatewayProperties knife4jGatewayProperties;

    @EventListener(classes={ApplicationReadyEvent.class, HeartbeatEvent.class, RefreshRoutesEvent.class})
    public void discover() {
        log.debug("discover service.");
        List services = this.discoveryClient.getServices();
        if (Objects.equals((Object)this.knife4jGatewayProperties.getStrategy(), (Object)GatewayStrategy.DISCOVER)) {
            this.serviceDiscoverHandler.discover(services);
        }
    }

    public ServiceChangeListener(DiscoveryClient discoveryClient, ServiceDiscoverHandler serviceDiscoverHandler, Knife4jGatewayProperties knife4jGatewayProperties) {
        this.discoveryClient = discoveryClient;
        this.serviceDiscoverHandler = serviceDiscoverHandler;
        this.knife4jGatewayProperties = knife4jGatewayProperties;
    }
}

