/*
 * Decompiled with CFR 0.152.
 */
package com.github.xiaoymin.knife4j.spring.gateway.spec.v2;

import com.github.xiaoymin.knife4j.spring.gateway.Knife4jGatewayProperties;
import com.github.xiaoymin.knife4j.spring.gateway.spec.AbstractOpenAPIResource;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Objects;

public class OpenAPI2Resource
extends AbstractOpenAPIResource {
    private String name;
    private String url;
    private String contextPath;
    private String id;

    public OpenAPI2Resource(Integer order, Boolean discovered) {
        super(order, discovered);
    }

    public OpenAPI2Resource(Knife4jGatewayProperties.Router router) {
        super(router.getOrder(), false);
        this.name = router.getName();
        this.url = router.getUrl();
        this.contextPath = router.getContextPath();
        this.id = Base64.getEncoder().encodeToString((router.getName() + router.getUrl() + router.getContextPath()).getBytes(StandardCharsets.UTF_8));
    }

    public OpenAPI2Resource(String url, int order, boolean discover, String groupName, String contextPath) {
        super(order, discover);
        this.name = groupName;
        this.url = url;
        this.contextPath = contextPath;
        this.id = Base64.getEncoder().encodeToString((groupName + url + contextPath).getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OpenAPI2Resource that = (OpenAPI2Resource)o;
        return Objects.equals(this.getName(), that.getName()) && Objects.equals(this.getUrl(), that.getUrl()) && Objects.equals(this.getContextPath(), that.getContextPath()) && Objects.equals(this.getId(), that.getId());
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.getName(), this.getUrl(), this.getContextPath(), this.getId());
    }

    public OpenAPI2Resource copy() {
        return new OpenAPI2Resource(this.url, this.order, this.discovered, this.name, this.contextPath);
    }

    public String toString() {
        return "OpenAPI2Resource{name='" + this.name + '\'' + ", url='" + this.url + '\'' + ", contextPath='" + this.contextPath + '\'' + ", id='" + this.id + '\'' + ", order=" + this.order + ", discovered=" + this.discovered + '}';
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getUrl() {
        return this.url;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public String getId() {
        return this.id;
    }
}

