/*
 * Decompiled with CFR 0.152.
 */
package com.github.xiaoymin.knife4j.spring.gateway.discover;

import com.github.xiaoymin.knife4j.spring.gateway.Knife4jGatewayProperties;
import com.github.xiaoymin.knife4j.spring.gateway.discover.spi.GatewayServiceExcludeService;
import com.github.xiaoymin.knife4j.spring.gateway.spec.AbstractOpenAPIResource;
import com.github.xiaoymin.knife4j.spring.gateway.spec.v2.OpenAPI2Resource;
import com.github.xiaoymin.knife4j.spring.gateway.utils.PathUtils;
import com.github.xiaoymin.knife4j.spring.gateway.utils.ServiceUtils;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.gateway.config.GatewayProperties;
import org.springframework.cloud.gateway.route.RouteDefinition;
import org.springframework.cloud.gateway.route.RouteDefinitionRepository;
import org.springframework.cloud.gateway.route.RouteLocator;
import org.springframework.context.ApplicationContext;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;
import org.springframework.util.CollectionUtils;

public class ServiceDiscoverHandler
implements EnvironmentAware {
    private static final Logger log = LoggerFactory.getLogger(ServiceDiscoverHandler.class);
    final RouteDefinitionRepository routeDefinitionRepository;
    final RouteLocator routeLocator;
    final GatewayProperties gatewayProperties;
    final Knife4jGatewayProperties knife4jGatewayProperties;
    final ApplicationContext applicationContext;
    private final String PATH = "Path";
    private List<OpenAPI2Resource> gatewayResources;
    private Environment environment;

    public ServiceDiscoverHandler(RouteDefinitionRepository routeDefinitionRepository, RouteLocator routeLocator, GatewayProperties gatewayProperties, Knife4jGatewayProperties knife4jGatewayProperties, ApplicationContext applicationContext) {
        this.routeDefinitionRepository = routeDefinitionRepository;
        this.routeLocator = routeLocator;
        this.gatewayProperties = gatewayProperties;
        this.knife4jGatewayProperties = knife4jGatewayProperties;
        this.applicationContext = applicationContext;
    }

    private Set<String> getExcludeService(List<String> service) {
        Map excludeServiceMap = this.applicationContext.getBeansOfType(GatewayServiceExcludeService.class);
        HashSet<String> excludeService = new HashSet<String>();
        if (!excludeServiceMap.isEmpty()) {
            for (Map.Entry entry : excludeServiceMap.entrySet()) {
                Set<String> stringSet = ((GatewayServiceExcludeService)entry.getValue()).exclude(this.environment, this.knife4jGatewayProperties, service);
                if (stringSet == null || stringSet.isEmpty()) continue;
                excludeService.addAll(stringSet);
            }
        }
        log.debug("exclude-service-size:{},value:{}", (Object)excludeService.size(), (Object)String.join((CharSequence)",", excludeService));
        return excludeService;
    }

    public void discover(List<String> service) {
        log.debug("service has change ,do discover doc for default route.");
        Set<String> excludeService = this.getExcludeService(service);
        Map<String, Knife4jGatewayProperties.ServiceConfigInfo> configInfoMap = this.knife4jGatewayProperties.getDiscover().getServiceConfig();
        TreeSet<OpenAPI2Resource> resources = new TreeSet<OpenAPI2Resource>(Comparator.comparing(AbstractOpenAPIResource::getOrder));
        this.gatewayProperties.getRoutes().stream().filter(routeDefinition -> ServiceUtils.startLoadBalance(routeDefinition.getUri())).filter(routeDefinition -> ServiceUtils.includeService(routeDefinition.getUri(), service, excludeService)).forEach(routeDefinition -> this.parseRouteDefinition((Set<OpenAPI2Resource>)resources, configInfoMap, (RouteDefinition)routeDefinition));
        this.routeDefinitionRepository.getRouteDefinitions().filter(routeDefinition -> ServiceUtils.startLoadBalance(routeDefinition.getUri())).filter(routeDefinition -> ServiceUtils.includeService(routeDefinition.getUri(), service, excludeService)).subscribe(routeDefinition -> this.parseRouteDefinition((Set<OpenAPI2Resource>)resources, configInfoMap, (RouteDefinition)routeDefinition));
        ServiceUtils.addCustomerResources(resources, this.knife4jGatewayProperties);
        this.gatewayResources = new ArrayList<OpenAPI2Resource>(resources);
    }

    public List<OpenAPI2Resource> getResources(String forwardPath) {
        ArrayList<OpenAPI2Resource> resourceList = new ArrayList<OpenAPI2Resource>();
        List<OpenAPI2Resource> resources = this.getGatewayResources();
        if (resources != null && !resources.isEmpty()) {
            resources.sort(Comparator.comparing(AbstractOpenAPIResource::getOrder));
            for (OpenAPI2Resource resource : resources) {
                OpenAPI2Resource copy = resource.copy();
                copy.setContextPath(PathUtils.processContextPath(PathUtils.append(forwardPath, copy.getContextPath())));
                copy.setUrl(PathUtils.append(forwardPath, copy.getUrl()));
                log.debug("api-resources:{}", (Object)copy);
                resourceList.add(copy);
            }
            return resourceList;
        }
        return resourceList;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    private void parseRouteDefinition(Set<OpenAPI2Resource> resources, Map<String, Knife4jGatewayProperties.ServiceConfigInfo> configInfoMap, RouteDefinition routeDefinition) {
        routeDefinition.getPredicates().stream().filter(predicateDefinition -> "Path".equalsIgnoreCase(predicateDefinition.getName())).findFirst().ifPresent(predicateDefinition -> {
            String id = routeDefinition.getId();
            String serviceName = routeDefinition.getUri().getHost();
            String pathPrefix = ((String)predicateDefinition.getArgs().get("_genkey_0")).replace("**", "");
            String contextPath = "";
            String groupName = id;
            int order = 0;
            String targetUrl = PathUtils.append(pathPrefix, "/v3/api-docs");
            Knife4jGatewayProperties.ServiceConfigInfo configInfo = (Knife4jGatewayProperties.ServiceConfigInfo)configInfoMap.get(serviceName);
            if (configInfo != null) {
                order = configInfo.getOrder();
                contextPath = PathUtils.append(pathPrefix, configInfo.getContextPath());
                targetUrl = PathUtils.append(contextPath, "/v3/api-docs");
                List<String> groupNames = configInfo.getGroupNames();
                if (CollectionUtils.isEmpty(groupNames)) {
                    groupName = configInfo.getGroupName();
                } else {
                    int sort = order;
                    String ctx = contextPath;
                    String url = targetUrl;
                    groupNames.forEach(_groupName -> resources.add(new OpenAPI2Resource(PathUtils.append(url, _groupName), sort, true, (String)_groupName, ctx)));
                    return;
                }
            }
            resources.add(new OpenAPI2Resource(targetUrl, order, true, groupName, contextPath));
        });
    }

    public List<OpenAPI2Resource> getGatewayResources() {
        return this.gatewayResources;
    }
}

