/*
 * Decompiled with CFR 0.152.
 */
package com.github.xiaoymin.knife4j.spring.gateway;

import com.github.xiaoymin.knife4j.spring.gateway.Knife4jGatewayHttpBasic;
import com.github.xiaoymin.knife4j.spring.gateway.enums.GatewayStrategy;
import com.github.xiaoymin.knife4j.spring.gateway.enums.GroupOrderStrategy;
import com.github.xiaoymin.knife4j.spring.gateway.enums.OpenApiVersion;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="knife4j.gateway")
public class Knife4jGatewayProperties {
    public static final String DEFAULT_API_PATH_PREFIX = "/";
    public static final Integer DEFAULT_ORDER = 0;
    public static final String DEFAULT_OPEN_API_V2_PATH = "/v2/api-docs?group=default";
    public static final String DEFAULT_OPEN_API_V3_PATH = "/v3/api-docs";
    private boolean enabled = false;
    private Knife4jGatewayHttpBasic basic;
    private GatewayStrategy strategy = GatewayStrategy.MANUAL;
    private GroupOrderStrategy tagsSorter = GroupOrderStrategy.alpha;
    private GroupOrderStrategy operationsSorter = GroupOrderStrategy.alpha;
    private final Discover discover = new Discover();
    private final List<Router> routes = new ArrayList<Router>();

    public boolean isEnabled() {
        return this.enabled;
    }

    public Knife4jGatewayHttpBasic getBasic() {
        return this.basic;
    }

    public GatewayStrategy getStrategy() {
        return this.strategy;
    }

    public GroupOrderStrategy getTagsSorter() {
        return this.tagsSorter;
    }

    public GroupOrderStrategy getOperationsSorter() {
        return this.operationsSorter;
    }

    public Discover getDiscover() {
        return this.discover;
    }

    public List<Router> getRoutes() {
        return this.routes;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setBasic(Knife4jGatewayHttpBasic basic) {
        this.basic = basic;
    }

    public void setStrategy(GatewayStrategy strategy) {
        this.strategy = strategy;
    }

    public void setTagsSorter(GroupOrderStrategy tagsSorter) {
        this.tagsSorter = tagsSorter;
    }

    public void setOperationsSorter(GroupOrderStrategy operationsSorter) {
        this.operationsSorter = operationsSorter;
    }

    public static class Discover {
        private Boolean enabled = Boolean.FALSE;
        private Set<String> excludedServices = new HashSet<String>();
        private OpenApiVersion version = OpenApiVersion.OpenAPI3;
        private final OpenApiV3 oas3 = new OpenApiV3();
        private final OpenApiV2 swagger2 = new OpenApiV2();
        private final Map<String, ServiceConfigInfo> serviceConfig = new HashMap<String, ServiceConfigInfo>();

        public String getUrl() {
            if (this.version == OpenApiVersion.OpenAPI3) {
                return this.oas3.getUrl();
            }
            if (this.version == OpenApiVersion.Swagger2) {
                return this.swagger2.getUrl();
            }
            return Knife4jGatewayProperties.DEFAULT_OPEN_API_V2_PATH;
        }

        public Boolean getEnabled() {
            return this.enabled;
        }

        public Set<String> getExcludedServices() {
            return this.excludedServices;
        }

        public OpenApiVersion getVersion() {
            return this.version;
        }

        public OpenApiV3 getOas3() {
            return this.oas3;
        }

        public OpenApiV2 getSwagger2() {
            return this.swagger2;
        }

        public Map<String, ServiceConfigInfo> getServiceConfig() {
            return this.serviceConfig;
        }

        public void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public void setExcludedServices(Set<String> excludedServices) {
            this.excludedServices = excludedServices;
        }

        public void setVersion(OpenApiVersion version) {
            this.version = version;
        }
    }

    public static class OpenApiV3 {
        private String url = "/v3/api-docs";
        private String oauth2RedirectUrl = "";
        private String validatorUrl = "";

        public String getUrl() {
            return this.url;
        }

        public String getOauth2RedirectUrl() {
            return this.oauth2RedirectUrl;
        }

        public String getValidatorUrl() {
            return this.validatorUrl;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public void setOauth2RedirectUrl(String oauth2RedirectUrl) {
            this.oauth2RedirectUrl = oauth2RedirectUrl;
        }

        public void setValidatorUrl(String validatorUrl) {
            this.validatorUrl = validatorUrl;
        }
    }

    public static class OpenApiV2 {
        private String url = "/v2/api-docs?group=default";

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }
    }

    public static class Router {
        private String name;
        private String serviceName;
        private String url = "/v2/api-docs?group=default";
        private String contextPath = "/";
        private Integer order = DEFAULT_ORDER;

        public String getName() {
            return this.name;
        }

        public String getServiceName() {
            return this.serviceName;
        }

        public String getUrl() {
            return this.url;
        }

        public String getContextPath() {
            return this.contextPath;
        }

        public Integer getOrder() {
            return this.order;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public void setContextPath(String contextPath) {
            this.contextPath = contextPath;
        }

        public void setOrder(Integer order) {
            this.order = order;
        }
    }

    public static class ServiceConfigInfo {
        private Integer order = DEFAULT_ORDER;
        private String groupName;
        private List<String> groupNames;
        private String contextPath;

        public Integer getOrder() {
            return this.order;
        }

        public String getGroupName() {
            return this.groupName;
        }

        public List<String> getGroupNames() {
            return this.groupNames;
        }

        public String getContextPath() {
            return this.contextPath;
        }

        public void setOrder(Integer order) {
            this.order = order;
        }

        public void setGroupName(String groupName) {
            this.groupName = groupName;
        }

        public void setGroupNames(List<String> groupNames) {
            this.groupNames = groupNames;
        }

        public void setContextPath(String contextPath) {
            this.contextPath = contextPath;
        }
    }
}

