/*
 * Decompiled with CFR 0.152.
 */
package com.github.xiaoymin.knife4j.spring.gateway;

import com.github.xiaoymin.knife4j.spring.gateway.Knife4jGatewayHttpBasic;
import com.github.xiaoymin.knife4j.spring.gateway.Knife4jGatewayProperties;
import com.github.xiaoymin.knife4j.spring.gateway.discover.ServiceChangeListener;
import com.github.xiaoymin.knife4j.spring.gateway.discover.ServiceDiscoverHandler;
import com.github.xiaoymin.knife4j.spring.gateway.discover.spi.GatewayServiceExcludeService;
import com.github.xiaoymin.knife4j.spring.gateway.discover.spi.impl.DefaultGatewayServiceExcludeService;
import com.github.xiaoymin.knife4j.spring.gateway.filter.basic.WebFluxSecurityBasicAuthFilter;
import com.github.xiaoymin.knife4j.spring.gateway.utils.EnvironmentUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.cloud.gateway.config.GatewayProperties;
import org.springframework.cloud.gateway.route.RouteDefinitionRepository;
import org.springframework.cloud.gateway.route.RouteLocator;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration
@EnableConfigurationProperties(value={Knife4jGatewayProperties.class, Knife4jGatewayHttpBasic.class})
@ComponentScan(basePackageClasses={Knife4jGatewayAutoConfiguration.class})
@ConditionalOnProperty(name={"knife4j.gateway.enabled"}, havingValue="true")
public class Knife4jGatewayAutoConfiguration {
    private final Environment environment;

    public Knife4jGatewayAutoConfiguration(Environment environment) {
        this.environment = environment;
    }

    @Bean
    @ConditionalOnMissingBean(value={WebFluxSecurityBasicAuthFilter.class})
    @ConditionalOnProperty(name={"knife4j.gateway.basic.enable"}, havingValue="true")
    public WebFluxSecurityBasicAuthFilter securityBasicAuthFilter(Knife4jGatewayProperties knife4jGatewayProperties) {
        WebFluxSecurityBasicAuthFilter authFilter = new WebFluxSecurityBasicAuthFilter();
        if (knife4jGatewayProperties == null) {
            authFilter.setEnableBasicAuth(EnvironmentUtils.resolveBool(this.environment, "knife4j.gateway.basic.enable", Boolean.FALSE));
            authFilter.setUserName(EnvironmentUtils.resolveString(this.environment, "knife4j.gateway.basic.username", "admin"));
            authFilter.setPassword(EnvironmentUtils.resolveString(this.environment, "knife4j.gateway.basic.password", "123321"));
        } else if (knife4jGatewayProperties.getBasic() == null) {
            authFilter.setEnableBasicAuth(Boolean.FALSE);
            authFilter.setUserName("admin");
            authFilter.setPassword("123321");
        } else {
            authFilter.setEnableBasicAuth(knife4jGatewayProperties.getBasic().isEnable());
            authFilter.setUserName(knife4jGatewayProperties.getBasic().getUsername());
            authFilter.setPassword(knife4jGatewayProperties.getBasic().getPassword());
            authFilter.addRule(knife4jGatewayProperties.getBasic().getInclude());
        }
        return authFilter;
    }

    @Configuration
    @EnableConfigurationProperties(value={Knife4jGatewayProperties.class})
    @ConditionalOnProperty(name={"knife4j.gateway.strategy"}, havingValue="discover")
    public static class Knife4jDiscoverConfiguration {
        @Bean(value={"defaultGatewayServiceExcludeService"})
        public GatewayServiceExcludeService defaultGatewayServiceExcludeService() {
            return new DefaultGatewayServiceExcludeService();
        }

        @Bean
        public ServiceDiscoverHandler serviceDiscoverHandler(RouteDefinitionRepository routeDefinitionRepository, RouteLocator routeLocator, GatewayProperties gatewayPropertiesDefault, Knife4jGatewayProperties gatewayProperties, ApplicationContext applicationContext) {
            return new ServiceDiscoverHandler(routeDefinitionRepository, routeLocator, gatewayPropertiesDefault, gatewayProperties, applicationContext);
        }

        @Bean
        public ServiceChangeListener serviceChangeListener(DiscoveryClient discoveryClient, ServiceDiscoverHandler serviceDiscoverHandler, Knife4jGatewayProperties knife4jGatewayProperties) {
            return new ServiceChangeListener(discoveryClient, serviceDiscoverHandler, knife4jGatewayProperties);
        }
    }
}

