/*
 * Decompiled with CFR 0.152.
 */
package com.github.xiaoymin.knife4j.spring.gateway.configuration;

import com.github.xiaoymin.knife4j.spring.gateway.pojo.Knife4jGatewayRoute;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="knife4j.gateway")
public class Knife4jGatewayProperties {
    private boolean enable = false;
    private List<Knife4jGatewayRoute> routes;

    public List<Map<String, String>> build() {
        ArrayList<Map<String, String>> dataMaps = new ArrayList<Map<String, String>>();
        if (this.routes != null && this.routes.size() > 0) {
            long count = this.routes.stream().filter(r -> r.getOrder() > 0).count();
            if (count > 0L) {
                this.routes.sort(Comparator.comparing(Knife4jGatewayRoute::getOrder));
            }
            for (Knife4jGatewayRoute route : this.routes) {
                LinkedHashMap<String, String> routeMap = new LinkedHashMap<String, String>();
                routeMap.put("name", route.getName());
                routeMap.put("url", route.getUrl());
                String source = route.getName() + route.getUrl() + route.getServiceName();
                String id = Base64.getEncoder().encodeToString(source.getBytes(StandardCharsets.UTF_8));
                routeMap.put("id", id);
                dataMaps.add(routeMap);
            }
        }
        return dataMaps;
    }

    public boolean isEnable() {
        return this.enable;
    }

    public List<Knife4jGatewayRoute> getRoutes() {
        return this.routes;
    }

    public void setEnable(boolean enable) {
        this.enable = enable;
    }

    public void setRoutes(List<Knife4jGatewayRoute> routes) {
        this.routes = routes;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Knife4jGatewayProperties)) {
            return false;
        }
        Knife4jGatewayProperties other = (Knife4jGatewayProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isEnable() != other.isEnable()) {
            return false;
        }
        List<Knife4jGatewayRoute> this$routes = this.getRoutes();
        List<Knife4jGatewayRoute> other$routes = other.getRoutes();
        return !(this$routes == null ? other$routes != null : !((Object)this$routes).equals(other$routes));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Knife4jGatewayProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEnable() ? 79 : 97);
        List<Knife4jGatewayRoute> $routes = this.getRoutes();
        result = result * 59 + ($routes == null ? 43 : ((Object)$routes).hashCode());
        return result;
    }

    public String toString() {
        return "Knife4jGatewayProperties(enable=" + this.isEnable() + ", routes=" + this.getRoutes() + ")";
    }
}

