/*
 * Decompiled with CFR 0.152.
 */
package com.github.xiaoymin.knife4j.spring.gateway.configuration;

import com.github.xiaoymin.knife4j.spring.gateway.configuration.Knife4jGatewayProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.MediaType;
import org.springframework.web.reactive.function.server.RouterFunction;
import org.springframework.web.reactive.function.server.RouterFunctions;
import org.springframework.web.reactive.function.server.ServerResponse;

@Configuration
@EnableConfigurationProperties(value={Knife4jGatewayProperties.class})
@ConditionalOnProperty(name={"knife4j.gateway.enable"}, havingValue="true")
public class Knife4jGatewayAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(Knife4jGatewayAutoConfiguration.class);
    public static final String GATEWAY_SWAGGER_GROUP_URL = "/swagger-resources";

    @Bean
    public RouterFunction<ServerResponse> gatewaySwaggerRoute(Knife4jGatewayProperties knife4jGatewayProperties) {
        log.info("init gateway swagger resources.");
        return RouterFunctions.route().GET(GATEWAY_SWAGGER_GROUP_URL, request -> ServerResponse.ok().contentType(MediaType.APPLICATION_JSON).bodyValue(knife4jGatewayProperties.build())).build();
    }
}

