/*
 * Decompiled with CFR 0.152.
 */
package com.github.xiaoymin.knife4j.extend.filter.basic;

import com.github.xiaoymin.knife4j.core.util.StrUtil;
import com.github.xiaoymin.knife4j.extend.filter.BasicFilter;
import java.util.Enumeration;
import java.util.List;

public abstract class AbstractSecurityFilter
extends BasicFilter {
    private boolean enableBasicAuth = false;
    private String userName;
    private String password;
    private List<String> include;

    protected void initServletConfig(Enumeration<String> enumeration, String initBasicEnable, String initUserName, String initPassword) {
        if (enumeration != null && enumeration.hasMoreElements()) {
            this.setEnableBasicAuth(Boolean.valueOf(initBasicEnable));
            this.setUserName(initUserName);
            this.setPassword(initPassword);
        }
    }

    protected boolean tryCommonBasic(String url, Object sessionAuth, String auth) {
        if (this.isEnableBasicAuth() && this.match(url) && sessionAuth == null) {
            if (StrUtil.isBlank(auth)) {
                return Boolean.FALSE;
            }
            String userAndPass = this.decodeBase64(auth.substring(6));
            String[] upArr = userAndPass.split(":");
            if (upArr.length != 2) {
                return false;
            }
            String iptUser = upArr[0];
            String iptPass = upArr[1];
            return iptUser.equals(this.getUserName()) && iptPass.equals(this.getPassword());
        }
        return Boolean.TRUE;
    }

    public boolean isEnableBasicAuth() {
        return this.enableBasicAuth;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getPassword() {
        return this.password;
    }

    public List<String> getInclude() {
        return this.include;
    }

    public void setEnableBasicAuth(boolean enableBasicAuth) {
        this.enableBasicAuth = enableBasicAuth;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setInclude(List<String> include) {
        this.include = include;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractSecurityFilter)) {
            return false;
        }
        AbstractSecurityFilter other = (AbstractSecurityFilter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isEnableBasicAuth() != other.isEnableBasicAuth()) {
            return false;
        }
        String this$userName = this.getUserName();
        String other$userName = other.getUserName();
        if (this$userName == null ? other$userName != null : !this$userName.equals(other$userName)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        List<String> this$include = this.getInclude();
        List<String> other$include = other.getInclude();
        return !(this$include == null ? other$include != null : !((Object)this$include).equals(other$include));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AbstractSecurityFilter;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEnableBasicAuth() ? 79 : 97);
        String $userName = this.getUserName();
        result = result * 59 + ($userName == null ? 43 : $userName.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        List<String> $include = this.getInclude();
        result = result * 59 + ($include == null ? 43 : ((Object)$include).hashCode());
        return result;
    }

    public String toString() {
        return "AbstractSecurityFilter(enableBasicAuth=" + this.isEnableBasicAuth() + ", userName=" + this.getUserName() + ", password=" + this.getPassword() + ", include=" + this.getInclude() + ")";
    }
}

