/*
 * Decompiled with CFR 0.152.
 */
package com.xiao.nicevideoplayer;

import com.xiao.nicevideoplayer.NiceVideoPlayer;

public class NiceVideoPlayerManager {
    private NiceVideoPlayer mVideoPlayer;
    private static NiceVideoPlayerManager sInstance;

    private NiceVideoPlayerManager() {
    }

    public static synchronized NiceVideoPlayerManager instance() {
        if (sInstance == null) {
            sInstance = new NiceVideoPlayerManager();
        }
        return sInstance;
    }

    public NiceVideoPlayer getCurrentNiceVideoPlayer() {
        return this.mVideoPlayer;
    }

    public void setCurrentNiceVideoPlayer(NiceVideoPlayer videoPlayer) {
        if (this.mVideoPlayer != videoPlayer) {
            this.releaseNiceVideoPlayer();
            this.mVideoPlayer = videoPlayer;
        }
    }

    public void suspendNiceVideoPlayer() {
        if (this.mVideoPlayer != null && (this.mVideoPlayer.isPlaying() || this.mVideoPlayer.isBufferingPlaying())) {
            this.mVideoPlayer.pause();
        }
    }

    public void resumeNiceVideoPlayer() {
        if (this.mVideoPlayer != null && (this.mVideoPlayer.isPaused() || this.mVideoPlayer.isBufferingPaused())) {
            this.mVideoPlayer.restart();
        }
    }

    public void releaseNiceVideoPlayer() {
        if (this.mVideoPlayer != null) {
            this.mVideoPlayer.release();
            this.mVideoPlayer = null;
        }
    }

    public boolean onBackPressd() {
        if (this.mVideoPlayer != null) {
            if (this.mVideoPlayer.isFullScreen()) {
                return this.mVideoPlayer.exitFullScreen();
            }
            if (this.mVideoPlayer.isTinyWindow()) {
                return this.mVideoPlayer.exitTinyWindow();
            }
        }
        return false;
    }
}

