/*
 * Decompiled with CFR 0.152.
 */
package com.xiao.nicevideoplayer;

import android.content.Context;
import android.graphics.SurfaceTexture;
import android.media.AudioManager;
import android.net.Uri;
import android.util.AttributeSet;
import android.view.Surface;
import android.view.TextureView;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.xiao.nicevideoplayer.INiceVideoPlayer;
import com.xiao.nicevideoplayer.LogUtil;
import com.xiao.nicevideoplayer.NiceTextureView;
import com.xiao.nicevideoplayer.NiceUtil;
import com.xiao.nicevideoplayer.NiceVideoPlayerController;
import com.xiao.nicevideoplayer.NiceVideoPlayerManager;
import java.io.IOException;
import java.util.Map;
import tv.danmaku.ijk.media.player.AndroidMediaPlayer;
import tv.danmaku.ijk.media.player.IMediaPlayer;
import tv.danmaku.ijk.media.player.IjkMediaPlayer;

public class NiceVideoPlayer
extends FrameLayout
implements INiceVideoPlayer,
TextureView.SurfaceTextureListener {
    public static final int STATE_ERROR = -1;
    public static final int STATE_IDLE = 0;
    public static final int STATE_PREPARING = 1;
    public static final int STATE_PREPARED = 2;
    public static final int STATE_PLAYING = 3;
    public static final int STATE_PAUSED = 4;
    public static final int STATE_BUFFERING_PLAYING = 5;
    public static final int STATE_BUFFERING_PAUSED = 6;
    public static final int STATE_COMPLETED = 7;
    public static final int MODE_NORMAL = 10;
    public static final int MODE_FULL_SCREEN = 11;
    public static final int MODE_TINY_WINDOW = 12;
    public static final int TYPE_IJK = 111;
    public static final int TYPE_NATIVE = 222;
    private int mPlayerType = 111;
    private int mCurrentState = 0;
    private int mCurrentMode = 10;
    private Context mContext;
    private AudioManager mAudioManager;
    private IMediaPlayer mMediaPlayer;
    private FrameLayout mContainer;
    private NiceTextureView mTextureView;
    private NiceVideoPlayerController mController;
    private SurfaceTexture mSurfaceTexture;
    private Surface mSurface;
    private String mUrl;
    private Map<String, String> mHeaders;
    private int mBufferPercentage;
    private boolean continueFromLastPosition = true;
    private long skipToPosition;
    private IMediaPlayer.OnPreparedListener mOnPreparedListener = new IMediaPlayer.OnPreparedListener(){

        public void onPrepared(IMediaPlayer mp) {
            NiceVideoPlayer.this.mCurrentState = 2;
            NiceVideoPlayer.this.mController.onPlayStateChanged(NiceVideoPlayer.this.mCurrentState);
            LogUtil.d("onPrepared \u2014\u2014> STATE_PREPARED");
            mp.start();
            if (NiceVideoPlayer.this.continueFromLastPosition) {
                long savedPlayPosition = NiceUtil.getSavedPlayPosition(NiceVideoPlayer.this.mContext, NiceVideoPlayer.this.mUrl);
                mp.seekTo(savedPlayPosition);
            }
            if (NiceVideoPlayer.this.skipToPosition != 0L) {
                mp.seekTo(NiceVideoPlayer.this.skipToPosition);
            }
        }
    };
    private IMediaPlayer.OnVideoSizeChangedListener mOnVideoSizeChangedListener = new IMediaPlayer.OnVideoSizeChangedListener(){

        public void onVideoSizeChanged(IMediaPlayer mp, int width, int height, int sar_num, int sar_den) {
            NiceVideoPlayer.this.mTextureView.adaptVideoSize(width, height);
            LogUtil.d("onVideoSizeChanged \u2014\u2014> width\uff1a" + width + "\uff0c height\uff1a" + height);
        }
    };
    private IMediaPlayer.OnCompletionListener mOnCompletionListener = new IMediaPlayer.OnCompletionListener(){

        public void onCompletion(IMediaPlayer mp) {
            NiceVideoPlayer.this.mCurrentState = 7;
            NiceVideoPlayer.this.mController.onPlayStateChanged(NiceVideoPlayer.this.mCurrentState);
            LogUtil.d("onCompletion \u2014\u2014> STATE_COMPLETED");
            NiceVideoPlayer.this.mContainer.setKeepScreenOn(false);
        }
    };
    private IMediaPlayer.OnErrorListener mOnErrorListener = new IMediaPlayer.OnErrorListener(){

        public boolean onError(IMediaPlayer mp, int what, int extra) {
            if (what != -38 && what != Integer.MIN_VALUE && extra != -38 && extra != Integer.MIN_VALUE) {
                NiceVideoPlayer.this.mCurrentState = -1;
                NiceVideoPlayer.this.mController.onPlayStateChanged(NiceVideoPlayer.this.mCurrentState);
                LogUtil.d("onError \u2014\u2014> STATE_ERROR \u2014\u2014\u2014\u2014 what\uff1a" + what + ", extra: " + extra);
            }
            return true;
        }
    };
    private IMediaPlayer.OnInfoListener mOnInfoListener = new IMediaPlayer.OnInfoListener(){

        public boolean onInfo(IMediaPlayer mp, int what, int extra) {
            if (what == 3) {
                NiceVideoPlayer.this.mCurrentState = 3;
                NiceVideoPlayer.this.mController.onPlayStateChanged(NiceVideoPlayer.this.mCurrentState);
                LogUtil.d("onInfo \u2014\u2014> MEDIA_INFO_VIDEO_RENDERING_START\uff1aSTATE_PLAYING");
            } else if (what == 701) {
                if (NiceVideoPlayer.this.mCurrentState == 4 || NiceVideoPlayer.this.mCurrentState == 6) {
                    NiceVideoPlayer.this.mCurrentState = 6;
                    LogUtil.d("onInfo \u2014\u2014> MEDIA_INFO_BUFFERING_START\uff1aSTATE_BUFFERING_PAUSED");
                } else {
                    NiceVideoPlayer.this.mCurrentState = 5;
                    LogUtil.d("onInfo \u2014\u2014> MEDIA_INFO_BUFFERING_START\uff1aSTATE_BUFFERING_PLAYING");
                }
                NiceVideoPlayer.this.mController.onPlayStateChanged(NiceVideoPlayer.this.mCurrentState);
            } else if (what == 702) {
                if (NiceVideoPlayer.this.mCurrentState == 5) {
                    NiceVideoPlayer.this.mCurrentState = 3;
                    NiceVideoPlayer.this.mController.onPlayStateChanged(NiceVideoPlayer.this.mCurrentState);
                    LogUtil.d("onInfo \u2014\u2014> MEDIA_INFO_BUFFERING_END\uff1a STATE_PLAYING");
                }
                if (NiceVideoPlayer.this.mCurrentState == 6) {
                    NiceVideoPlayer.this.mCurrentState = 4;
                    NiceVideoPlayer.this.mController.onPlayStateChanged(NiceVideoPlayer.this.mCurrentState);
                    LogUtil.d("onInfo \u2014\u2014> MEDIA_INFO_BUFFERING_END\uff1a STATE_PAUSED");
                }
            } else if (what == 10001) {
                if (NiceVideoPlayer.this.mTextureView != null) {
                    NiceVideoPlayer.this.mTextureView.setRotation(extra);
                    LogUtil.d("\u89c6\u9891\u65cb\u8f6c\u89d2\u5ea6\uff1a" + extra);
                }
            } else if (what == 801) {
                LogUtil.d("\u89c6\u9891\u4e0d\u80fdseekTo\uff0c\u4e3a\u76f4\u64ad\u89c6\u9891");
            } else {
                LogUtil.d("onInfo \u2014\u2014> what\uff1a" + what);
            }
            return true;
        }
    };
    private IMediaPlayer.OnBufferingUpdateListener mOnBufferingUpdateListener = new IMediaPlayer.OnBufferingUpdateListener(){

        public void onBufferingUpdate(IMediaPlayer mp, int percent) {
            NiceVideoPlayer.this.mBufferPercentage = percent;
        }
    };

    public NiceVideoPlayer(Context context) {
        this(context, null);
    }

    public NiceVideoPlayer(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mContext = context;
        this.init();
    }

    private void init() {
        this.mContainer = new FrameLayout(this.mContext);
        this.mContainer.setBackgroundColor(-16777216);
        FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-1, -1);
        this.addView((View)this.mContainer, (ViewGroup.LayoutParams)params);
    }

    @Override
    public void setUp(String url, Map<String, String> headers) {
        this.mUrl = url;
        this.mHeaders = headers;
    }

    public void setController(NiceVideoPlayerController controller) {
        this.mContainer.removeView((View)this.mController);
        this.mController = controller;
        this.mController.reset();
        this.mController.setNiceVideoPlayer(this);
        FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-1, -1);
        this.mContainer.addView((View)this.mController, (ViewGroup.LayoutParams)params);
    }

    public void setPlayerType(int playerType) {
        this.mPlayerType = playerType;
    }

    @Override
    public void continueFromLastPosition(boolean continueFromLastPosition) {
        this.continueFromLastPosition = continueFromLastPosition;
    }

    @Override
    public void setSpeed(float speed) {
        if (this.mMediaPlayer instanceof IjkMediaPlayer) {
            ((IjkMediaPlayer)this.mMediaPlayer).setSpeed(speed);
        } else {
            LogUtil.d("\u53ea\u6709IjkPlayer\u624d\u80fd\u8bbe\u7f6e\u64ad\u653e\u901f\u5ea6");
        }
    }

    @Override
    public void start() {
        if (this.mCurrentState == 0) {
            NiceVideoPlayerManager.instance().setCurrentNiceVideoPlayer(this);
            this.initAudioManager();
            this.initMediaPlayer();
            this.initTextureView();
            this.addTextureView();
        } else {
            LogUtil.d("NiceVideoPlayer\u53ea\u6709\u5728mCurrentState == STATE_IDLE\u65f6\u624d\u80fd\u8c03\u7528start\u65b9\u6cd5.");
        }
    }

    @Override
    public void start(long position) {
        this.skipToPosition = position;
        this.start();
    }

    @Override
    public void restart() {
        if (this.mCurrentState == 4) {
            this.mMediaPlayer.start();
            this.mCurrentState = 3;
            this.mController.onPlayStateChanged(this.mCurrentState);
            LogUtil.d("STATE_PLAYING");
        } else if (this.mCurrentState == 6) {
            this.mMediaPlayer.start();
            this.mCurrentState = 5;
            this.mController.onPlayStateChanged(this.mCurrentState);
            LogUtil.d("STATE_BUFFERING_PLAYING");
        } else if (this.mCurrentState == 7 || this.mCurrentState == -1) {
            this.mMediaPlayer.reset();
            this.openMediaPlayer();
        } else {
            LogUtil.d("NiceVideoPlayer\u5728mCurrentState == " + this.mCurrentState + "\u65f6\u4e0d\u80fd\u8c03\u7528restart()\u65b9\u6cd5.");
        }
    }

    @Override
    public void pause() {
        if (this.mCurrentState == 3) {
            this.mMediaPlayer.pause();
            this.mCurrentState = 4;
            this.mController.onPlayStateChanged(this.mCurrentState);
            LogUtil.d("STATE_PAUSED");
        }
        if (this.mCurrentState == 5) {
            this.mMediaPlayer.pause();
            this.mCurrentState = 6;
            this.mController.onPlayStateChanged(this.mCurrentState);
            LogUtil.d("STATE_BUFFERING_PAUSED");
        }
    }

    @Override
    public void seekTo(long pos) {
        if (this.mMediaPlayer != null) {
            this.mMediaPlayer.seekTo(pos);
        }
    }

    @Override
    public void setVolume(int volume) {
        if (this.mAudioManager != null) {
            this.mAudioManager.setStreamVolume(3, volume, 0);
        }
    }

    @Override
    public boolean isIdle() {
        return this.mCurrentState == 0;
    }

    @Override
    public boolean isPreparing() {
        return this.mCurrentState == 1;
    }

    @Override
    public boolean isPrepared() {
        return this.mCurrentState == 2;
    }

    @Override
    public boolean isBufferingPlaying() {
        return this.mCurrentState == 5;
    }

    @Override
    public boolean isBufferingPaused() {
        return this.mCurrentState == 6;
    }

    @Override
    public boolean isPlaying() {
        return this.mCurrentState == 3;
    }

    @Override
    public boolean isPaused() {
        return this.mCurrentState == 4;
    }

    @Override
    public boolean isError() {
        return this.mCurrentState == -1;
    }

    @Override
    public boolean isCompleted() {
        return this.mCurrentState == 7;
    }

    @Override
    public boolean isFullScreen() {
        return this.mCurrentMode == 11;
    }

    @Override
    public boolean isTinyWindow() {
        return this.mCurrentMode == 12;
    }

    @Override
    public boolean isNormal() {
        return this.mCurrentMode == 10;
    }

    @Override
    public int getMaxVolume() {
        if (this.mAudioManager != null) {
            return this.mAudioManager.getStreamMaxVolume(3);
        }
        return 0;
    }

    @Override
    public int getVolume() {
        if (this.mAudioManager != null) {
            return this.mAudioManager.getStreamVolume(3);
        }
        return 0;
    }

    @Override
    public long getDuration() {
        return this.mMediaPlayer != null ? this.mMediaPlayer.getDuration() : 0L;
    }

    @Override
    public long getCurrentPosition() {
        return this.mMediaPlayer != null ? this.mMediaPlayer.getCurrentPosition() : 0L;
    }

    @Override
    public int getBufferPercentage() {
        return this.mBufferPercentage;
    }

    @Override
    public float getSpeed(float speed) {
        if (this.mMediaPlayer instanceof IjkMediaPlayer) {
            return ((IjkMediaPlayer)this.mMediaPlayer).getSpeed(speed);
        }
        return 0.0f;
    }

    @Override
    public long getTcpSpeed() {
        if (this.mMediaPlayer instanceof IjkMediaPlayer) {
            return ((IjkMediaPlayer)this.mMediaPlayer).getTcpSpeed();
        }
        return 0L;
    }

    private void initAudioManager() {
        if (this.mAudioManager == null) {
            this.mAudioManager = (AudioManager)this.getContext().getSystemService("audio");
            this.mAudioManager.requestAudioFocus(null, 3, 1);
        }
    }

    private void initMediaPlayer() {
        if (this.mMediaPlayer == null) {
            switch (this.mPlayerType) {
                case 222: {
                    this.mMediaPlayer = new AndroidMediaPlayer();
                    break;
                }
                default: {
                    this.mMediaPlayer = new IjkMediaPlayer();
                    ((IjkMediaPlayer)this.mMediaPlayer).setOption(1, "analyzemaxduration", 100L);
                    ((IjkMediaPlayer)this.mMediaPlayer).setOption(1, "probesize", 10240L);
                    ((IjkMediaPlayer)this.mMediaPlayer).setOption(1, "flush_packets", 1L);
                    ((IjkMediaPlayer)this.mMediaPlayer).setOption(4, "packet-buffering", 0L);
                    ((IjkMediaPlayer)this.mMediaPlayer).setOption(4, "framedrop", 1L);
                }
            }
            this.mMediaPlayer.setAudioStreamType(3);
        }
    }

    private void initTextureView() {
        if (this.mTextureView == null) {
            this.mTextureView = new NiceTextureView(this.mContext);
            this.mTextureView.setSurfaceTextureListener(this);
        }
    }

    private void addTextureView() {
        this.mContainer.removeView((View)this.mTextureView);
        FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-1, -1, 17);
        this.mContainer.addView((View)this.mTextureView, 0, (ViewGroup.LayoutParams)params);
    }

    public void onSurfaceTextureAvailable(SurfaceTexture surfaceTexture, int width, int height) {
        if (this.mSurfaceTexture == null) {
            this.mSurfaceTexture = surfaceTexture;
            this.openMediaPlayer();
        } else {
            this.mTextureView.setSurfaceTexture(this.mSurfaceTexture);
        }
    }

    private void openMediaPlayer() {
        this.mContainer.setKeepScreenOn(true);
        this.mMediaPlayer.setOnPreparedListener(this.mOnPreparedListener);
        this.mMediaPlayer.setOnVideoSizeChangedListener(this.mOnVideoSizeChangedListener);
        this.mMediaPlayer.setOnCompletionListener(this.mOnCompletionListener);
        this.mMediaPlayer.setOnErrorListener(this.mOnErrorListener);
        this.mMediaPlayer.setOnInfoListener(this.mOnInfoListener);
        this.mMediaPlayer.setOnBufferingUpdateListener(this.mOnBufferingUpdateListener);
        try {
            this.mMediaPlayer.setDataSource(this.mContext.getApplicationContext(), Uri.parse((String)this.mUrl), this.mHeaders);
            if (this.mSurface == null) {
                this.mSurface = new Surface(this.mSurfaceTexture);
            }
            this.mMediaPlayer.setSurface(this.mSurface);
            this.mMediaPlayer.prepareAsync();
            this.mCurrentState = 1;
            this.mController.onPlayStateChanged(this.mCurrentState);
            LogUtil.d("STATE_PREPARING");
        }
        catch (IOException e) {
            e.printStackTrace();
            LogUtil.e("\u6253\u5f00\u64ad\u653e\u5668\u53d1\u751f\u9519\u8bef", e);
        }
    }

    public void onSurfaceTextureSizeChanged(SurfaceTexture surface, int width, int height) {
    }

    public boolean onSurfaceTextureDestroyed(SurfaceTexture surface) {
        return this.mSurfaceTexture == null;
    }

    public void onSurfaceTextureUpdated(SurfaceTexture surface) {
    }

    @Override
    public void enterFullScreen() {
        if (this.mCurrentMode == 11) {
            return;
        }
        NiceUtil.hideActionBar(this.mContext);
        NiceUtil.scanForActivity(this.mContext).setRequestedOrientation(0);
        ViewGroup contentView = (ViewGroup)NiceUtil.scanForActivity(this.mContext).findViewById(0x1020002);
        if (this.mCurrentMode == 12) {
            contentView.removeView((View)this.mContainer);
        } else {
            this.removeView((View)this.mContainer);
        }
        FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-1, -1);
        contentView.addView((View)this.mContainer, (ViewGroup.LayoutParams)params);
        this.mCurrentMode = 11;
        this.mController.onPlayModeChanged(this.mCurrentMode);
        LogUtil.d("MODE_FULL_SCREEN");
    }

    @Override
    public boolean exitFullScreen() {
        if (this.mCurrentMode == 11) {
            NiceUtil.showActionBar(this.mContext);
            NiceUtil.scanForActivity(this.mContext).setRequestedOrientation(1);
            ViewGroup contentView = (ViewGroup)NiceUtil.scanForActivity(this.mContext).findViewById(0x1020002);
            contentView.removeView((View)this.mContainer);
            FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-1, -1);
            this.addView((View)this.mContainer, (ViewGroup.LayoutParams)params);
            this.mCurrentMode = 10;
            this.mController.onPlayModeChanged(this.mCurrentMode);
            LogUtil.d("MODE_NORMAL");
            return true;
        }
        return false;
    }

    @Override
    public void enterTinyWindow() {
        if (this.mCurrentMode == 12) {
            return;
        }
        this.removeView((View)this.mContainer);
        ViewGroup contentView = (ViewGroup)NiceUtil.scanForActivity(this.mContext).findViewById(0x1020002);
        FrameLayout.LayoutParams params = new FrameLayout.LayoutParams((int)((float)NiceUtil.getScreenWidth(this.mContext) * 0.6f), (int)((float)NiceUtil.getScreenWidth(this.mContext) * 0.6f * 9.0f / 16.0f));
        params.gravity = 0x800055;
        params.rightMargin = NiceUtil.dp2px(this.mContext, 8.0f);
        params.bottomMargin = NiceUtil.dp2px(this.mContext, 8.0f);
        contentView.addView((View)this.mContainer, (ViewGroup.LayoutParams)params);
        this.mCurrentMode = 12;
        this.mController.onPlayModeChanged(this.mCurrentMode);
        LogUtil.d("MODE_TINY_WINDOW");
    }

    @Override
    public boolean exitTinyWindow() {
        if (this.mCurrentMode == 12) {
            ViewGroup contentView = (ViewGroup)NiceUtil.scanForActivity(this.mContext).findViewById(0x1020002);
            contentView.removeView((View)this.mContainer);
            FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-1, -1);
            this.addView((View)this.mContainer, (ViewGroup.LayoutParams)params);
            this.mCurrentMode = 10;
            this.mController.onPlayModeChanged(this.mCurrentMode);
            LogUtil.d("MODE_NORMAL");
            return true;
        }
        return false;
    }

    @Override
    public void releasePlayer() {
        if (this.mAudioManager != null) {
            this.mAudioManager.abandonAudioFocus(null);
            this.mAudioManager = null;
        }
        if (this.mMediaPlayer != null) {
            this.mMediaPlayer.release();
            this.mMediaPlayer = null;
        }
        this.mContainer.removeView((View)this.mTextureView);
        if (this.mSurface != null) {
            this.mSurface.release();
            this.mSurface = null;
        }
        if (this.mSurfaceTexture != null) {
            this.mSurfaceTexture.release();
            this.mSurfaceTexture = null;
        }
        this.mCurrentState = 0;
    }

    @Override
    public void release() {
        if (this.isPlaying() || this.isBufferingPlaying() || this.isBufferingPaused() || this.isPaused()) {
            NiceUtil.savePlayPosition(this.mContext, this.mUrl, this.getCurrentPosition());
        } else if (this.isCompleted()) {
            NiceUtil.savePlayPosition(this.mContext, this.mUrl, 0L);
        }
        if (this.isFullScreen()) {
            this.exitFullScreen();
        }
        if (this.isTinyWindow()) {
            this.exitTinyWindow();
        }
        this.mCurrentMode = 10;
        this.releasePlayer();
        if (this.mController != null) {
            this.mController.reset();
        }
        Runtime.getRuntime().gc();
    }
}

