/*
 * Decompiled with CFR 0.152.
 */
package com.xiaojinzi.component.impl.service;

import android.support.annotation.AnyThread;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import com.xiaojinzi.component.error.NotSupportException;
import com.xiaojinzi.component.error.ServiceRepeatCreateException;
import com.xiaojinzi.component.support.Callable;
import com.xiaojinzi.component.support.DecoratorCallable;
import com.xiaojinzi.component.support.SingletonCallable;
import com.xiaojinzi.component.support.Utils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class ServiceManager {
    public static final String DEFAULT_NAME = "";
    private static final Map<Class, HashMap<String, Callable<?>>> serviceMap = new HashMap();
    private static final Map<Class, HashMap<String, DecoratorCallable<?>>> serviceDecoratorMap = new HashMap();
    private static final Set<String> uniqueServiceSet = new HashSet<String>();
    private static final HashMap<Class, String> autoInitMap = new HashMap();

    private ServiceManager() {
        throw new NotSupportException("can't to create");
    }

    public static <T> void registerAutoInit(@NonNull Class<T> tClass) {
        ServiceManager.registerAutoInit(tClass, null);
    }

    public static <T> void registerAutoInit(@NonNull Class<T> tClass, @Nullable String name) {
        Utils.checkNullPointer(tClass, "tClass");
        autoInitMap.put(tClass, name);
    }

    public static <T> void unregisterAutoInit(@NonNull Class<T> tClass) {
        Utils.checkNullPointer(tClass, "tClass");
        autoInitMap.remove(tClass);
    }

    @WorkerThread
    public static void autoInitService() {
        for (Map.Entry<Class, String> entry : autoInitMap.entrySet()) {
            if (entry.getValue() == null) {
                ServiceManager.get(entry.getKey());
                continue;
            }
            ServiceManager.get(entry.getKey(), entry.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AnyThread
    public static <T> void registerDecorator(@NonNull Class<T> tClass, @NonNull String uid, @NonNull DecoratorCallable<? extends T> callable) {
        Utils.checkNullPointer(tClass, "tClass");
        Utils.checkNullPointer(uid, "uid");
        Utils.checkNullPointer(callable, "callable");
        Map<Class, HashMap<String, DecoratorCallable<?>>> map = serviceDecoratorMap;
        synchronized (map) {
            HashMap<String, DecoratorCallable<Object>> map2 = serviceDecoratorMap.get(tClass);
            if (map2 == null) {
                map2 = new HashMap();
                serviceDecoratorMap.put(tClass, map2);
            }
            if (serviceDecoratorMap.containsKey(uid)) {
                throw new RuntimeException(tClass.getSimpleName() + " the key of '" + uid + "' is exist");
            }
            map2.put(uid, callable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AnyThread
    public static <T> void unregisterDecorator(@NonNull Class<T> tClass, @NonNull String uid) {
        Utils.checkNullPointer(tClass, "tClass");
        Utils.checkNullPointer(uid, "uid");
        Map<Class, HashMap<String, DecoratorCallable<?>>> map = serviceDecoratorMap;
        synchronized (map) {
            HashMap<String, DecoratorCallable<?>> map2 = serviceDecoratorMap.get(tClass);
            if (map2 != null) {
                map2.remove(uid);
            }
        }
    }

    @AnyThread
    public static <T> void register(@NonNull Class<T> tClass, @NonNull Callable<? extends T> callable) {
        ServiceManager.register(tClass, DEFAULT_NAME, callable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AnyThread
    public static <T> void register(@NonNull Class<T> tClass, @NonNull String name, @NonNull Callable<? extends T> callable) {
        Utils.checkNullPointer(tClass, "tClass");
        Utils.checkNullPointer(name, "name");
        Utils.checkNullPointer(callable, "callable");
        Map<Class, HashMap<String, Callable<?>>> map = serviceMap;
        synchronized (map) {
            HashMap<String, Callable<Object>> implServiceMap = serviceMap.get(tClass);
            if (implServiceMap == null) {
                implServiceMap = new HashMap();
                serviceMap.put(tClass, implServiceMap);
            }
            if (implServiceMap.containsKey(name)) {
                throw new RuntimeException(tClass.getSimpleName() + " the key of '" + name + "' is exist");
            }
            implServiceMap.put(name, callable);
        }
    }

    @Nullable
    @AnyThread
    public static <T> void unregister(@NonNull Class<T> tClass) {
        ServiceManager.unregister(tClass, DEFAULT_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    @AnyThread
    public static <T> void unregister(@NonNull Class<T> tClass, @NonNull String name) {
        Utils.checkNullPointer(tClass, "tClass");
        Utils.checkNullPointer(name, "name");
        Map<Class, HashMap<String, Callable<?>>> map = serviceMap;
        synchronized (map) {
            HashMap<String, Callable<?>> implServiceMap = serviceMap.get(tClass);
            if (implServiceMap != null) {
                Callable<?> callable = implServiceMap.remove(name);
                if (callable == null) {
                    return;
                }
                if (callable instanceof SingletonCallable && ((SingletonCallable)callable).isInit()) {
                    ((SingletonCallable)callable).destroy();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T decorate(@NonNull Class<T> tClass, @NonNull T target) {
        Utils.checkNullPointer(tClass, "tClass");
        Utils.checkNullPointer(target, "target");
        T result = target;
        Map<Class, HashMap<String, DecoratorCallable<?>>> map = serviceDecoratorMap;
        synchronized (map) {
            Collection<DecoratorCallable<?>> values;
            HashMap<String, DecoratorCallable<?>> map2 = serviceDecoratorMap.get(tClass);
            if (map2 != null && (values = map2.values()) != null) {
                ArrayList list = new ArrayList(values);
                Collections.sort(list, new Comparator<DecoratorCallable<?>>(){

                    @Override
                    public int compare(DecoratorCallable<?> o1, DecoratorCallable<?> o2) {
                        return o1.priority() - o2.priority();
                    }
                });
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    DecoratorCallable callable;
                    DecoratorCallable realCallable = callable = (DecoratorCallable)iterator.next();
                    result = realCallable.get(result);
                }
            }
        }
        return result;
    }

    @Nullable
    @AnyThread
    public static <T> T get(@NonNull Class<T> tClass) {
        return ServiceManager.get(tClass, DEFAULT_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    @AnyThread
    public static <T> T get(@NonNull Class<T> tClass, @NonNull String name) {
        Utils.checkNullPointer(tClass, "tClass");
        Utils.checkNullPointer(name, "name");
        Map<Class, HashMap<String, Callable<?>>> map = serviceMap;
        synchronized (map) {
            Callable<?> callable;
            String uniqueName = tClass.getName() + ":" + name;
            if (uniqueServiceSet.contains(uniqueName)) {
                throw new ServiceRepeatCreateException("className is " + tClass.getName() + ", serviceName is '" + name + "'");
            }
            uniqueServiceSet.add(uniqueName);
            T result = null;
            HashMap<String, Callable<?>> implServiceMap = serviceMap.get(tClass);
            if (implServiceMap != null && (callable = implServiceMap.get(name)) != null) {
                Object t = Utils.checkNullPointer(callable.get());
                result = ServiceManager.decorate(tClass, t);
            }
            uniqueServiceSet.remove(uniqueName);
            return result;
        }
    }

    @NonNull
    @AnyThread
    public static <T> T requiredGet(@NonNull Class<T> tClass) {
        return ServiceManager.requiredGet(tClass, DEFAULT_NAME);
    }

    @NonNull
    @AnyThread
    public static <T> T requiredGet(@NonNull Class<T> tClass, @NonNull String name) {
        return Utils.checkNullPointer(ServiceManager.get(tClass, name));
    }
}

