/*
 * Decompiled with CFR 0.152.
 */
package com.xiaojinzi.component.impl.application;

import android.support.annotation.AnyThread;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.UiThread;
import com.xiaojinzi.component.Component;
import com.xiaojinzi.component.ComponentUtil;
import com.xiaojinzi.component.application.IComponentCenterApplication;
import com.xiaojinzi.component.application.IComponentHostApplication;
import com.xiaojinzi.component.cache.ClassCache;
import com.xiaojinzi.component.impl.RouterCenter;
import com.xiaojinzi.component.impl.RouterDegradeCenter;
import com.xiaojinzi.component.impl.fragment.FragmentCenter;
import com.xiaojinzi.component.impl.interceptor.InterceptorCenter;
import com.xiaojinzi.component.impl.service.ServiceCenter;
import com.xiaojinzi.component.impl.service.ServiceManager;
import com.xiaojinzi.component.support.ASMUtil;
import com.xiaojinzi.component.support.LogUtil;
import com.xiaojinzi.component.support.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class ModuleManager
implements IComponentCenterApplication {
    private static volatile ModuleManager instance;
    private static Map<String, IComponentHostApplication> moduleApplicationMap;

    private ModuleManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ModuleManager getInstance() {
        if (instance != null) return instance;
        Class<ModuleManager> clazz = ModuleManager.class;
        synchronized (ModuleManager.class) {
            if (instance != null) return instance;
            instance = new ModuleManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    @Override
    @UiThread
    public void register(final @NonNull IComponentHostApplication moduleApp) {
        Utils.checkNullPointer(moduleApp);
        if (moduleApplicationMap.containsKey(moduleApp.getHost())) {
            LogUtil.loge("The module \"" + moduleApp.getHost() + "\" is already registered");
        } else {
            moduleApplicationMap.put(moduleApp.getHost(), moduleApp);
            moduleApp.onCreate(Component.getApplication());
            ServiceCenter.getInstance().register(moduleApp.getHost());
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    RouterCenter.getInstance().register(moduleApp.getHost());
                    InterceptorCenter.getInstance().register(moduleApp.getHost());
                    RouterDegradeCenter.getInstance().register(moduleApp.getHost());
                    FragmentCenter.getInstance().register(moduleApp.getHost());
                    ModuleManager.this.notifyModuleChanged();
                }
            };
            if (Component.getConfig().isInitRouterAsync()) {
                Utils.postActionToWorkThread(r);
            } else {
                r.run();
            }
        }
    }

    @Override
    public void register(@NonNull String host) {
        Utils.checkNullPointer(host, "host");
        if (moduleApplicationMap.containsKey(host)) {
            LogUtil.loge("the host '" + host + "' is already load");
            return;
        }
        IComponentHostApplication moduleApplication = ModuleManager.findModuleApplication(host);
        if (moduleApplication == null) {
            LogUtil.log("\u6a21\u5757 '" + host + "' \u52a0\u8f7d\u5931\u8d25, \u8bf7\u6839\u636e\u94fe\u63a5\u4e2d\u7684\u5185\u5bb9\u81ea\u884c\u6392\u67e5! \n " + "https://github.com/xiaojinzi123/Component/issues/21");
        } else {
            this.register(moduleApplication);
        }
    }

    public void autoRegister() {
        List<String> moduleNames;
        if (!Component.getConfig().isOptimizeInit()) {
            LogUtil.logw("you can't use this method to register module. Because you not turn on 'optimizeInit' by calling method 'Config.Builder.optimizeInit(true)' when you init");
        }
        if ((moduleNames = ASMUtil.getModuleNames()) != null && !moduleNames.isEmpty()) {
            this.registerArr(moduleNames.toArray(new String[0]));
        }
    }

    public void registerArr(String ... hosts) {
        if (hosts != null) {
            ArrayList<IComponentHostApplication> appList = new ArrayList<IComponentHostApplication>(hosts.length);
            for (String host : hosts) {
                IComponentHostApplication moduleApplication = ModuleManager.findModuleApplication(host);
                if (moduleApplication == null) {
                    LogUtil.log("\u6a21\u5757 '" + host + "' \u52a0\u8f7d\u5931\u8d25, \u8bf7\u6839\u636e\u94fe\u63a5\u4e2d\u7684\u5185\u5bb9\u81ea\u884c\u6392\u67e5! \n " + "https://github.com/xiaojinzi123/Component/issues/21");
                    continue;
                }
                appList.add(moduleApplication);
            }
            Collections.sort(appList, new Comparator<IComponentHostApplication>(){

                @Override
                public int compare(IComponentHostApplication o1, IComponentHostApplication o2) {
                    return o2.getPriority() - o1.getPriority();
                }
            });
            for (IComponentHostApplication moduleApplication : appList) {
                this.register(moduleApplication);
            }
        }
    }

    @Override
    @UiThread
    public void unregister(final @NonNull IComponentHostApplication moduleApp) {
        Utils.checkNullPointer(moduleApp);
        moduleApplicationMap.remove(moduleApp.getHost());
        moduleApp.onDestroy();
        ServiceCenter.getInstance().unregister(moduleApp.getHost());
        Utils.postActionToWorkThread(new Runnable(){

            @Override
            public void run() {
                RouterCenter.getInstance().unregister(moduleApp.getHost());
                InterceptorCenter.getInstance().unregister(moduleApp.getHost());
                RouterDegradeCenter.getInstance().unregister(moduleApp.getHost());
                FragmentCenter.getInstance().unregister(moduleApp.getHost());
                ClassCache.clear();
                ModuleManager.this.notifyModuleChanged();
            }
        });
    }

    @Override
    public void unregister(@NonNull String host) {
        Utils.checkNullPointer(host, "host");
        IComponentHostApplication moduleApp = moduleApplicationMap.get(host);
        if (moduleApp == null) {
            LogUtil.log("\u6a21\u5757 '" + host + "' \u5378\u8f7d\u5931\u8d25");
        } else {
            this.unregister(moduleApp);
        }
    }

    public void unregisterAll() {
        for (String host : new HashSet<String>(moduleApplicationMap.keySet())) {
            this.unregister(host);
        }
    }

    @Nullable
    public static IComponentHostApplication findModuleApplication(@NonNull String host) {
        IComponentHostApplication result = null;
        if (Component.getConfig().isOptimizeInit()) {
            LogUtil.log("\"" + host + "\" will try to load by bytecode");
            result = ASMUtil.findModuleApplicationAsmImpl(ComponentUtil.transformHostForClass((String)host));
        } else {
            Class<?> clazz2;
            LogUtil.log("\"" + host + "\" will try to load by reflection");
            if (result == null) {
                try {
                    clazz2 = Class.forName(ComponentUtil.genHostModuleApplicationClassName((String)host));
                    result = (IComponentHostApplication)clazz2.newInstance();
                }
                catch (Exception clazz2) {
                    // empty catch block
                }
            }
            if (result == null) {
                try {
                    clazz2 = Class.forName(ComponentUtil.genDefaultHostModuleApplicationClassName((String)host));
                    result = (IComponentHostApplication)clazz2.newInstance();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return result;
    }

    @AnyThread
    private void notifyModuleChanged() {
        final int compareValue = Utils.COUNTER.incrementAndGet();
        Utils.postDelayActionToMainThread(new Runnable(){

            @Override
            public void run() {
                if (compareValue == Utils.COUNTER.get()) {
                    ModuleManager.this.doNotifyModuleChanged();
                }
            }
        }, Component.getConfig().getNotifyModuleChangedDelayTime());
    }

    @UiThread
    private void doNotifyModuleChanged() {
        for (IComponentHostApplication hostApplication : moduleApplicationMap.values()) {
            hostApplication.onModuleChanged(Component.getApplication());
        }
        Component.check();
        Utils.postActionToWorkThread(new Runnable(){

            @Override
            public void run() {
                ServiceManager.autoInitService();
            }
        });
    }

    static {
        moduleApplicationMap = new HashMap<String, IComponentHostApplication>();
    }
}

