/*
 * Decompiled with CFR 0.152.
 */
package com.xiaojinzi.component.impl;

import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.support.annotation.AnyThread;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.UiThread;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import com.xiaojinzi.component.error.RouterRuntimeException;
import com.xiaojinzi.component.impl.BiCallback;
import com.xiaojinzi.component.impl.Callback;
import com.xiaojinzi.component.impl.Router;
import com.xiaojinzi.component.impl.RouterErrorResult;
import com.xiaojinzi.component.impl.RouterListener;
import com.xiaojinzi.component.impl.RouterRequest;
import com.xiaojinzi.component.impl.RouterResult;
import com.xiaojinzi.component.support.LogUtil;
import com.xiaojinzi.component.support.OnRouterCancel;
import com.xiaojinzi.component.support.RouterRequestHelp;
import com.xiaojinzi.component.support.Utils;

class RouterUtil {
    private static final String TAG = "-------- Router --------";

    private RouterUtil() {
    }

    @AnyThread
    public static void cancelCallback(final @Nullable RouterRequest request, final @Nullable OnRouterCancel callback) {
        Utils.postActionToMainThreadAnyway(new Runnable(){

            @Override
            public void run() {
                RouterUtil.cancelCallbackOnMainThread(request, callback);
            }
        });
        RouterUtil.deliveryListener(null, null, request);
    }

    @UiThread
    private static void cancelCallbackOnMainThread(@Nullable RouterRequest request, @Nullable OnRouterCancel callback) {
        if (request == null) {
            LogUtil.log(TAG, "route canceled, request is null!");
        } else {
            LogUtil.log(TAG, "route canceled\uff1a" + request.uri.toString());
        }
        if (callback == null) {
            return;
        }
        callback.onCancel(request);
    }

    @AnyThread
    public static void errorCallback(final @Nullable Callback callback, final @Nullable BiCallback biCallback, final @NonNull RouterErrorResult errorResult) {
        Utils.postActionToMainThreadAnyway(new Runnable(){

            @Override
            public void run() {
                RouterUtil.errorCallbackOnMainThread(callback, biCallback, errorResult);
            }
        });
        RouterUtil.deliveryListener(null, errorResult, null);
    }

    @UiThread
    private static void errorCallbackOnMainThread(@Nullable Callback callback, @Nullable BiCallback biCallback, @NonNull RouterErrorResult errorResult) {
        Utils.checkNullPointer(errorResult, "errorResult");
        if (errorResult.getOriginalRequest() == null) {
            LogUtil.log(TAG, "route fail\uff1arouterRequest has not been created, errorClass is " + Utils.getRealThrowable(errorResult.getError()).getClass().getSimpleName() + ":" + Utils.getRealMessage(errorResult.getError()));
        } else {
            LogUtil.log(TAG, "route fail\uff1a" + errorResult.getOriginalRequest().uri.toString() + " and errorClass is " + Utils.getRealThrowable(errorResult.getError()).getClass().getSimpleName() + ",errorMsg is '" + Utils.getRealMessage(errorResult.getError()) + "'");
        }
        if (errorResult.getOriginalRequest() != null && RouterUtil.isRequestUnavailabled(errorResult.getOriginalRequest())) {
            return;
        }
        if (errorResult.getOriginalRequest() != null) {
            try {
                RouterRequestHelp.executeAfterErrorAction(errorResult.getOriginalRequest());
            }
            catch (Exception e) {
                throw new RouterRuntimeException("afterErrorCallback or afterEventCallback can't throw any exception!", e);
            }
        }
        if (callback != null) {
            callback.onError(errorResult);
            callback.onEvent(null, errorResult);
        }
        if (biCallback != null) {
            biCallback.onError(errorResult);
        }
    }

    @AnyThread
    public static void successCallback(final @Nullable Callback callback, final @NonNull RouterResult successResult) {
        Utils.postActionToMainThreadAnyway(new Runnable(){

            @Override
            public void run() {
                RouterUtil.successCallbackOnMainThread(callback, successResult);
            }
        });
        RouterUtil.deliveryListener(successResult, null, null);
    }

    @UiThread
    private static void successCallbackOnMainThread(@Nullable Callback callback, @NonNull RouterResult result) {
        Utils.checkNullPointer(result, "result");
        LogUtil.log(TAG, "route success\uff1a" + result.getOriginalRequest().uri.toString());
        if (RouterUtil.isRequestUnavailabled(result.getOriginalRequest())) {
            return;
        }
        try {
            RouterRequestHelp.executeAfterAction(result.getFinalRequest());
        }
        catch (Exception e) {
            throw new RouterRuntimeException("afterJumpCallback or afterEventCallback can't throw any exception!", e);
        }
        if (callback != null) {
            callback.onSuccess(result);
            callback.onEvent(result, null);
        }
    }

    @AnyThread
    public static void deliveryListener(final @Nullable RouterResult successResult, final @Nullable RouterErrorResult errorResult, final @Nullable RouterRequest cancelRequest) {
        Utils.postActionToMainThreadAnyway(new Runnable(){

            @Override
            public void run() {
                RouterUtil.deliveryListenerOnMainThread(successResult, errorResult, cancelRequest);
            }
        });
    }

    @UiThread
    public static void deliveryListenerOnMainThread(@Nullable RouterResult successResult, @Nullable RouterErrorResult errorResult, @Nullable RouterRequest cancelRequest) {
        for (RouterListener listener : Router.routerListeners) {
            try {
                if (successResult != null) {
                    listener.onSuccess(successResult);
                }
                if (errorResult != null) {
                    listener.onError(errorResult);
                }
                if (cancelRequest == null) continue;
                listener.onCancel(cancelRequest);
            }
            catch (Exception exception) {}
        }
    }

    private static boolean isRequestUnavailabled(@NonNull RouterRequest originalRequest) {
        Context context = originalRequest.context;
        Fragment fragment = originalRequest.fragment;
        Activity act = Utils.getActivityFromContext(context);
        if (act != null && RouterUtil.isActivityUnavailabled(act)) {
            return true;
        }
        if (fragment != null) {
            if (fragment.isDetached()) {
                return true;
            }
            FragmentActivity activity = fragment.getActivity();
            if (activity == null) {
                return true;
            }
            if (RouterUtil.isActivityUnavailabled((Activity)activity)) {
                return true;
            }
        }
        return false;
    }

    private static boolean isActivityUnavailabled(@NonNull Activity activity) {
        boolean isUseful = true;
        if (activity.isFinishing()) {
            isUseful = false;
        }
        if (Build.VERSION.SDK_INT >= 17 && activity.isDestroyed()) {
            isUseful = false;
        }
        return !isUseful;
    }
}

