/*
 * Decompiled with CFR 0.152.
 */
package com.xiaojinzi.component.impl;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.xiaojinzi.component.impl.BiCallback;
import com.xiaojinzi.component.impl.RouterErrorResult;
import com.xiaojinzi.component.impl.RouterRequest;
import com.xiaojinzi.component.impl.RouterResult;
import com.xiaojinzi.component.support.Utils;

class BiCallbackWrap<T>
implements BiCallback<T> {
    private boolean isEnd;
    @NonNull
    private BiCallback<T> targetBiCallback;

    public BiCallbackWrap(@NonNull BiCallback<T> targetBiCallback) {
        Utils.checkNullPointer(targetBiCallback, "targetBiCallback");
        this.targetBiCallback = targetBiCallback;
    }

    @Override
    public synchronized void onSuccess(@NonNull RouterResult result, @NonNull T t) {
        if (!this.isEnd) {
            this.targetBiCallback.onSuccess(result, t);
        }
        this.isEnd = true;
    }

    @Override
    public synchronized void onCancel(@Nullable RouterRequest originalRequest) {
        if (!this.isEnd) {
            this.targetBiCallback.onCancel(originalRequest);
        }
        this.isEnd = true;
    }

    @Override
    public synchronized void onError(@NonNull RouterErrorResult errorResult) {
        if (!this.isEnd) {
            this.targetBiCallback.onError(errorResult);
        }
        this.isEnd = true;
    }
}

