/*
 * Decompiled with CFR 0.152.
 */
package com.xiaojinzi.component;

import com.google.auto.service.AutoService;
import com.google.gson.Gson;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.xiaojinzi.component.BaseHostProcessor;
import com.xiaojinzi.component.ComponentUtil;
import com.xiaojinzi.component.ProcessException;
import com.xiaojinzi.component.anno.RouterAnno;
import com.xiaojinzi.component.bean.RouterAnnoBean;
import com.xiaojinzi.component.bean.RouterDocBean;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedOptions;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.MirroredTypesException;
import javax.lang.model.type.TypeMirror;
import org.apache.commons.collections4.CollectionUtils;

@SupportedOptions(value={"HOST"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_7)
@SupportedAnnotationTypes(value={"com.xiaojinzi.component.anno.RouterAnno"})
@AutoService(value={Processor.class})
public class RouterProcessor
extends BaseHostProcessor {
    private static final String NAME_OF_REQUEST = "request";
    private ClassName customerIntentCallClassName;
    private TypeElement routerBeanTypeElement;
    private TypeElement pageInterceptorBeanTypeElement;
    private ClassName exceptionClassName;
    private TypeElement intentTypeElement;
    private TypeMirror intentTypeMirror;
    private TypeMirror routerRequestTypeMirror;
    private TypeMirror activityTypeMirror;
    private TypeElement interceptorTypeElement;
    final AtomicInteger atomicInteger = new AtomicInteger();
    private final String checkScheme = "__checkScheme__";
    private final Set<String> routerCheckMap = new HashSet<String>();
    private final Set<RouterAnnoBean> routerMap = new HashSet<RouterAnnoBean>();

    @Override
    public synchronized void init(ProcessingEnvironment processingEnvironment) {
        super.init(processingEnvironment);
        this.activityTypeMirror = this.mElements.getTypeElement("android.app.Activity").asType();
        this.interceptorTypeElement = this.mElements.getTypeElement("com.xiaojinzi.component.impl.RouterInterceptor");
        this.routerBeanTypeElement = this.mElements.getTypeElement("com.xiaojinzi.component.bean.RouterBean");
        this.pageInterceptorBeanTypeElement = this.mElements.getTypeElement("com.xiaojinzi.component.bean.PageInterceptorBean");
        TypeElement exceptionTypeElement = this.mElements.getTypeElement("java.lang.Exception");
        this.exceptionClassName = ClassName.get((TypeElement)exceptionTypeElement);
        TypeElement customerIntentCallTypeElement = this.mElements.getTypeElement("com.xiaojinzi.component.support.CustomerIntentCall");
        this.intentTypeElement = this.mElements.getTypeElement("android.content.Intent");
        this.intentTypeMirror = this.intentTypeElement.asType();
        TypeElement routerRequestTypeElement = this.mElements.getTypeElement("com.xiaojinzi.component.impl.RouterRequest");
        this.routerRequestTypeMirror = routerRequestTypeElement.asType();
        this.customerIntentCallClassName = ClassName.get((TypeElement)customerIntentCallTypeElement);
    }

    @Override
    public boolean process(Set<? extends TypeElement> set, RoundEnvironment roundEnvironment) {
        if (CollectionUtils.isNotEmpty(set)) {
            Set<? extends Element> routeElements = roundEnvironment.getElementsAnnotatedWith(RouterAnno.class);
            this.parseAnno(routeElements);
            this.adjustInterceptorPriorities();
            this.createRouterImpl();
            try {
                this.createRouterJson();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return true;
        }
        return false;
    }

    private void parseAnno(Set<? extends Element> routeElements) {
        for (Element element : routeElements) {
            String checkKey;
            RouterAnno router = element.getAnnotation(RouterAnno.class);
            if (router == null) continue;
            RouterAnnoBean routerBean = this.toRouterAnnoBean(element, router);
            String scheme = routerBean.getScheme();
            if (scheme == null || "".equals(scheme)) {
                scheme = "__checkScheme__";
            }
            if (this.routerCheckMap.contains(checkKey = scheme + "://" + routerBean.hostAndPath())) {
                if ("__checkScheme__".equals(scheme)) {
                    throw new ProcessException("the uri '" + routerBean.hostAndPath() + "' of " + element + " is already exist");
                }
                throw new ProcessException("the uri '" + checkKey + "' of " + element + " is already exist");
            }
            this.routerCheckMap.add(checkKey);
            this.routerMap.add(routerBean);
        }
    }

    private RouterAnnoBean toRouterAnnoBean(Element element, RouterAnno routerAnno) {
        if (routerAnno.host() != null && !routerAnno.host().isEmpty() && routerAnno.host().contains("/")) {
            throw new ProcessException(element + "the host path '" + routerAnno.host() + "' can't contains '/'");
        }
        RouterAnnoBean routerBean = new RouterAnnoBean();
        routerBean.setRegex(routerAnno.regex());
        routerBean.setScheme(routerAnno.scheme());
        String host = routerAnno.host();
        String path = routerAnno.path();
        String hostAndPath = routerAnno.hostAndPath();
        if (!"".equals(hostAndPath)) {
            int index = hostAndPath.indexOf(47);
            if (index < 0) {
                throw new ProcessException("the hostAndPath(" + hostAndPath + ") must have '/',such as \"app/test\"");
            }
            if (index == 0 || index == hostAndPath.length() - 1) {
                throw new ProcessException("the hostAndPath(" + hostAndPath + ") can't start with '/' and end with '/'");
            }
            host = hostAndPath.substring(0, index);
            path = hostAndPath.substring(index + 1);
        }
        if (host == null || host.isEmpty()) {
            host = this.componentModuleName;
        }
        if (path != null && path.length() > 0 && path.charAt(0) != '/') {
            path = "/" + path;
        }
        routerBean.setHost(host);
        routerBean.setPath(path);
        routerBean.setDesc(routerAnno.desc());
        routerBean.setRawType(element);
        routerBean.setInterceptorPriorities(routerAnno.interceptorPriorities());
        routerBean.setInterceptorNamePriorities(routerAnno.interceptorNamePriorities());
        routerBean.getInterceptors().clear();
        routerBean.getInterceptors().addAll(this.getImplClassName(routerAnno));
        if (routerAnno.interceptorNames() != null) {
            routerBean.getInterceptorNames().clear();
            for (String interceptorName : routerAnno.interceptorNames()) {
                routerBean.getInterceptorNames().add(interceptorName);
            }
        }
        return routerBean;
    }

    private void adjustInterceptorPriorities() {
        this.routerMap.forEach(new Consumer<RouterAnnoBean>(){

            @Override
            public void accept(RouterAnnoBean value) {
                int i;
                int[] interceptorPriorities;
                int totalSize = 0;
                if (value.getInterceptors() == null) {
                    value.setInterceptorPriorities(null);
                } else if (value.getInterceptors().isEmpty()) {
                    value.setInterceptorPriorities(new int[0]);
                } else {
                    totalSize += value.getInterceptors().size();
                    if (value.getInterceptorPriorities() == null || value.getInterceptorPriorities().length == 0) {
                        interceptorPriorities = new int[value.getInterceptors().size()];
                        for (i = 0; i < interceptorPriorities.length; ++i) {
                            interceptorPriorities[i] = 0;
                        }
                        value.setInterceptorPriorities(interceptorPriorities);
                    } else if (value.getInterceptorPriorities().length != value.getInterceptors().size()) {
                        throw new ProcessException("size of RouterAnno.interceptorPriorities and RouterAnno.interceptors are not equal");
                    }
                }
                if (value.getInterceptorNames() == null) {
                    value.setInterceptorNamePriorities(null);
                } else if (value.getInterceptorNames().isEmpty()) {
                    value.setInterceptorNamePriorities(new int[0]);
                } else {
                    totalSize += value.getInterceptorNames().size();
                    if (value.getInterceptorNamePriorities() == null || value.getInterceptorNamePriorities().length == 0) {
                        interceptorPriorities = new int[value.getInterceptorNames().size()];
                        for (i = 0; i < interceptorPriorities.length; ++i) {
                            interceptorPriorities[i] = 0;
                        }
                        value.setInterceptorNamePriorities(interceptorPriorities);
                    } else if (value.getInterceptorNamePriorities().length != value.getInterceptorNames().size()) {
                        throw new ProcessException("size of RouterAnno.interceptorNamePriorities and RouterAnno.interceptorNames are not equal");
                    }
                }
                value.setTotalInterceptorSize(totalSize);
            }
        });
    }

    private void createRouterImpl() {
        String claName = ComponentUtil.genHostRouterClassName((String)this.componentModuleName);
        String pkg = claName.substring(0, claName.lastIndexOf(46));
        String cn = claName.substring(claName.lastIndexOf(46) + 1);
        ClassName superClass = ClassName.get((TypeElement)this.mElements.getTypeElement("com.xiaojinzi.component.impl.ModuleRouterImpl"));
        MethodSpec initHostMethod = this.generateInitHostMethod();
        MethodSpec initMapMethod = this.generateInitMapMethod();
        TypeSpec typeSpec = TypeSpec.classBuilder((String)cn).addAnnotation(this.mClassNameKeep).addAnnotation(this.mClassNameComponentGeneratedAnno).addModifiers(new Modifier[]{Modifier.PUBLIC}).addModifiers(new Modifier[]{Modifier.FINAL}).superclass((TypeName)superClass).addMethod(initHostMethod).addMethod(initMapMethod).addJavadoc(this.componentModuleName + "\u4e1a\u52a1\u6a21\u5757\u7684\u8def\u7531\u8868\n", new Object[0]).build();
        try {
            JavaFile.builder((String)pkg, (TypeSpec)typeSpec).indent("    ").build().writeTo(this.mFiler);
        }
        catch (IOException e) {
            throw new ProcessException(e);
        }
    }

    private void createRouterJson() throws IOException {
        File file;
        if (!this.isRouterDocEnable()) {
            return;
        }
        File docFolder = new File(this.routerDocFolder);
        if (docFolder.exists() && docFolder.isFile()) {
            docFolder.delete();
        }
        docFolder.mkdirs();
        int size = this.routerMap.size();
        ArrayList<RouterDocBean> result = new ArrayList<RouterDocBean>(size);
        for (RouterAnnoBean routerAnnoBean : this.routerMap) {
            RouterDocBean item = new RouterDocBean();
            item.setHost(routerAnnoBean.getHost());
            item.setPath(routerAnnoBean.getPath());
            item.setDesc(routerAnnoBean.getDesc());
            Element rawType = routerAnnoBean.getRawType();
            TypeMirror targetClassTypeMirror = rawType.asType();
            if (rawType instanceof TypeElement && this.mTypes.isSubtype(targetClassTypeMirror, this.activityTypeMirror)) {
                item.setTargetActivity(targetClassTypeMirror.toString());
                item.setTargetActivityName(rawType.getSimpleName().toString());
            } else if (rawType instanceof ExecutableElement) {
                ExecutableElement executableElement = (ExecutableElement)rawType;
                item.setTargetSimpleMethod(executableElement.getEnclosingElement().toString());
                item.setTargetMethod("(" + executableElement.getReturnType().toString() + ") " + executableElement.getEnclosingElement().toString() + "." + executableElement.toString());
            }
            result.add(item);
        }
        Gson gson = new Gson();
        String json = gson.toJson(result);
        File routerDocJsonFolder = new File(docFolder, "router");
        if (!routerDocJsonFolder.exists()) {
            routerDocJsonFolder.mkdirs();
        }
        if ((file = new File(routerDocJsonFolder, this.componentModuleName + ".json")).exists()) {
            file.delete();
        }
        FileWriter writer = new FileWriter(file);
        writer.write(json);
        ((Writer)writer).close();
    }

    private MethodSpec generateInitMapMethod() {
        TypeName returnType = TypeName.VOID;
        final MethodSpec.Builder initMapMethodSpecBuilder = MethodSpec.methodBuilder((String)"initMap").returns(returnType).addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC});
        initMapMethodSpecBuilder.addStatement("super.initMap()", new Object[0]);
        initMapMethodSpecBuilder.addComment("\u9ed8\u8ba4\u7684 scheme", new Object[0]);
        initMapMethodSpecBuilder.addStatement("String defaultScheme = com.xiaojinzi.component.Component.getConfig().getDefaultScheme()", new Object[0]);
        this.routerMap.forEach(new Consumer<RouterAnnoBean>(){

            @Override
            public void accept(RouterAnnoBean routerBean) {
                String regexStr;
                List<String> interceptorNames;
                String routerBeanName = "routerBean" + RouterProcessor.this.atomicInteger.incrementAndGet();
                RouterProcessor.this.generateActivityCall(routerBean, routerBeanName, initMapMethodSpecBuilder);
                RouterProcessor.this.generateStaticMethodCall(routerBean, routerBeanName, initMapMethodSpecBuilder);
                String interceptorListName = "interceptorList" + RouterProcessor.this.atomicInteger.incrementAndGet();
                initMapMethodSpecBuilder.addStatement("$N<$T> $N = new $N<$T>($L)", new Object[]{"java.util.List", RouterProcessor.this.pageInterceptorBeanTypeElement, interceptorListName, "java.util.ArrayList", RouterProcessor.this.pageInterceptorBeanTypeElement, routerBean.getTotalInterceptorSize()});
                initMapMethodSpecBuilder.addStatement("$N.setPageInterceptors($N)", new Object[]{routerBeanName, interceptorListName});
                List<String> interceptors = routerBean.getInterceptors();
                if (interceptors != null && !interceptors.isEmpty()) {
                    for (int i = 0; i < interceptors.size(); ++i) {
                        initMapMethodSpecBuilder.addStatement("$N.getPageInterceptors().add(new $T($L, $T.class))", new Object[]{routerBeanName, RouterProcessor.this.pageInterceptorBeanTypeElement, routerBean.getInterceptorPriorities()[i], ClassName.get((TypeElement)RouterProcessor.this.mElements.getTypeElement(interceptors.get(i)))});
                    }
                }
                if ((interceptorNames = routerBean.getInterceptorNames()) != null && !interceptorNames.isEmpty()) {
                    for (int i = 0; i < interceptorNames.size(); ++i) {
                        initMapMethodSpecBuilder.addStatement("$N.getPageInterceptors().add(new $T($L, $S))", new Object[]{routerBeanName, RouterProcessor.this.pageInterceptorBeanTypeElement, routerBean.getInterceptorNamePriorities()[i], interceptorNames.get(i)});
                    }
                }
                if ((regexStr = routerBean.getRegex()) == null || "".equals(regexStr)) {
                    String scheme = routerBean.getScheme();
                    if (scheme == null || "".equals(scheme)) {
                        initMapMethodSpecBuilder.addStatement("routerBeanMap.put(defaultScheme + $S,$N)", new Object[]{"://" + routerBean.hostAndPath(), routerBeanName});
                    } else {
                        String key = scheme + "://" + routerBean.hostAndPath();
                        initMapMethodSpecBuilder.addStatement("routerBeanMap.put($S,$N)", new Object[]{key, routerBeanName});
                    }
                } else {
                    initMapMethodSpecBuilder.addStatement("regExRouterBeanMap.put($S,$N)", new Object[]{regexStr, routerBeanName});
                }
                initMapMethodSpecBuilder.addCode("\n", new Object[0]);
            }
        });
        initMapMethodSpecBuilder.addJavadoc("\u521d\u59cb\u5316\u8def\u7531\u8868\u7684\u6570\u636e\n", new Object[0]);
        return initMapMethodSpecBuilder.build();
    }

    private MethodSpec generateInitHostMethod() {
        ClassName returnType = this.mClassNameString;
        MethodSpec.Builder openUriMethodSpecBuilder = MethodSpec.methodBuilder((String)"getHost").returns((TypeName)returnType).addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC});
        openUriMethodSpecBuilder.addStatement("return $S", new Object[]{this.componentModuleName});
        return openUriMethodSpecBuilder.build();
    }

    private String getHostAndPathFromAnno(RouterAnno anno) {
        String host = anno.host();
        String path = anno.path();
        String hostAndPath = anno.hostAndPath();
        if (!"".equals(hostAndPath)) {
            int index = hostAndPath.indexOf(47);
            if (index < 0) {
                throw new ProcessException("the hostAndPath(" + hostAndPath + ") must have '/',such as \"app/test\"");
            }
            if (index == 0 || index == hostAndPath.length() - 1) {
                throw new ProcessException("the hostAndPath(" + hostAndPath + ") can't start with '/' and end with '/'");
            }
            host = hostAndPath.substring(0, index);
            path = hostAndPath.substring(index + 1);
        }
        if (host == null || host.isEmpty()) {
            host = this.componentModuleName;
        }
        if (path != null && path.length() > 0 && path.charAt(0) != '/') {
            path = "/" + path;
        }
        return host + path;
    }

    /*
     * WARNING - void declaration
     */
    private List<String> getImplClassName(RouterAnno anno) {
        ArrayList<String> implClassNames = new ArrayList<String>();
        try {
            void var6_10;
            Class[] interceptors;
            implClassNames.clear();
            Class[] classArray = interceptors = anno.interceptors();
            int n = classArray.length;
            boolean bl = false;
            while (var6_10 < n) {
                Class interceptor = classArray[var6_10];
                implClassNames.add(interceptor.getName());
                ++var6_10;
            }
        }
        catch (MirroredTypesException e) {
            implClassNames.clear();
            List<? extends TypeMirror> typeMirrors = e.getTypeMirrors();
            for (TypeMirror typeMirror : typeMirrors) {
                implClassNames.add(typeMirror.toString());
            }
        }
        return implClassNames;
    }

    private void generateActivityCall(RouterAnnoBean routerBean, String routerBeanName, MethodSpec.Builder methodSpecBuilder) {
        if (!(routerBean.getRawType() instanceof TypeElement)) {
            return;
        }
        ClassName targetActivityClassName = ClassName.get((TypeElement)((TypeElement)routerBean.getRawType()));
        String commentStr = targetActivityClassName.toString();
        methodSpecBuilder.addCode("\n", new Object[0]);
        methodSpecBuilder.addComment("---------------------------" + commentStr + "---------------------------", new Object[0]);
        methodSpecBuilder.addCode("\n", new Object[0]);
        methodSpecBuilder.addStatement("$T $N = new $T()", new Object[]{this.routerBeanTypeElement, routerBeanName, this.routerBeanTypeElement});
        methodSpecBuilder.addStatement("$N.setDesc($S)", new Object[]{routerBeanName, routerBean.getDesc()});
        methodSpecBuilder.addStatement("$N.setTargetClass($T.class)", new Object[]{routerBeanName, targetActivityClassName});
    }

    private void generateStaticMethodCall(RouterAnnoBean routerBean, String routerBeanName, MethodSpec.Builder methodSpecBuilder) {
        String customerIntentOrJumpPath;
        if (!(routerBean.getRawType() instanceof ExecutableElement)) {
            return;
        }
        ExecutableElement executableElement = (ExecutableElement)routerBean.getRawType();
        TypeElement declareClassType = (TypeElement)executableElement.getEnclosingElement();
        String commentStr = customerIntentOrJumpPath = declareClassType.toString() + "." + executableElement.getSimpleName();
        TypeMirror customerReturnType = executableElement.getReturnType();
        methodSpecBuilder.addCode("\n", new Object[0]);
        methodSpecBuilder.addComment("---------------------------" + commentStr + "---------------------------", new Object[0]);
        methodSpecBuilder.addCode("\n", new Object[0]);
        methodSpecBuilder.addStatement("$T $N = new $T()", new Object[]{this.routerBeanTypeElement, routerBeanName, this.routerBeanTypeElement});
        methodSpecBuilder.addStatement("$N.setDesc($S)", new Object[]{routerBeanName, routerBean.getDesc()});
        if (!this.intentTypeMirror.equals(customerReturnType)) {
            throw new ProcessException("the return type of method(" + customerIntentOrJumpPath + ") must be 'Intent' ");
        }
        MethodSpec.Builder jumpMethodBuilder = MethodSpec.methodBuilder((String)"get").addParameter(TypeName.get((TypeMirror)this.routerRequestTypeMirror), NAME_OF_REQUEST, new Modifier[]{Modifier.FINAL}).addAnnotation(Override.class).addException((TypeName)this.exceptionClassName).addModifiers(new Modifier[]{Modifier.PUBLIC});
        this.generateActualMethodCall(jumpMethodBuilder, executableElement, customerIntentOrJumpPath, true);
        jumpMethodBuilder.returns(TypeName.get((TypeMirror)this.intentTypeElement.asType()));
        TypeSpec intentCallTypeSpec = TypeSpec.anonymousClassBuilder((String)"", (Object[])new Object[0]).addSuperinterface((TypeName)this.customerIntentCallClassName).addMethod(jumpMethodBuilder.build()).build();
        methodSpecBuilder.addStatement("$N.setCustomerIntentCall($L)", new Object[]{routerBeanName, intentCallTypeSpec});
    }

    private void generateActualMethodCall(MethodSpec.Builder jumpMethodBuilder, ExecutableElement executableElement, String customerIntentOrJumpPath, boolean isReturnIntent) {
        List<? extends VariableElement> parameters = executableElement.getParameters();
        StringBuilder parameterSB = new StringBuilder();
        if (parameters != null && !parameters.isEmpty()) {
            int size = parameters.size();
            for (int i = 0; i < size; ++i) {
                VariableElement variableElement;
                if (i > 0) {
                    parameterSB.append(",");
                }
                if (!(variableElement = parameters.get(i)).asType().equals(this.routerRequestTypeMirror)) {
                    throw new ProcessException("can resolve parameter " + variableElement.getSimpleName() + " in " + variableElement.getEnclosingElement().getEnclosingElement().getSimpleName() + "." + variableElement.getEnclosingElement().getSimpleName() + " method");
                }
                parameterSB.append(NAME_OF_REQUEST);
            }
        }
        if (isReturnIntent) {
            jumpMethodBuilder.addStatement("return $N($N)", new Object[]{customerIntentOrJumpPath, parameterSB.toString()});
        } else {
            jumpMethodBuilder.addStatement("$N($N)", new Object[]{customerIntentOrJumpPath, parameterSB.toString()});
        }
    }
}

