/*
 * Decompiled with CFR 0.152.
 */
package com.xiaojinzi.component;

import com.google.auto.service.AutoService;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.xiaojinzi.component.BaseHostProcessor;
import com.xiaojinzi.component.ComponentUtil;
import com.xiaojinzi.component.ProcessException;
import com.xiaojinzi.component.Utils;
import com.xiaojinzi.component.anno.ConditionalAnno;
import com.xiaojinzi.component.anno.GlobalInterceptorAnno;
import com.xiaojinzi.component.anno.InterceptorAnno;
import com.xiaojinzi.component.bean.InterceptorBean;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedOptions;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.MirroredTypesException;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;
import org.apache.commons.collections4.CollectionUtils;

@SupportedOptions(value={"HOST"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_7)
@SupportedAnnotationTypes(value={"com.xiaojinzi.component.anno.GlobalInterceptorAnno", "com.xiaojinzi.component.anno.InterceptorAnno"})
@AutoService(value={Processor.class})
public class InterceptorProcessor
extends BaseHostProcessor {
    private TypeElement collectionsTypeElement;
    private TypeElement interceptorUtilTypeElement;
    private TypeElement interceptorBeanTypeElement;
    private final List<InterceptorBean> mGlobalInterceptElementList = new ArrayList<InterceptorBean>();
    private final Map<String, InterceptorBean> mNormalInterceptElementMap = new HashMap<String, InterceptorBean>();

    @Override
    public synchronized void init(ProcessingEnvironment processingEnvironment) {
        super.init(processingEnvironment);
        this.collectionsTypeElement = this.mElements.getTypeElement("java.util.Collections");
        this.interceptorUtilTypeElement = this.mElements.getTypeElement("com.xiaojinzi.component.support.RouterInterceptorCache");
        this.interceptorBeanTypeElement = this.mElements.getTypeElement("com.xiaojinzi.component.impl.interceptor.InterceptorBean");
    }

    @Override
    public boolean process(Set<? extends TypeElement> set, RoundEnvironment roundEnvironment) {
        if (CollectionUtils.isNotEmpty(set)) {
            Set<? extends Element> globalInterceptorElements = roundEnvironment.getElementsAnnotatedWith(GlobalInterceptorAnno.class);
            Set<? extends Element> interceptorElements = roundEnvironment.getElementsAnnotatedWith(InterceptorAnno.class);
            this.parseGlobalInterceptAnnotation(globalInterceptorElements);
            this.parseNormalInterceptAnnotation(interceptorElements);
            this.createImpl();
            return true;
        }
        return false;
    }

    private void parseGlobalInterceptAnnotation(Set<? extends Element> globalInterceptorElements) {
        this.mGlobalInterceptElementList.clear();
        TypeMirror typeInterceptor = this.mElements.getTypeElement("com.xiaojinzi.component.impl.RouterInterceptor").asType();
        for (Element element : globalInterceptorElements) {
            TypeMirror tm = element.asType();
            boolean type = !(element instanceof TypeElement);
            boolean subType = !this.mTypes.isSubtype(tm, typeInterceptor);
            GlobalInterceptorAnno anno = element.getAnnotation(GlobalInterceptorAnno.class);
            if (type || subType || anno == null) {
                if (type) {
                    this.mMessager.printMessage(Diagnostic.Kind.ERROR, element + " is not a 'TypeElement' ");
                    continue;
                }
                if (!subType) continue;
                this.mMessager.printMessage(Diagnostic.Kind.ERROR, element + " must implementation interface '" + "com.xiaojinzi.component.impl.RouterInterceptor" + "'");
                continue;
            }
            this.mGlobalInterceptElementList.add(new InterceptorBean(0, element, anno.priority(), null));
        }
    }

    private void parseNormalInterceptAnnotation(Set<? extends Element> normalInterceptorElements) {
        this.mNormalInterceptElementMap.clear();
        TypeMirror typeInterceptor = this.mElements.getTypeElement("com.xiaojinzi.component.impl.RouterInterceptor").asType();
        for (Element element : normalInterceptorElements) {
            TypeMirror tm = element.asType();
            boolean type = !(element instanceof TypeElement);
            boolean subType = !this.mTypes.isSubtype(tm, typeInterceptor);
            InterceptorAnno anno = element.getAnnotation(InterceptorAnno.class);
            if (type || subType || anno == null) {
                if (type) {
                    this.mMessager.printMessage(Diagnostic.Kind.ERROR, element + " is not a 'TypeElement' ");
                    continue;
                }
                if (!subType) continue;
                this.mMessager.printMessage(Diagnostic.Kind.ERROR, element + " must implementation interface '" + "com.xiaojinzi.component.impl.RouterInterceptor" + "'");
                continue;
            }
            if (this.mNormalInterceptElementMap.containsKey(anno.value())) {
                throw new ProcessException("the interceptor's name '" + anno.value() + "' is exist");
            }
            this.mNormalInterceptElementMap.put(anno.value(), new InterceptorBean(1, element, 0, anno.value()));
        }
    }

    private void createImpl() {
        String claName = ComponentUtil.genHostInterceptorClassName((String)this.componentModuleName);
        String pkg = claName.substring(0, claName.lastIndexOf(46));
        String cn = claName.substring(claName.lastIndexOf(46) + 1);
        ClassName superClass = ClassName.get((TypeElement)this.mElements.getTypeElement("com.xiaojinzi.component.impl.interceptor.ModuleInterceptorImpl"));
        MethodSpec initHostMethod = this.generateInitHostMethod();
        MethodSpec globalInterceptorListMethod = this.generateGlobalInterceptorListMethod();
        MethodSpec normalInterceptorListMethod = this.generateNormalInterceptorInitMapMethod();
        TypeSpec typeSpec = TypeSpec.classBuilder((String)cn).addAnnotation(this.mClassNameKeep).addAnnotation(this.mClassNameComponentGeneratedAnno).addModifiers(new Modifier[]{Modifier.PUBLIC}).addModifiers(new Modifier[]{Modifier.FINAL}).superclass((TypeName)superClass).addMethod(initHostMethod).addMethod(globalInterceptorListMethod).addMethod(normalInterceptorListMethod).build();
        try {
            JavaFile.builder((String)pkg, (TypeSpec)typeSpec).indent("    ").build().writeTo(this.mFiler);
        }
        catch (IOException e) {
            throw new ProcessException(e);
        }
    }

    private MethodSpec generateGlobalInterceptorListMethod() {
        ParameterizedTypeName returnType = ParameterizedTypeName.get((ClassName)this.mClassNameList, (TypeName[])new TypeName[]{TypeName.get((TypeMirror)this.interceptorBeanTypeElement.asType())});
        final MethodSpec.Builder globalInterceptorListMethodSpecBuilder = MethodSpec.methodBuilder((String)"globalInterceptorList").returns((TypeName)returnType).addAnnotation(Override.class).addAnnotation(this.mClassNameNonNull).addModifiers(new Modifier[]{Modifier.PUBLIC});
        if (this.mGlobalInterceptElementList.isEmpty()) {
            globalInterceptorListMethodSpecBuilder.addStatement("return $T.emptyList()", new Object[]{this.collectionsTypeElement});
        } else {
            globalInterceptorListMethodSpecBuilder.addStatement("$T<$T> list = new $T<>()", new Object[]{this.mClassNameList, this.interceptorBeanTypeElement, this.mClassNameArrayList});
            this.mGlobalInterceptElementList.forEach(new Consumer<InterceptorBean>(){

                @Override
                public void accept(InterceptorBean interceptorBean) {
                    String implClassName = interceptorBean.element.toString();
                    TypeElement implTypeElement = InterceptorProcessor.this.mElements.getTypeElement(implClassName);
                    ConditionalAnno conditionalAnno = interceptorBean.element.getAnnotation(ConditionalAnno.class);
                    if (conditionalAnno != null) {
                        StringBuffer conditionsSB = new StringBuffer();
                        List conditionsImplClassNames = InterceptorProcessor.this.getConditionsImplClassName(conditionalAnno);
                        ArrayList<Object> conditionsArgs = new ArrayList<Object>(2 * conditionsImplClassNames.size());
                        Utils.generateCondition(InterceptorProcessor.this.mElements, InterceptorProcessor.this.mConditionCacheTypeElement, conditionsSB, conditionsArgs, conditionsImplClassNames);
                        globalInterceptorListMethodSpecBuilder.beginControlFlow("if(" + conditionsSB.toString() + ")", conditionsArgs.toArray());
                        globalInterceptorListMethodSpecBuilder.addStatement("list.add(new $T($T.getInterceptorByClass($T.class),$L))", new Object[]{InterceptorProcessor.this.interceptorBeanTypeElement, InterceptorProcessor.this.interceptorUtilTypeElement, implTypeElement, interceptorBean.priority});
                        globalInterceptorListMethodSpecBuilder.endControlFlow();
                    } else {
                        globalInterceptorListMethodSpecBuilder.addStatement("list.add(new $T($T.getInterceptorByClass($T.class),$L))", new Object[]{InterceptorProcessor.this.interceptorBeanTypeElement, InterceptorProcessor.this.interceptorUtilTypeElement, implTypeElement, interceptorBean.priority});
                    }
                }
            });
            globalInterceptorListMethodSpecBuilder.addStatement("return list", new Object[0]);
        }
        return globalInterceptorListMethodSpecBuilder.build();
    }

    private MethodSpec generateNormalInterceptorInitMapMethod() {
        final MethodSpec.Builder normalInterceptorInitMapMethodSpecBuilder = MethodSpec.methodBuilder((String)"initInterceptorMap").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PROTECTED});
        normalInterceptorInitMapMethodSpecBuilder.addStatement("super.initInterceptorMap()", new Object[0]);
        if (this.mNormalInterceptElementMap.size() != 0) {
            this.mNormalInterceptElementMap.values().forEach(new Consumer<InterceptorBean>(){

                @Override
                public void accept(InterceptorBean interceptorBean) {
                    String implClassName = interceptorBean.element.toString();
                    TypeElement implTypeElement = InterceptorProcessor.this.mElements.getTypeElement(implClassName);
                    ConditionalAnno conditionalAnno = interceptorBean.element.getAnnotation(ConditionalAnno.class);
                    if (conditionalAnno != null) {
                        List conditionsImplClassNames = InterceptorProcessor.this.getConditionsImplClassName(conditionalAnno);
                        StringBuffer conditionsSB = new StringBuffer();
                        ArrayList<Object> conditionsArgs = new ArrayList<Object>(2 * conditionsImplClassNames.size());
                        Utils.generateCondition(InterceptorProcessor.this.mElements, InterceptorProcessor.this.mConditionCacheTypeElement, conditionsSB, conditionsArgs, conditionsImplClassNames);
                        normalInterceptorInitMapMethodSpecBuilder.beginControlFlow("if(" + conditionsSB.toString() + ")", conditionsArgs.toArray());
                        normalInterceptorInitMapMethodSpecBuilder.addStatement("interceptorMap.put($S, $T.class)", new Object[]{interceptorBean.name, implTypeElement});
                        normalInterceptorInitMapMethodSpecBuilder.endControlFlow();
                    } else {
                        normalInterceptorInitMapMethodSpecBuilder.addStatement("interceptorMap.put($S, $T.class)", new Object[]{interceptorBean.name, implTypeElement});
                    }
                }
            });
        }
        return normalInterceptorInitMapMethodSpecBuilder.build();
    }

    private MethodSpec generateInitHostMethod() {
        TypeName returnType = TypeName.get((TypeMirror)this.mTypeElementString.asType());
        MethodSpec.Builder openUriMethodSpecBuilder = MethodSpec.methodBuilder((String)"getHost").returns(returnType).addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC});
        openUriMethodSpecBuilder.addStatement("return $S", new Object[]{this.componentModuleName});
        return openUriMethodSpecBuilder.build();
    }

    /*
     * WARNING - void declaration
     */
    private List<String> getConditionsImplClassName(ConditionalAnno anno) {
        ArrayList<String> implClassNames = new ArrayList<String>();
        try {
            void var6_10;
            Class[] interceptors;
            implClassNames.clear();
            Class[] classArray = interceptors = anno.conditions();
            int n = classArray.length;
            boolean bl = false;
            while (var6_10 < n) {
                Class interceptor = classArray[var6_10];
                implClassNames.add(interceptor.getName());
                ++var6_10;
            }
        }
        catch (MirroredTypesException e) {
            implClassNames.clear();
            List<? extends TypeMirror> typeMirrors = e.getTypeMirrors();
            for (TypeMirror typeMirror : typeMirrors) {
                implClassNames.add(typeMirror.toString());
            }
        }
        return implClassNames;
    }
}

