/*
 * Decompiled with CFR 0.152.
 */
package com.stx.xhb.androidx.transformers;

import android.view.View;
import com.stx.xhb.androidx.transformers.BasePageTransformer;

public class CubePageTransformer
extends BasePageTransformer {
    private float mMaxRotation = 90.0f;

    public CubePageTransformer() {
    }

    public CubePageTransformer(float maxRotation) {
        this.setMaxRotation(maxRotation);
    }

    @Override
    public void handleInvisiblePage(View view, float position) {
        view.setPivotX((float)view.getMeasuredWidth());
        view.setPivotY((float)view.getMeasuredHeight() * 0.5f);
        view.setRotationY(0.0f);
    }

    @Override
    public void handleLeftPage(View view, float position) {
        view.setPivotX((float)view.getMeasuredWidth());
        view.setPivotY((float)view.getMeasuredHeight() * 0.5f);
        view.setRotationY(this.mMaxRotation * position);
    }

    @Override
    public void handleRightPage(View view, float position) {
        view.setPivotX(0.0f);
        view.setPivotY((float)view.getMeasuredHeight() * 0.5f);
        view.setRotationY(this.mMaxRotation * position);
    }

    public void setMaxRotation(float maxRotation) {
        if (maxRotation >= 0.0f && maxRotation <= 90.0f) {
            this.mMaxRotation = maxRotation;
        }
    }
}

