/*
 * Decompiled with CFR 0.152.
 */
package com.stx.xhb.xbanner.transformers;

import android.support.v4.view.ViewPager;
import android.view.View;
import com.stx.xhb.xbanner.transformers.AccordionPageTransformer;
import com.stx.xhb.xbanner.transformers.AlphaPageTransformer;
import com.stx.xhb.xbanner.transformers.CubePageTransformer;
import com.stx.xhb.xbanner.transformers.DefaultPageTransformer;
import com.stx.xhb.xbanner.transformers.DepthPageTransformer;
import com.stx.xhb.xbanner.transformers.FlipPageTransformer;
import com.stx.xhb.xbanner.transformers.OverLapPageTransformer;
import com.stx.xhb.xbanner.transformers.RotatePageTransformer;
import com.stx.xhb.xbanner.transformers.ScalePageTransformer;
import com.stx.xhb.xbanner.transformers.StackPageTransformer;
import com.stx.xhb.xbanner.transformers.Transformer;
import com.stx.xhb.xbanner.transformers.ZoomCenterPageTransformer;
import com.stx.xhb.xbanner.transformers.ZoomFadePageTransformer;
import com.stx.xhb.xbanner.transformers.ZoomPageTransformer;
import com.stx.xhb.xbanner.transformers.ZoomStackPageTransformer;

public abstract class BasePageTransformer
implements ViewPager.PageTransformer {
    public void transformPage(View view, float position) {
        if (!(view.getParent() instanceof ViewPager)) {
            return;
        }
        ViewPager viewPager = (ViewPager)view.getParent();
        position = this.getRealPosition(viewPager, view);
        if (position < -1.0f) {
            this.handleInvisiblePage(view, position);
        } else if (position <= 0.0f) {
            this.handleLeftPage(view, position);
        } else if (position <= 1.0f) {
            this.handleRightPage(view, position);
        } else {
            this.handleInvisiblePage(view, position);
        }
    }

    private float getRealPosition(ViewPager viewPager, View page) {
        int width = viewPager.getMeasuredWidth() - viewPager.getPaddingLeft() - viewPager.getPaddingRight();
        return (float)(page.getLeft() - viewPager.getScrollX() - viewPager.getPaddingLeft()) / (float)width;
    }

    public abstract void handleInvisiblePage(View var1, float var2);

    public abstract void handleLeftPage(View var1, float var2);

    public abstract void handleRightPage(View var1, float var2);

    public static BasePageTransformer getPageTransformer(Transformer effect) {
        switch (effect) {
            case Alpha: {
                return new AlphaPageTransformer();
            }
            case Rotate: {
                return new RotatePageTransformer();
            }
            case Cube: {
                return new CubePageTransformer();
            }
            case Flip: {
                return new FlipPageTransformer();
            }
            case Accordion: {
                return new AccordionPageTransformer();
            }
            case ZoomFade: {
                return new ZoomFadePageTransformer();
            }
            case ZoomCenter: {
                return new ZoomCenterPageTransformer();
            }
            case ZoomStack: {
                return new ZoomStackPageTransformer();
            }
            case Stack: {
                return new StackPageTransformer();
            }
            case Depth: {
                return new DepthPageTransformer();
            }
            case Zoom: {
                return new ZoomPageTransformer();
            }
            case Scale: {
                return new ScalePageTransformer();
            }
            case OverLap: {
                return new OverLapPageTransformer();
            }
        }
        return new DefaultPageTransformer();
    }
}

