/*
 * Decompiled with CFR 0.152.
 */
package com.stx.xhb.androidx;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Color;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.annotation.Dimension;
import androidx.annotation.DrawableRes;
import androidx.annotation.LayoutRes;
import androidx.annotation.NonNull;
import androidx.viewpager.widget.PagerAdapter;
import androidx.viewpager.widget.ViewPager;
import com.stx.xhb.androidx.OnDoubleClickListener;
import com.stx.xhb.androidx.R;
import com.stx.xhb.androidx.XBannerUtils;
import com.stx.xhb.androidx.XBannerViewPager;
import com.stx.xhb.androidx.entity.BaseBannerInfo;
import com.stx.xhb.androidx.transformers.BasePageTransformer;
import com.stx.xhb.androidx.transformers.Transformer;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;

public class XBanner
extends RelativeLayout
implements XBannerViewPager.AutoPlayDelegate,
ViewPager.OnPageChangeListener {
    private static final int RMP = -1;
    private static final int RWC = -2;
    private static final int LWC = -2;
    private static final int VEL_THRESHOLD = 400;
    public static final int NO_PLACE_HOLDER = -1;
    public static final int MAX_VALUE = Integer.MAX_VALUE;
    private int mPageScrollPosition;
    private float mPageScrollPositionOffset;
    private ViewPager.OnPageChangeListener mOnPageChangeListener;
    private OnItemClickListener mOnItemClickListener;
    public static final int LEFT = 0;
    public static final int CENTER = 1;
    public static final int RIGHT = 2;
    private AutoSwitchTask mAutoSwitchTask;
    private LinearLayout mPointRealContainerLl;
    private XBannerViewPager mViewPager;
    private int mPointLeftRightPading;
    private int mPointTopBottomPading;
    private int mPointContainerLeftRightPadding;
    private List<?> mDatas;
    private boolean mIsOneImg = false;
    private boolean mIsAutoPlay = true;
    private int mAutoPalyTime = 5000;
    private boolean mIsAllowUserScroll = true;
    private int mSlideScrollMode = 0;
    private int mPointPosition = 1;
    @DrawableRes
    private int mPointNoraml;
    @DrawableRes
    private int mPointSelected;
    private Drawable mPointContainerBackgroundDrawable;
    private RelativeLayout.LayoutParams mPointRealContainerLp;
    private TextView mTipTv;
    private int mTipTextColor;
    private boolean mPointsIsVisible = true;
    private int mTipTextSize;
    private boolean mIsShowTips;
    private List<String> mTipData;
    public static final int TOP = 10;
    public static final int BOTTOM = 12;
    private int mPointContainerPosition = 12;
    private XBannerAdapter mAdapter;
    private RelativeLayout.LayoutParams mPointContainerLp;
    private boolean mIsNumberIndicator = false;
    private TextView mNumberIndicatorTv;
    private Drawable mNumberIndicatorBackground;
    private boolean mIsShowIndicatorOnlyOne = false;
    private int mPageChangeDuration = 1000;
    private boolean mIsTipsMarquee = false;
    private boolean mIsFirstInvisible = true;
    private boolean mIsHandLoop = false;
    private Transformer mTransformer;
    private int mPlaceholderDrawableResId = -1;
    private ImageView mPlaceholderImg;
    private boolean mIsClipChildrenMode;
    private int mClipChildrenLeftMargin;
    private int mClipChildrenRightMargin;
    private int mClipChildrenTopBottomMargin;
    private int mViewPagerMargin;
    private boolean mIsClipChildrenModeLessThree;
    public int mBannerBottomMargin = 0;
    public int currentPos = 0;
    private boolean mShowIndicatorInCenter;
    @LayoutRes
    private int layoutResId = -1;
    private boolean isCanClickSide = true;
    private ImageView.ScaleType mScaleType = ImageView.ScaleType.FIT_XY;
    private static final ImageView.ScaleType[] sScaleTypeArray = new ImageView.ScaleType[]{ImageView.ScaleType.MATRIX, ImageView.ScaleType.FIT_XY, ImageView.ScaleType.FIT_START, ImageView.ScaleType.FIT_CENTER, ImageView.ScaleType.FIT_END, ImageView.ScaleType.CENTER, ImageView.ScaleType.CENTER_CROP, ImageView.ScaleType.CENTER_INSIDE};

    @Deprecated
    public void setmAdapter(XBannerAdapter mAdapter) {
        this.mAdapter = mAdapter;
    }

    public void loadImage(XBannerAdapter mAdapter) {
        this.mAdapter = mAdapter;
    }

    public XBanner(Context context) {
        this(context, null);
    }

    public XBanner(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public XBanner(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context);
        this.initCustomAttrs(context, attrs);
        this.initView();
    }

    private void init(Context context) {
        this.mAutoSwitchTask = new AutoSwitchTask(this);
        this.mPointLeftRightPading = XBannerUtils.dp2px(context, 3.0f);
        this.mPointTopBottomPading = XBannerUtils.dp2px(context, 6.0f);
        this.mPointContainerLeftRightPadding = XBannerUtils.dp2px(context, 10.0f);
        this.mClipChildrenLeftMargin = XBannerUtils.dp2px(context, 30.0f);
        this.mClipChildrenRightMargin = XBannerUtils.dp2px(context, 30.0f);
        this.mClipChildrenTopBottomMargin = XBannerUtils.dp2px(context, 10.0f);
        this.mViewPagerMargin = XBannerUtils.dp2px(context, 10.0f);
        this.mTipTextSize = XBannerUtils.sp2px(context, 10.0f);
        this.mTransformer = Transformer.Default;
        this.mTipTextColor = -1;
        this.mPointContainerBackgroundDrawable = new ColorDrawable(Color.parseColor((String)"#44aaaaaa"));
    }

    private void initCustomAttrs(Context context, AttributeSet attrs) {
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.XBanner);
        if (typedArray != null) {
            this.mIsAutoPlay = typedArray.getBoolean(R.styleable.XBanner_isAutoPlay, true);
            this.mIsHandLoop = typedArray.getBoolean(R.styleable.XBanner_isHandLoop, false);
            this.mIsTipsMarquee = typedArray.getBoolean(R.styleable.XBanner_isTipsMarquee, false);
            this.mAutoPalyTime = typedArray.getInteger(R.styleable.XBanner_AutoPlayTime, 5000);
            this.mPointsIsVisible = typedArray.getBoolean(R.styleable.XBanner_pointsVisibility, true);
            this.mPointPosition = typedArray.getInt(R.styleable.XBanner_pointsPosition, 1);
            this.mPointContainerLeftRightPadding = typedArray.getDimensionPixelSize(R.styleable.XBanner_pointContainerLeftRightPadding, this.mPointContainerLeftRightPadding);
            this.mPointLeftRightPading = typedArray.getDimensionPixelSize(R.styleable.XBanner_pointLeftRightPadding, this.mPointLeftRightPading);
            this.mPointTopBottomPading = typedArray.getDimensionPixelSize(R.styleable.XBanner_pointTopBottomPadding, this.mPointTopBottomPading);
            this.mPointContainerPosition = typedArray.getInt(R.styleable.XBanner_pointContainerPosition, 12);
            this.mPointContainerBackgroundDrawable = typedArray.getDrawable(R.styleable.XBanner_pointsContainerBackground);
            this.mPointNoraml = typedArray.getResourceId(R.styleable.XBanner_pointNormal, R.drawable.shape_point_normal);
            this.mPointSelected = typedArray.getResourceId(R.styleable.XBanner_pointSelect, R.drawable.shape_point_select);
            this.mTipTextColor = typedArray.getColor(R.styleable.XBanner_tipTextColor, this.mTipTextColor);
            this.mTipTextSize = typedArray.getDimensionPixelSize(R.styleable.XBanner_tipTextSize, this.mTipTextSize);
            this.mIsNumberIndicator = typedArray.getBoolean(R.styleable.XBanner_isShowNumberIndicator, this.mIsNumberIndicator);
            this.mNumberIndicatorBackground = typedArray.getDrawable(R.styleable.XBanner_numberIndicatorBacgroud);
            this.mIsShowIndicatorOnlyOne = typedArray.getBoolean(R.styleable.XBanner_isShowIndicatorOnlyOne, this.mIsShowIndicatorOnlyOne);
            this.mPageChangeDuration = typedArray.getInt(R.styleable.XBanner_pageChangeDuration, this.mPageChangeDuration);
            this.mPlaceholderDrawableResId = typedArray.getResourceId(R.styleable.XBanner_placeholderDrawable, this.mPlaceholderDrawableResId);
            this.mIsClipChildrenMode = typedArray.getBoolean(R.styleable.XBanner_isClipChildrenMode, false);
            this.mClipChildrenLeftMargin = typedArray.getDimensionPixelSize(R.styleable.XBanner_clipChildrenLeftMargin, this.mClipChildrenLeftMargin);
            this.mClipChildrenRightMargin = typedArray.getDimensionPixelSize(R.styleable.XBanner_clipChildrenRightMargin, this.mClipChildrenRightMargin);
            this.mClipChildrenTopBottomMargin = typedArray.getDimensionPixelSize(R.styleable.XBanner_clipChildrenTopBottomMargin, this.mClipChildrenTopBottomMargin);
            this.mViewPagerMargin = typedArray.getDimensionPixelSize(R.styleable.XBanner_viewpagerMargin, this.mViewPagerMargin);
            this.mIsClipChildrenModeLessThree = typedArray.getBoolean(R.styleable.XBanner_isClipChildrenModeLessThree, false);
            this.mIsShowTips = typedArray.getBoolean(R.styleable.XBanner_isShowTips, false);
            this.mBannerBottomMargin = typedArray.getDimensionPixelSize(R.styleable.XBanner_bannerBottomMargin, this.mBannerBottomMargin);
            this.mShowIndicatorInCenter = typedArray.getBoolean(R.styleable.XBanner_showIndicatorInCenter, true);
            int scaleTypeIndex = typedArray.getInt(R.styleable.XBanner_android_scaleType, -1);
            if (scaleTypeIndex >= 0 && scaleTypeIndex < sScaleTypeArray.length) {
                this.mScaleType = sScaleTypeArray[scaleTypeIndex];
            }
            typedArray.recycle();
        }
        if (this.mIsClipChildrenMode) {
            this.mTransformer = Transformer.Scale;
        }
    }

    private void initView() {
        RelativeLayout pointContainerRl = new RelativeLayout(this.getContext());
        if (Build.VERSION.SDK_INT >= 16) {
            pointContainerRl.setBackground(this.mPointContainerBackgroundDrawable);
        } else {
            pointContainerRl.setBackgroundDrawable(this.mPointContainerBackgroundDrawable);
        }
        pointContainerRl.setPadding(this.mPointContainerLeftRightPadding, this.mPointTopBottomPading, this.mPointContainerLeftRightPadding, this.mPointTopBottomPading);
        this.mPointContainerLp = new RelativeLayout.LayoutParams(-1, -2);
        this.mPointContainerLp.addRule(this.mPointContainerPosition);
        if (this.mIsClipChildrenMode && this.mShowIndicatorInCenter) {
            if (this.mIsShowTips) {
                this.mPointContainerLp.setMargins(this.mClipChildrenLeftMargin, 0, this.mClipChildrenRightMargin, 0);
            } else {
                this.mPointContainerLp.setMargins(0, 0, 0, 0);
            }
        }
        this.addView((View)pointContainerRl, (ViewGroup.LayoutParams)this.mPointContainerLp);
        this.mPointRealContainerLp = new RelativeLayout.LayoutParams(-2, -2);
        if (this.mIsNumberIndicator) {
            this.mNumberIndicatorTv = new TextView(this.getContext());
            this.mNumberIndicatorTv.setId(R.id.xbanner_pointId);
            this.mNumberIndicatorTv.setGravity(17);
            this.mNumberIndicatorTv.setSingleLine(true);
            this.mNumberIndicatorTv.setEllipsize(TextUtils.TruncateAt.END);
            this.mNumberIndicatorTv.setTextColor(this.mTipTextColor);
            this.mNumberIndicatorTv.setTextSize(0, (float)this.mTipTextSize);
            this.mNumberIndicatorTv.setVisibility(4);
            if (this.mNumberIndicatorBackground != null) {
                if (Build.VERSION.SDK_INT >= 16) {
                    this.mNumberIndicatorTv.setBackground(this.mNumberIndicatorBackground);
                } else {
                    this.mNumberIndicatorTv.setBackgroundDrawable(this.mNumberIndicatorBackground);
                }
            }
            pointContainerRl.addView((View)this.mNumberIndicatorTv, (ViewGroup.LayoutParams)this.mPointRealContainerLp);
        } else {
            this.mPointRealContainerLl = new LinearLayout(this.getContext());
            this.mPointRealContainerLl.setOrientation(0);
            this.mPointRealContainerLl.setId(R.id.xbanner_pointId);
            pointContainerRl.addView((View)this.mPointRealContainerLl, (ViewGroup.LayoutParams)this.mPointRealContainerLp);
        }
        if (this.mPointRealContainerLl != null) {
            if (this.mPointsIsVisible) {
                this.mPointRealContainerLl.setVisibility(0);
            } else {
                this.mPointRealContainerLl.setVisibility(8);
            }
        }
        RelativeLayout.LayoutParams pointLp = new RelativeLayout.LayoutParams(-1, -2);
        pointLp.addRule(15);
        if (this.mIsShowTips) {
            this.mTipTv = new TextView(this.getContext());
            this.mTipTv.setGravity(16);
            this.mTipTv.setSingleLine(true);
            if (this.mIsTipsMarquee) {
                this.mTipTv.setEllipsize(TextUtils.TruncateAt.MARQUEE);
                this.mTipTv.setMarqueeRepeatLimit(3);
                this.mTipTv.setSelected(true);
            } else {
                this.mTipTv.setEllipsize(TextUtils.TruncateAt.END);
            }
            this.mTipTv.setTextColor(this.mTipTextColor);
            this.mTipTv.setTextSize(0, (float)this.mTipTextSize);
            pointContainerRl.addView((View)this.mTipTv, (ViewGroup.LayoutParams)pointLp);
        }
        if (1 == this.mPointPosition) {
            this.mPointRealContainerLp.addRule(14);
            pointLp.addRule(0, R.id.xbanner_pointId);
        } else if (0 == this.mPointPosition) {
            this.mPointRealContainerLp.addRule(9);
            if (this.mTipTv != null) {
                this.mTipTv.setGravity(21);
            }
            pointLp.addRule(1, R.id.xbanner_pointId);
        } else if (2 == this.mPointPosition) {
            this.mPointRealContainerLp.addRule(11);
            pointLp.addRule(0, R.id.xbanner_pointId);
        }
        this.setBannerPlaceholderDrawable();
    }

    private void setBannerPlaceholderDrawable() {
        if (this.mPlaceholderDrawableResId != -1 && this.mPlaceholderImg == null) {
            this.mPlaceholderImg = new ImageView(this.getContext());
            this.mPlaceholderImg.setScaleType(this.mScaleType);
            this.mPlaceholderImg.setImageResource(this.mPlaceholderDrawableResId);
            RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-1, -1);
            this.addView((View)this.mPlaceholderImg, (ViewGroup.LayoutParams)layoutParams);
        }
    }

    private void removeBannerPlaceHolderDrawable() {
        if (this.mPlaceholderImg != null && this.equals(this.mPlaceholderImg.getParent())) {
            this.removeView((View)this.mPlaceholderImg);
            this.mPlaceholderImg = null;
        }
    }

    @Deprecated
    public void setData(@LayoutRes int layoutResId, @NonNull List<?> models, List<String> tips) {
        if (models == null) {
            models = new ArrayList();
        }
        if (models.isEmpty()) {
            this.mIsAutoPlay = false;
            this.mIsClipChildrenMode = false;
        }
        if (!this.mIsClipChildrenModeLessThree && models.size() < 3) {
            this.mIsClipChildrenMode = false;
        }
        this.layoutResId = layoutResId;
        this.mDatas = models;
        this.mTipData = tips;
        this.mIsOneImg = models.size() == 1;
        this.initPoints();
        this.initViewPager();
        this.removeBannerPlaceHolderDrawable();
        if (!models.isEmpty()) {
            this.removeBannerPlaceHolderDrawable();
        } else {
            this.setBannerPlaceholderDrawable();
        }
    }

    @Deprecated
    public void setData(@NonNull List<?> models, List<String> tips) {
        this.setData(R.layout.xbanner_item_image, models, tips);
    }

    public void setBannerData(@LayoutRes int layoutResId, @NonNull List<? extends BaseBannerInfo> models) {
        if (models == null) {
            models = new ArrayList<BaseBannerInfo>();
        }
        if (models.isEmpty()) {
            this.mIsAutoPlay = false;
            this.mIsClipChildrenMode = false;
        }
        if (!this.mIsClipChildrenModeLessThree && models.size() < 3) {
            this.mIsClipChildrenMode = false;
        }
        this.layoutResId = layoutResId;
        this.mDatas = models;
        this.mIsOneImg = models.size() == 1;
        this.initPoints();
        this.initViewPager();
        this.removeBannerPlaceHolderDrawable();
        if (!models.isEmpty()) {
            this.removeBannerPlaceHolderDrawable();
        } else {
            this.setBannerPlaceholderDrawable();
        }
    }

    public void setBannerData(@NonNull List<? extends BaseBannerInfo> models) {
        this.setBannerData(R.layout.xbanner_item_image, models);
    }

    public void setPointsIsVisible(boolean isVisible) {
        if (null != this.mPointRealContainerLl) {
            if (isVisible) {
                this.mPointRealContainerLl.setVisibility(0);
            } else {
                this.mPointRealContainerLl.setVisibility(8);
            }
        }
    }

    public void setPointPosition(int position) {
        if (1 == position) {
            this.mPointRealContainerLp.addRule(14);
        } else if (0 == position) {
            this.mPointRealContainerLp.addRule(9);
        } else if (2 == position) {
            this.mPointRealContainerLp.addRule(11);
        }
    }

    public void setPointContainerPosition(int position) {
        if (12 == position) {
            this.mPointContainerLp.addRule(12);
        } else if (10 == position) {
            this.mPointContainerLp.addRule(10);
        }
    }

    private void initViewPager() {
        if (this.mViewPager != null && this.equals(this.mViewPager.getParent())) {
            this.removeView((View)this.mViewPager);
            this.mViewPager = null;
        }
        this.currentPos = 0;
        this.mViewPager = new XBannerViewPager(this.getContext());
        this.mViewPager.setAdapter(new XBannerPageAdapter());
        this.mViewPager.clearOnPageChangeListeners();
        this.mViewPager.addOnPageChangeListener(this);
        this.mViewPager.setOverScrollMode(this.mSlideScrollMode);
        this.mViewPager.setIsAllowUserScroll(this.mIsAllowUserScroll);
        this.mViewPager.setPageTransformer(true, BasePageTransformer.getPageTransformer(this.mTransformer));
        this.setPageChangeDuration(this.mPageChangeDuration);
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-1, -1);
        layoutParams.setMargins(0, 0, 0, this.mBannerBottomMargin);
        if (this.mIsClipChildrenMode) {
            this.setClipChildren(false);
            this.mViewPager.setClipToPadding(false);
            this.mViewPager.setClipChildren(false);
            this.mViewPager.setPadding(this.mClipChildrenLeftMargin, this.mClipChildrenTopBottomMargin, this.mClipChildrenRightMargin, this.mBannerBottomMargin);
            this.mViewPager.setPageMargin(this.mViewPagerMargin);
        }
        this.addView((View)this.mViewPager, 0, (ViewGroup.LayoutParams)layoutParams);
        if (!this.mIsOneImg && this.mIsAutoPlay && this.getRealCount() != 0) {
            this.currentPos = 0x3FFFFFFF - 0x3FFFFFFF % this.getRealCount();
            this.mViewPager.setCurrentItem(this.currentPos);
            this.mViewPager.setAutoPlayDelegate(this);
            this.startAutoPlay();
        } else {
            if (this.mIsHandLoop && this.getRealCount() != 0) {
                this.currentPos = 0x3FFFFFFF - 0x3FFFFFFF % this.getRealCount();
                this.mViewPager.setCurrentItem(this.currentPos);
            }
            this.switchToPoint(0);
        }
    }

    public int getRealCount() {
        return this.mDatas == null ? 0 : this.mDatas.size();
    }

    public XBannerViewPager getViewPager() {
        return this.mViewPager;
    }

    public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
        this.mPageScrollPosition = position;
        this.mPageScrollPositionOffset = positionOffset;
        if (this.mTipTv != null && this.mDatas != null && this.mDatas.size() != 0 && this.mDatas.get(0) instanceof BaseBannerInfo) {
            if ((double)positionOffset > 0.5) {
                this.mTipTv.setText((CharSequence)((BaseBannerInfo)this.mDatas.get(this.getRealPosition(position + 1))).getXBannerTitle());
                this.mTipTv.setAlpha(positionOffset);
            } else {
                this.mTipTv.setText((CharSequence)((BaseBannerInfo)this.mDatas.get(this.getRealPosition(position))).getXBannerTitle());
                this.mTipTv.setAlpha(1.0f - positionOffset);
            }
        } else if (this.mTipTv != null && this.mTipData != null && !this.mTipData.isEmpty()) {
            if ((double)positionOffset > 0.5) {
                this.mTipTv.setText((CharSequence)this.mTipData.get(this.getRealPosition(position + 1)));
                this.mTipTv.setAlpha(positionOffset);
            } else {
                this.mTipTv.setText((CharSequence)this.mTipData.get(this.getRealPosition(position)));
                this.mTipTv.setAlpha(1.0f - positionOffset);
            }
        }
        if (null != this.mOnPageChangeListener && this.getRealCount() != 0) {
            this.mOnPageChangeListener.onPageScrolled(position % this.getRealCount(), positionOffset, positionOffsetPixels);
        }
    }

    public void onPageSelected(int position) {
        if (this.getRealCount() == 0) {
            return;
        }
        this.currentPos = this.getRealPosition(position);
        this.switchToPoint(this.currentPos);
        if (this.mOnPageChangeListener != null) {
            this.mOnPageChangeListener.onPageSelected(this.currentPos);
        }
    }

    public void onPageScrollStateChanged(int state) {
        if (this.mOnPageChangeListener != null) {
            this.mOnPageChangeListener.onPageScrollStateChanged(state);
        }
    }

    @Override
    public void handleAutoPlayActionUpOrCancel(float xVelocity) {
        if (this.mViewPager != null) {
            if (this.mPageScrollPosition < this.mViewPager.getCurrentItem()) {
                if (xVelocity > 400.0f || this.mPageScrollPositionOffset < 0.7f && xVelocity > -400.0f) {
                    if (this.mIsClipChildrenMode) {
                        int realPosition = this.getRealPosition(this.mPageScrollPosition);
                        this.setBannerCurrentItem(realPosition, true);
                    } else {
                        this.mViewPager.setBannerCurrentItemInternal(this.mPageScrollPosition, true);
                    }
                } else {
                    this.mViewPager.setBannerCurrentItemInternal(this.mPageScrollPosition + 1, true);
                }
            } else if (this.mPageScrollPosition == this.mViewPager.getCurrentItem()) {
                if (xVelocity < -400.0f || this.mPageScrollPositionOffset > 0.3f && xVelocity < 400.0f) {
                    this.mViewPager.setBannerCurrentItemInternal(this.mPageScrollPosition + 1, true);
                } else {
                    this.mViewPager.setBannerCurrentItemInternal(this.mPageScrollPosition, true);
                }
            } else if (this.mIsClipChildrenMode) {
                int realPosition = this.getRealPosition(this.mPageScrollPosition);
                this.setBannerCurrentItem(realPosition, true);
            } else {
                this.mViewPager.setBannerCurrentItemInternal(this.mPageScrollPosition, true);
            }
        }
    }

    private int getRealPosition(int position) {
        return position % this.getRealCount();
    }

    private void initPoints() {
        if (this.mPointRealContainerLl != null) {
            this.mPointRealContainerLl.removeAllViews();
            if (this.getRealCount() > 0 && (this.mIsShowIndicatorOnlyOne || !this.mIsOneImg)) {
                LinearLayout.LayoutParams lp = new LinearLayout.LayoutParams(-2, -2);
                lp.gravity = 16;
                lp.setMargins(this.mPointLeftRightPading, this.mPointTopBottomPading, this.mPointLeftRightPading, this.mPointTopBottomPading);
                for (int i = 0; i < this.getRealCount(); ++i) {
                    ImageView imageView = new ImageView(this.getContext());
                    imageView.setLayoutParams((ViewGroup.LayoutParams)lp);
                    if (this.mPointNoraml != 0 && this.mPointSelected != 0) {
                        imageView.setImageResource(this.mPointNoraml);
                    }
                    this.mPointRealContainerLl.addView((View)imageView);
                }
            }
        }
        if (this.mNumberIndicatorTv != null) {
            if (this.getRealCount() > 0 && (this.mIsShowIndicatorOnlyOne || !this.mIsOneImg)) {
                this.mNumberIndicatorTv.setVisibility(0);
            } else {
                this.mNumberIndicatorTv.setVisibility(8);
            }
        }
    }

    private void switchToPoint(int currentPoint) {
        if (this.mPointRealContainerLl != null & this.mDatas != null && this.getRealCount() > 1) {
            for (int i = 0; i < this.mPointRealContainerLl.getChildCount(); ++i) {
                if (i == currentPoint) {
                    ((ImageView)this.mPointRealContainerLl.getChildAt(i)).setImageResource(this.mPointSelected);
                } else {
                    ((ImageView)this.mPointRealContainerLl.getChildAt(i)).setImageResource(this.mPointNoraml);
                }
                this.mPointRealContainerLl.getChildAt(i).requestLayout();
            }
        }
        if (this.mTipTv != null && this.mDatas != null && this.mDatas.size() != 0 && this.mDatas.get(0) instanceof BaseBannerInfo) {
            this.mTipTv.setText((CharSequence)((BaseBannerInfo)this.mDatas.get(currentPoint)).getXBannerTitle());
        } else if (this.mTipTv != null && this.mTipData != null && !this.mTipData.isEmpty()) {
            this.mTipTv.setText((CharSequence)this.mTipData.get(currentPoint));
        }
        if (this.mNumberIndicatorTv != null && this.mDatas != null && (this.mIsShowIndicatorOnlyOne || !this.mIsOneImg)) {
            this.mNumberIndicatorTv.setText((CharSequence)String.valueOf(currentPoint + 1 + "/" + this.mDatas.size()));
        }
    }

    public boolean dispatchTouchEvent(MotionEvent ev) {
        if (!this.mIsOneImg & this.mViewPager != null) {
            switch (ev.getAction()) {
                case 0: {
                    float touchX = ev.getRawX();
                    int paddingLeft = this.mViewPager.getLeft();
                    if (!(touchX >= (float)paddingLeft) || !(touchX < (float)(XBannerUtils.getScreenWidth(this.getContext()) - paddingLeft))) break;
                    this.stopAutoPlay();
                    break;
                }
                case 1: {
                    this.startAutoPlay();
                    break;
                }
                case 3: {
                    this.getParent().requestDisallowInterceptTouchEvent(false);
                }
                case 4: {
                    this.startAutoPlay();
                    break;
                }
            }
        }
        return super.dispatchTouchEvent(ev);
    }

    public void startAutoPlay() {
        this.stopAutoPlay();
        if (this.mIsAutoPlay) {
            this.postDelayed(this.mAutoSwitchTask, this.mAutoPalyTime);
        }
    }

    public void stopAutoPlay() {
        if (this.mAutoSwitchTask != null) {
            this.removeCallbacks(this.mAutoSwitchTask);
        }
    }

    public void setOnPageChangeListener(ViewPager.OnPageChangeListener onPageChangeListener) {
        this.mOnPageChangeListener = onPageChangeListener;
    }

    public void setSlideScrollMode(int slideScrollMode) {
        this.mSlideScrollMode = slideScrollMode;
        if (null != this.mViewPager) {
            this.mViewPager.setOverScrollMode(slideScrollMode);
        }
    }

    public void setAllowUserScrollable(boolean allowUserScrollable) {
        this.mIsAllowUserScroll = allowUserScrollable;
        if (null != this.mViewPager) {
            this.mViewPager.setIsAllowUserScroll(allowUserScrollable);
        }
    }

    public void setAutoPlayAble(boolean mAutoPlayAble) {
        this.mIsAutoPlay = mAutoPlayAble;
        this.stopAutoPlay();
        if (this.mViewPager != null && this.mViewPager.getAdapter() != null) {
            this.mViewPager.getAdapter().notifyDataSetChanged();
        }
    }

    public void setAutoPalyTime(int mAutoPalyTime) {
        this.mAutoPalyTime = mAutoPalyTime;
    }

    public void setPageTransformer(Transformer transformer) {
        this.mTransformer = transformer;
        if (this.mViewPager != null) {
            this.initViewPager();
        }
    }

    public void setViewPagerMargin(@Dimension int viewPagerMargin) {
        this.mViewPagerMargin = viewPagerMargin;
        if (this.mViewPager != null) {
            this.mViewPager.setPageMargin(XBannerUtils.dp2px(this.getContext(), viewPagerMargin));
        }
    }

    public void setCustomPageTransformer(ViewPager.PageTransformer transformer) {
        if (transformer != null && this.mViewPager != null) {
            this.mViewPager.setPageTransformer(true, transformer);
        }
    }

    public void setPageChangeDuration(int duration) {
        if (this.mViewPager != null) {
            this.mViewPager.setScrollDuration(duration);
        }
    }

    public void setHandLoop(boolean handLoop) {
        this.mIsHandLoop = handLoop;
    }

    public void setIsClipChildrenMode(boolean mIsClipChildrenMode) {
        this.mIsClipChildrenMode = mIsClipChildrenMode;
    }

    public void setShowIndicatorOnlyOne(boolean showIndicatorOnlyOne) {
        this.mIsShowIndicatorOnlyOne = showIndicatorOnlyOne;
    }

    public int getBannerCurrentItem() {
        if (this.mViewPager == null || this.mDatas == null || this.mDatas.size() == 0) {
            return -1;
        }
        return this.mViewPager.getCurrentItem() % this.getRealCount();
    }

    public void setBannerCurrentItem(int position) {
        this.setBannerCurrentItem(position, false);
    }

    public void setBannerCurrentItem(int position, boolean smoothScroll) {
        if (this.mViewPager == null || this.mDatas == null || position > this.getRealCount() - 1) {
            return;
        }
        if (this.mIsAutoPlay || this.mIsHandLoop) {
            int currentItem = this.mViewPager.getCurrentItem();
            int realCurrentItem = this.getRealPosition(currentItem);
            int offset = position - realCurrentItem;
            if (offset < 0) {
                for (int i = -1; i >= offset; --i) {
                    this.mViewPager.setCurrentItem(currentItem + i, smoothScroll);
                }
            } else if (offset > 0) {
                for (int i = 1; i <= offset; ++i) {
                    this.mViewPager.setCurrentItem(currentItem + i, smoothScroll);
                }
            }
            this.startAutoPlay();
        } else {
            this.mViewPager.setCurrentItem(position, smoothScroll);
        }
    }

    public void setCanClickSide(boolean canClickSide) {
        this.isCanClickSide = canClickSide;
    }

    protected void onVisibilityChanged(@NonNull View changedView, int visibility) {
        super.onVisibilityChanged(changedView, visibility);
        if (0 == visibility) {
            this.startAutoPlay();
        } else if (8 == visibility || 4 == visibility) {
            this.onInvisibleToUser();
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.onInvisibleToUser();
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.startAutoPlay();
    }

    private void onInvisibleToUser() {
        this.stopAutoPlay();
        if (!this.mIsFirstInvisible && this.mIsAutoPlay && this.mViewPager != null && this.getRealCount() > 0 && this.mPageScrollPositionOffset != 0.0f) {
            this.mViewPager.setCurrentItem(this.mViewPager.getCurrentItem() - 1, false);
            this.mViewPager.setCurrentItem(this.mViewPager.getCurrentItem() + 1, false);
        }
        this.mIsFirstInvisible = false;
    }

    public void setOnItemClickListener(OnItemClickListener listener) {
        this.mOnItemClickListener = listener;
    }

    public static interface XBannerAdapter {
        public void loadBanner(XBanner var1, Object var2, View var3, int var4);
    }

    public static interface OnItemClickListener {
        public void onItemClick(XBanner var1, Object var2, View var3, int var4);
    }

    private static class AutoSwitchTask
    implements Runnable {
        private final WeakReference<XBanner> mXBanner;

        private AutoSwitchTask(XBanner mXBanner) {
            this.mXBanner = new WeakReference<XBanner>(mXBanner);
        }

        @Override
        public void run() {
            XBanner banner = (XBanner)this.mXBanner.get();
            if (banner != null) {
                if (banner.mViewPager != null) {
                    int currentItem = banner.mViewPager.getCurrentItem() + 1;
                    banner.mViewPager.setCurrentItem(currentItem);
                }
                banner.startAutoPlay();
            }
        }
    }

    private class XBannerPageAdapter
    extends PagerAdapter {
        private XBannerPageAdapter() {
        }

        public int getCount() {
            if (XBanner.this.mIsOneImg) {
                return 1;
            }
            return XBanner.this.mIsAutoPlay ? Integer.MAX_VALUE : (XBanner.this.mIsHandLoop ? Integer.MAX_VALUE : XBanner.this.getRealCount());
        }

        public boolean isViewFromObject(@NonNull View view, @NonNull Object object) {
            return view == object;
        }

        @NonNull
        public Object instantiateItem(@NonNull ViewGroup container, int position) {
            View view = LayoutInflater.from((Context)XBanner.this.getContext()).inflate(XBanner.this.layoutResId, container, false);
            if (XBanner.this.getRealCount() > 0) {
                final int realPosition = XBanner.this.getRealPosition(position);
                if (XBanner.this.mOnItemClickListener != null && !XBanner.this.mDatas.isEmpty()) {
                    view.setOnClickListener((View.OnClickListener)new OnDoubleClickListener(){

                        @Override
                        public void onNoDoubleClick(View v) {
                            if (XBanner.this.isCanClickSide) {
                                XBanner.this.setBannerCurrentItem(realPosition, true);
                            }
                            XBanner.this.mOnItemClickListener.onItemClick(XBanner.this, XBanner.this.mDatas.get(realPosition), v, realPosition);
                        }
                    });
                }
                if (null != XBanner.this.mAdapter && !XBanner.this.mDatas.isEmpty()) {
                    XBanner.this.mAdapter.loadBanner(XBanner.this, XBanner.this.mDatas.get(realPosition), view, realPosition);
                }
            }
            container.addView(view, 0);
            return view;
        }

        public void destroyItem(@NonNull ViewGroup container, int position, @NonNull Object object) {
            container.removeView((View)object);
        }

        public void finishUpdate(@NonNull ViewGroup container) {
            super.finishUpdate(container);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface INDICATOR_POSITION {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface INDICATOR_GRAVITY {
    }
}

