/*
 * Decompiled with CFR 0.152.
 */
package com.stx.xhb.androidx.transformers;

import android.view.View;
import androidx.viewpager.widget.ViewPager;
import com.stx.xhb.androidx.transformers.AccordionPageTransformer;
import com.stx.xhb.androidx.transformers.AlphaPageTransformer;
import com.stx.xhb.androidx.transformers.CubePageTransformer;
import com.stx.xhb.androidx.transformers.DefaultPageTransformer;
import com.stx.xhb.androidx.transformers.DepthPageTransformer;
import com.stx.xhb.androidx.transformers.FlipPageTransformer;
import com.stx.xhb.androidx.transformers.RotatePageTransformer;
import com.stx.xhb.androidx.transformers.ScalePageTransformer;
import com.stx.xhb.androidx.transformers.StackPageTransformer;
import com.stx.xhb.androidx.transformers.Transformer;
import com.stx.xhb.androidx.transformers.ZoomCenterPageTransformer;
import com.stx.xhb.androidx.transformers.ZoomFadePageTransformer;
import com.stx.xhb.androidx.transformers.ZoomPageTransformer;
import com.stx.xhb.androidx.transformers.ZoomStackPageTransformer;

public abstract class BasePageTransformer
implements ViewPager.PageTransformer {
    public void transformPage(View view, float position) {
        if (position < -1.0f) {
            this.handleInvisiblePage(view, position);
        } else if (position <= 0.0f) {
            this.handleLeftPage(view, position);
        } else if (position <= 1.0f) {
            this.handleRightPage(view, position);
        } else {
            this.handleInvisiblePage(view, position);
        }
    }

    public abstract void handleInvisiblePage(View var1, float var2);

    public abstract void handleLeftPage(View var1, float var2);

    public abstract void handleRightPage(View var1, float var2);

    public static BasePageTransformer getPageTransformer(Transformer effect) {
        switch (effect) {
            case Default: {
                return new DefaultPageTransformer();
            }
            case Alpha: {
                return new AlphaPageTransformer();
            }
            case Rotate: {
                return new RotatePageTransformer();
            }
            case Cube: {
                return new CubePageTransformer();
            }
            case Flip: {
                return new FlipPageTransformer();
            }
            case Accordion: {
                return new AccordionPageTransformer();
            }
            case ZoomFade: {
                return new ZoomFadePageTransformer();
            }
            case ZoomCenter: {
                return new ZoomCenterPageTransformer();
            }
            case ZoomStack: {
                return new ZoomStackPageTransformer();
            }
            case Stack: {
                return new StackPageTransformer();
            }
            case Depth: {
                return new DepthPageTransformer();
            }
            case Zoom: {
                return new ZoomPageTransformer();
            }
            case Scale: {
                return new ScalePageTransformer();
            }
        }
        return new DefaultPageTransformer();
    }
}

